/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.target;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.CustomerMatchPerson;
import com.tcbj.crm.entity.EmployeeMatchCustomer;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.entity.Target;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.entity.TargetSplit;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.target.EmployeeMatchCustomerCondition;
import com.tcbj.crm.target.TargetCondition;
import com.tcbj.crm.target.TargetPartnerWrap;
import com.tcbj.crm.target.TargetWrap;
import com.tcbj.crm.targetdata.TargetDataCondition;
import com.tcbj.crm.targetdata.TargetDataService;
import com.tcbj.crm.targetdatae.TargetDataeCondition;
import com.tcbj.crm.targetdatae.TargetDataeService;
import com.tcbj.crm.targetx.TargetXService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TargetService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    NewBaseDao newBaseDao;
    @Autowired
    private PactMainService pactMainService;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    TargetDataService targetDataService;
    @Autowired
    TargetDataeService targetDataeService;
    @Autowired
    TargetXService targetXService;

    public TargetWrap queryByEmployee(TargetCondition condition, Employee emp) {
        List<Target> targetList = this.queryTargetByEmployee(condition, emp);
        List<TargetData> targetDataList = this.queryTargetDataByEmployee(condition, emp);
        TargetWrap tw = new TargetWrap();
        tw.addTargetList(targetList);
        tw.addTargetDataList(targetDataList);
        return tw;
    }

    public Page queryByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetWrap tw;
        String customerId;
        LinkedHashMap<String, TargetWrap> map = new LinkedHashMap<String, TargetWrap>();
        Page targetPage = this.queryTargetByCustomer(condition, emp, pageNo, rowsize);
        List targetList = targetPage.getList();
        TargetDataCondition con = new TargetDataCondition();
        con.setRowsize(Integer.MAX_VALUE);
        con.setYear(Long.valueOf(condition.getYear()));
        con.setSaleChannelTypeCode(condition.getChannelId());
        List targetDataList = this.targetDataService.getNewTargetDatas(emp, con).getList();
        condition.setYear(String.valueOf(Integer.valueOf(condition.getYear()) - 1));
        List targetList2 = this.queryTargetByCustomer(condition, emp, pageNo, rowsize).getList();
        con.setYear(Long.valueOf(condition.getYear()));
        List targetDataList2 = this.targetDataService.getNewTargetDatas(emp, con).getList();
        for (Target target : targetList) {
            customerId = this.getCustomerId2(target);
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(customerId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            customerId = String.valueOf(targetData.getSupplierId()) + "-" + targetData.getType() + "-" + targetData.getApplyerId() + "-" + targetData.getBrand();
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        for (Target target : targetList2) {
            customerId = this.getCustomerId2(target);
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTarget2(target);
        }
        for (TargetData targetData : targetDataList2) {
            customerId = String.valueOf(targetData.getSupplierId()) + "-" + targetData.getType() + "-" + targetData.getApplyerId() + "-" + targetData.getBrand();
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData2(targetData);
        }
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        targetPage.setList(list);
        return targetPage;
    }

    public List<TargetPartnerWrap> queryByPartner(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetPartnerWrap tw;
        String customerId;
        List<PactMbo> pactMboList = this.pactMainService.getPactMbos(condition, emp, pageNo, rowsize);
        condition.setPartner(true);
        List<TargetData> targetDataList = this.queryTargetDataByCustomer(condition, emp, pageNo, rowsize);
        HashMap<String, TargetPartnerWrap> map = new HashMap<String, TargetPartnerWrap>();
        for (PactMbo pactMbo : pactMboList) {
            customerId = pactMbo.getYear() + pactMbo.getTargetType();
            tw = (TargetPartnerWrap)map.get(customerId);
            if (tw == null) {
                tw = new TargetPartnerWrap();
                map.put(customerId, tw);
            }
            tw.addTarget(pactMbo);
        }
        for (TargetData targetData : targetDataList) {
            customerId = targetData.getYear() + targetData.getType();
            tw = (TargetPartnerWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList<TargetPartnerWrap> list = new ArrayList<TargetPartnerWrap>();
        list.addAll(map.values());
        return list;
    }

    public Page queryByBigarea(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetWrap tw;
        String bigareaId;
        Page targetPage = this.queryTargetByCustomer(condition, emp, pageNo, Integer.MAX_VALUE);
        List targetList = targetPage.getList();
        TargetDataCondition con = new TargetDataCondition();
        con.setRowsize(Integer.MAX_VALUE);
        con.setYear(Long.valueOf(condition.getYear()));
        con.setSaleChannelTypeCode(condition.getChannelId());
        List targetDataList = this.targetDataService.getNewTargetDatas(emp, con).getList();
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        for (Target target : targetList) {
            bigareaId = this.getBigareaId(target);
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(bigareaId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            bigareaId = String.valueOf(targetData.getUnionId()) + targetData.getBigareaId() + "-" + targetData.getBrand();
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        targetPage.setList(list);
        return targetPage;
    }

    public Page queryBySalesman(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetWrap tw;
        String bigareaId;
        condition.setPageSize(rowsize);
        Page targetPage = this.getTargetByNewPersonForPage(condition, emp);
        List targetList = targetPage.getList();
        TargetDataeCondition con = new TargetDataeCondition();
        con.setRowsize(Integer.MAX_VALUE);
        con.setYear(Long.valueOf(condition.getYear()));
        List targetDataList = this.targetDataeService.getPersonTargetPage(con, emp).getList();
        LinkedHashMap<String, TargetWrap> map = new LinkedHashMap<String, TargetWrap>();
        for (Target target : targetList) {
            bigareaId = String.valueOf(target.getUnionId()) + target.getObjectId();
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(bigareaId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            bigareaId = String.valueOf(targetData.getUnionId()) + targetData.getUserId();
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        targetPage.setList(list);
        return targetPage;
    }

    public List<TargetWrap> queryByTarget(TargetCondition condition, Employee emp, String type, int pageNo, int rowsize) {
        TargetWrap tw;
        String customerId;
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        List<Target> targetList = this.queryAllTargetByCustomer(condition, emp, pageNo, rowsize);
        TargetDataCondition con = new TargetDataCondition();
        con.setRowsize(Integer.MAX_VALUE);
        con.setYear(Long.valueOf(condition.getYear()));
        con.setType(condition.getTargetType());
        con.setSaleChannelTypeCode(condition.getChannelId());
        con.setBigAreaCode(condition.getBigAreaCode());
        con.setAreaCode(condition.getAreaCode());
        con.setApplyerId(condition.getObjectId());
        List targetDataList = this.targetDataService.getNewTargetDatas(emp, con).getList();
        for (Target target : targetList) {
            customerId = "";
            if ("0".equals(type)) {
                customerId = this.getCus(target);
            } else if ("1".equals(type)) {
                customerId = this.getCustomerId(target);
            } else if ("2".equals(type)) {
                customerId = this.getAreaId(target);
            } else if ("3".equals(type)) {
                customerId = this.getBigareaId(target);
            } else if ("4".equals(type)) {
                customerId = this.getChannelId(target);
            } else if ("5".equals(type)) {
                customerId = String.valueOf(target.getUnionId()) + "-" + target.getBrand();
            }
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(customerId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            customerId = "";
            if ("0".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getProductSubType() + "-" + targetData.getProductType() + "-" + targetData.getBrand();
            } else if ("1".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getApplyerId() + "-" + targetData.getBrand();
            } else if ("2".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getAreaId() + "-" + targetData.getBrand();
            } else if ("3".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getBigareaId() + "-" + targetData.getBrand();
            } else if ("4".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getChannelId() + "-" + targetData.getBrand();
            } else if ("5".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + "-" + targetData.getBrand();
            }
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList<TargetWrap> list = new ArrayList<TargetWrap>();
        list.addAll(map.values());
        return list;
    }

    public String getChannelTypeId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getPartnerChnlType();
        }
        List customers = this.baseDao.findEntity(" from Customer c where c.cityManagerId = ? and c.supplierId = ? and startdate > ? and (enddate < ? or enddate is null )", new Object[]{target.getObjectId(), target.getPartnerId()}, Customer.class);
        if (customers.size() > 0) {
            Customer customer = (Customer)customers.get(0);
            return String.valueOf(target.getUnionId()) + customer.getPartnerChnlType();
        }
        return null;
    }

    public String getBigAreaId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getBigAreaCode();
        }
        List customers = this.baseDao.findEntity(" from Customer c where c.cityManagerId = ? and c.supplierId = ? and startdate > ? and (enddate < ? or enddate is null )", new Object[]{target.getObjectId(), target.getPartnerId()}, Customer.class);
        if (customers.size() > 0) {
            Customer customer = (Customer)customers.get(0);
            return String.valueOf(target.getUnionId()) + customer.getBigAreaCode();
        }
        return null;
    }

    public String getAreaId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getAreaCode() + "-" + target.getBrand();
        }
        List customers = this.baseDao.findEntity(" from Customer c where c.cityManagerId = ? and c.supplierId = ? and startdate > ? and (enddate < ? or enddate is null )", new Object[]{target.getObjectId(), target.getPartnerId()}, Customer.class);
        if (customers.size() > 0) {
            Customer customer = (Customer)customers.get(0);
            return String.valueOf(target.getUnionId()) + customer.getAreaCode() + "-" + target.getBrand();
        }
        return null;
    }

    public String getPersonId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getCityManagerId();
        }
        return String.valueOf(target.getUnionId()) + target.getObjectId();
    }

    public String getCus(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getProductSubType() + "-" + target.getProductType() + "-" + target.getBrand();
        }
        return null;
    }

    public String getCustomerId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getObjectId() + "-" + target.getBrand();
        }
        return null;
    }

    public String getCustomerId2(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getPartnerId()) + "-" + target.getType() + "-" + target.getObjectId() + "-" + target.getBrand();
        }
        return null;
    }

    public String getBigareaId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getBigareaId() + "-" + target.getBrand();
        }
        return null;
    }

    public String getChannelId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getChannelId() + "-" + target.getBrand();
        }
        return null;
    }

    public List<Target> queryTargetByEmployee(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t where t.partnerId = ? t.objectId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        args.add(emp.getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        return list;
    }

    public Page queryTargetByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Customer c where t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page;
    }

    public List<TargetData> queryTargetDataByEmployee(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t where t.supplierId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), TargetData.class);
        return list;
    }

    public List<TargetData> queryTargetDataByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t,Partner p,Customer c where t.userId is null and p.id = t.supplierId and c.supplierId = t.supplierId and c.applyerId = t.applyerId ");
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (condition.isPartner()) {
            hql.append(" and t.applyerId = ? ");
        } else {
            hql.append(" and t.supplierId = ? ");
        }
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.userId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    private Page queryTargetBySalesman(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t where t.partnerId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        hql.append(" order by t.objectId ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page;
    }

    private List<TargetData> queryTargetDataBySalesman(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t where t.userId <> null and t.supplierId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.userId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        hql.append(" order by t.type ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    public Page getTargetPageByCustomer(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Partner p,Customer c where p.id = c.applyerId and t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and p.saleChannelTypeCode = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        hql.append(" order by t.objectId ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), condition.getPageno().intValue());
        return page;
    }

    public List<Target> getTargetListByCustomer(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Partner p,Customer c where p.id = c.applyerId and t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and p.saleChannelTypeCode = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        return list;
    }

    public Page getTargetPageByPerson(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select distinct t from Target t,PartnerContact e where t.objectId = e.id and t.partnerId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and t.channelId = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and t.bigareaId = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and t.areaId = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getPersonName())) {
            hql.append(" and e.name like ? ");
            args.add("%" + condition.getPersonName() + "%");
        }
        hql.append(" order by t.objectId ");
        Page page = this.baseDao.searchForPager2(hql.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), condition.getPageno().intValue());
        return page;
    }

    public List<Target> getTargetListByPerson(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select distinct t from Target t,PartnerContact e where t.objectId = e.id and t.partnerId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and t.channelId = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and t.bigareaId = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and t.areaId = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getPersonName())) {
            hql.append(" and e.name like ? ");
            args.add("%" + condition.getPersonName() + "%");
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        return list;
    }

    public void update(List<Target> targetList, String delIds, Employee me) {
        String[] ids;
        String[] stringArray = ids = delIds.split(",");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                Target cfr_ignored_0 = (Target)this.baseDao.get(Target.class, (Serializable)((Object)id));
                this.baseDao.executeHQL("delete Target where id= ?", args);
            }
            ++n2;
        }
        for (Target target : targetList) {
            target.fillInitData(me);
            target.setPartnerId(me.getCurrentPartner().getId());
            if (target.getBigareaId() != null) {
                target.setChannelId(Cache.getRegions(target.getBigareaId()).getParentId());
            }
            if (StringUtils.isEmpty(target.getId())) {
                try {
                    this.baseDao.save((Object)target);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                Target cfr_ignored_1 = (Target)this.baseDao.get(Target.class, (Serializable)((Object)target.getId()));
                ArrayList<Object> args = new ArrayList<Object>();
                String sql = " update CX_TARGET set PARTNER_ID = ? ,year = ?,type = ?,CHANNEL_ID = ?,BIGAREA_ID = ?,AREA_ID = ?,OBJECT_ID = ?,PRODUCT_TYPE = ?,PRODUCT_SUB_TYPE = ?,BRAND = ?,";
                args.add(target.getPartnerId());
                args.add(target.getYear());
                args.add(target.getType());
                args.add(target.getChannelId());
                args.add(target.getBigareaId());
                args.add(target.getAreaId());
                args.add(target.getObjectId());
                args.add(target.getProductType());
                args.add(target.getProductSubType());
                args.add(target.getBrand());
                sql = String.valueOf(sql) + "M1 = ?,";
                args.add(TargetService.vaildataNull(target.getM1()));
                sql = String.valueOf(sql) + "M2 = ?,";
                args.add(TargetService.vaildataNull(target.getM2()));
                sql = String.valueOf(sql) + "M3 = ?,";
                args.add(TargetService.vaildataNull(target.getM3()));
                sql = String.valueOf(sql) + "M4 = ?,";
                args.add(TargetService.vaildataNull(target.getM4()));
                sql = String.valueOf(sql) + "M5 = ?,";
                args.add(TargetService.vaildataNull(target.getM5()));
                sql = String.valueOf(sql) + "M6 = ?,";
                args.add(TargetService.vaildataNull(target.getM6()));
                sql = String.valueOf(sql) + "M7 = ?,";
                args.add(TargetService.vaildataNull(target.getM7()));
                sql = String.valueOf(sql) + "M8 = ?,";
                args.add(TargetService.vaildataNull(target.getM8()));
                sql = String.valueOf(sql) + "M9 = ?,";
                args.add(TargetService.vaildataNull(target.getM9()));
                sql = String.valueOf(sql) + "M10 = ?,";
                args.add(TargetService.vaildataNull(target.getM10()));
                sql = String.valueOf(sql) + "M11 = ?,";
                args.add(TargetService.vaildataNull(target.getM11()));
                sql = String.valueOf(sql) + "M12 = ?,";
                args.add(TargetService.vaildataNull(target.getM12()));
                sql = String.valueOf(sql) + " OBJECT_TYPE = ? where ROW_ID = ? ";
                args.add(target.getObjectType());
                args.add(target.getId());
                this.baseDao.executeSQL(sql, args.toArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deletePersonTarget(Target oldTarget) {
        if ("\u4eba\u5458".equals(oldTarget.getObjectType())) {
            return;
        }
        List list = this.baseDao.findEntity("from TargetSplit t where t.orgId = ? and t.partnerId = ? and year = ? and type = ? ", new Object[]{oldTarget.getPartnerId(), oldTarget.getObjectId(), String.valueOf(oldTarget.getYear()), oldTarget.getType()}, TargetSplit.class);
        for (TargetSplit ts : list) {
            ArrayList<Object> args = new ArrayList<Object>();
            String hql = "from Target t where t.objectType = '\u4eba\u5458' and t.partnerId = ? and t.year = ? and t.type = ? and t.objectId = ? ";
            args.add(oldTarget.getPartnerId());
            args.add(oldTarget.getYear());
            args.add(oldTarget.getType());
            args.add(ts.getUserId());
            Target personTarget = (Target)this.baseDao.findFirstEntity(hql, args.toArray(), Target.class);
            if (personTarget == null) continue;
            personTarget.setM1(personTarget.getM1() - ts.getM1() * oldTarget.getM1() / 100.0);
            personTarget.setM2(personTarget.getM2() - ts.getM2() * oldTarget.getM2() / 100.0);
            personTarget.setM3(personTarget.getM3() - ts.getM3() * oldTarget.getM3() / 100.0);
            personTarget.setM4(personTarget.getM4() - ts.getM4() * oldTarget.getM4() / 100.0);
            personTarget.setM5(personTarget.getM5() - ts.getM5() * oldTarget.getM5() / 100.0);
            personTarget.setM6(personTarget.getM6() - ts.getM6() * oldTarget.getM6() / 100.0);
            personTarget.setM7(personTarget.getM7() - ts.getM7() * oldTarget.getM7() / 100.0);
            personTarget.setM8(personTarget.getM8() - ts.getM8() * oldTarget.getM8() / 100.0);
            personTarget.setM9(personTarget.getM9() - ts.getM9() * oldTarget.getM9() / 100.0);
            personTarget.setM10(personTarget.getM10() - ts.getM10() * oldTarget.getM10() / 100.0);
            personTarget.setM11(personTarget.getM11() - ts.getM11() * oldTarget.getM11() / 100.0);
            personTarget.setM12(personTarget.getM12() - ts.getM12() * oldTarget.getM12() / 100.0);
            this.baseDao.update((Object)personTarget);
        }
    }

    public void updatePersonTarget(Target oldTarget, Target target) {
        if ("\u4eba\u5458".equals(oldTarget.getObjectType())) {
            return;
        }
        List list = this.baseDao.findEntity("from TargetSplit t where t.orgId = ? and t.partnerId = ? and year = ? and type = ? ", new Object[]{target.getPartnerId(), target.getObjectId(), String.valueOf(target.getYear()), target.getType()}, TargetSplit.class);
        for (TargetSplit ts : list) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(oldTarget.getPartnerId());
            args.add(oldTarget.getYear());
            args.add(oldTarget.getType());
            args.add(ts.getUserId());
            String hql = "from Target t where t.objectType = '\u4eba\u5458' and t.partnerId = ? and t.year = ? and t.type = ? and t.objectId = ? ";
            if (StringUtils.isNotEmpty(oldTarget.getProductType())) {
                hql = String.valueOf(hql) + " and t.productType = ? ";
                args.add(oldTarget.getProductType());
            } else {
                hql = String.valueOf(hql) + " and t.productType is null ";
            }
            if (StringUtils.isNotEmpty(oldTarget.getProductSubType())) {
                hql = String.valueOf(hql) + " and t.productSubType = ? ";
                args.add(oldTarget.getProductSubType());
            } else {
                hql = String.valueOf(hql) + " and t.productSubType is null ";
            }
            Target personTarget = (Target)this.baseDao.findFirstEntity(hql, args.toArray(), Target.class);
            if (personTarget != null) {
                personTarget.setM1(personTarget.getM1() + ts.getM1() * TargetService.vaildataNull(target.getM1()) / 100.0 - ts.getM1() * oldTarget.getM1() / 100.0);
                personTarget.setM2(personTarget.getM2() + ts.getM2() * TargetService.vaildataNull(target.getM2()) / 100.0 - ts.getM2() * oldTarget.getM2() / 100.0);
                personTarget.setM3(personTarget.getM3() + ts.getM3() * TargetService.vaildataNull(target.getM3()) / 100.0 - ts.getM3() * oldTarget.getM3() / 100.0);
                personTarget.setM4(personTarget.getM4() + ts.getM4() * TargetService.vaildataNull(target.getM4()) / 100.0 - ts.getM4() * oldTarget.getM4() / 100.0);
                personTarget.setM5(personTarget.getM5() + ts.getM5() * TargetService.vaildataNull(target.getM5()) / 100.0 - ts.getM5() * oldTarget.getM5() / 100.0);
                personTarget.setM6(personTarget.getM6() + ts.getM6() * TargetService.vaildataNull(target.getM6()) / 100.0 - ts.getM6() * oldTarget.getM6() / 100.0);
                personTarget.setM7(personTarget.getM7() + ts.getM7() * TargetService.vaildataNull(target.getM7()) / 100.0 - ts.getM7() * oldTarget.getM7() / 100.0);
                personTarget.setM8(personTarget.getM8() + ts.getM8() * TargetService.vaildataNull(target.getM8()) / 100.0 - ts.getM8() * oldTarget.getM8() / 100.0);
                personTarget.setM9(personTarget.getM9() + ts.getM9() * TargetService.vaildataNull(target.getM9()) / 100.0 - ts.getM9() * oldTarget.getM9() / 100.0);
                personTarget.setM10(personTarget.getM10() + ts.getM10() * TargetService.vaildataNull(target.getM10()) / 100.0 - ts.getM10() * oldTarget.getM10() / 100.0);
                personTarget.setM11(personTarget.getM11() + ts.getM11() * TargetService.vaildataNull(target.getM11()) / 100.0 - ts.getM11() * oldTarget.getM11() / 100.0);
                personTarget.setM12(personTarget.getM12() + ts.getM12() * TargetService.vaildataNull(target.getM12()) / 100.0 - ts.getM12() * oldTarget.getM12() / 100.0);
                this.baseDao.update((Object)personTarget);
                continue;
            }
            if (target == null) continue;
            this.addPersonTarget(target);
        }
    }

    public void addPersonTarget(Target newTarget) {
        if ("\u4eba\u5458".equals(newTarget.getObjectType())) {
            return;
        }
        List list = this.baseDao.findEntity("from TargetSplit t where t.orgId = ? and t.partnerId = ? and year = ? and type = ? ", new Object[]{newTarget.getPartnerId(), newTarget.getObjectId(), String.valueOf(newTarget.getYear()), newTarget.getType()}, TargetSplit.class);
        for (TargetSplit ts : list) {
            ArrayList<Object> updateArgs;
            ArrayList<Object> args2 = new ArrayList<Object>();
            ArrayList<Object> args = new ArrayList<Object>();
            args2.add(newTarget.getPartnerId());
            args2.add(newTarget.getYear());
            args2.add(newTarget.getType());
            args2.add(ts.getUserId());
            args.add(newTarget.getPartnerId());
            args.add(newTarget.getYear());
            args.add(newTarget.getType());
            args.add(ts.getUserId());
            String hql = "from Target t where t.objectType = '\u4eba\u5458' and t.partnerId = ? and t.year = ? and t.type = ? and t.objectId = ? ";
            if (StringUtils.isNotEmpty(newTarget.getProductType())) {
                hql = String.valueOf(hql) + " and t.productType = ? ";
                args2.add(newTarget.getProductType());
            } else {
                hql = String.valueOf(hql) + " and t.productType is null ";
            }
            if (StringUtils.isNotEmpty(newTarget.getProductSubType())) {
                hql = String.valueOf(hql) + " and t.productSubType = ? ";
                args2.add(newTarget.getProductSubType());
            } else {
                hql = String.valueOf(hql) + " and t.productSubType is null ";
            }
            Target _target = (Target)this.baseDao.findFirstEntity(hql, args2.toArray(), Target.class);
            if (_target != null) {
                updateArgs = new ArrayList<Object>();
                updateArgs.add(_target.getM1() + ts.getM1() * TargetService.vaildataNull(newTarget.getM1()) / 100.0);
                updateArgs.add(_target.getM2() + ts.getM2() * TargetService.vaildataNull(newTarget.getM2()) / 100.0);
                updateArgs.add(_target.getM3() + ts.getM3() * TargetService.vaildataNull(newTarget.getM3()) / 100.0);
                updateArgs.add(_target.getM4() + ts.getM4() * TargetService.vaildataNull(newTarget.getM4()) / 100.0);
                updateArgs.add(_target.getM5() + ts.getM5() * TargetService.vaildataNull(newTarget.getM5()) / 100.0);
                updateArgs.add(_target.getM6() + ts.getM6() * TargetService.vaildataNull(newTarget.getM6()) / 100.0);
                updateArgs.add(_target.getM7() + ts.getM7() * TargetService.vaildataNull(newTarget.getM7()) / 100.0);
                updateArgs.add(_target.getM8() + ts.getM8() * TargetService.vaildataNull(newTarget.getM8()) / 100.0);
                updateArgs.add(_target.getM9() + ts.getM9() * TargetService.vaildataNull(newTarget.getM9()) / 100.0);
                updateArgs.add(_target.getM10() + ts.getM10() * TargetService.vaildataNull(newTarget.getM10()) / 100.0);
                updateArgs.add(_target.getM11() + ts.getM11() * TargetService.vaildataNull(newTarget.getM11()) / 100.0);
                updateArgs.add(_target.getM12() + ts.getM12() * TargetService.vaildataNull(newTarget.getM12()) / 100.0);
                updateArgs.addAll(args);
                this.baseDao.executeSQL(" update CX_TARGET set m1 = ? ,m2 = ? ,m3 = ? ,m4 = ? ,m5 = ? ,m6 = ? ,m7 = ? ,m8 = ? ,m9 = ? ,m10 = ?,m11 = ? ,m12 = ?  where OBJECT_TYPE = '\u4eba\u5458' and PARTNER_ID = ? and YEAR = ? and TYPE = ? and OBJECT_ID = ? ", updateArgs.toArray());
                continue;
            }
            updateArgs = new ArrayList();
            updateArgs.add(ts.getM1() * TargetService.vaildataNull(newTarget.getM1()) / 100.0);
            updateArgs.add(ts.getM2() * TargetService.vaildataNull(newTarget.getM2()) / 100.0);
            updateArgs.add(ts.getM3() * TargetService.vaildataNull(newTarget.getM3()) / 100.0);
            updateArgs.add(ts.getM4() * TargetService.vaildataNull(newTarget.getM4()) / 100.0);
            updateArgs.add(ts.getM5() * TargetService.vaildataNull(newTarget.getM5()) / 100.0);
            updateArgs.add(ts.getM6() * TargetService.vaildataNull(newTarget.getM6()) / 100.0);
            updateArgs.add(ts.getM7() * TargetService.vaildataNull(newTarget.getM7()) / 100.0);
            updateArgs.add(ts.getM8() * TargetService.vaildataNull(newTarget.getM8()) / 100.0);
            updateArgs.add(ts.getM9() * TargetService.vaildataNull(newTarget.getM9()) / 100.0);
            updateArgs.add(ts.getM10() * TargetService.vaildataNull(newTarget.getM10()) / 100.0);
            updateArgs.add(ts.getM11() * TargetService.vaildataNull(newTarget.getM11()) / 100.0);
            updateArgs.add(ts.getM12() * TargetService.vaildataNull(newTarget.getM12()) / 100.0);
            updateArgs.add("\u4eba\u5458");
            updateArgs.add(UUIDUtils.getId());
            updateArgs.add("0-2");
            updateArgs.add(new Date());
            updateArgs.add("0-2");
            updateArgs.add(new Date());
            args.addAll(updateArgs);
            args.add(newTarget.getChannelId() == null ? " " : newTarget.getChannelId());
            args.add(newTarget.getBigareaId() == null ? " " : newTarget.getBigareaId());
            args.add(newTarget.getAreaId() == null ? " " : newTarget.getAreaId());
            System.out.println(args.toArray());
            this.baseDao.executeSQL(" insert into CX_TARGET (PARTNER_ID,year,type,OBJECT_ID,M1,M2,M3,M4,M5,M6,M7,M8,M9,M10,M11,M12,OBJECT_TYPE,ROW_ID,CREATED_BY,CREATED,LAST_UPD_BY,LAST_UPD,CHANNEL_ID,BIGAREA_ID,AREA_ID) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ", args.toArray());
        }
    }

    public void updatePersonTarget(List<Target> targetList, String delIds, Employee me) {
        String[] ids;
        String[] stringArray = ids = delIds.split(",");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete Target where id= ?", args);
            }
            ++n2;
        }
        for (Target target : targetList) {
            target.fillInitData(me);
            target.setPartnerId(me.getCurrentPartner().getId());
            if (target.getBigareaId() != null) {
                target.setChannelId(Cache.getRegions(target.getBigareaId()).getParentId());
            }
            this.validataTarget(target);
            if (StringUtils.isNotEmpty(target.getId())) {
                this.baseDao.update((Object)target);
                continue;
            }
            this.baseDao.save((Object)target);
        }
    }

    private void validataTarget(Target target) {
        target.setM1(TargetService.vaildataNull(target.getM1()));
        target.setM2(TargetService.vaildataNull(target.getM2()));
        target.setM3(TargetService.vaildataNull(target.getM3()));
        target.setM4(TargetService.vaildataNull(target.getM4()));
        target.setM5(TargetService.vaildataNull(target.getM5()));
        target.setM6(TargetService.vaildataNull(target.getM6()));
        target.setM7(TargetService.vaildataNull(target.getM7()));
        target.setM8(TargetService.vaildataNull(target.getM8()));
        target.setM9(TargetService.vaildataNull(target.getM9()));
        target.setM10(TargetService.vaildataNull(target.getM10()));
        target.setM11(TargetService.vaildataNull(target.getM11()));
        target.setM12(TargetService.vaildataNull(target.getM12()));
    }

    public static boolean excels(List<Target> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5ba2\u6237\u52a9\u8bb0\u7801", "\u5ba2\u6237", "\u54c1\u724c", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708", "\u5355\u4f4d"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            Target stu = list.get(i);
            row.createCell(0).setCellValue(stu.getTypeName());
            row.createCell(1).setCellValue(stu.getApplyerCode());
            row.createCell(2).setCellValue(stu.getApplyerName());
            row.createCell(3).setCellValue(stu.getBrandName());
            row.createCell(4).setCellValue(TargetService.vaildataNull(stu.getM1()).doubleValue());
            row.createCell(5).setCellValue(TargetService.vaildataNull(stu.getM2()).doubleValue());
            row.createCell(6).setCellValue(TargetService.vaildataNull(stu.getM3()).doubleValue());
            row.createCell(7).setCellValue(TargetService.vaildataNull(stu.getM4()).doubleValue());
            row.createCell(8).setCellValue(TargetService.vaildataNull(stu.getM5()).doubleValue());
            row.createCell(9).setCellValue(TargetService.vaildataNull(stu.getM6()).doubleValue());
            row.createCell(10).setCellValue(TargetService.vaildataNull(stu.getM7()).doubleValue());
            row.createCell(11).setCellValue(TargetService.vaildataNull(stu.getM8()).doubleValue());
            row.createCell(12).setCellValue(TargetService.vaildataNull(stu.getM9()).doubleValue());
            row.createCell(13).setCellValue(TargetService.vaildataNull(stu.getM10()).doubleValue());
            row.createCell(14).setCellValue(TargetService.vaildataNull(stu.getM11()).doubleValue());
            row.createCell(15).setCellValue(TargetService.vaildataNull(stu.getM12()).doubleValue());
            row.createCell(16).setCellValue(stu.getUnit());
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean excelsPerson(List<Target> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5e74\u4efd", "\u4eba\u5458", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708", "\u5355\u4f4d"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            Target stu = list.get(i);
            String[] vals = new String[]{stu.getTypeName(), String.valueOf(stu.getYear()), stu.getObjectName(), String.valueOf(TargetService.vaildataNull(stu.getM1())), String.valueOf(TargetService.vaildataNull(stu.getM2())), String.valueOf(TargetService.vaildataNull(stu.getM3())), String.valueOf(TargetService.vaildataNull(stu.getM4())), String.valueOf(TargetService.vaildataNull(stu.getM5())), String.valueOf(TargetService.vaildataNull(stu.getM6())), String.valueOf(TargetService.vaildataNull(stu.getM7())), String.valueOf(TargetService.vaildataNull(stu.getM8())), String.valueOf(TargetService.vaildataNull(stu.getM9())), String.valueOf(TargetService.vaildataNull(stu.getM10())), String.valueOf(TargetService.vaildataNull(stu.getM11())), String.valueOf(TargetService.vaildataNull(stu.getM12())), String.valueOf(stu.getUnit())};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean exportCustomer(List<TargetWrap> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(String.valueOf(DateUtils.getCurrentDate((String)"yyyyMMdd")) + ".xls");
        HSSFCellStyle style = wb.createCellStyle();
        style.setVerticalAlignment((short)1);
        style.setAlignment((short)2);
        HSSFRow row = sheet.createRow(0);
        HSSFRow row2 = sheet.createRow(1);
        String[] name1 = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5355\u4f4d", "\u5e74\u4efd", "\u6e20\u9053", "\u5927\u533a", "\u533a\u57df", "\u5ba2\u6237"};
        String[] name2 = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u7b2c\u4e00\u5b63\u5ea6", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u7b2c\u4e8c\u5b63\u5ea6", "\u524d\u534a\u5e74", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u7b2c\u4e09\u5b63\u5ea6", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708", "\u7b2c\u56db\u5b63\u5ea6", "\u540e\u534a\u5e74", "\u5168\u5e74"};
        String[] name3 = new String[]{"\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u53bb\u5e74\u5b8c\u6210\u7387", "\u4eca\u5e74\u5b8c\u6210\u7387", "\u589e\u957f\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u53bb\u5e74\u5b8c\u6210\u7387", "\u4eca\u5e74\u5b8c\u6210\u7387", "\u589e\u957f\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387"};
        int i = 0;
        while (i < name1.length) {
            sheet.addMergedRegion(new CellRangeAddress(0, 1, i, (int)((short)i)));
            HSSFCell cell = (HSSFCell)row.createCell((int)((short)i));
            cell.setCellValue(name1[i]);
            cell.setCellStyle(style);
            ++i;
        }
        int ce = name1.length;
        int i2 = 0;
        while (i2 < name2.length) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, ce + i2 * 3, (short)ce + i2 * 3 + 2));
            HSSFCell cell = (HSSFCell)row.createCell((int)((short)(ce + i2 * 3)));
            cell.setCellValue(name2[i2]);
            cell.setCellStyle(style);
            ++i2;
        }
        i2 = 0;
        while (i2 < name3.length) {
            HSSFCell s1 = (HSSFCell)row2.createCell((short)ce + i2);
            s1.setCellValue(name3[i2]);
            s1.setCellStyle(style);
            ++i2;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static Double vaildataNull(Double db) {
        if (db == null) {
            db = 0.0;
        }
        return db;
    }

    public List<Target> queryAllTargetByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Customer c where t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    public List<TargetData> queryAllTargetDataByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t,Partner p,Customer c where t.userId is null and p.id = t.supplierId and c.supplierId = t.supplierId and c.applyerId = t.applyerId ");
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (condition.isPartner()) {
            hql.append(" and t.applyerId = ? ");
        } else {
            hql.append(" and t.supplierId = ? ");
        }
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.userId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    public Page getCustomerTargetPage(EmployeeMatchCustomerCondition con, Employee em) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from EmployeeMatchCustomer emp where emp.orgId = ? ");
        args.add(em.getCurrentPartner().getOrganizationid());
        if (Beans.isNotEmpty((Object)con.getCustomerId())) {
            hql.append(" and emp.customerId = ? ");
            args.add(con.getCustomerId());
        }
        hql.append(" order by emp.customerId");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), con.getPageSize() == null ? Constant.DEFAULT_ROWS : con.getPageSize(), con.getPageno().intValue());
        return page;
    }

    public List<String> saveBatch(List<EmployeeMatchCustomer> emcList, Employee em) {
        HashMap<String, CustomerMatchPerson> personMap = new HashMap<String, CustomerMatchPerson>();
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<CustomerMatchPerson> list = new ArrayList<CustomerMatchPerson>();
        int i = 0;
        for (EmployeeMatchCustomer emp : emcList) {
            ++i;
            CustomerMatchPerson salePerson = new CustomerMatchPerson();
            CustomerMatchPerson cityPerson = new CustomerMatchPerson();
            CustomerMatchPerson areaPerson = new CustomerMatchPerson();
            CustomerMatchPerson bigAreaPerson = new CustomerMatchPerson();
            salePerson.setOrgId(em.getCurrentPartner().getOrganizationid());
            salePerson.setCustomerId(emp.getCustomerId());
            salePerson.setCustomerNo(emp.getCustomerNo());
            salePerson.setCustomerName(emp.getCustomerName());
            cityPerson.setOrgId(em.getCurrentPartner().getOrganizationid());
            cityPerson.setCustomerId(emp.getCustomerId());
            cityPerson.setCustomerNo(emp.getCustomerNo());
            cityPerson.setCustomerName(emp.getCustomerName());
            areaPerson.setOrgId(em.getCurrentPartner().getOrganizationid());
            areaPerson.setCustomerId(emp.getCustomerId());
            areaPerson.setCustomerNo(emp.getCustomerNo());
            areaPerson.setCustomerName(emp.getCustomerName());
            bigAreaPerson.setOrgId(em.getCurrentPartner().getOrganizationid());
            bigAreaPerson.setCustomerId(emp.getCustomerId());
            bigAreaPerson.setCustomerNo(emp.getCustomerNo());
            bigAreaPerson.setCustomerName(emp.getCustomerName());
            if (Beans.isNotEmpty((Object)emp.getSalemanName()) && Beans.isNotEmpty((Object)emp.getSalemanNo())) {
                if (Beans.isNotEmpty(personMap.get(emp.getSalemanNo())) && !"1".equals(((CustomerMatchPerson)personMap.get(emp.getSalemanNo())).getLevel())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u4e1a\u52a1\u4eba\u5458" + emp.getSalemanName() + "\u4e0d\u80fd\u540c\u65f6\u62c5\u4efb\u591a\u4e2a\u804c\u4f4d");
                } else if (Beans.isNotEmpty(personMap.get(emp.getSalemanNo())) && !((CustomerMatchPerson)personMap.get(emp.getSalemanNo())).getPersonName().equals(emp.getSalemanName())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u4e1a\u52a1\u4eba\u5458" + emp.getSalemanName() + "\u7684\u7f16\u53f7" + emp.getSalemanNo() + "\u5df2\u88ab\u4f7f\u7528");
                } else {
                    salePerson.setPersonName(emp.getSalemanName());
                    salePerson.setPersonNo(emp.getSalemanNo());
                    salePerson.setLevel("1");
                    list.add(salePerson);
                    personMap.put(salePerson.getPersonNo(), salePerson);
                }
            } else if (Beans.isEmpty((Object)emp.getSalemanName()) && Beans.isNotEmpty((Object)emp.getSalemanNo())) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u4e1a\u52a1\u4eba\u5458\u7684\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (Beans.isNotEmpty((Object)emp.getSalemanName()) && Beans.isEmpty((Object)emp.getSalemanNo())) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u4e1a\u52a1\u4eba\u5458\u7684\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Beans.isNotEmpty((Object)emp.getCityManagerName()) && Beans.isNotEmpty((Object)emp.getCityManagerNo())) {
                if (Beans.isNotEmpty(personMap.get(emp.getCityManagerNo())) && !"2".equals(((CustomerMatchPerson)personMap.get(emp.getCityManagerNo())).getLevel())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u57ce\u5e02\u7ecf\u7406" + emp.getCityManagerName() + "\u4e0d\u80fd\u540c\u65f6\u62c5\u4efb\u591a\u4e2a\u804c\u4f4d");
                } else if (Beans.isNotEmpty(personMap.get(emp.getCityManagerNo())) && !((CustomerMatchPerson)personMap.get(emp.getCityManagerNo())).getPersonName().equals(emp.getCityManagerName())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u57ce\u5e02\u7ecf\u7406" + emp.getCityManagerName() + "\u7684\u7f16\u53f7" + emp.getCityManagerNo() + "\u5df2\u88ab\u4f7f\u7528");
                } else {
                    cityPerson.setPersonName(emp.getCityManagerName());
                    cityPerson.setPersonNo(emp.getCityManagerNo());
                    cityPerson.setLevel("2");
                    list.add(cityPerson);
                    personMap.put(cityPerson.getPersonNo(), cityPerson);
                    salePerson.setParentNo(emp.getCityManagerNo());
                }
            } else if (Beans.isEmpty((Object)emp.getCityManagerName()) && Beans.isNotEmpty((Object)emp.getCityManagerNo())) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u57ce\u5e02\u7ecf\u7406\u7684\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (Beans.isNotEmpty((Object)emp.getCityManagerName()) && Beans.isEmpty((Object)emp.getCityManagerNo())) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u57ce\u5e02\u7ecf\u7406\u7684\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Beans.isNotEmpty((Object)emp.getAreaManagerName()) && Beans.isNotEmpty((Object)emp.getAreaManagerNo())) {
                if (Beans.isNotEmpty(personMap.get(emp.getAreaManagerNo())) && !"3".equals(((CustomerMatchPerson)personMap.get(emp.getAreaManagerNo())).getLevel())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u533a\u57df\u7ecf\u7406" + emp.getAreaManagerName() + "\u4e0d\u80fd\u540c\u65f6\u62c5\u4efb\u591a\u4e2a\u804c\u4f4d");
                } else if (Beans.isNotEmpty(personMap.get(emp.getAreaManagerNo())) && !((CustomerMatchPerson)personMap.get(emp.getAreaManagerNo())).getPersonName().equals(emp.getAreaManagerName())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u533a\u57df\u7ecf\u7406" + emp.getAreaManagerName() + "\u7684\u7f16\u53f7" + emp.getAreaManagerNo() + "\u5df2\u88ab\u4f7f\u7528");
                } else {
                    areaPerson.setPersonName(emp.getAreaManagerName());
                    areaPerson.setPersonNo(emp.getAreaManagerNo());
                    areaPerson.setLevel("3");
                    list.add(areaPerson);
                    personMap.put(areaPerson.getPersonNo(), areaPerson);
                    if (Beans.isEmpty((Object)emp.getCityManagerName()) || Beans.isEmpty((Object)emp.getCityManagerNo())) {
                        salePerson.setParentNo(emp.getAreaManagerNo());
                    } else {
                        cityPerson.setParentNo(emp.getAreaManagerNo());
                    }
                }
            } else if (Beans.isEmpty((Object)emp.getAreaManagerName()) && Beans.isNotEmpty((Object)emp.getAreaManagerNo())) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u533a\u57df\u7ecf\u7406\u7684\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (Beans.isNotEmpty((Object)emp.getAreaManagerName()) && Beans.isEmpty((Object)emp.getAreaManagerNo())) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u533a\u57df\u7ecf\u7406\u7684\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Beans.isNotEmpty((Object)emp.getBigAreaManagerName()) && Beans.isNotEmpty((Object)emp.getBigAreaManagerNo())) {
                if (Beans.isNotEmpty(personMap.get(emp.getBigAreaManagerNo())) && !"4".equals(((CustomerMatchPerson)personMap.get(emp.getBigAreaManagerNo())).getLevel())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u5927\u533a\u7ecf\u7406" + emp.getBigAreaManagerName() + "\u4e0d\u80fd\u540c\u65f6\u62c5\u4efb\u591a\u4e2a\u804c\u4f4d");
                    continue;
                }
                if (Beans.isNotEmpty(personMap.get(emp.getBigAreaManagerNo())) && !((CustomerMatchPerson)personMap.get(emp.getBigAreaManagerNo())).getPersonName().equals(emp.getBigAreaManagerName())) {
                    messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u5927\u533a\u7ecf\u7406" + emp.getBigAreaManagerName() + "\u7684\u7f16\u53f7" + emp.getBigAreaManagerNo() + "\u5df2\u88ab\u4f7f\u7528");
                    continue;
                }
                bigAreaPerson.setPersonName(emp.getBigAreaManagerName());
                bigAreaPerson.setPersonNo(emp.getBigAreaManagerNo());
                bigAreaPerson.setLevel("4");
                list.add(bigAreaPerson);
                personMap.put(bigAreaPerson.getPersonNo(), bigAreaPerson);
                if (Beans.isEmpty((Object)emp.getAreaManagerName()) || Beans.isEmpty((Object)emp.getAreaManagerNo())) {
                    if (Beans.isEmpty((Object)emp.getCityManagerName()) || Beans.isEmpty((Object)emp.getCityManagerNo())) {
                        salePerson.setParentNo(emp.getBigAreaManagerNo());
                        continue;
                    }
                    cityPerson.setParentNo(emp.getBigAreaManagerNo());
                    continue;
                }
                areaPerson.setParentNo(emp.getBigAreaManagerNo());
                continue;
            }
            if (Beans.isEmpty((Object)emp.getBigAreaManagerName()) && Beans.isNotEmpty((Object)emp.getBigAreaManagerNo())) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u5927\u533a\u7ecf\u7406\u7684\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (!Beans.isNotEmpty((Object)emp.getBigAreaManagerName()) || !Beans.isEmpty((Object)emp.getBigAreaManagerNo())) continue;
            messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u4e2d\u5927\u533a\u7ecf\u7406\u7684\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (messages.size() == 0) {
            String orgId = em.getCurrentPartner().getOrganizationid();
            this.baseDao.executeHQL(" delete CustomerMatchPerson where orgId = ? ", new Object[]{orgId});
            for (CustomerMatchPerson c : list) {
                StringBuilder hql = new StringBuilder();
                ArrayList<String> args = new ArrayList<String>();
                hql.append(" from CustomerMatchPerson c where c.orgId = ? ");
                args.add(c.getOrgId());
                hql.append(" and c.customerId = ? ");
                args.add(c.getCustomerId());
                hql.append(" and c.personNo = ? ");
                args.add(c.getPersonNo());
                CustomerMatchPerson cmp = (CustomerMatchPerson)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), CustomerMatchPerson.class);
                if (Beans.isEmpty((Object)cmp)) {
                    this.baseDao.save((Object)c);
                    continue;
                }
                cmp.setCustomerNo(c.getCustomerNo());
                cmp.setCustomerName(c.getCustomerName());
                cmp.setPersonName(c.getPersonName());
                cmp.setParentNo(c.getParentNo());
                cmp.setLevel(c.getLevel());
                this.baseDao.update((Object)cmp);
            }
        }
        return messages;
    }

    public Page getTargetByNewPersonForPage(TargetCondition con, Employee em) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" select p.person_no,p.person_name,c.type,c.year,");
        hql.append("sum(c.m1),sum(c.m2),sum(c.m3),sum(c.m4),sum(c.m5),sum(c.m6),sum(c.m7),sum(c.m8),sum(c.m9),sum(c.m10),sum(c.m11),sum(c.m12) ");
        hql.append("from cx_target c ,cx_customer_match_person p ");
        hql.append(" where c.object_id = p.customer_id and c.object_type = '\u5ba2\u6237' and p.org_id = ?  ");
        args.add(em.getCurrentPartner().getOrganizationid());
        if (Beans.isNotEmpty((Object)con.getYear())) {
            hql.append(" and c.year = ?");
            args.add(con.getYear());
        }
        if (Beans.isNotEmpty((Object)con.getTargetType())) {
            hql.append(" and c.type = ?");
            args.add(con.getTargetType());
        }
        hql.append(" group by p.person_no,p.person_name,c.type,c.year order by p.person_no,p.person_name,c.type,c.year ");
        Page page = this.baseDao.searchBySql(hql.toString(), args.toArray(), con.getRowsize() == null ? Constant.DEFAULT_ROWS : con.getRowsize(), con.getPageno().intValue(), Object.class);
        List list = page.getList();
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Object object : list) {
            Object[] obj = (Object[])object;
            Target target = new Target();
            target.setObjectId(String.valueOf(obj[0]));
            target.setObjectName(String.valueOf(obj[1]));
            target.setType(String.valueOf(obj[2]));
            target.setPartnerId(em.getCurrentPartner().getOrganizationid());
            target.setYear(Long.valueOf(String.valueOf(obj[3])));
            target.setM1(Double.valueOf(String.valueOf(obj[4])));
            target.setM2(Double.valueOf(String.valueOf(obj[5])));
            target.setM3(Double.valueOf(String.valueOf(obj[6])));
            target.setM4(Double.valueOf(String.valueOf(obj[7])));
            target.setM5(Double.valueOf(String.valueOf(obj[8])));
            target.setM6(Double.valueOf(String.valueOf(obj[9])));
            target.setM7(Double.valueOf(String.valueOf(obj[10])));
            target.setM8(Double.valueOf(String.valueOf(obj[11])));
            target.setM9(Double.valueOf(String.valueOf(obj[12])));
            target.setM10(Double.valueOf(String.valueOf(obj[13])));
            target.setM11(Double.valueOf(String.valueOf(obj[14])));
            target.setM12(Double.valueOf(String.valueOf(obj[15])));
            targets.add(target);
        }
        page.setList(targets);
        return page;
    }

    public <T> T getTargetByNewPerson(TargetCondition con, Employee em, Class<T> clazz) {
        StringBuilder hql = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from Target t where t.year = ? and t.objectType = '\u5ba2\u6237' ");
        args.add(Long.valueOf(con.getYear()));
        if (Beans.isNotEmpty((Object)con.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(con.getTargetType());
        }
        List customers = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        HashMap<String, Target> persons = new HashMap<String, Target>();
        for (Target t : customers) {
            List<CustomerMatchPerson> cmps = this.getCustomerMatchPersonList(t.getObjectId(), em);
            Iterator iterator = cmps.iterator();
            while (iterator.hasNext()) {
                Target target;
                CustomerMatchPerson c = (CustomerMatchPerson)iterator.next();
                TargetSplit ts = this.getTargetSplit(c, em, t.getYear(), t.getType());
                EmployeeMatchCustomer emp = new EmployeeMatchCustomer();
                this.setEmployeeMatchCustomer(emp, c);
                if (Beans.isNotEmpty((Object)emp.getSalemanNo()) && Beans.isEmpty(persons.get(String.valueOf(emp.getSalemanNo()) + t.getType()))) {
                    target = new Target();
                    Beans.copy((Object)target, (Object)t);
                    target.setObjectId(emp.getSalemanNo());
                    target.setObjectName(emp.getSalemanName());
                    if (Beans.isNotEmpty((Object)ts)) {
                        this.setMonthQuantity(target, ts);
                    }
                    persons.put(String.valueOf(target.getObjectId()) + t.getType(), target);
                } else if (Beans.isNotEmpty((Object)emp.getSalemanNo()) && Beans.isNotEmpty(persons.get(String.valueOf(emp.getSalemanNo()) + t.getType()))) {
                    target = (Target)persons.get(String.valueOf(emp.getSalemanNo()) + t.getType());
                    if (Beans.isNotEmpty((Object)ts)) {
                        this.calculate(t, ts, target);
                    } else {
                        this.add(t, target);
                    }
                }
                if (Beans.isNotEmpty((Object)emp.getCityManagerNo()) && Beans.isEmpty(persons.get(String.valueOf(emp.getCityManagerNo()) + t.getType()))) {
                    target = new Target();
                    Beans.copy((Object)target, (Object)t);
                    target.setObjectId(emp.getCityManagerNo());
                    target.setObjectName(emp.getCityManagerName());
                    if (Beans.isNotEmpty((Object)ts)) {
                        this.setMonthQuantity(target, ts);
                    }
                    persons.put(String.valueOf(target.getObjectId()) + t.getType(), target);
                } else if (Beans.isNotEmpty((Object)emp.getCityManagerNo()) && Beans.isNotEmpty(persons.get(String.valueOf(emp.getCityManagerNo()) + t.getType()))) {
                    target = (Target)persons.get(String.valueOf(emp.getCityManagerNo()) + t.getType());
                    if (Beans.isNotEmpty((Object)ts)) {
                        this.calculate(t, ts, target);
                    } else {
                        this.add(t, target);
                    }
                }
                if (Beans.isNotEmpty((Object)emp.getAreaManagerNo()) && Beans.isEmpty(persons.get(String.valueOf(emp.getAreaManagerNo()) + t.getType()))) {
                    target = new Target();
                    Beans.copy((Object)target, (Object)t);
                    target.setObjectId(emp.getAreaManagerNo());
                    target.setObjectName(emp.getAreaManagerName());
                    if (Beans.isNotEmpty((Object)ts)) {
                        this.setMonthQuantity(target, ts);
                    }
                    persons.put(String.valueOf(target.getObjectId()) + t.getType(), target);
                } else if (Beans.isNotEmpty((Object)emp.getAreaManagerNo()) && Beans.isNotEmpty(persons.get(String.valueOf(emp.getAreaManagerNo()) + t.getType()))) {
                    target = (Target)persons.get(String.valueOf(emp.getAreaManagerNo()) + t.getType());
                    if (Beans.isNotEmpty((Object)ts)) {
                        this.calculate(t, ts, target);
                    } else {
                        this.add(t, target);
                    }
                }
                if (Beans.isNotEmpty((Object)emp.getBigAreaManagerNo()) && Beans.isEmpty(persons.get(String.valueOf(emp.getBigAreaManagerNo()) + t.getType()))) {
                    target = new Target();
                    Beans.copy((Object)target, (Object)t);
                    target.setObjectId(emp.getBigAreaManagerNo());
                    target.setObjectName(emp.getBigAreaManagerName());
                    if (Beans.isNotEmpty((Object)ts)) {
                        this.setMonthQuantity(target, ts);
                    }
                    persons.put(String.valueOf(target.getObjectId()) + t.getType(), target);
                    continue;
                }
                if (!Beans.isNotEmpty((Object)emp.getBigAreaManagerNo()) || !Beans.isNotEmpty(persons.get(String.valueOf(emp.getBigAreaManagerNo()) + t.getType()))) continue;
                target = (Target)persons.get(String.valueOf(emp.getBigAreaManagerNo()) + t.getType());
                if (Beans.isNotEmpty((Object)ts)) {
                    this.calculate(t, ts, target);
                    continue;
                }
                this.add(t, target);
            }
        }
        Page newTargets = new ArrayList();
        for (String no : persons.keySet()) {
            newTargets.add((Target)persons.get(no));
        }
        Collections.sort(newTargets, new Comparator<Target>(){

            @Override
            public int compare(Target t1, Target t2) {
                return t1.getObjectId().compareTo(t2.getObjectId());
            }
        });
        Page t = null;
        if (clazz == Page.class) {
            Page page;
            ArrayList<Target> pagelist = new ArrayList<Target>();
            int first = (con.getPageno() - 1) * (con.getPageSize() == null ? Constant.DEFAULT_ROWS : con.getPageSize());
            int last = con.getPageno() * (con.getPageSize() == null ? Constant.DEFAULT_ROWS : con.getPageSize()) > newTargets.size() ? newTargets.size() : con.getPageno() * (con.getPageSize() == null ? Constant.DEFAULT_ROWS : con.getPageSize());
            int i = first;
            while (i < last) {
                pagelist.add((Target)newTargets.get(i));
                ++i;
            }
            t = page = new Page(pagelist, con.getPageno().intValue(), con.getPageSize() == null ? Constant.DEFAULT_ROWS : con.getPageSize(), newTargets.size());
        } else {
            t = newTargets;
        }
        return (T)t;
    }

    public TargetSplit getTargetSplit(CustomerMatchPerson c, Employee em, Long year, String type) {
        String s = " from TargetSplit where orgId = ? and userId = ? and partnerId = ? and year = ? and type = ? ";
        return (TargetSplit)this.baseDao.findFirstEntity(s, new Object[]{em.getCurrentPartner().getOrganizationid(), c.getPersonNo(), c.getCustomerId(), String.valueOf(year), type}, TargetSplit.class);
    }

    public List<CustomerMatchPerson> getCustomerMatchPersonList(String objectId, Employee em) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from CustomerMatchPerson c where c.orgId = ? and customerId = ? and  not exists(select 1 from CustomerMatchPerson m where c.personNo = m.parentNo )");
        args.add(em.getCurrentPartner().getOrganizationid());
        args.add(objectId);
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), CustomerMatchPerson.class);
        return list;
    }

    private void setMonthQuantity(Target saleTarget, TargetSplit ts) {
        saleTarget.setM1(saleTarget.getM1() * ts.getM1() / 100.0);
        saleTarget.setM2(saleTarget.getM2() * ts.getM2() / 100.0);
        saleTarget.setM3(saleTarget.getM3() * ts.getM3() / 100.0);
        saleTarget.setM4(saleTarget.getM4() * ts.getM4() / 100.0);
        saleTarget.setM5(saleTarget.getM5() * ts.getM5() / 100.0);
        saleTarget.setM6(saleTarget.getM6() * ts.getM6() / 100.0);
        saleTarget.setM7(saleTarget.getM7() * ts.getM7() / 100.0);
        saleTarget.setM8(saleTarget.getM8() * ts.getM8() / 100.0);
        saleTarget.setM9(saleTarget.getM9() * ts.getM9() / 100.0);
        saleTarget.setM10(saleTarget.getM10() * ts.getM10() / 100.0);
        saleTarget.setM11(saleTarget.getM11() * ts.getM11() / 100.0);
        saleTarget.setM12(saleTarget.getM12() * ts.getM12() / 100.0);
    }

    private void calculate(Target t, TargetSplit ts, Target saleTarget) {
        saleTarget.setM1(t.getM1() * ts.getM1() / 100.0 + saleTarget.getM1());
        saleTarget.setM2(t.getM2() * ts.getM2() / 100.0 + saleTarget.getM2());
        saleTarget.setM3(t.getM3() * ts.getM3() / 100.0 + saleTarget.getM3());
        saleTarget.setM4(t.getM4() * ts.getM4() / 100.0 + saleTarget.getM4());
        saleTarget.setM5(t.getM5() * ts.getM5() / 100.0 + saleTarget.getM5());
        saleTarget.setM6(t.getM6() * ts.getM6() / 100.0 + saleTarget.getM6());
        saleTarget.setM7(t.getM7() * ts.getM7() / 100.0 + saleTarget.getM7());
        saleTarget.setM8(t.getM8() * ts.getM8() / 100.0 + saleTarget.getM8());
        saleTarget.setM9(t.getM9() * ts.getM9() / 100.0 + saleTarget.getM9());
        saleTarget.setM10(t.getM10() * ts.getM10() / 100.0 + saleTarget.getM10());
        saleTarget.setM11(t.getM11() * ts.getM11() / 100.0 + saleTarget.getM11());
        saleTarget.setM12(t.getM12() * ts.getM12() / 100.0 + saleTarget.getM12());
    }

    private void add(Target t, Target saleTarget) {
        saleTarget.setM1(t.getM1() + saleTarget.getM1());
        saleTarget.setM2(t.getM2() + saleTarget.getM2());
        saleTarget.setM3(t.getM3() + saleTarget.getM3());
        saleTarget.setM4(t.getM4() + saleTarget.getM4());
        saleTarget.setM5(t.getM5() + saleTarget.getM5());
        saleTarget.setM6(t.getM6() + saleTarget.getM6());
        saleTarget.setM7(t.getM7() + saleTarget.getM7());
        saleTarget.setM8(t.getM8() + saleTarget.getM8());
        saleTarget.setM9(t.getM9() + saleTarget.getM9());
        saleTarget.setM10(t.getM10() + saleTarget.getM10());
        saleTarget.setM11(t.getM11() + saleTarget.getM11());
        saleTarget.setM12(t.getM12() + saleTarget.getM12());
    }

    public List<EmployeeMatchCustomer> getEmcListByCustomer(String objectId, Employee em) {
        EmployeeMatchCustomerCondition con = new EmployeeMatchCustomerCondition();
        con.setPageno(1);
        con.setPageSize(Integer.MAX_VALUE);
        con.setCustomerId(objectId);
        List emclist = this.getCustomerMatchPerson(con, em).getList();
        return emclist;
    }

    public TargetSplit findTargetSplit(String customerId, String year, String salemanNo, String type) {
        String hql = "from TargetSplit t where t.partnerId = ? and t.year = ? and t.type = ? and t.userId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(customerId);
        args.add(year);
        args.add(type);
        args.add(salemanNo);
        TargetSplit ts = (TargetSplit)this.baseDao.findFirstEntity(hql, args.toArray(), TargetSplit.class);
        return ts;
    }

    public Page getCustomerMatchPerson(EmployeeMatchCustomerCondition con, Employee em) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from CustomerMatchPerson c where c.orgId = ? and  not exists(select 1 from CustomerMatchPerson m where c.personNo = m.parentNo )");
        args.add(em.getCurrentPartner().getOrganizationid());
        if (Beans.isNotEmpty((Object)con.getCustomerId())) {
            hql.append(" and c.customerId = ? ");
            args.add(con.getCustomerId());
        }
        hql.append(" order by c.customerId");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), con.getPageSize() == null ? Constant.DEFAULT_ROWS : con.getPageSize(), con.getPageno().intValue());
        List list = page.getList();
        ArrayList<EmployeeMatchCustomer> newlist = new ArrayList<EmployeeMatchCustomer>();
        for (CustomerMatchPerson c : list) {
            EmployeeMatchCustomer emp = new EmployeeMatchCustomer();
            this.setEmployeeMatchCustomer(emp, c);
            newlist.add(emp);
        }
        page.setList(newlist);
        return page;
    }

    public void setEmployeeMatchCustomer(EmployeeMatchCustomer emp, CustomerMatchPerson c) {
        emp.setCustomerId(c.getCustomerId());
        emp.setCustomerName(c.getCustomerName());
        emp.setCustomerNo(c.getCustomerNo());
        emp.setOrgId(c.getOrgId());
        this.setPersonNoAndName(emp, c);
    }

    public void setPersonNoAndName(EmployeeMatchCustomer emp, CustomerMatchPerson c) {
        if ("1".equals(c.getLevel())) {
            emp.setSalemanName(c.getPersonName());
            emp.setSalemanNo(c.getPersonNo());
        } else if ("2".equals(c.getLevel())) {
            emp.setCityManagerName(c.getPersonName());
            emp.setCityManagerNo(c.getPersonNo());
        } else if ("3".equals(c.getLevel())) {
            emp.setAreaManagerName(c.getPersonName());
            emp.setAreaManagerNo(c.getPersonNo());
        } else if ("4".equals(c.getLevel())) {
            emp.setBigAreaManagerName(c.getPersonName());
            emp.setBigAreaManagerNo(c.getPersonNo());
        }
        if (Beans.isNotEmpty((Object)c.getParentNo())) {
            CustomerMatchPerson cmp = this.getCustomerMatchPersonByPersonNo(c.getParentNo(), c.getOrgId());
            this.setPersonNoAndName(emp, cmp);
        }
    }

    public CustomerMatchPerson getCustomerMatchPersonByPersonNo(String parentNo, String orgId) {
        return (CustomerMatchPerson)this.baseDao.findFirstEntity(" from CustomerMatchPerson where personNo = ? and orgId = ? ", new Object[]{parentNo, orgId}, CustomerMatchPerson.class);
    }
}

