/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.target;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.target.TargetCondition;
import com.tcbj.crm.target.TargetService;
import com.tcbj.crm.target.TargetViewCondition;
import com.tcbj.crm.target.TargetViewService;
import com.tcbj.crm.target.excel.TargetSellerExc;
import com.tcbj.crm.target.excel.TargetViewExc;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/targetview"})
public class TargetViewController
extends BaseController {
    @Autowired
    TargetViewService service;
    @Autowired
    TargetService targetService;

    @RequestMapping(value={"/targetAll.do"}, method={RequestMethod.GET})
    public String targetAll(@ModelAttribute(value="condition") TargetViewCondition con, Model model) {
        Employee emp = this.getCurrentEmployee();
        if (emp.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "target/view/targetAll.ftl";
    }

    @RequestMapping(value={"/targetAll_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page targetAll_data(@ModelAttribute(value="condition") TargetViewCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="10000") int rowsize, Model model) {
        con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        con.setPageno(pageNo);
        con.setPageSize(rowsize);
        return this.service.targetAllQuery(con, 1, Integer.MAX_VALUE);
    }

    @RequestMapping(value={"/export.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(TargetViewCondition con, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="1000") int rowsize) {
        Employee em = this.getCurrentEmployee();
        try {
            con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
            con.setEmployeeId(this.getCurrentEmployee().getId());
            File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "exportexcel");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ("all".equals(con.getByType())) {
                con.setPageno(pageNo);
                con.setPageSize(rowsize);
                List<TargetViewExc> excelDatas = this.service.getTargetAllExcelData(con, pageNo, Integer.MAX_VALUE);
                String[] titles = new String[]{"\u8d39\u7528\u7c7b\u578b", "\u76ee\u6807\u5e74\u4efd", "\u5355\u4f4d", "\u54c1\u724c", "\u6e20\u9053", "\u5927\u533a", "\u533a\u57df", "\u5ba2\u6237", "\u76ee\u6807\u503c", "1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
                ExcelUtils.exportExcel("\u76ee\u6807\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u76ee\u6807\u8bbe\u7f6e", titles, excelDatas, response);
            } else if ("seller".equals(con.getByType())) {
                List<TargetSellerExc> excelDatas = this.service.getSellerTargetExcelData(con, pageNo, Integer.MAX_VALUE, em);
                String[] titles = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5355\u4f4d", "\u9500\u552e\u4eba\u5458", "\u76ee\u6807\u503c", "1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
                ExcelUtils.exportExcel("\u9500\u552e\u4eba\u5458\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u4eba\u5458\u76ee\u6807\u8bbe\u7f6e", titles, excelDatas, response);
            }
        }
        catch (Exception e) {
            throw new AppException("\u76ee\u6807\u62a5\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/org.do"}, method={RequestMethod.GET})
    public String org(@ModelAttribute(value="condition") TargetViewCondition con, Model model) {
        Employee emp = this.getCurrentEmployee();
        if (emp.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "target/view/org.ftl";
    }

    @RequestMapping(value={"/org_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page org_data(@ModelAttribute(value="condition") TargetViewCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="1") int rowsize, Model model) {
        con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        return this.service.orgQuery(con, pageNo, rowsize);
    }

    @RequestMapping(value={"/channel.do"}, method={RequestMethod.GET})
    public String channel(@ModelAttribute(value="condition") TargetViewCondition con, Model model) {
        return "target/view/channel.ftl";
    }

    @RequestMapping(value={"/channel_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page channel_data(@ModelAttribute(value="condition") TargetViewCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="1") int rowsize, Model model) {
        con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        return this.service.channelQuery(con, pageNo, rowsize);
    }

    @RequestMapping(value={"/bigarea.do"}, method={RequestMethod.GET})
    public String bigarea() {
        return "target/view/bigarea.ftl";
    }

    @RequestMapping(value={"/bigarea_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page bigarea_data(@ModelAttribute(value="condition") TargetViewCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="1") int rowsize, Model model) {
        con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        return this.service.bigareaQuery(con, pageNo, rowsize);
    }

    @RequestMapping(value={"/area.do"}, method={RequestMethod.GET})
    public String area() {
        return "target/view/area.ftl";
    }

    @RequestMapping(value={"/area_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page area_data(@ModelAttribute(value="condition") TargetViewCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="1") int rowsize, Model model) {
        con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        return this.service.areaQuery(con, pageNo, rowsize);
    }

    @RequestMapping(value={"/sellerCustomer.do"}, method={RequestMethod.GET})
    public String sellerCustomer(TargetViewCondition con, Model model) {
        return "target/view/seller.ftl";
    }

    @RequestMapping(value={"/sellerCustomer_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page sellerCustomer_data(@ModelAttribute(value="condition") TargetViewCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="rowsize", required=false, defaultValue="1") int rowsize, Model model) {
        con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        return this.service.findCustomerTargetBySeller(con, pageno, rowsize);
    }

    @RequestMapping(value={"/seller.do"}, method={RequestMethod.GET})
    public String seller(@ModelAttribute(value="condition") TargetCondition con, Model model) {
        Employee emp = this.getCurrentEmployee();
        if (emp.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        model.addAttribute("condition", (Object)con);
        return "target/view/seller.ftl";
    }

    @RequestMapping(value={"/seller_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page seller_data(@ModelAttribute(value="condition") TargetCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="1") int rowsize, Model model) {
        con.setPageno(pageNo);
        con.setPageSize(rowsize);
        Page page = this.targetService.getTargetByNewPersonForPage(con, this.getCurrentEmployee());
        return page;
    }

    @RequestMapping(value={"/customer.do"}, method={RequestMethod.GET})
    public String customer(Model model) {
        Employee emp = this.getCurrentEmployee();
        if (emp.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "target/view/customer.ftl";
    }

    @RequestMapping(value={"/customer_data.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page customer_data(@ModelAttribute(value="condition") TargetViewCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="1") int rowsize, Model model) {
        con.setSupplierId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        return this.service.customerQuery(con, pageNo, rowsize);
    }
}

