/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetdata;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.entity.TargetDataItem;
import com.tcbj.crm.targetdata.TargetDataCondition;
import com.tcbj.crm.targetdata.TargetDataService;
import com.tcbj.crm.targetdatae.TargetDataeService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/targetdata"})
public class TargetDataController
extends BaseController {
    @Autowired
    TargetDataService service;
    @Autowired
    TargetDataeService targetDataeService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, TargetDataCondition condition, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        condition.setPartnerId(e.getCurrentPartner().getId());
        if (condition.getYear() == null) {
            condition.setYear(Long.valueOf(DateUtils.getYear()));
        }
        condition.setUserId(e.getId());
        if (e.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        Page page = this.service.getNewTargetDatas(e, condition);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "targetdata/list.ftl";
    }

    @RequestMapping(value={"batchedit.do"}, method={RequestMethod.GET})
    public String editsGet(Model model) {
        Employee em = this.getCurrentEmployee();
        if (em.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "targetdata/batchedit.ftl";
    }

    @RequestMapping(value={"/editTarget.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editGifts(TargetDataCondition condition, int pageno) {
        Employee e = this.getCurrentEmployee();
        condition.setPartnerId(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        return this.service.getPage(e.getCurrentPartner().getId(), pageno, condition);
    }

    @RequestMapping(value={"/editTarget.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPostGrd(@Valid @RequestBody TargetDataCondition wrap) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = wrap.getDelIds();
        List<TargetData> targetData = wrap.getTargetData();
        this.service.update(targetData, delIds, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/addItem.do"}, method={RequestMethod.GET})
    public String addItem(Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("date", (Object)DateUtils.formartDate((Date)new Date(), (String)"yyyy"));
        return "targetdata/addItem.ftl";
    }

    @RequestMapping(value={"/addItem.do"}, method={RequestMethod.POST})
    public String addItemPost(Long year, Model model, HttpServletRequest request) {
        String rtn = null;
        String url = "";
        List<IUploadFile> filelist = this.uploadFile(request, "targetdata");
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<TargetDataItem> list = new ArrayList<TargetDataItem>();
        List<AdjustStockUtil> msglist = this.getFileReadyExcelItem(year, list, url);
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    public List<AdjustStockUtil> getFileReadyExcelItem(Long year, List<TargetDataItem> list, String url) {
        Employee emp = this.getCurrentEmployee();
        LinkedList<List<Object>> readExcelList = new LinkedList();
        readExcelList = ExcelHandle.readExcel(url);
        List<AdjustStockUtil> msglist = this.service.saveAndValidateItem(year, readExcelList, emp, list);
        return msglist;
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("date", (Object)DateUtils.formartDate((Date)new Date(), (String)"yyyy"));
        return "targetdata/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String addPost(Long year, Model model, HttpServletRequest request) {
        String rtn = null;
        String url = "";
        List<IUploadFile> filelist = this.uploadFile(request, "targetdata");
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<TargetData> list = new ArrayList<TargetData>();
        List<AdjustStockUtil> msglist = this.getFileReadyExcel(year, list, url);
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        Employee me = this.getCurrentEmployee();
        HashMap<String, TargetData> map = new HashMap<String, TargetData>();
        this.initMap(map, year, me);
        this.service.update(list, year, me, map);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    private void initMap(Map<String, TargetData> map, Long year, Employee e) {
        List<TargetData> datas = this.service.getList(e.getCurrentPartner().getId(), year);
        for (TargetData t1 : datas) {
            map.put(String.valueOf(t1.getType()) + t1.getYear().toString() + t1.getApplyerId() + t1.getBrand(), t1);
        }
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.service.delete(id);
        return "redirect:/targetdata/list.do";
    }

    List<AdjustStockUtil> getFileReadyExcel(Long year, List<TargetData> list, String url) {
        Employee emp = this.getCurrentEmployee();
        LinkedList<List<Object>> readExcelList = new LinkedList();
        readExcelList = ExcelHandle.readExcel(url);
        List<AdjustStockUtil> msglist = this.service.validate(year, readExcelList, emp, list);
        return msglist;
    }

    @RequestMapping(value={"/listExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(TargetDataCondition condition, HttpServletRequest request, HttpServletResponse response) {
        Employee e = this.getCurrentEmployee();
        condition.setPartnerId(e.getCurrentPartner().getId());
        if (condition.getYear() == null) {
            condition.setYear(Long.valueOf(DateUtils.getYear()));
        }
        condition.setUserId(e.getId());
        condition.setRowsize(Integer.MAX_VALUE);
        List list = this.service.getNewTargetDatas(e, condition).getList();
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "target");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.service.excels(list, dir.getPath(), "\u5ba2\u6237\u5b8c\u6210\u503c\u62a5\u8868-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }
}

