/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetover;

import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.TargetSplit;
import com.tcbj.crm.entity.TargeteOver;
import com.tcbj.crm.targetover.TargeteOverCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetOverService")
public class TargeteOverService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public TargeteOver getById(String id) {
        return (TargeteOver)this.baseDao.get(TargeteOver.class, (Serializable)((Object)id));
    }

    public Page findPartnerApplysValid(ClientCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(con.getEmployeeId());
        HQL.append("from Customer c where supplierId=?");
        args.add(con.getPartnerId());
        HQL.append(" and (c.bigAreaCode in ( ");
        HQL.append(sb);
        HQL.append(") or c.areaCode in ( ");
        HQL.append(sb);
        HQL.append(" ))");
        if (StringUtils.isNotEmpty(con.getUserId())) {
            HQL.append(" and (exists(from TargeteOver ts where ts.partnerId = c.applyerId and ts.userId = ? )) ");
            args.add(con.getUserId());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and applyerName like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getAreaId())) {
            HQL.append(" and areaCode = ?");
            args.add(con.getAreaId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            HQL.append(" and bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getApplyerCode())) {
            HQL.append(" and applyerCode like ?");
            args.add("%" + con.getApplyerCode().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and createDt <= ?");
            args.add(con.getCreateDtE());
        }
        HQL.append(" and startdate <= ? and nvl(enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        HQL.append(" order by applyerCode ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page getPage(TargeteOverCondition con, int pageno) {
        String hql = "from TargeteOver t where t.partnerId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getPartnerId());
        hql = String.valueOf(hql) + "order by t.year desc ";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<TargeteOver> getTargetSplits(TargeteOverCondition con) {
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from TargeteOver t where t.orgId = ? and t.partnerId = ? ";
        args.add(con.getOrgId());
        args.add(con.getPartnerId());
        if (StringUtils.isNotEmpty(con.getYear())) {
            hql = String.valueOf(hql) + " and t.year = ? ";
            args.add(con.getYear());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + " and t.type = ? ";
            args.add(con.getType());
        }
        hql = String.valueOf(hql) + " order by t.year desc";
        return this.baseDao.findEntity(hql, args.toArray(), TargeteOver.class);
    }

    public void saveAndUpdate(TargeteOverCondition con, Employee em) {
        List<TargeteOver> list = con.getOverList();
        for (TargeteOver ts : list) {
            ts.setPartnerId(con.getPartnerId());
            ts.setYear(con.getYear());
            ts.fillInitData(em);
            ts.setOrgId(con.getOrgId());
            if (StringUtils.isNotEmpty(ts.getId())) {
                this.baseDao.update((Object)ts);
                continue;
            }
            this.baseDao.save((Object)ts);
        }
    }

    public void del(String id) {
        this.baseDao.deleteById(TargetSplit.class, (Serializable)((Object)id));
    }

    public boolean isExist(String partnerId, String year, String type, String userId, String id) {
        List tss;
        boolean isExist = false;
        String hql = "from TargeteOver t where t.partnerId = ? and t.year = ? and t.type = ? and t.userId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        args.add(year);
        args.add(type);
        args.add(userId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + "and t.id != ? ";
            args.add(id);
        }
        if ((tss = this.baseDao.findEntity(hql, args.toArray(), TargetSplit.class)).size() > 0) {
            isExist = true;
        }
        return isExist;
    }
}

