/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetrate;

import com.tcbj.crm.entity.TargetRate;
import com.tcbj.crm.targetrate.TargetRateCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targeTrateService")
public class TargetRateService {
    @Autowired
    BaseDao baseDao;

    public TargetRate getById(String id) {
        return (TargetRate)this.baseDao.get(TargetRate.class, (Serializable)((Object)id));
    }

    public void save(TargetRate targetRate) {
        this.baseDao.save((Object)targetRate);
    }

    public void update(TargetRateCondition trc, Employee em) {
        List<TargetRate> list = trc.getTargetRates();
        for (TargetRate tr : list) {
            tr.setPartnerId(em.getCurrentPartner().getId());
            tr.setYear(trc.getYear());
            tr.fillInitData(em);
            if (StringUtils.isNotEmpty(tr.getId())) {
                this.baseDao.update((Object)tr);
                continue;
            }
            this.baseDao.save((Object)tr);
        }
    }

    public void delete(String id) {
        this.baseDao.deleteById(TargetRate.class, (Serializable)((Object)id));
    }

    public Page getPage(TargetRateCondition con, int pageno) {
        String hql = "from TargetRate t where 1=1";
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(con.getPartnerId())) {
            hql = String.valueOf(hql) + "and t.partnerId = ?";
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannel())) {
            hql = String.valueOf(hql) + "and t.saleChannel = ?";
            args.add(con.getSaleChannel());
        }
        if (StringUtils.isNotEmpty(con.getTarget())) {
            hql = String.valueOf(hql) + "and t.target = ?";
            args.add(con.getTarget());
        }
        if (StringUtils.isNotNull(con.getYear())) {
            hql = String.valueOf(hql) + "and t.year = ?";
            args.add(con.getYear());
        }
        hql = String.valueOf(hql) + "order by created desc";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<TargetRate> getList(TargetRateCondition con) {
        String hql = "from TargetRate t where t.year = ? and t.partnerId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{con.getYear(), con.getPartnerId()}, TargetRate.class);
    }

    public boolean isExist(String partnerId, Long year, String saleChannel, String target, String id) {
        List tts;
        boolean isExist = false;
        String hql = "from TargetRate t where 1=1 ";
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(partnerId)) {
            hql = String.valueOf(hql) + "and t.partnerId = ?";
            args.add(partnerId);
        }
        if (StringUtils.isNotNull(year)) {
            hql = String.valueOf(hql) + "and t.year = ?";
            args.add(year);
        }
        if (StringUtils.isNotEmpty(saleChannel)) {
            hql = String.valueOf(hql) + "and t.saleChannel = ?";
            args.add(saleChannel);
        }
        if (StringUtils.isNotEmpty(target)) {
            hql = String.valueOf(hql) + "and t.target = ?";
            args.add(target);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and t.id != ? ";
            args.add(id);
        }
        if ((tts = this.baseDao.findEntity(hql.toString(), args.toArray(), TargetRate.class)).size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public TargetRate getTargetRate(String partnerId, Long year, String saleChannel, String target) {
        String hql = "from TargetRate t where t.partnerId = ? and t.year = ? and t.saleChannel = ? and t.target = ? ";
        return (TargetRate)this.baseDao.findFirstEntity(hql, new Object[]{partnerId, year, saleChannel, target}, TargetRate.class);
    }
}

