/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetsplit;

import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.TargetSplit;
import com.tcbj.crm.entity.TargeteOver;
import com.tcbj.crm.targetsplit.TargetSplitCondition;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetSplitService")
public class TargetSplitService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public Page findPartnerApplysValid(ClientCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(con.getEmployeeId());
        HQL.append("select c from Customer c where c.supplierId=?");
        args.add(con.getPartnerId());
        HQL.append(" and (c.bigAreaCode in ( ");
        HQL.append(sb);
        HQL.append(") or c.areaCode in ( ");
        HQL.append(sb);
        HQL.append(" ))");
        if (StringUtils.isNotEmpty(con.getUserId())) {
            HQL.append(" and (exists(from TargetSplit ts where ts.partnerId = c.applyerId and ts.userId = ? )) ");
            args.add(con.getUserId());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and c.applyerName like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getAreaId())) {
            HQL.append(" and c.areaCode = ?");
            args.add(con.getAreaId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            HQL.append(" and c.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getApplyerCode())) {
            HQL.append(" and c.applyerCode like ?");
            args.add("%" + con.getApplyerCode().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and c.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and c.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        HQL.append(" and c.startdate <= ? and nvl(c.enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        HQL.append(" order by c.applyerCode ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public TargetSplit getById(String id) {
        return (TargetSplit)this.baseDao.get(TargetSplit.class, (Serializable)((Object)id));
    }

    public void saveExcel(List<TargetSplit> tts, List<TargeteOver> tos) {
        for (TargetSplit ts : tts) {
            this.baseDao.executeHQL("delete TargetSplit where partnerId = ? and year = ? and type = ?", new Object[]{ts.getPartnerId(), ts.getYear(), ts.getType()});
            this.baseDao.executeHQL("delete TargeteOver where partnerId = ? and year = ? and type = ?", new Object[]{ts.getPartnerId(), ts.getYear(), ts.getType()});
        }
        this.baseDao.save(tts);
        this.baseDao.save(tos);
    }

    public Page getPage(TargetSplitCondition con, int pageno) {
        String hql = "from TargetSplit t where t.partnerId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getPartnerId());
        hql = String.valueOf(hql) + "order by t.year desc ";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<TargetSplit> getTargetSplits(TargetSplitCondition con) {
        String hql = "from TargetSplit t where t.orgId = ? and t.partnerId = ? and t.year = ? order by t.year desc";
        return this.baseDao.findEntity(hql, new Object[]{con.getOrgId(), con.getPartnerId(), con.getYear()}, TargetSplit.class);
    }

    public void saveAndUpdate(TargetSplitCondition con, Employee em) {
        List<TargetSplit> list = con.getSplitList();
        for (TargetSplit ts : list) {
            ts.setPartnerId(con.getPartnerId());
            ts.setYear(con.getYear());
            ts.fillInitData(em);
            ts.setOrgId(con.getOrgId());
            if (StringUtils.isNotEmpty(ts.getId())) {
                this.baseDao.update((Object)ts);
                continue;
            }
            this.baseDao.save((Object)ts);
        }
    }

    public void del(String id) {
        this.baseDao.deleteById(TargetSplit.class, (Serializable)((Object)id));
    }

    public boolean isExist(String partnerId, String year, String type, String userId, String id) {
        List tss;
        boolean isExist = false;
        String hql = "from TargetSplit t where t.partnerId = ? and t.year = ? and t.type = ? and t.userId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        args.add(year);
        args.add(type);
        args.add(userId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + "and t.id != ? ";
            args.add(id);
        }
        if ((tss = this.baseDao.findEntity(hql, args.toArray(), TargetSplit.class)).size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public Contact getPCS(String no, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("from Contact p where p.empno = ? and p.fullname = ? ");
        Object[] args = new Object[]{no, name};
        Contact pc = (Contact)this.baseDao.findFirstEntity(sb.toString(), args, Contact.class);
        return pc;
    }
}

