/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetx;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.targetx.TargetXService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/targetx"})
public class TargetXController
extends BaseController {
    @Autowired
    TargetXService targetXService;

    @RequestMapping(value={"/uploadTarget.do"}, method={RequestMethod.POST})
    public String uploadTarget(String year, HttpServletRequest request, Model model) {
        List<IUploadFile> list = this.uploadFile(request, "target");
        Employee emp = this.getCurrentEmployee();
        String rtn = null;
        if (list.size() > 0) {
            IUploadFile file = list.get(0);
            List<List<Object>> datas = ExcelHandle.readExcel(file.getRealPath());
            List<String> errorList = this.targetXService.save(year, emp.getCurrentPartner().getId(), datas, emp);
            if (errorList.size() > 0) {
                rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(errorList)));
                model.addAttribute("rtn", (Object)rtn);
                return "common/iframeRtn.ftl";
            }
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/uploadTarget.do"}, method={RequestMethod.GET})
    public String uploadTarget() {
        return "targetx/uploadTarget.ftl";
    }

    @RequestMapping(value={"/uploadPersonTarget.do"}, method={RequestMethod.GET})
    public String uploadPersonTarget() {
        return "targetx/uploadPersonTarget.ftl";
    }

    @RequestMapping(value={"/uploadPersonTarget.do"}, method={RequestMethod.POST})
    public String uploadPersonTarget(String year, HttpServletRequest request, Model model) {
        List<IUploadFile> list = this.uploadFile(request, "target");
        Employee emp = this.getCurrentEmployee();
        String rtn = null;
        if (list.size() > 0) {
            IUploadFile file = list.get(0);
            List<List<Object>> datas = ExcelHandle.readExcel(file.getRealPath());
            List<String> errorList = this.targetXService.savePerson(year, emp.getCurrentPartner().getId(), datas);
            if (errorList.size() > 0) {
                rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(errorList)));
                model.addAttribute("rtn", (Object)rtn);
                return "common/iframeRtn.ftl";
            }
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"exportTemplet.do"}, method={RequestMethod.GET})
    public void exportTemplet(String targetType, HttpServletResponse response) throws Exception {
        Employee em = this.getCurrentEmployee();
        List<DictionaryItem> items = Cache.getItems("TCBJ_PACT_TARGET_TYPE");
        String targetTypeName = "";
        String unit = "";
        for (DictionaryItem item : items) {
            if (!item.getName().equals(targetType)) continue;
            targetTypeName = item.getVal();
            if ("WEB_TARGET".equals(item.getName())) {
                unit = "\u4e2a";
                break;
            }
            unit = "\u4e07\u5143";
            break;
        }
        List<Partner> partners = this.targetXService.findPartners(em);
        LinkedHashMap<String, String> filedNameMap = new LinkedHashMap<String, String>();
        filedNameMap.put("typeName", "\u76ee\u6807\u7c7b\u578b");
        filedNameMap.put("no", "\u5ba2\u6237\u52a9\u8bb0\u7801");
        filedNameMap.put("name", "\u5ba2\u6237");
        filedNameMap.put("m1", "\u4e00\u6708");
        filedNameMap.put("m2", "\u4e8c\u6708");
        filedNameMap.put("m3", "\u4e09\u6708");
        filedNameMap.put("m4", "\u56db\u6708");
        filedNameMap.put("m5", "\u4e94\u6708");
        filedNameMap.put("m6", "\u516d\u6708");
        filedNameMap.put("m7", "\u4e03\u6708");
        filedNameMap.put("m8", "\u516b\u6708");
        filedNameMap.put("m9", "\u4e5d\u6708");
        filedNameMap.put("m10", "\u5341\u6708");
        filedNameMap.put("m11", "\u5341\u4e00\u6708");
        filedNameMap.put("m12", "\u5341\u4e8c\u6708");
        filedNameMap.put("unit", "\u5355\u4f4d");
        filedNameMap.put("brand", "\u54c1\u724c");
        ArrayList listExcel = new ArrayList();
        for (Partner p : partners) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("typeName", targetTypeName);
            itemMap.put("no", p.getNo());
            itemMap.put("name", p.getName());
            itemMap.put("unit", unit);
            listExcel.add(itemMap);
        }
        String[] titles = new String[filedNameMap.size()];
        String[] pop = new String[filedNameMap.size()];
        int i = 0;
        for (Map.Entry e : filedNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u5ba2\u6237\u76ee\u6807\u6279\u91cf\u4e0a\u4f20\u6a21\u677f-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u5ba2\u6237\u76ee\u6807", ".xls", titles, listExcel, pop, response);
    }

    @RequestMapping(value={"uploadEmployeeMatchCustomer.do"}, method={RequestMethod.GET})
    public String uploadEmployeeMatchCustomer() {
        return "targetx/uploadEmployeeMatchCustomer.ftl";
    }

    @RequestMapping(value={"uploadEmployeeMatchCustomer.do"}, method={RequestMethod.POST})
    public String uploadEmployeeMatchCustomer(HttpServletRequest request, Model model) {
        IUploadFile file;
        List<List<Object>> datas;
        List<String> errorList;
        List<IUploadFile> list = this.uploadFile(request, "target");
        Employee em = this.getCurrentEmployee();
        String rtn = null;
        if (list.size() > 0 && (errorList = this.targetXService.saveEmployeeMatchCustomer(em, datas = ExcelHandle.readExcel((file = list.get(0)).getRealPath()))).size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSON(errorList)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }
}

