/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.trainapply;

import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.entity.TrainApply;
import com.tcbj.crm.trainapply.TrainApplyCondition;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="trainApplyService")
public class TrainApplyService {
    @Autowired
    BaseDao baseDao;

    public TrainApply getById(String id) {
        return (TrainApply)this.baseDao.get(TrainApply.class, (Serializable)((Object)id));
    }

    public Page getPage(TrainApplyCondition con, int pageno) {
        String hql = "from TrainApply t where t.applyerId = ? and t.state !='9'";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getApplyerId());
        if (StringUtils.isNotEmpty(con.getState())) {
            hql = String.valueOf(hql) + "and t.state = ? ";
            args.add(con.getState());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + " and t.trainType = ? ";
            args.add(con.getType());
        }
        hql = String.valueOf(hql) + "order by t.createDt desc ";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void save(TrainApply trainApply, List<IUploadFile> filelist, Employee me) {
        this.baseDao.save((Object)trainApply);
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(trainApply.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        this.baseDao.save(files);
    }

    public void update(TrainApply trainApply, List<IUploadFile> filelist, TrainApplyCondition con, Employee me) {
        String[] fileids;
        this.baseDao.update((Object)trainApply);
        String[] stringArray = fileids = con.getFileId().split(",");
        int n = fileids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete ShoppeApplyFile where id= ?", args);
            }
            ++n2;
        }
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(trainApply.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        this.baseDao.save(files);
    }

    public void delete(String id) {
        this.baseDao.deleteById(TrainApply.class, (Serializable)((Object)id));
    }
}

