/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.util;

import com.tcbj.util.Beans;
import com.tcbj.util.Https;
import com.tcbj.util.Jsons;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseRequestHelper {
    protected String token;
    protected static final String SUCCESS = "00";
    protected static final String TOKEN_EXPIRE = "99";
    protected static final String TOKEN_EXPIRE2 = "98";

    public abstract String initToken();

    public void setToken() {
        this.token = this.initToken();
    }

    public <T> T sendRequest(String url, Map<String, Object> param) {
        String json = Jsons.toJson(param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsonStr", json);
        map.put("access_token", this.token);
        String response = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)response)) {
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code) || TOKEN_EXPIRE2.equals(code)) {
                this.setToken();
                return this.sendRequest(url, param);
            }
            return (T)result.get("returnObject");
        }
        return null;
    }

    public String sendBody(String url, Map<String, String> map) {
        map.put("access_token", this.token);
        String body = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)body)) {
            Map result = (Map)Jsons.toBean((String)body, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code) || TOKEN_EXPIRE2.equals(code)) {
                this.setToken();
                return this.sendBody(url, map);
            }
            return body;
        }
        return null;
    }

    public <T> T sendFile(String url, Map<String, Object> param, Map<String, List<File>> fileMap) {
        String json = Jsons.toJson(param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsonStr", json);
        map.put("access_token", this.token);
        String response = Https.getInstance().postFile(url, map, fileMap);
        if (Beans.isNotEmpty((Object)response)) {
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code) || TOKEN_EXPIRE2.equals(code)) {
                this.setToken();
                return this.sendFile(url, param, fileMap);
            }
            return (T)result.get("returnObject");
        }
        return null;
    }
}

