/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.util;

import com.tcbj.crm.exception.AppException;
import com.tcbj.util.Beans;
import com.tcbj.util.Https;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EasRequestHelper {
    private static String token;
    private static final String SUCCESS = "00";
    private static final String ESBSUCCESS = "0000";
    private static final String TOKEN_EXPIRE = "99";
    private static final String TOKEN_EXPIRE2 = "98";
    private static EasRequestHelper helper;

    private EasRequestHelper() {
        EasRequestHelper.initToken();
    }

    public void setToken() {
        EasRequestHelper.initToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static EasRequestHelper getInstance() {
        if (helper == null) {
            Class<EasRequestHelper> clazz = EasRequestHelper.class;
            // MONITORENTER : com.tcbj.crm.util.EasRequestHelper.class
            helper = new EasRequestHelper();
            // MONITOREXIT : clazz
        }
        if (!Beans.isEmpty((Object)token)) return helper;
        EasRequestHelper.initToken();
        return helper;
    }

    private static synchronized void initToken() {
        String url = StringUtils.getConfigure("eas_token_url_post");
        String appId = StringUtils.getConfigure("eas_appId");
        String appSecret = StringUtils.getConfigure("eas_appSecret");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appId", appId);
        param.put("appSecret", appSecret);
        String response = Https.getInstance().post(url, param);
        if (Beans.isEmpty((Object)response)) {
            throw new RuntimeException("get token error");
        }
        Map result = (Map)Jsons.toBean((String)response, Map.class);
        Map rtn = (Map)result.get("returnObject");
        token = (String)rtn.get("access_token");
    }

    public String getToken() {
        return token;
    }

    public <T> T sendRequest(String url, Map<String, Object> param) {
        String json = Jsons.toJson(param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsonStr", json);
        map.put("access_token", token);
        String response = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)response)) {
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code) || TOKEN_EXPIRE2.equals(code)) {
                EasRequestHelper.initToken();
                return this.sendRequest(url, param);
            }
            return (T)result.get("returnObject");
        }
        return null;
    }

    public <T> T sendRequestData(String url, Map<String, Object> param, String acctId) {
        String data = Jsons.toJson(param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("data", data);
        Map acctIdMap = (Map)Jsons.toBean((String)acctId, Map.class);
        map.put("acctID", (String)acctIdMap.get("acctID"));
        map.put("username", (String)acctIdMap.get("username"));
        map.put("password", (String)acctIdMap.get("password"));
        map.put("lcid", (String)acctIdMap.get("lcid"));
        String response = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)response)) {
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            String code = result.get("errorCode").toString();
            if (!ESBSUCCESS.equals(code)) {
                throw new AppException("2022", result.get("errorMessage").toString());
            }
            return (T)result.get("returnObject");
        }
        return null;
    }

    public <T> T sendNormalRequest(String url, Map<String, String> param) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(param);
        map.put("access_token", token);
        String response = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)response)) {
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code) || TOKEN_EXPIRE2.equals(code)) {
                EasRequestHelper.initToken();
                return this.sendNormalRequest(url, param);
            }
            return (T)result.get("returnObject");
        }
        return null;
    }

    public String sendCspBody(String url, Map<String, Object> param) {
        String json = Jsons.toJson(param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsonStr", json);
        map.put("access_token", token);
        return this.sendBody(url, map);
    }

    public String sendBody(String url, Map<String, String> map) {
        map.put("access_token", token);
        String body = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)body)) {
            Map result = (Map)Jsons.toBean((String)body, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code) || TOKEN_EXPIRE2.equals(code)) {
                EasRequestHelper.initToken();
                return this.sendBody(url, map);
            }
            return body;
        }
        return null;
    }

    public Map<String, Object> sendBodyToESB(String url, Map<String, String> map) {
        HashMap result;
        block4: {
            result = new HashMap();
            try {
                String body = this.sendBody(url, map);
                if (Beans.isNotEmpty((Object)body)) {
                    result = (HashMap)Jsons.toBean((String)body, Map.class);
                    String code = result.get("errorCode").toString();
                    if (!SUCCESS.equals(code)) {
                        throw new AppException("2022", result.get("errorMessage").toString());
                    }
                    break block4;
                }
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AppException("2021");
            }
        }
        return result;
    }

    public <T> T sendBodyToESBResult(String url, Map<String, String> map) {
        Map<String, Object> resultMap = this.sendBodyToESB(url, map);
        return (T)resultMap.get("returnObject");
    }

    public <T> T sendFile(String url, Map<String, Object> param, Map<String, List<File>> fileMap) {
        String json = Jsons.toJson(param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsonStr", json);
        map.put("access_token", token);
        String response = Https.getInstance().postFile(url, map, fileMap);
        if (Beans.isNotEmpty((Object)response)) {
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code) || TOKEN_EXPIRE2.equals(code)) {
                this.setToken();
                return this.sendFile(url, param, fileMap);
            }
            return (T)result.get("returnObject");
        }
        return null;
    }
}

