/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.view;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.util.MathUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExchangeOrder
implements Cloneable {
    private String id;
    private String supplierId;
    private String no;
    private Date createDt;
    private String supplierNo;
    private String supplierName;
    private String orderType;
    private String state;
    private String useStatus;
    private String channelType;
    private String redeemType;
    private String exchangeStatus;
    private String shopId;
    private String shopNo;
    private String shopName;
    private String memberId;
    private String memberName;
    private String dlvOrdNum;
    private String dlvCmpn;
    private String dlvCmmt;
    private Date dlvDate;
    private String shippingAddress;
    private String contacts;
    private String phone;
    private String remark;
    private String orderContacts;
    private String orderPhone;
    private String bh_membertype;
    private List<ExchangeDetail> details = new ArrayList<ExchangeDetail>();
    private String memberType;
    private String clerkMobileNo;
    private String posNum;
    private String cSN;
    private String receiverName;
    private String deliveryOrderNo;
    private String deliveryPayFlag;
    private String comments;
    private String campaignId;
    private String exchangeOrderType;
    private Double productQuantity;
    private Double giftQuantity;
    private Double productScore;
    private Double giftScore;
    private Double orderQuantity;
    private Double orderScore;

    public ExchangeOrder init(Employee me) {
        this.setRedeemType("SendByTCBJ");
        this.setChannelType("CSP");
        this.setMemberType("\u7ecf\u9500\u5546");
        this.setShopNo(me.getCurrentPartner().getNo());
        this.setcSN(me.getCurrentPartner().getNo());
        this.setOrderType("PartnerExchange");
        this.setSupplierId(me.getCurrentPartner().getOrganizationid());
        this.setExchangeStatus("Pending");
        this.setShopId(me.getCurrentPartner().getId());
        return this;
    }

    public String getOrderTypeName() {
        return Cache.getItemName("TCBJ_EXCHANGE_ORDER_TYPE", this.orderType);
    }

    public String getUseStatusName() {
        return Cache.getItemName("TCBJ_MEM_ORD_STATUS", this.useStatus);
    }

    public String getOrderStatusName() {
        return Cache.getItemName("TCBJ_MEM_ORD_DEL_STATUS", this.state);
    }

    public String getRedeemTypeName() {
        return Cache.getItemName("TCBJ_MEM_ORD_METHOD", this.redeemType);
    }

    public String getExchangeStatusName() {
        return Cache.getItemName("TCBJ_MEM_RDM_STATUS", this.exchangeStatus);
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public List<ExchangeDetail> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<ExchangeDetail>();
        }
        return this.details;
    }

    public void setDetails(List<ExchangeDetail> details) {
        this.details = details;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public String getClerkMobileNo() {
        return this.clerkMobileNo;
    }

    public void setClerkMobileNo(String clerkMobileNo) {
        this.clerkMobileNo = clerkMobileNo;
    }

    public String getPosNum() {
        return this.posNum;
    }

    public void setPosNum(String posNum) {
        this.posNum = posNum;
    }

    public String getcSN() {
        return this.cSN;
    }

    public void setcSN(String cSN) {
        this.cSN = cSN;
    }

    public String getRedeemType() {
        return this.redeemType;
    }

    public void setRedeemType(String redeemType) {
        this.redeemType = redeemType;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getDeliveryOrderNo() {
        return this.deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo;
    }

    public String getDeliveryPayFlag() {
        return this.deliveryPayFlag;
    }

    public void setDeliveryPayFlag(String deliveryPayFlag) {
        this.deliveryPayFlag = deliveryPayFlag;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public String getExchangeOrderType() {
        return this.exchangeOrderType;
    }

    public void setExchangeOrderType(String exchangeOrderType) {
        this.exchangeOrderType = exchangeOrderType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSupplierId() {
        return this.supplierId;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierNo() {
        return this.supplierNo;
    }

    public void setSupplierNo(String supplierNo) {
        this.supplierNo = supplierNo;
    }

    public String getSupplierName() {
        return this.supplierName;
    }

    public String getSupplierNameById() {
        return Cache.getPartnerName(this.getSupplierId());
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getUseStatus() {
        return this.useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getExchangeStatus() {
        return this.exchangeStatus;
    }

    public void setExchangeStatus(String exchangeStatus) {
        this.exchangeStatus = exchangeStatus;
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getShopNo() {
        return this.shopNo;
    }

    public void setShopNo(String shopNo) {
        this.shopNo = shopNo;
    }

    public String getShopName() {
        return this.shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberNameById() {
        return Cache.getPartnerName(this.getMemberId());
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public Date getCreateDt() {
        return this.createDt;
    }

    public void setCreateDt(Date createDt) {
        this.createDt = createDt;
    }

    public String getDlvOrdNum() {
        return this.dlvOrdNum;
    }

    public void setDlvOrdNum(String dlvOrdNum) {
        this.dlvOrdNum = dlvOrdNum;
    }

    public String getDlvCmpn() {
        return this.dlvCmpn;
    }

    public void setDlvCmpn(String dlvCmpn) {
        this.dlvCmpn = dlvCmpn;
    }

    public String getDlvCmmt() {
        return this.dlvCmmt;
    }

    public void setDlvCmmt(String dlvCmmt) {
        this.dlvCmmt = dlvCmmt;
    }

    public Date getDlvDate() {
        return this.dlvDate;
    }

    public void setDlvDate(Date dlvDate) {
        this.dlvDate = dlvDate;
    }

    public String getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public String getContacts() {
        return this.contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOrderContacts() {
        return this.orderContacts;
    }

    public void setOrderContacts(String orderContacts) {
        this.orderContacts = orderContacts;
    }

    public String getOrderPhone() {
        return this.orderPhone;
    }

    public void setOrderPhone(String orderPhone) {
        this.orderPhone = orderPhone;
    }

    public Double getProductQuantity() {
        if (this.productQuantity == null) {
            this.productQuantity = 0.0;
        }
        return this.productQuantity;
    }

    public void setProductQuantity(Double productQuantity) {
        this.productQuantity = productQuantity;
    }

    public Double getGiftQuantity() {
        if (this.giftQuantity == null) {
            this.giftQuantity = 0.0;
        }
        return this.giftQuantity;
    }

    public void setGiftQuantity(Double giftQuantity) {
        this.giftQuantity = giftQuantity;
    }

    public Double getProductScore() {
        if (this.productScore == null) {
            this.productScore = 0.0;
        }
        return this.productScore;
    }

    public void setProductScore(Double productScore) {
        this.productScore = productScore;
    }

    public Double getGiftScore() {
        if (this.giftScore == null) {
            this.giftScore = 0.0;
        }
        return this.giftScore;
    }

    public void setGiftScore(Double giftScore) {
        this.giftScore = giftScore;
    }

    public Double getTotalScore() {
        return MathUtils.add((Double)this.getGiftScore(), (Double)this.getProductScore());
    }

    public Double getTotalQuantity() {
        return MathUtils.add((Double)this.getGiftQuantity(), (Double)this.getProductQuantity());
    }

    public void bindEditData(Customer customer, Employee me) {
        this.setOrderContacts(me.getName());
        this.setOrderPhone(me.getMobile());
        if (customer.getReceiptAddresses() != null && customer.getReceiptAddresses().size() > 0) {
            PartnerAddress address = customer.getReceiptAddresses().get(0);
            this.setContacts(address.getContactCode());
            this.setPhone(address.getContactPhone());
            this.setShippingAddress(address.getAddress());
        }
    }

    public void bindCannotEditData(Customer customer, Employee me) {
        Long days = customer.getTransportOnlineCode();
        if (days != null) {
            days.intValue();
        }
    }

    public Double getOrderQuantity() {
        return this.orderQuantity;
    }

    public void setOrderQuantity(Double orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    public Double getOrderScore() {
        return this.orderScore;
    }

    public void setOrderScore(Double orderScore) {
        this.orderScore = orderScore;
    }

    public ExchangeOrder clone() {
        try {
            return (ExchangeOrder)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBh_membertype() {
        return this.bh_membertype;
    }

    public void setBh_membertype(String bh_membertype) {
        this.bh_membertype = bh_membertype;
    }
}

