/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.warning;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.WarSummary;
import com.tcbj.crm.entity.Warning;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.warning.WarSummaryCondition;
import com.tcbj.crm.warning.WarningCondition;
import com.tcbj.crm.warning.WarningService;
import com.tcbj.framework.util.Page;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/warning"})
public class WarningController
extends BaseController {
    @Autowired
    WarningService warningService;
    @Autowired
    ProductService productService;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    PartnerService service;
    @Autowired
    ClientService clientService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String add_get(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ClientCondition con, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        con.setPartnerId(e.getCurrentPartner().getId());
        con.setEmployeeId(e.getId());
        List<Warning> wns = this.warningService.getWS();
        HashMap<String, Warning> waMap = new HashMap<String, Warning>();
        int i = 0;
        while (i < wns.size()) {
            waMap.put(wns.get(i).getPartnerId(), wns.get(i));
            ++i;
        }
        Page page = this.clientService.findPartnerApplysValid(con, pageno);
        List<DictionaryItem> dts = Cache.getItems("TCBJ_DUE_DAYS");
        model.addAttribute("page", (Object)page);
        model.addAttribute("dts", dts);
        model.addAttribute("waMap", waMap);
        model.addAttribute("wns", wns);
        return "warning/add.ftl";
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.POST})
    public String add_post(@Valid Warning wn, BindingResult errors, String expireDate, Model model, String[] id, HttpServletRequest request) {
        if (errors.hasErrors()) {
            model.addAttribute("errors", (Object)errors.getFieldErrors());
            return "common/error.ftl";
        }
        Employee e = this.getCurrentEmployee();
        if (id != null) {
            int i = 0;
            while (i < id.length) {
                wn.setPartnerId(e.getCurrentPartner().getId());
                wn.setCustomerId(id[i]);
                String er = String.valueOf(expireDate) + "\u5929";
                wn.setExpireDate(er);
                wn.setIsUse("Y");
                wn.fillInitData(e);
                this.warningService.save(wn);
                ++i;
            }
        }
        return this.redirect("/warning/list.do");
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="result") String result, WarningCondition condition, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        condition.setPartnerId(me.getCurrentPartner().getId());
        condition.setEm(me);
        model.addAttribute("page", (Object)this.warningService.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("result", (Object)result);
        return "warning/list.ftl";
    }

    @RequestMapping(value={"/edit.do"})
    public void edit_post(String id, String useName, String ed, HttpServletResponse response) {
        Warning wg = this.warningService.get(id);
        Employee e = this.getCurrentEmployee();
        wg.fillInitData(e);
        wg.setId(id);
        wg.setExpireDate(ed);
        wg.setIsUse(useName);
        this.warningService.update(wg);
        try {
            response.getWriter().write("true");
        }
        catch (IOException iOException) {}
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model, HttpServletRequest request) {
        this.warningService.delete(id);
        return this.redirect("/warning/list.do");
    }

    @RequestMapping(value={"myList.do"})
    public String getMyList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, WarningCondition condition, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        condition.setCustomerId(e.getCurrentPartner().getId());
        Page page = this.warningService.getMyList(condition, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        return "/warning/myList.ftl";
    }

    @RequestMapping(value={"myAdd.do"})
    public String getMyAdd(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PartnerCondition con, Warning wn, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner p = this.personnelservice.getById(e.getCurrentPartner().getId());
        List<DictionaryItem> dts = Cache.getItems("TCBJ_DUE_DAYS");
        model.addAttribute("dts", dts);
        model.addAttribute("con", (Object)con);
        model.addAttribute("p", (Object)p);
        model.addAttribute("wn", (Object)wn);
        return "/warning/myAdd.ftl";
    }

    @RequestMapping(value={"mySave.do"}, method={RequestMethod.POST})
    public String add(Warning wn, String expireDate, Model model, String[] id) {
        Employee e = this.getCurrentEmployee();
        if (id != null) {
            int i = 0;
            while (i < id.length) {
                wn.setPartnerId(e.getCurrentPartner().getId());
                wn.setCustomerId(id[i]);
                String er = String.valueOf(expireDate) + "\u5929";
                wn.setExpireDate(er);
                wn.setIsUse("Y");
                wn.fillInitData(e);
                this.warningService.save(wn);
                ++i;
            }
        }
        return this.redirect("/warning/myList.do");
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET})
    public String del(String id, Model model, HttpServletRequest request) {
        this.warningService.delete(id);
        return this.redirect("/warning/myList.do");
    }

    @RequestMapping(value={"collectList.do"})
    public String getlist(Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner p = this.service.getSimplePartner(e.getCurrentPartner().getId());
        List<Warning> wns = this.warningService.getwns(e.getCurrentPartner().getId());
        List<Object> warSummaryGroupBy = new ArrayList();
        HashMap<String, WarSummary> groupMap = new HashMap<String, WarSummary>();
        if (StringUtils.isNotEmpty((String)p.getClientAppNo())) {
            warSummaryGroupBy = this.warningService.getWarSummarysGroupBy(p.getClientNo());
            WarSummary arry = null;
            int i = 0;
            while (i < warSummaryGroupBy.size()) {
                arry = (WarSummary)warSummaryGroupBy.get(i);
                groupMap.put(String.valueOf(arry.getBatchNo()) + "-" + arry.getProductNo(), arry);
                ++i;
            }
            List<WarSummary> WarSummaryAll = this.warningService.getWarSummarysAll(p.getClientNo());
            HashMap<String, Double> map = null;
            int i2 = 0;
            while (i2 < WarSummaryAll.size()) {
                map = new HashMap<String, Double>();
                arry = WarSummaryAll.get(i2);
                if (groupMap.get(String.valueOf(arry.getBatchNo()) + "-" + arry.getProductNo()) != null) {
                    if (((WarSummary)groupMap.get(String.valueOf(arry.getBatchNo()) + "-" + arry.getProductNo())).getMap().keySet().size() > 0) {
                        ((WarSummary)groupMap.get(String.valueOf(arry.getBatchNo()) + "-" + arry.getProductNo())).addMap(String.valueOf(arry.getWarningDate()) + "\u5929", arry.getSummaryTotal());
                    } else {
                        map.put(String.valueOf(arry.getWarningDate()) + "\u5929", arry.getSummaryTotal());
                        ((WarSummary)groupMap.get(String.valueOf(arry.getBatchNo()) + "-" + arry.getProductNo())).setMap(map);
                    }
                }
                ++i2;
            }
            model.addAttribute("WarSummaryGroupBy", warSummaryGroupBy);
            model.addAttribute("wus", wns);
            return "/warning/collectList.ftl";
        }
        model.addAttribute("WarSummaryGroupBy", warSummaryGroupBy);
        model.addAttribute("wus", wns);
        return "/warning/collectList.ftl";
    }

    @RequestMapping(value={"detail.do"})
    public String getDetail(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, WarSummaryCondition con, Model model) {
        Employee emp = this.getCurrentEmployee();
        Partner p = this.service.getSimplePartner(emp.getCurrentPartner().getId());
        try {
            if (StringUtils.isNotEmpty((String)con.getExpireDate())) {
                con.setExpireDate(new String(con.getExpireDate().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String clientAppNo = p.getClientAppNo().substring(p.getClientAppNo().lastIndexOf(".") + 1, p.getClientAppNo().length());
        con.setExpireDate(con.getExpireDate().substring(0, con.getExpireDate().length() - 1));
        List<Object> args = this.warningService.list(clientAppNo, con);
        model.addAttribute("args", args);
        return "/warning/detail.ftl";
    }
}

