/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.warning;

import com.tcbj.crm.common.BaseDao2;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.WarSummary;
import com.tcbj.crm.entity.Warning;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.warning.WarSummaryCondition;
import com.tcbj.crm.warning.WarningCondition;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.dao.SQLHibernateCallback;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.stereotype.Service;

@Service(value="warningService")
public class WarningService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    BaseDao2 baseDao2;
    @Autowired
    PersonnelService personnelService;

    public Warning get(String id) {
        return (Warning)this.baseDao.get(Warning.class, (Serializable)((Object)id));
    }

    public void save(Warning wn) {
        this.baseDao.save((Object)wn);
    }

    public List<Warning> getWS() throws Exception {
        String hql = "from Warning ";
        return this.baseDao.findEntity(hql, Warning.class);
    }

    public List<Partner> getPS() {
        String hql = "from Partner p where p.masterOuId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{StringUtils.getOrgId()}, Partner.class);
    }

    public Page getList(int pageno, WarningCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String regionids = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        HQL.append("select distinct w from Warning w,Customer c where ( c.areaCode in (" + regionids + ") or c.bigAreaCode in (" + regionids + ") ) ");
        HQL.append(" and c.supplierId =? and w.customerId = c.applyerId ");
        args.add(condition.getPartnerId());
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and c.areaCode =? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            HQL.append(" and c.bigAreaCode =? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getIsUse())) {
            HQL.append(" and w.isUse =? ");
            args.add(condition.getIsUse());
        }
        if (StringUtils.isNotEmpty(condition.getExpireDate())) {
            HQL.append(" and w.expireDate like ? ");
            args.add("%" + condition.getExpireDate() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPartnerId())) {
            HQL.append(" and w.partnerId = ? ");
            args.add(condition.getPartnerId());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerId())) {
            HQL.append(" and w.customerId = ? ");
            args.add(condition.getCustomerId());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerCode())) {
            HQL.append(" and w.customerId = ? ");
            args.add(condition.getCustomerCode());
        }
        HQL.append("order by w.createDt ");
        return this.baseDao.searchForPager2(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    Page getMyList(WarningCondition condition, int pageno) {
        String hql = "from Warning w where 1=1 ";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(condition.getCustomerId())) {
            hql = String.valueOf(hql) + "and w.customerId = ? ";
            args.add(condition.getCustomerId());
        }
        if (StringUtils.isNotEmpty(condition.getExpireDate())) {
            hql = String.valueOf(hql) + "and w.expireDate like ?";
            args.add("%" + condition.expireDate + "%");
        }
        return this.baseDao.search(hql, args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    List<Warning> getwns(String customerId) {
        String hql = " from Warning w where w.customerId = ? order by w.expireDate ";
        return this.baseDao.findEntity(hql, new Object[]{customerId}, Warning.class);
    }

    public void update(Warning obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        this.baseDao.deleteById(Warning.class, (Serializable)((Object)id));
    }

    public Page page(int pageno, WarningCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append(" from Warning where 1=1 ");
        if (StringUtils.isNotEmpty(condition.getIsUse())) {
            HQL.append(" and isUse =? ");
            args.add(condition.getIsUse());
        }
        if (StringUtils.isNotEmpty(condition.getPartnerId())) {
            HQL.append(" and partnerId =? ");
            args.add(condition.getPartnerId());
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findPartners(PartnerCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("from Partner where masterOuId = ? ");
        args.add(StringUtils.getOrgId());
        if (StringUtils.isNotEmpty(con.getPartnerId())) {
            HQL.append(" and parentPartnerId=?");
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotEmpty(con.getEmployeeId())) {
            HQL.append(" and creatorId = ?");
            args.add(con.getEmployeeId());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            HQL.append(" and bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            HQL.append(" and areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            HQL.append(" and saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        HQL.append(" order by createDt ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<WarSummary> getWarSummarysGroupBy(String outClientNo) {
        String hql = "select new WarSummary(w.batchNo,w.productNo) from WarSummary w where w.outClientNo = ? group by w.batchNo,w.productNo ";
        return this.baseDao.findEntity(hql, new Object[]{outClientNo}, WarSummary.class);
    }

    public List<WarSummary> getWarSummarysAll(String outClientNo) {
        String hql = "from WarSummary w where w.outClientNo = ? ";
        return this.baseDao.findEntity(hql, new Object[]{outClientNo}, WarSummary.class);
    }

    Page getScans(WarSummaryCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Scan s where 1=1");
        if (StringUtils.isNotEmpty(con.getCustomerNo())) {
            HQL.append(" and s.customerNo = ? ");
            args.add(con.getCustomerNo());
        }
        if (StringUtils.isNotEmpty(con.getExpireDate())) {
            HQL.append(" and s.expireDate <= ?");
            args.add(con.getExpireDate());
        }
        if (StringUtils.isNotEmpty(con.getProductNo())) {
            HQL.append(" and s.productNo = ?");
            args.add(con.getProductNo());
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    List<Object> list(String outClientNo, WarSummaryCondition con) {
        String sql = "select Barcode,itemcode,batch,productiondate,zid,COUNT(*),DATEADD(yy, 2,ProductionDate) as y,DATEDIFF(DAY, SYSDATETIME(),  DATEADD(YEAR, 2,ProductionDate)) as d from V_DealerBarcodeLib where zid= ? and itemcode = ? and batch = ? and (SELECT DATEDIFF(DAY, SYSDATETIME(),  DATEADD(YEAR, 2,ProductionDate))) < ? group by Barcode,itemcode,batch,productiondate,zid";
        return (List)this.baseDao2.execute((HibernateCallback)new SQLHibernateCallback(sql.toString(), new Object[]{outClientNo, con.getProductNo(), con.getBatchNo(), con.getExpireDate()}, 0));
    }
}

