/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.yorder;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.siebel.service.SiebelUtil;
import com.tcbj.crm.view.CxAwkOrderView;
import com.tcbj.crm.view.CxAwkOrderXmView;
import com.tcbj.crm.yorder.CxAwkOrderViewCondition;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="YorderService")
public class YorderService {
    @Autowired
    private BaseDao baseDao;
    private static String business = StringUtils.getBusiness();

    public Page getOrderList(CxAwkOrderViewCondition con, int pageno) {
        Page page = new Page();
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        this.baseHql(HQL, args, con);
        if ("Submitted".equals(con.getDelivery_status()) && StringUtils.isNotEmpty(con.getYfCounts())) {
            return page;
        }
        page = this.baseDao.search(HQL.toString(), args.toArray(), Constant.BATCH_ROWS, pageno);
        return page;
    }

    private void baseHql(StringBuffer HQL, List<Object> args, CxAwkOrderViewCondition con) {
        HQL.append(" from CxAwkOrderView o ");
        HQL.append(" where o.exchange_method = 'SendByTCBJ' ");
        if (StringUtils.isNotEmpty(con.getOrgId())) {
            HQL.append(" and o.bh_brandid = ?");
            args.add(con.getOrgId().trim());
        }
        if (StringUtils.isNotEmpty(con.getOrder_no())) {
            HQL.append(" and o.order_no = ?");
            args.add(con.getOrder_no().trim());
        }
        if (StringUtils.isNotEmpty(con.getDelivery_status())) {
            if ("All".equals(con.getDelivery_status())) {
                HQL.append(" and o.delivery_status not in('Refuse','Review','Delivery')");
            } else {
                HQL.append(" and o.delivery_status = ?");
                args.add(con.getDelivery_status().trim());
            }
        }
        if (StringUtils.isNotEmpty(con.getX_mob_pho_no())) {
            HQL.append(" and o.x_mob_pho_no = ?");
            args.add(con.getX_mob_pho_no().trim());
        }
        Calendar cd = Calendar.getInstance();
        if (con.getCreateDtS() != null) {
            HQL.append(" and o.created >= ?");
            cd.setTime(con.getCreateDtS());
            cd.add(10, -8);
            args.add(cd.getTime());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and o.created <= ?");
            cd.setTime(con.getCreateDtE());
            cd.add(5, 1);
            cd.add(10, -8);
            args.add(cd.getTime());
        }
        if (StringUtils.isNotEmpty(con.getRdm_chnl())) {
            HQL.append(" and o.rdm_chnl = ?");
            args.add(con.getRdm_chnl().trim());
        }
        if (StringUtils.isNotEmpty(con.getStore_name())) {
            HQL.append(" and o.store_name like ? ");
            args.add("%" + con.getStore_name().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getStore_code())) {
            HQL.append(" and o.store_code = ?");
            args.add(con.getStore_code().trim());
        }
        if (StringUtils.isNotEmpty(con.getReceiver_address())) {
            HQL.append(" and o.receiver_address like ?");
            args.add("%" + con.getReceiver_address().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getReceiver_comments())) {
            HQL.append(" and o.receiver_comments like ?");
            args.add("%" + con.getReceiver_comments().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getReceiver_name())) {
            HQL.append(" and o.receiver_name like ?");
            args.add("%" + con.getReceiver_name().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getReceiver_phone())) {
            HQL.append(" and o.receiver_phone = ?");
            args.add(con.getReceiver_phone().trim());
        }
        if (StringUtils.isNotEmpty(con.getDelivery_comments())) {
            HQL.append(" and o.delivery_comments like ?");
            args.add("%" + con.getDelivery_comments().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getDelivery_company())) {
            HQL.append(" and o.delivery_company like ?");
            args.add("%" + con.getDelivery_company().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getDelivery_order_no())) {
            HQL.append(" and o.delivery_order_no like ?");
            args.add("%" + con.getDelivery_order_no().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getMem_class_cd())) {
            HQL.append(" and o.mem_class_cd like ? ");
            args.add("%" + con.getMem_class_cd().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and o.name like ? ");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getComments())) {
            if ("1".equals(con.getIscheck())) {
                HQL.append(" and o.comments like ? ");
                args.add("%" + con.getComments().trim() + "%");
            }
            if ("2".equals(con.getIscheck())) {
                HQL.append(" and nvl(o.comments,0) NOT LIKE ? ");
                args.add("%" + con.getComments().trim() + "%");
            }
        }
        if (StringUtils.isNotEmpty(con.getYfCounts())) {
            if ("success".equals(con.getYfCounts())) {
                HQL.append(" and o.jy_counts = '0' ");
            } else if ("fail".equals(con.getYfCounts())) {
                HQL.append(" and nvl(o.jy_counts,1) != '0' ");
            }
        }
        if (StringUtils.isNotEmpty(con.getOrder_ship_type())) {
            HQL.append(" and o.order_ship_type = ? ");
            args.add(con.getOrder_ship_type().trim());
        }
        HQL.append(" order by o.created desc");
    }

    public Map<String, Object> getOrderDetail(CxAwkOrderViewCondition condition, int pageno) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CxAwkOrderView cxAwkOrderView = (CxAwkOrderView)this.baseDao.get(CxAwkOrderView.class, (Serializable)((Object)condition.getId()));
        map.put("cxAwkOrderView", cxAwkOrderView);
        Page page = new Page();
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from CxAwkOrderXmView o where 1=1 and o.par_row_id = ? ");
        args.add(condition.getId().trim());
        page = this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        map.put("page", page);
        return map;
    }

    public String updateOrder(CxAwkOrderView cxAwkOrderView) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from CxAwkOrderXmView o where 1=1 and o.par_row_id = ? ");
        args.add(cxAwkOrderView.getRow_id().trim());
        List list = this.baseDao.findEntity(HQL.toString(), args.toArray());
        Element e = DocumentHelper.createElement((String)"RedeemReq");
        this.getAddElement(e, "SerialNumber", cxAwkOrderView.getOrder_no());
        if (!"\u4fdd\u5b58".equals(cxAwkOrderView.getDelivery_status())) {
            this.getAddElement(e, "DeliveryStatus", cxAwkOrderView.getDelivery_status());
        }
        this.getAddElement(e, "ReceiverName", cxAwkOrderView.getReceiver_name());
        this.getAddElement(e, "ReceiverAddr", cxAwkOrderView.getReceiver_address());
        this.getAddElement(e, "ReceiverPhone", cxAwkOrderView.getReceiver_phone());
        this.getAddElement(e, "ReceiverComments", cxAwkOrderView.getReceiver_comments());
        this.getAddElement(e, "DeliveryOrderNo", cxAwkOrderView.getDelivery_order_no());
        this.getAddElement(e, "DeliveryComments", cxAwkOrderView.getDelivery_comments());
        this.getAddElement(e, "DeliveryCompany", cxAwkOrderView.getDelivery_company());
        if ("\u5df2\u53d1\u9001".equals(cxAwkOrderView.getDelivery_status())) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
            String dateStr = formatter.format(new Date());
            this.getAddElement(e, "DeliveryDate", dateStr);
        }
        Document _document = DocumentHelper.createDocument();
        Element e_prodList = e.addElement("ProdList");
        int i = 0;
        while (i < list.size()) {
            CxAwkOrderXmView cxAwkOrderXmView = (CxAwkOrderXmView)list.get(i);
            Element e_prodInfo = e_prodList.addElement("ProdInfo");
            this.getAddElement(e_prodInfo, "ItemId", cxAwkOrderXmView.getRow_id());
            this.getAddElement(e_prodInfo, "BarCode", cxAwkOrderXmView.getProduct_code());
            this.getAddElement(e_prodInfo, "SecurityCode", cxAwkOrderXmView.getValidate_code());
            this.getAddElement(e_prodInfo, "Quantity", cxAwkOrderXmView.getProduct_quantity().toString());
            ++i;
        }
        _document.add(e);
        String resultXml = this.getFormatXml(_document);
        return resultXml;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> updateOrderNew(String xml) {
        HashMap<String, String> hashMap;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_ExchangeOrderUpdate_WF");
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String ErrCode = output.getProperty("ErrCode");
            String ErrDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ErrCode", ErrCode);
            map.put("ErrDesc", ErrDesc);
            map.put("rowId", rowId);
            hashMap = map;
        }
        catch (AppException es) {
            try {
                throw es;
                catch (Exception e) {
                    throw new AppException("8007", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return hashMap;
        }
        catch (Exception exception) {}
        return hashMap;
    }

    public Element getAddElement(Element e, String name, String value) {
        Element sub_Element = e.addElement(name);
        if (StringUtils.isEmpty(value)) {
            value = "";
        }
        sub_Element.addText(value);
        return sub_Element;
    }

    public String getFormatXml(Document doc) {
        String s = "";
        try {
            OutputFormat format = new OutputFormat("", true);
            format.setEncoding("utf-8");
            StringWriter out = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)out, format);
            xmlWriter.write(doc);
            xmlWriter.flush();
            s = out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public List<CxAwkOrderView> getOrderListByArgs(CxAwkOrderViewCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        if ("Submitted".equals(con.getDelivery_status()) && StringUtils.isNotEmpty(con.getYfCounts())) {
            return new ArrayList<CxAwkOrderView>();
        }
        this.baseHql(hql, params, con);
        return this.baseDao.findEntity(hql.toString(), params.toArray(), CxAwkOrderView.class);
    }

    public String updateBatch(CxAwkOrderView cxAwkOrderView) {
        Document _document = DocumentHelper.createDocument();
        String resultXml = null;
        if (cxAwkOrderView.getRow_id() != null) {
            Element e = DocumentHelper.createElement((String)"RedeemReq");
            this.getAddElement(e, "Comments", cxAwkOrderView.getComments());
            if (!"XGBZ".equals(cxAwkOrderView.getDelivery_status())) {
                this.getAddElement(e, "DeliveryStatus", cxAwkOrderView.getDeliveryStatusName());
            }
            this.getAddElement(e, "SerialNumber", cxAwkOrderView.getOrder_no());
            if ("Sended".equals(cxAwkOrderView.getDelivery_status())) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                String dateStr = formatter.format(new Date());
                this.getAddElement(e, "DeliveryDate", dateStr);
            }
            StringBuffer HQL2 = new StringBuffer();
            ArrayList<String> args2 = new ArrayList<String>();
            HQL2.append("from CxAwkOrderView o where o.order_no = ? ");
            args2.add(cxAwkOrderView.getOrder_no().trim());
            List list2 = this.baseDao.findEntity(HQL2.toString(), args2.toArray());
            int i = 0;
            while (i < list2.size()) {
                CxAwkOrderView cv = (CxAwkOrderView)list2.get(i);
                cxAwkOrderView.setRow_id(cv.getRow_id());
                ++i;
            }
            StringBuffer HQL = new StringBuffer();
            ArrayList<String> args = new ArrayList<String>();
            HQL.append("from CxAwkOrderXmView o where 1=1 and o.par_row_id = ? ");
            args.add(cxAwkOrderView.getRow_id().trim());
            List list = this.baseDao.findEntity(HQL.toString(), args.toArray());
            Element e_prodList = e.addElement("ProdList");
            int j = 0;
            while (j < list.size()) {
                CxAwkOrderXmView cxAwkOrderXmView = (CxAwkOrderXmView)list.get(j);
                Element e_prodInfo = e_prodList.addElement("ProdInfo");
                this.getAddElement(e_prodInfo, "ItemId", cxAwkOrderXmView.getRow_id());
                this.getAddElement(e_prodInfo, "BarCode", cxAwkOrderXmView.getProduct_code());
                this.getAddElement(e_prodInfo, "SecurityCode", cxAwkOrderXmView.getValidate_code());
                this.getAddElement(e_prodInfo, "Quantity", cxAwkOrderXmView.getProduct_quantity().toString());
                ++j;
            }
            _document.add(e);
            resultXml = this.getFormatXml(_document);
        }
        return resultXml;
    }

    public List<CxAwkOrderXmView> findOrderItemByPid(String orderId) {
        return this.baseDao.findEntity("from CxAwkOrderXmView o where o.par_row_id = ?", (Object)orderId, CxAwkOrderXmView.class);
    }

    public String importUpdateOrder(CxAwkOrderView cxAwkOrderView) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from CxAwkOrderXmView o where 1=1 and o.par_row_id = ? ");
        args.add(cxAwkOrderView.getRow_id().trim());
        List list = this.baseDao.findEntity(HQL.toString(), args.toArray());
        Element e = DocumentHelper.createElement((String)"RedeemReq");
        this.getAddElement(e, "SerialNumber", cxAwkOrderView.getOrder_no());
        this.getAddElement(e, "DeliveryOrderNo", cxAwkOrderView.getDelivery_order_no());
        this.getAddElement(e, "DeliveryComments", cxAwkOrderView.getDelivery_comments());
        this.getAddElement(e, "DeliveryCompany", cxAwkOrderView.getDelivery_company());
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        String dateStr = formatter.format(new Date());
        this.getAddElement(e, "DeliveryDate", dateStr);
        Document _document = DocumentHelper.createDocument();
        Element e_prodList = e.addElement("ProdList");
        int i = 0;
        while (i < list.size()) {
            CxAwkOrderXmView cxAwkOrderXmView = (CxAwkOrderXmView)list.get(i);
            Element e_prodInfo = e_prodList.addElement("ProdInfo");
            this.getAddElement(e_prodInfo, "ItemId", cxAwkOrderXmView.getRow_id());
            this.getAddElement(e_prodInfo, "BarCode", cxAwkOrderXmView.getProduct_code());
            this.getAddElement(e_prodInfo, "SecurityCode", cxAwkOrderXmView.getValidate_code());
            this.getAddElement(e_prodInfo, "Quantity", cxAwkOrderXmView.getProduct_quantity().toString());
            ++i;
        }
        _document.add(e);
        String resultXml = this.getFormatXml(_document);
        return resultXml;
    }
}

