/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import com.tcbj.util.BeanMap;
import com.tcbj.util.Beans;
import com.tcbj.util.ExcelLogicHandler;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelUtils {
    public static void exportExcel(String fileName, String sheetName, String[] titles, List<?> data, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < titles.length) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(titles[i]);
            ++i;
        }
        i = 0;
        while (i < data.size()) {
            row = sheet.createRow(i + 1);
            Object obj = data.get(i);
            Field[] fields = obj.getClass().getDeclaredFields();
            int j = 0;
            while (j < fields.length) {
                HSSFCell cell = row.createCell(j);
                fields[j].setAccessible(true);
                Object result = fields[j].get(obj);
                cell.setCellValue(result == null ? "" : result.toString());
                ++j;
            }
            ++i;
        }
        fileName = URLDecoder.decode(fileName, "gbk");
        fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
        workbook.write((OutputStream)response.getOutputStream());
    }

    public static void exportExcelNew(String fileName, String sheetName, String format, String[] titles, List<?> data, String[] pop, HttpServletResponse response) throws Exception {
        ExcelUtils.exportExcelNew(fileName, sheetName, format, titles, data, pop, null, response);
    }

    public static void exportExcelNew(String fileName, String sheetName, String format, String[] titles, List<?> data, String[] pop, ExcelLogicHandler handler, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = null;
        if (format.endsWith(".xls")) {
            workbook = new HSSFWorkbook();
        } else {
            format = ".xlsx";
            workbook = new XSSFWorkbook();
        }
        Sheet sheet = workbook.createSheet(sheetName);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < titles.length) {
            Cell cell = row.createCell(i);
            cell.setCellValue(titles[i]);
            ++i;
        }
        i = 0;
        while (i < data.size()) {
            row = sheet.createRow(i + 1);
            Object obj = data.get(i);
            if (Beans.isNotEmpty((Object)handler)) {
                handler.invoke(obj);
            }
            boolean isMap = Map.class.isAssignableFrom(obj.getClass());
            Map map = null;
            map = isMap ? (Map)obj : new BeanMap(obj);
            if (pop != null) {
                List<String> prop = Arrays.asList(pop);
                int j = 0;
                while (j < prop.size()) {
                    Cell cell = row.createCell(j);
                    Object result = map.get(prop.get(j));
                    cell.setCellValue(result == null ? "" : result.toString());
                    ++j;
                }
            } else {
                int j = 0;
                for (Object key : map.keySet()) {
                    Cell cell = row.createCell(j);
                    Object result = map.get(key);
                    cell.setCellValue(result == null ? "" : result.toString());
                }
            }
            ++i;
        }
        fileName = URLDecoder.decode(fileName, "gbk");
        fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + format);
        workbook.write((OutputStream)response.getOutputStream());
    }

    public static void exportBigExcel(String fileName, String sheetName, String[] titles, List<Map<String, Object>> data, String[] pop, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < titles.length) {
            Cell cell = row.createCell(i);
            cell.setCellValue(titles[i]);
            ++i;
        }
        i = 0;
        while (i < data.size()) {
            row = sheet.createRow(i + 1);
            Map<String, Object> map = data.get(i);
            if (Beans.isNotEmpty((Object)pop)) {
                List<String> pops = Arrays.asList(pop);
                int j = 0;
                while (j < pops.size()) {
                    Cell cell = row.createCell(j);
                    Object result = map.get(pops.get(j));
                    cell.setCellValue(result == null ? "" : result.toString());
                    ++j;
                }
            } else {
                int j = 0;
                for (String key : map.keySet()) {
                    Cell cell = row.createCell(j);
                    Object result = map.get(key);
                    cell.setCellValue(result == null ? "" : result.toString());
                }
            }
            ++i;
        }
        fileName = URLDecoder.decode(fileName, "gbk");
        fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        workbook.write((OutputStream)response.getOutputStream());
    }
}

