/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipCompressor {
    private File zipFile;
    public final int BUFFER = 8192;

    private ZipCompressor() {
    }

    public static ZipCompressor getInstance(String pathName) {
        ZipCompressor zipCompressor = new ZipCompressor();
        zipCompressor.zipFile = new File(pathName);
        return zipCompressor;
    }

    public void compressExe(String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(String.valueOf(srcPathName) + "\u4e0d\u5b58\u5728\uff01");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.zipFile);
            CheckedOutputStream cos = new CheckedOutputStream(fileOutputStream, new CRC32());
            ZipOutputStream out = new ZipOutputStream(cos);
            String basedir = "";
            this.compressByType(file, out, basedir);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void compressByType(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            this.compressDirectory(file, out, basedir);
        } else {
            this.compressFile(file, out, basedir);
        }
    }

    private void compressDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            this.compressByType(files[i], out, String.valueOf(basedir) + dir.getName() + "/");
            ++i;
        }
    }

    private void compressFile(File file, ZipOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(String.valueOf(basedir) + file.getName());
            out.putNextEntry(entry);
            byte[] data = new byte[8192];
            while ((count = bis.read(data, 0, 8192)) != -1) {
                out.write(data, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

