/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.msyxy.common.util.excel;

import com.tcbj.msyxy.common.util.excel.ExcelErrorMsg;
import com.tcbj.msyxy.common.util.excel.ExcelImportValidator;
import com.tcbj.msyxy.common.util.excel.ExcelRow;
import com.tcbj.msyxy.common.util.excel.ExcelVersion;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader<T> {
    private List<ExcelErrorMsg> errorMsgs = new ArrayList<ExcelErrorMsg>();

    public List<T> readExcel(InputStream excelStream, ExcelVersion version, int fromRow, String[] headerName, ExcelImportValidator<T> validator) {
        ArrayList<T> rtnList = new ArrayList<T>();
        Workbook workbook = null;
        try {
            workbook = this.getWorkbook(version, excelStream);
            Sheet sheet = workbook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            for (int i = fromRow - 1; i < rows; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                HashMap<String, String> val = new HashMap<String, String>();
                for (int j = 0; j < headerName.length; ++j) {
                    Cell cell = row.getCell(j);
                    String cellValue = this.getCellValue(cell);
                    val.put(headerName[j], cellValue);
                }
                ExcelRow<T> realRow = validator.validate(val, i + 1);
                if (realRow.getErrorMsg() != null) {
                    this.errorMsgs.add(realRow.getErrorMsg());
                    continue;
                }
                rtnList.add(realRow.getRow());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error reading excel:" + e);
        }
        finally {
            try {
                if (excelStream != null) {
                    excelStream.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rtnList;
    }

    private String getCellValue(Cell cell) {
        DecimalFormat df = new DecimalFormat("#.00");
        String cellValue = null;
        if (cell == null) {
            return "";
        }
        if (CellType.NUMERIC == cell.getCellTypeEnum()) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                cellValue = sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
            } else {
                cellValue = df.format(cell.getNumericCellValue()).replace(".00", "");
            }
        } else if (CellType.STRING == cell.getCellTypeEnum()) {
            cellValue = String.valueOf(cell.getStringCellValue());
        } else if (CellType.FORMULA == cell.getCellTypeEnum()) {
            cellValue = String.valueOf(cell.getCellFormula());
        } else if (CellType.BLANK == cell.getCellTypeEnum()) {
            cellValue = "";
        } else if (CellType.BOOLEAN == cell.getCellTypeEnum()) {
            cellValue = String.valueOf(cell.getBooleanCellValue());
        } else if (CellType.ERROR == cell.getCellTypeEnum()) {
            cellValue = String.valueOf(cell.getErrorCellValue());
        }
        return cellValue;
    }

    private Workbook getWorkbook(ExcelVersion version, InputStream is) throws Exception {
        HSSFWorkbook wb = null;
        if (ExcelVersion.EXCEL_2003 == version) {
            wb = new HSSFWorkbook(is);
        } else if (ExcelVersion.EXCEL_2007 == version) {
            wb = new XSSFWorkbook(is);
        } else {
            throw new RuntimeException("Unsuport version of the excel type");
        }
        return wb;
    }

    public boolean hasError() {
        return this.errorMsgs != null && this.errorMsgs.size() > 0;
    }

    public List<ExcelErrorMsg> getErrorMsg() {
        return this.errorMsgs;
    }
}

