/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.bpm;

import com.tcbj.framework.bpm.BpmNode;
import com.tcbj.framework.bpm.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BpmDefine<T> {
    private String bpmDefineCode;
    public Map<String, BpmNode<T>> nodeMap = new HashMap<String, BpmNode<T>>();

    public BpmDefine(String bpmDefineCode) {
        this.bpmDefineCode = bpmDefineCode;
    }

    public void addNode(BpmNode<T> node) {
        this.nodeMap.put(node.getNodeCode(), node);
    }

    public void clearNodeTransition() {
        for (BpmNode<T> node : this.nodeMap.values()) {
            node.clearTransition();
        }
    }

    public void deleteNode(String nodeCode) {
        this.nodeMap.remove(nodeCode);
    }

    public void clearNodes() {
        this.nodeMap.clear();
    }

    public BpmNode<T> getNode(String nodeCode) {
        return this.nodeMap.get(nodeCode);
    }

    public abstract BpmNode<T> getCurrentNode(T var1);

    public String getBpmDefineCode() {
        return this.bpmDefineCode;
    }

    public List<BpmNode<T>> getAllNode() {
        return new ArrayList<BpmNode<T>>(this.nodeMap.values());
    }

    public abstract Event getEventByCode(String var1);
}

