/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.bpm;

import com.tcbj.framework.bpm.Action;
import com.tcbj.framework.bpm.BpmActionChooser;
import com.tcbj.framework.bpm.BpmCondition;
import com.tcbj.framework.bpm.BpmContext;
import com.tcbj.framework.bpm.SimpleActionChooser;
import java.util.HashMap;
import java.util.Map;

public class ConditionalActionChooser<T>
implements BpmActionChooser<T> {
    private Map<BpmCondition<T>, SimpleActionChooser<T>> conditionMap = new HashMap<BpmCondition<T>, SimpleActionChooser<T>>();

    private ConditionalActionChooser() {
    }

    private ConditionalActionChooser(BpmCondition<T> condition, Action<T> action) {
        if (condition != null) {
            this.conditionMap.put(condition, SimpleActionChooser.of(action));
        }
    }

    public void add(BpmCondition<T> condition, Action<T> action) {
        this.conditionMap.put(condition, SimpleActionChooser.of(action));
    }

    public static <T> ConditionalActionChooser<T> NEW() {
        return new ConditionalActionChooser<T>();
    }

    @Override
    public Action<T> chooseAction(BpmContext<T> context) {
        for (BpmCondition<T> c : this.conditionMap.keySet()) {
            if (!c.match(context)) continue;
            return this.conditionMap.get(c).chooseAction(context);
        }
        return null;
    }
}

