/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.dto;

import com.tcbj.framework.dto.DTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="\u54cd\u5e94\u6570\u636e")
public class Response<T>
extends DTO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u9519\u8bef\u7801")
    private String code;
    @ApiModelProperty(value="\u9519\u8bef\u6d88\u606f")
    private String msg;
    @ApiModelProperty(value="\u8bf7\u6c42\u662f\u5426\u6210\u529f")
    private boolean isSuccess;
    @ApiModelProperty(value="\u8fd4\u56de\u4fe1\u606f")
    private T data;

    public Response() {
    }

    private Response(Builder<T> builder) {
        this.code = ((Builder)builder).code;
        this.msg = ((Builder)builder).msg;
        this.data = ((Builder)builder).data;
        this.isSuccess = ((Builder)builder).code.equals(StatusCode.SUCCESS.getValue());
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String errorCode) {
        this.code = errorCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String errorMsg) {
        this.msg = errorMsg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public static <T> Response<T> buildSuccessResponse(T data) {
        Response r = new Builder(StatusCode.SUCCESS.getValue()).msg("success").data(data).build();
        return r;
    }

    public static <T> Response<T> buildSysFailureResponse(T data) {
        Response r = new Builder(StatusCode.ERROR.getValue()).msg("Sys Error").data(data).build();
        return r;
    }

    public static <T> Response<T> build404Response(T data) {
        Response r = new Builder(StatusCode.NOT_FOUND.getValue()).msg("Resource not found").data(data).build();
        return r;
    }

    public static <T> Response<T> buildValidErrorResponse(String validMessage) {
        Response r = new Builder(StatusCode.VALID_ERROR.getValue()).msg(validMessage).build();
        return r;
    }

    public static <T> Response<T> buildBizzFailureResponse(String errorCode, String errorMsg, T data) {
        Response r = new Builder(errorCode).code(errorCode).msg(errorMsg).data(data).build();
        return r;
    }

    public static class Builder<T> {
        private String code;
        private String msg;
        private T data;

        public Builder(String code) {
            this.code = code;
        }

        public Builder<T> code(String code) {
            this.code = code;
            return this;
        }

        public Builder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Response<T> build() {
            return new Response(this);
        }

        public Response<T> build404() {
            return new Response(this);
        }
    }

    public static enum StatusCode {
        SUCCESS("200"),
        NOT_FOUND("404"),
        VALID_ERROR("400"),
        ERROR("500"),
        AUTH_ERROR("401"),
        TOKEN_INVALID("402"),
        ACCESS_DENIED("403");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private StatusCode(String value) {
            this.value = value;
        }
    }
}

