/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.message;

import com.tcbj.framework.message.DefaultLocaleHolder;
import com.tcbj.framework.message.LocaleHolder;
import com.tcbj.framework.message.MessageFactory;
import com.tcbj.framework.message.MessageSourceWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

public class DefaultMessageSourceWrapper
implements MessageSourceWrapper {
    @Autowired
    private MessageSource messageSource;
    private LocaleHolder localeHolder;

    public DefaultMessageSourceWrapper() {
        MessageFactory.setMessageSource(this);
        this.localeHolder = new DefaultLocaleHolder();
    }

    @Override
    public String getMessage(String key) {
        try {
            return this.messageSource.getMessage(key, null, this.localeHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            return key;
        }
    }

    @Override
    public void setLocaleHolder(LocaleHolder localeHolder) {
        this.localeHolder = localeHolder;
    }

    @Override
    public String getMessage(String code, Object[] args, String defaultMessage) {
        try {
            return this.messageSource.getMessage(code, args, this.localeHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            return defaultMessage;
        }
    }

    @Override
    public String getMessage(String key, Object[] args) {
        try {
            return this.messageSource.getMessage(key, args, this.localeHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            return key;
        }
    }

    @Override
    public String getMessage(String code, String defaultMessage) {
        try {
            return this.messageSource.getMessage(code, null, this.localeHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            return defaultMessage;
        }
    }
}

