/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.util.excel;

import com.tcbj.framework.util.excel.ExcelImportValidator;
import com.tcbj.framework.util.excel.ExcelResult;
import com.tcbj.framework.util.excel.ExcelRow;
import com.tcbj.framework.util.excel.ExcelVersion;
import com.tcbj.framework.util.validator.ValidateError;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader<T> {
    private ExcelVersion version;
    private InputStream source;
    private int fromRow = 2;
    private String[] headerProps;
    private ExcelImportValidator validator;

    public ExcelReader(ExcelVersion version) {
        this.version = version;
    }

    public static ExcelReader New2003() {
        return new ExcelReader(ExcelVersion.EXCEL_2003);
    }

    public static ExcelReader New2007() {
        return new ExcelReader(ExcelVersion.EXCEL_2007);
    }

    public ExcelReader source(InputStream source) {
        this.source = source;
        return this;
    }

    public ExcelReader beginRow(int row) {
        this.fromRow = row;
        return this;
    }

    public ExcelReader headerProps(String[] headerProps) {
        this.headerProps = headerProps;
        return this;
    }

    public ExcelReader validator(ExcelImportValidator validator) {
        this.validator = validator;
        return this;
    }

    public ExcelResult<T> read() {
        ExcelResult result = new ExcelResult();
        ArrayList rtnList = new ArrayList();
        ValidateError validateError = ValidateError.NEW();
        Workbook workbook = null;
        try {
            workbook = this.getWorkbook(this.version, this.source);
            Sheet sheet = workbook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            for (int i = this.fromRow - 1; i < rows; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                HashMap<String, String> val = new HashMap<String, String>();
                for (int j = 0; j < this.headerProps.length; ++j) {
                    Cell cell = row.getCell(j);
                    String cellValue = this.getCellValue(cell);
                    val.put(this.headerProps[j], cellValue);
                }
                ExcelRow realRow = this.validator.validate(val, i + 1);
                if (realRow.getValidateError() != null && realRow.getValidateError().hasError()) {
                    validateError.appendError(realRow.getValidateError());
                    continue;
                }
                rtnList.add(realRow.getRow());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error reading excel:" + String.valueOf(e));
        }
        finally {
            try {
                if (this.source != null) {
                    this.source.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        result.setResult(rtnList);
        result.setValidateError(validateError);
        return result;
    }

    private String getCellValue(Cell cell) {
        DecimalFormat df = new DecimalFormat("#.00");
        String cellValue = null;
        if (cell == null) {
            return "";
        }
        if (CellType.NUMERIC == cell.getCellType()) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
            } else {
                cellValue = df.format(cell.getNumericCellValue()).replace(".00", "");
            }
        } else if (CellType.STRING == cell.getCellType()) {
            cellValue = String.valueOf(cell.getStringCellValue());
        } else if (CellType.FORMULA == cell.getCellType()) {
            cellValue = String.valueOf(cell.getCellFormula());
        } else if (CellType.BLANK == cell.getCellType()) {
            cellValue = "";
        } else if (CellType.BOOLEAN == cell.getCellType()) {
            cellValue = String.valueOf(cell.getBooleanCellValue());
        } else if (CellType.ERROR == cell.getCellType()) {
            cellValue = String.valueOf(cell.getErrorCellValue());
        }
        return cellValue;
    }

    private Workbook getWorkbook(ExcelVersion version, InputStream is) throws Exception {
        HSSFWorkbook wb = null;
        if (ExcelVersion.EXCEL_2003 == version) {
            wb = new HSSFWorkbook(is);
        } else if (ExcelVersion.EXCEL_2007 == version) {
            wb = new XSSFWorkbook(is);
        } else {
            throw new RuntimeException("Unsuport version of the excel type");
        }
        return wb;
    }
}

