/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.web.util;

import com.tcbj.framework.exception.exception.Thrower;
import com.tcbj.framework.web.util.DynamicTimeoutInterceptor;
import com.tcbj.framework.web.util.HttpTimeountConfig;
import com.tcbj.framework.web.util.LoggingInterceptor;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Https {
    private static volatile Https instance;
    private OkHttpClient client;
    private DynamicTimeoutInterceptor interceptor;

    private Https() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.writeTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(30L, TimeUnit.SECONDS);
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            builder.sslSocketFactory(sslContext.getSocketFactory(), Https.getX509TrustManager());
        }
        catch (Exception e) {
            Thrower.throwAppException((String)"500", (String)"\u521d\u59cb\u5316okHttp\u5931\u8d25");
        }
        this.interceptor = new DynamicTimeoutInterceptor();
        builder.addInterceptor((Interceptor)this.interceptor);
        builder.addInterceptor((Interceptor)new LoggingInterceptor());
        builder.retryOnConnectionFailure(true);
        this.client = builder.build();
    }

    public static X509TrustManager getX509TrustManager() {
        X509TrustManager trustManager = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            trustManager = (X509TrustManager)trustManagers[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trustManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Https getInstance() {
        if (instance != null) return instance;
        Class<Https> clazz = Https.class;
        synchronized (Https.class) {
            if (instance != null) return instance;
            instance = new Https();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addHttpTimeoutConfig(HttpTimeountConfig ... configs) {
        DynamicTimeoutInterceptor.addTimeoutConfig(configs);
    }

    public void getAsyc(String url, Map<String, String> headers, Callback callback) {
        Request request = this.getRequestBuilder(headers).url(url).build();
        this.client.newCall(request).enqueue(callback);
    }

    public String get(String url, Map<String, String> headers) {
        Request request = this.getRequestBuilder(headers).url(url).build();
        try {
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void postAsyc(String url, Map<String, String> headers, Map<String, String> data, Callback callback) {
        FormBody.Builder formBody = new FormBody.Builder();
        if (Objects.nonNull(data)) {
            data.forEach((x, y) -> formBody.add(x, y));
        }
        FormBody body = formBody.build();
        Request request = this.getRequestBuilder(headers).url(url).post((RequestBody)body).build();
        this.client.newCall(request).enqueue(callback);
    }

    public String post(String url, Map<String, String> headers, Map<String, String> data) {
        FormBody.Builder formBody = new FormBody.Builder();
        if (Objects.nonNull(data)) {
            data.forEach((x, y) -> formBody.add(x, y));
        }
        FormBody body = formBody.build();
        Request request = this.getRequestBuilder(headers).url(url).post((RequestBody)body).build();
        try {
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void postJsonAsyc(String url, Map<String, String> headers, String jsonData, Callback callback) {
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonData);
        Request request = this.getRequestBuilder(headers).url(url).post(body).build();
        this.client.newCall(request).enqueue(callback);
    }

    public String postJson(String url, Map<String, String> headers, String jsonData) {
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonData);
        Request request = this.getRequestBuilder(headers).url(url).post(body).build();
        try {
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void postFileAsyc(String url, Map<String, String> headers, File file, Callback callback) {
        MediaType MEDIA_TYPE = MediaType.parse((String)"multipart/form-data");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MEDIA_TYPE, (File)file)).build();
        Request request = this.getRequestBuilder(headers).url(url).post((RequestBody)requestBody).build();
        this.client.newCall(request).enqueue(callback);
    }

    public String postFile(String url, Map<String, String> headers, List<File> files) {
        MediaType MEDIA_TYPE = MediaType.parse((String)"multipart/form-data");
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (files != null && files.size() > 0) {
            for (File file : files) {
                builder.addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MEDIA_TYPE, (File)file));
            }
        }
        MultipartBody requestBody = builder.build();
        Request request = this.getRequestBuilder(headers).url(url).post((RequestBody)requestBody).build();
        try {
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Request.Builder getRequestBuilder(Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        if (headers != null && headers.size() > 0) {
            headers.forEach((k, v) -> builder.addHeader(k, v));
        }
        return builder;
    }
}

