/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.web.exception;

import com.tcbj.framework.dto.Response;
import com.tcbj.framework.exception.exception.AppException;
import com.tcbj.framework.exception.exception.ExceptionUtil;
import com.tcbj.framework.message.MessageFactory;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class RestResponseEntityExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(RestResponseEntityExceptionHandler.class);

    @ExceptionHandler(value={NoHandlerFoundException.class})
    protected ResponseEntity<Object> handle404(NoHandlerFoundException ex) {
        Response r = Response.build404Response(null);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={AppException.class})
    protected ResponseEntity<Object> handleBizz(AppException ex) {
        Response r = Response.buildBizzFailureResponse((String)ex.getErrorCode(), (String)ex.getErrorMsg(), null);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException e, HttpServletRequest request) {
        logger.error("\u3010\u7f3a\u5c11\u5fc5\u586b\u8bf7\u6c42\u53c2\u6570\u3011\u53c2\u6570\u540d\uff1a{}\uff0c\u8bf7\u6c42URL\uff1a{}\uff0c\u8bf7\u6c42\u65b9\u5f0f\uff1a{}\uff0c\u5ba2\u6237\u7aefIP\uff1a{}", new Object[]{e.getParameterName(), request.getRequestURL(), request.getMethod(), request.getRemoteAddr()});
        Response r = Response.buildBizzFailureResponse((String)Response.StatusCode.VALID_ERROR.getValue(), (String)"\u53c2\u6570\u7f3a\u5931", null);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handle500(Exception ex) {
        String stack = ExceptionUtil.getStackTrace((Exception)ex);
        Response r = Response.buildBizzFailureResponse((String)Response.StatusCode.ERROR.getValue(), (String)stack, null);
        logger.error("\u8fd0\u884c\u65f6\u5f02\u5e38\uff1a", (Throwable)ex);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleFormValidate(ConstraintViolationException ex) {
        String message = "";
        for (ConstraintViolation vio : ex.getConstraintViolations()) {
            String msg;
            message = msg = MessageFactory.getMessageSource().getMessage(vio.getMessage());
        }
        Response r = Response.buildValidErrorResponse((String)message);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={BindException.class})
    protected ResponseEntity<Object> handleFormValidate(BindException ex) {
        String message = "";
        for (FieldError fieldError : ex.getBindingResult().getFieldErrors()) {
            String msg;
            message = msg = MessageFactory.getMessageSource().getMessage(fieldError.getDefaultMessage());
        }
        Response r = Response.buildValidErrorResponse((String)message);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ResponseEntity<Object> handleJsonValidate(MethodArgumentNotValidException ex) {
        String message = "";
        for (FieldError fieldError : ex.getBindingResult().getFieldErrors()) {
            String msg;
            message = msg = MessageFactory.getMessageSource().getMessage(fieldError.getDefaultMessage());
        }
        Response r = Response.buildValidErrorResponse((String)message);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }
}

