/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.basedata.api.rpc;

import com.tcbj.framework.dto.Page;
import com.tcbj.framework.dto.Response;
import com.tcbj.tangsales.basedata.api.contract.ContractTicketOpensQuery;
import com.tcbj.tangsales.basedata.api.contract.request.PartnerAddressQuery;
import com.tcbj.tangsales.basedata.api.contract.request.PartnerQuery;
import com.tcbj.tangsales.basedata.api.contract.request.SubPartnerQuery;
import com.tcbj.tangsales.basedata.api.contract.response.partner.ContractTicketOpenDto;
import com.tcbj.tangsales.basedata.api.contract.response.partner.ContractTicketReceiveDto;
import com.tcbj.tangsales.basedata.api.contract.response.partner.PartnerAddressDto;
import com.tcbj.tangsales.basedata.api.contract.response.partner.PartnerDto;
import com.tcbj.tangsales.basedata.api.contract.response.partner.SubPartnerDto;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="tang-sales-basedata-module-service", path="/api/basedata/partner")
public interface PartnerApi {
    @GetMapping(value={"/get"})
    public Response<PartnerDto> getFullPartnerInfo(@RequestParam(name="id") String var1);

    @PostMapping(value={"/list"})
    public Response<List<PartnerDto>> getFullPartnerList(@RequestBody PartnerQuery var1);

    @PostMapping(value={"/getSimple"})
    public Response<PartnerDto> getSimplePartnerInfo(@RequestParam(name="id") String var1);

    @PostMapping(value={"/simple/list"})
    public Response<List<PartnerDto>> getSimplePartnerList(@RequestBody PartnerQuery var1);

    @PostMapping(value={"/simple/page"})
    public Response<Page<PartnerDto>> queryPartnerList(@RequestBody PartnerQuery var1);

    @GetMapping(value={"/getCache"})
    public Response<PartnerDto> getFullPartnerInfoCache(@RequestParam(name="id") String var1);

    @PostMapping(value={"/getCache/simple"})
    public Response<PartnerDto> getSimplePartnerInfoCache(@RequestParam(name="id") String var1);

    @PostMapping(value={"/address"})
    public Response<List<PartnerAddressDto>> getPartnerAddresssList(@RequestBody PartnerAddressQuery var1);

    @GetMapping(value={"/getAddress"})
    public Response<PartnerAddressDto> getPartnerAddress(@RequestParam(name="addressId") String var1);

    @PostMapping(value={"/isBigCustomerOrKa"})
    public Response<Boolean> isBigCustomerOrKa(@RequestParam(name="partnerId") String var1);

    @PostMapping(value={"/getRelatePartners"})
    public Response<List<PartnerDto>> getRelatePartners(@RequestParam(name="partnerId") String var1);

    @PostMapping(value={"/getRelatedDelear"})
    public Response<List<PartnerDto>> getRelatedDelear(@RequestParam(name="partnerId") String var1);

    @PostMapping(value={"/subPartners"})
    public Response<List<SubPartnerDto>> getSubPartners(@RequestBody SubPartnerQuery var1);

    @PostMapping(value={"/getPartnerById"})
    public Response<PartnerDto> getPartnerById(@RequestParam(name="partnerId") String var1);

    @PostMapping(value={"/getContractTicketOpens"})
    public Response<List<ContractTicketOpenDto>> getContractTicketOpens(@RequestBody ContractTicketOpensQuery var1);

    @PostMapping(value={"/getContractTicketReceives"})
    public Response<List<ContractTicketReceiveDto>> getContractTicketReceives(@RequestBody ContractTicketOpensQuery var1);
}

