/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.order.api.contract.constant;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.stream.Stream;

public class ReturnOrderEnum {

    public static enum MyOrderState {
        all("", "\u5168\u90e8"),
        draft("0", "\u8349\u7a3f"),
        approve("2", "\u5f85\u5ba1\u6279"),
        approveNoPass("2-0", "\u5ba1\u6279\u4e0d\u901a\u8fc7"),
        approvePass("3", "\u5ba1\u6279\u901a\u8fc7"),
        balancePass("4", "\u8d22\u52a1\u901a\u8fc7"),
        billing("4-1", "\u5df2\u5f00\u5355"),
        balanceNoPass("4-2", "\u8d22\u52a1\u4e0d\u901a\u8fc7"),
        sended("5", "\u5df2\u53d1\u8d27"),
        received("6", "\u5df2\u6536\u8d27"),
        cspapprove("7", "CSP\u5ba1\u6279\u901a\u8fc7"),
        cspapproveNoPass("8", "CSP\u5ba1\u6279\u4e0d\u901a\u8fc7"),
        verify("10", "\u5f85\u6838\u5b9e"),
        merges("12", "\u5df2\u5408\u5e76"),
        partnerConfirm("13", "\u5f85\u7ecf\u9500\u5546\u786e\u8ba4"),
        toReceived("14", "\u5f85\u6536\u8d27"),
        toOaReceived("15", "\u5f85OA\u5ba1\u6279");

        private final String value;
        private final String name;

        private MyOrderState(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum CustomerOrderState {
        all("", "\u5168\u90e8"),
        audit("1", "\u5f85\u786e\u8ba4"),
        verify("10", "\u5f85\u6838\u5b9e"),
        merges("12", "\u5df2\u5408\u5e76"),
        approvePass("3", "\u5ba1\u6279\u901a\u8fc7"),
        approveNoPass("2-0", "\u5ba1\u6279\u4e0d\u901a\u8fc7"),
        balancePass("4", "\u8d22\u52a1\u901a\u8fc7"),
        sended("5", "\u5df2\u53d1\u8d27"),
        received("6", "\u5df2\u6536\u8d27"),
        cspapprove("7", "CSP\u5ba1\u6279\u901a\u8fc7"),
        cspapproveNoPass("8", "CSP\u5ba1\u6279\u4e0d\u901a\u8fc7"),
        toReceived("14", "\u5f85\u6536\u8d27"),
        toOaReceived("15", "\u5f85OA\u5ba1\u6279");

        private final String value;
        private final String name;

        private CustomerOrderState(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum OrderEvent {
        SUBMIT("submit", "\u5355\u636e\u63d0\u4ea4"),
        CONFIRM("confirm", "\u786e\u8ba4\u6536\u8d27"),
        VERIFY("verify", "\u6838\u5b9e\u901a\u8fc7"),
        APPROVE("approve", "\u5ba1\u6279\u901a\u8fc7"),
        OA_APPROVE("oaApprove", "OA\u5ba1\u6279\u901a\u8fc7"),
        REJECT_TO_NO("rejectToNo", "\u9a73\u56de\u5230CSP\u5ba1\u6279\u4e0d\u901a\u8fc7"),
        REJECT_TO_WAIT("rejectToWait", "\u9a73\u56de\u5230\u5f85\u5ba1\u6279\u72b6\u6001"),
        DELETE("delete", "\u5220\u9664");

        @JsonValue
        private final String value;
        private final String name;

        public static OrderEvent of(String value) {
            Objects.requireNonNull(value);
            return Stream.of(OrderEvent.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        private OrderEvent(String value, String name) {
            this.value = value;
            this.name = name;
        }
    }

    public static enum OrderState {
        draft("0", "\u8349\u7a3f"),
        toReceived("14", "\u5f85\u6536\u8d27"),
        verify("10", "\u5f85\u6838\u5b9e"),
        received("6", "\u5df2\u6536\u8d27"),
        approve("2", "\u5f85\u5ba1\u6279"),
        toOaReceived("15", "\u5f85OA\u5ba1\u6279"),
        cspapproveNoPass("8", "CSP\u5ba1\u6279\u4e0d\u901a\u8fc7"),
        del("9", "\u5df2\u5220\u9664");

        @JsonValue
        private final String value;
        private final String name;

        public static OrderState of(String value) {
            Objects.requireNonNull(value);
            return Stream.of(OrderState.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        private OrderState(String value, String name) {
            this.value = value;
            this.name = name;
        }
    }
}

