/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: Sean
 * Date: 14-3-3
 * Time: 下午4:33
 */
$(function () {
    if (navigator.userAgent.indexOf('IE') >= 0) {
        $.ajaxSetup({cache: false});
    }
    var Mytask = {
        STATIC: {
            DETAILSEARCH: false,
            TASKTYPE: 2,
            TASKNAME: null,
            SPONSOR: null,
            SENDER: null,
            SENDSTART: null,
            SENDEND: null,
            DEADSTART: null,
            DEADEND: null,
            TASKSTATE: null,
            TASKOPT: null,
            FILTER: null,
            SORT: true
        },
        CONSTS: {
            TASKCATE: {
                0: FR.i18nText('Dec-Workflow_All_Tasks'),
                1: FR.i18nText('Dec-Workflow_Finished_Task'),
                2: FR.i18nText('Dec-Workflow_Unfinished_Task_Name')
            },
            AUTHS: {
                0: FR.i18nText("Dec-Workflow_Report"),
                1: FR.i18nText("Dec-Workflow_Review"),
                2: FR.i18nText("Dec-Workflow_Deliver"),
                3: FR.i18nText("Dec-Workflow_Close"),
                4: FR.i18nText("Dec-Workflow_Face_View"),
                5: FR.i18nText("Dec-Workflow_Note"),
                6: FR.i18nText("Dec-Workflow__View"),
                7: FR.i18nText("Dec-Workflow_Save"),
                8: FR.i18nText("Dec-Workflow_Pass"),
                9: FR.i18nText("Dec-Workflow_Rollback"),
                10: FR.i18nText("Dec-Workflow_Report")
            },
            TASK_STATE_OVERTIME: 5,
            TASK_STATE_CLOSED: 4,
            TASKSTATES: [
                {value: -1, text: FR.i18nText('Dec-Workflow_None')},
                {value: 0, text: FR.i18nText('Dec-Workflow_To_Report')},
                {value: 1, text: FR.i18nText('Dec-Workflow_To_Check')},
                {value: 2, text: FR.i18nText('Dec-Workflow_Pass')},
                {value: 3, text: FR.i18nText('Dec-Workflow_Rollback')},
                {value: 4, text: FR.i18nText('Dec-Workflow_Closed')},
                {value: 5, text: FR.i18nText('Dec-Workflow_Overtime')}
            ]
        },
        init: function () {
            var self = this;
            //获取是否当前登录用户是管理员
            FR.ajax({
                url: FR.servletURL + "?op=report_process&cmd=check_admin",
                async: false,
                complete: function (res, status) {
                    if (status == 'success') {
                        var result = FR.jsonDecode(res.responseText);
                        self.isAdmin = result.isAdmin;
                    }
                }
            });
            if (this.isAdmin) {
                this.STATIC.TASKTYPE = 0;
            }
            this.mytaskPane = new FR.Panel({
                renderEl: $('#rp-mytask'),
                doSize: true,
                fit: true,
                contentWidget: {
                    type: 'border',
                    scrollable: true,
                    widgetName: 'MAINLAYOUT',
                    items: [
                        {
                            el: {
                                type: 'tablelayout',
                                scrollable: false,
                                widgetName: 'TOPTOOL',
                                items: [
                                    [
                                        null,
                                        null,
                                        {el: {type: 'label'}},
                                        null
                                    ],
                                    [
                                        {
                                            el: {type: 'label'}
                                        },
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                text: FR.i18nText("Dec-Workflow_Refresh"),
                                                height: 24,
                                                width: 70,
                                                baseClass: 'rp-mytask-refresh',
                                                handler: function () {
                                                    self.mytaskPane.getWidgetByName('TASKGRID').refresh({isRefresh: true});
                                                }
                                            }
                                        },
                                        {el: {type: 'label'}},
                                        {
                                            el: {
                                                type: 'search',
                                                width: 244,
                                                advanced: true,
                                                onSearch: function () {
                                                    self.STATIC.DETAILSEARCH = false;
                                                    var val = this.getValue();
                                                    var data = {getAll: false, filter: val};
                                                    if (self.STATIC.GETALL === 1) {
                                                        data.getAll = true;
                                                    }
                                                    FR.ajax({
                                                        url: FR.servletURL + "?op=report_process&cmd=get_all_taskImpl",
                                                        type: 'POST',
                                                        data: data,
                                                        complete: function (res, status) {
                                                            if (status == 'success') {
                                                                self.STATIC.FILTER = val;
                                                                self.STATIC.DETAILSEARCH = false;
                                                                var items = FR.jsonDecode(res.responseText);
                                                                self.mytaskPane.getWidgetByName('TASKGRID').refresh(items);
                                                            }
                                                        }
                                                    })
                                                },
                                                onTrigger: function () {
                                                    var $advance = $('<div class="fr-mytask-advance"/>');
                                                    $advance.css({
                                                        position: 'absolute',
                                                        left: this.element.offset().left,
                                                        top: this.element.offset().top + this.element.height(),
                                                        'z-Index': FR.widget.opts.zIndex++
                                                    }).appendTo('body');
                                                    var rh = 20, fill = 155, sizeLong = 135, sizeMedium = 115,
                                                        sizeShort = 95;
                                                    var conditionPane = new FR.ConfirmPane({
                                                        renderEl: $advance,
                                                        doSize: true,
                                                        width4OK: 60,
                                                        height4OK: 30,
                                                        width: 300,
                                                        height: 300,
                                                        width4Cancel: Math.max(60, FR.i18nTextWidth("Dec-Basic_Cancel") + 30),
                                                        height4Cancel: 30,
                                                        text4OK: FR.i18nText("Dec-Workflow_Search"),
                                                        text4Cancel: FR.i18nText("Dec-Basic_Cancel"),
                                                        onOK: function () {
                                                            var tasktype = this.getWidgetByName('TASKTYPE').getValue();
                                                            var taskname = this.getWidgetByName('TASKNAME').getValue();
                                                            var sponsor = this.getWidgetByName('SPONSOR').getValue();
                                                            var sender = this.getWidgetByName('SENDER').getValue();
                                                            var sendstart = this.getWidgetByName('SENDSTART').getValue();
                                                            var sendend = this.getWidgetByName('SENDEND').getValue();
                                                            var deadstart = this.getWidgetByName('DEADSTART').getValue();
                                                            var deadend = this.getWidgetByName('DEADEND').getValue();
                                                            var taskstate = this.getWidgetByName('TASKSTATE').getValue();
                                                            var taskopt = this.getWidgetByName('TASKOPT').getValue();
                                                            FR.ajax({
                                                                url: FR.servletURL + "?op=report_process&cmd=get_all_taskImpl",
                                                                type: 'POST',
                                                                data: {
                                                                    detailSearch: true,
                                                                    getType: tasktype,
                                                                    taskName: taskname,
                                                                    creatorId: sponsor,
                                                                    senderId: sender,
                                                                    sendStartTime: sendstart,
                                                                    sendEndTime: sendend,
                                                                    deadStartTime: deadstart,
                                                                    deadEndTime: deadend,
                                                                    taskState: taskstate,
                                                                    taskOpt: taskopt
                                                                },
                                                                complete: function (res, status) {
                                                                    if (status == 'success') {
                                                                        if (!FR.isEmpty(tasktype)) {
                                                                            self.STATIC.TASKTYPE = tasktype;
                                                                        }
                                                                        self.STATIC.TASKNAME = taskname;
                                                                        self.STATIC.SPONSOR = sponsor;
                                                                        self.STATIC.SENDER = sender;
                                                                        self.STATIC.SENDSTART = sendstart;
                                                                        self.STATIC.SENDEND = sendend;
                                                                        self.STATIC.DEADSTART = deadstart;
                                                                        self.STATIC.DEADEND = deadend;
                                                                        self.STATIC.TASKSTATE = taskstate;
                                                                        self.STATIC.TASKOPT = taskopt;
                                                                        var items = FR.jsonDecode(res.responseText);
                                                                        self.mytaskPane.getWidgetByName('TASKGRID').refresh(items);
                                                                    }
                                                                }
                                                            });

                                                        },
                                                        contentWidget: {
                                                            type: 'tablelayout',
                                                            columnSize: [10, 60, 5, 205],
                                                            rowSize: [5, rh, rh, rh, rh, rh, rh, rh, rh],
                                                            vgap: 8,
                                                            items: [
                                                                [
                                                                    {el: $('<div/>')},
                                                                    null,
                                                                    null,
                                                                    null,
                                                                    null
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Task_Type")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetName: 'TASKTYPE',
                                                                            disabled: !!self.isAdmin,
                                                                            items: [
                                                                                {
                                                                                    value: 0,
                                                                                    text: FR.i18nText('Dec-Workflow_All_Tasks')
                                                                                },
                                                                                {
                                                                                    value: 1,
                                                                                    text: FR.i18nText('Dec-Workflow_Finished_Task')
                                                                                },
                                                                                {
                                                                                    value: 2,
                                                                                    text: FR.i18nText('Dec-Workflow_Unfinished_Task_Name')
                                                                                }
                                                                            ],
                                                                            width: fill
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_TaskName")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'text',
                                                                            widgetName: 'TASKNAME',
                                                                            width: sizeLong
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Sponsor")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetName: 'SPONSOR',
                                                                            widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user",
                                                                            width: sizeMedium
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Sender")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetName: 'SENDER',
                                                                            widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user",
                                                                            width: sizeMedium
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Send_Date")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'border', items: [
                                                                                {
                                                                                    region: 'west', el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'SENDSTART',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('SENDEND');
                                                                                                c.setStartDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    }, width: sizeShort
                                                                                },
                                                                                {
                                                                                    region: 'center',
                                                                                    el: $('<div class="fr-mytask-to"/>').html('&minus;')
                                                                                },
                                                                                {
                                                                                    region: 'east', el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'SENDEND',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('SENDSTART');
                                                                                                c.setEndDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    }, width: sizeShort
                                                                                }
                                                                            ]
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Report_Deadline")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'border', items: [
                                                                                {
                                                                                    region: 'west', el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'DEADSTART',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('DEADEND');
                                                                                                c.setStartDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    }, width: sizeShort
                                                                                },
                                                                                {
                                                                                    region: 'center',
                                                                                    el: $('<div class="fr-mytask-to"/>').html('&minus;')
                                                                                },
                                                                                {
                                                                                    region: 'east', el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'DEADEND',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('DEADSTART');
                                                                                                c.setEndDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    }, width: sizeShort
                                                                                }
                                                                            ]
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Task_Status")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            items: self.CONSTS.TASKSTATES,
                                                                            widgetName: 'TASKSTATE',
                                                                            width: sizeMedium
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Task_Operations")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            width: sizeMedium,
                                                                            items: [
                                                                                {
                                                                                    value: 0,
                                                                                    text: FR.i18nText("Dec-Workflow_Report")
                                                                                },
                                                                                {
                                                                                    value: 1,
                                                                                    text: FR.i18nText("Dec-Workflow_Review")
                                                                                },
                                                                                {
                                                                                    value: 2,
                                                                                    text: FR.i18nText("Dec-Workflow_Deliver")
                                                                                },
                                                                                {
                                                                                    value: 3,
                                                                                    text: FR.i18nText("Dec-Workflow_Close")
                                                                                },
                                                                                {
                                                                                    value: 4,
                                                                                    text: FR.i18nText("Dec-Workflow_Face_View")
                                                                                },
                                                                                {
                                                                                    value: 5,
                                                                                    text: FR.i18nText('Dec-Workflow_Offline')
                                                                                }
                                                                            ],
                                                                            widgetName: 'TASKOPT'
                                                                        }
                                                                    }
                                                                ]
                                                            ]
                                                        }
                                                    });
                                                    $(document).bind('mousedown.advance', function (e) {
                                                        var target = e.target;
                                                        var res = $(target).isChildAndSelfOf('.fr-mytask-advance')
                                                            || $(target).isChildAndSelfOf('.view-container');
                                                        if (!res) {
                                                            $advance.remove();
                                                            $(document).unbind('mousedown.advance');
                                                        }
                                                    });
                                                    conditionPane.getWidgetByName('TASKTYPE').setValue(self.STATIC.TASKTYPE);
                                                    conditionPane.getWidgetByName('TASKNAME').setValue(self.STATIC.TASKNAME);
                                                    conditionPane.getWidgetByName('SPONSOR').setValue(self.STATIC.USERID);
                                                    conditionPane.getWidgetByName('SENDER').setValue(self.STATIC.SENDER);
                                                    conditionPane.getWidgetByName('SENDSTART').setValue(self.STATIC.SENDSTART);
                                                    conditionPane.getWidgetByName('SENDEND').setValue(self.STATIC.SENDEND);
                                                    conditionPane.getWidgetByName('DEADSTART').setValue(self.STATIC.DEADSTART);
                                                    conditionPane.getWidgetByName('DEADEND').setValue(self.STATIC.DEADEND);
                                                    conditionPane.getWidgetByName('TASKSTATE').setValue(self.STATIC.TASKSTATE);
                                                    conditionPane.getWidgetByName('TASKOPT').setValue(self.STATIC.TASKOPT);
                                                    conditionPane.getWidgetByName('SENDSTART').setEndDate(self.STATIC.SENDEND);
                                                    conditionPane.getWidgetByName('SENDEND').setStartDate(self.STATIC.SENDSTART);
                                                    conditionPane.getWidgetByName('DEADSTART').setEndDate(self.STATIC.DEADEND);
                                                    conditionPane.getWidgetByName('DEADEND').setStartDate(self.STATIC.DEADSTART);
                                                }
                                            }
                                        }
                                    ]
                                ],
                                columnSize: [0.01, 0.1, 0.55, 0.3],
                                rowSize: [24, 28, 24]
                            },
                            region: 'north',
                            height: 76
                        },
                        {
                            el: {
                                type: "fitablequickgrid",
                                widgetName: 'TASKGRID',
                                intervalColor: true,
                                page: true,
                                pageCount: 15,
                                isHeadShow: true,
                                hasHoverCls: false,
                                async: {
                                    url: FR.servletURL + '?op=report_process&cmd=get_all_taskImpl',
                                    type: 'POST',
                                    data: {}
                                },
                                columnsConfig: [
                                    {
                                        key: 'name',
                                        value: self.CONSTS.TASKCATE[self.STATIC.TASKTYPE],
                                        width: 0.2,
                                        onHeadCellCreate: function () {
                                            var $cell = $('<div/>').hover(
                                                function () {
                                                    $(this).addClass('cell-hover');
                                                },
                                                function () {
                                                    $(this).removeClass('cell-hover');
                                                }
                                            );

                                            $('<span/>').text(self.CONSTS.TASKCATE[self.STATIC.TASKTYPE]).appendTo($cell);
                                            if (!self.isAdmin) {
                                                $cell.click(
                                                    function () {
                                                        self.createNameCombo($(this));
                                                    }
                                                );
                                                $('<span class="rp-mytask-arrow">').appendTo($cell);
                                            }
                                            return $cell;
                                        }
                                    },
                                    {
                                        key: 'creatorName',
                                        value: FR.i18nText("Dec-Workflow_Sponsor"),
                                        width: 0.1,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'sender',
                                        value: FR.i18nText("Dec-Workflow_Sender"),
                                        width: 0.1,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'sendTime',
                                        value: FR.i18nText("Dec-Workflow_Send_Time"),
                                        width: 0.15,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'deadLine',
                                        value: FR.i18nText("Dec-Workflow_Report_Deadline"),
                                        width: 0.15,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'stateName',
                                        value: FR.i18nText("Dec-Workflow_Task_Status"),
                                        width: 0.1,
                                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                                            var $cell = $('<div/>');
                                            if (!isNaN(item.state)) {
                                                $('<span class="state-name"/>').text(self.CONSTS.TASKSTATES[item.state + 1].text).appendTo($cell);
                                            }
                                            return $cell;
                                        },
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        width: 0.2,
                                        key: 'taskOpt',
                                        value: FR.i18nText("Dec-Workflow_Task_Operations"),
                                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                                            var $cells = $('<div/>');
                                            var $cell = $('<span/>').appendTo($cells);
                                            for (var i = 0; i < 4; i++) {
                                                if (item.authority && item.authority.charAt(i) == '1') {
                                                    var text = self.CONSTS.AUTHS[i];
                                                    $('<span class="rp-mytask-auth"/>').data('nav', i).text(text).appendTo($cell);
                                                }
                                            }
                                            if (item.authority && item.authority.charAt(4) == '1') {
                                                var text = self.CONSTS.AUTHS[4];
                                                $('<span class="rp-mytask-auth"/>').data('nav', 4).text(text).appendTo($cells);
                                                $cells.click(
                                                    function (e) {
                                                        var target = e.target;
                                                        item.left = $(target).offset().left - 300;//300是弹出框的固定宽度加上间隙
                                                        switch ($(target).data('nav')) {
                                                            case 4:
                                                                self.createViewBtn(item);
                                                                break;
                                                            default :
                                                                break;
                                                        }
                                                    }
                                                );
                                            }
                                            if (item.needOfflineReport) {
                                                $('<span class="rp-mytask-auth"/>').data('nav', 5).text(FR.i18nText('Dec-Workflow_Offline')).appendTo($cell);
                                            }
                                            if (item.state !== self.CONSTS.TASK_STATE_OVERTIME && item.isTodo) {
                                                $cell.click(
                                                    function (e) {
                                                        var target = e.target;
                                                        switch ($(target).data('nav')) {
                                                            case 0:
                                                            case 1:
                                                                var url = FR.buildServletUrl({
                                                                    reportlet: item.reportPath,
                                                                    op: 'write',
                                                                    __cutpage__: item.cutpage,
                                                                    '__processtaskid__': item.id,
                                                                    '__allprocesstaskid__': item.taskId
                                                                });
                                                                if (FR.Report.Plugin.OpenOnNewTabpane.action) {
                                                                    FR.Report.Plugin.OpenOnNewTabpane.action(item, url);
                                                                } else {
                                                                    window.location = url;
                                                                }
                                                                //上报和审核操作
                                                                break;
                                                            case 2:
                                                                //分发操作
                                                                var dialog = FR.Taskmgr.createOptDialog(null, null, item.id);
                                                                dialog.setVisible(true);
                                                                dialog.getWidgetByName('MAINTABLE').doLayout();
                                                                break;
                                                            case 3:
                                                                //关闭操作
                                                                FR.ajax({
                                                                    url: FR.servletURL + "?op=report_process&cmd=task_close&taskId=" + item.id,
                                                                    type: 'POST',
                                                                    async: false,
                                                                    complete: function (res, status) {
                                                                        if (status == 'success') {
                                                                            var result = FR.jsonDecode(res.responseText);
                                                                            if (result.error) {
                                                                                FR.Msg.toast(result.error);
                                                                            } else {
                                                                                window.location.reload();
                                                                            }
                                                                        } else {
                                                                            FR.Msg.toast(FR.i18nText('Dec-Workflow_Fail'));
                                                                        }
                                                                    }
                                                                });
                                                                break;
                                                            case 5:
                                                                //离线操作
                                                                window.location = FR.servletURL + "?op=report_process_offline&cmd=send_offline&taskId=" + item.id;
//                                                            FR.ajax({
//                                                                url: FR.servletURL+"?op=report_process&cmd=send_offline",
//                                                                type: 'POST',
//                                                                data: {taskId: item.id},
//                                                                complete: function(res, status){
//                                                                    if(status == 'success'){
//                                                                        var result = FR.jsonDecode(res.responseText);
//                                                                        if(result.error){
//                                                                            FR.Msg.toast(FR.i18nText('Fail'));
//                                                                        }
//                                                                    }
//                                                                }
//                                                            });
                                                                break;
                                                            default :
                                                                break;
                                                        }
                                                    }
                                                );
                                            } else {
                                                $cell.addClass('rp-mytask-auth-disable');
                                            }
                                            return $cells;
                                        },
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    }
                                ],
                                onAfterRowCreate: function ($row, rowIdx, item) {
                                    if (item.state === self.CONSTS.TASK_STATE_OVERTIME) {
                                        $row.addClass('task-overtime');
                                    } else if (item.state === self.CONSTS.TASK_STATE_CLOSED) {
                                        $row.addClass('hilit');
                                    }
                                },
                                onAsyncSuccess: function (res, status, items) {
                                    this.options.items = FR.jsonDecode(res);
                                    if (items && items.isRefresh) {
                                        FR.Msg.toast(FR.i18nText("Dec-Workflow_Refresh_Successfully"));
                                    }
                                }
                            },
                            region: 'center',
                            height: 700
                        }
                    ]
                }
            });
            this.mytaskPane.getWidgetByName('MAINLAYOUT').doLayout();
        },

        createSortCell: function (itemcfg) {
            var grid = this.mytaskPane.getWidgetByName('TASKGRID'), self = this;
            var $cell = $('<div/>').hover(
                function () {
                    $(this).addClass('cell-hover');
                },
                function () {
                    $(this).removeClass('cell-hover');
                }
            ).click(
                function () {
                    var data = {
                        detailSearch: self.STATIC.DETAILSEARCH,
                        getType: self.STATIC.TASKTYPE,
                        taskName: self.STATIC.TASKNAME,
                        creatorId: self.STATIC.SPONSOR,
                        senderId: self.STATIC.SENDER,
                        sendStartTime: self.STATIC.SENDSTART,
                        sendEndTime: self.STATIC.SENDEND,
                        deadStartTime: self.STATIC.DEADSTART,
                        deadEndTime: self.STATIC.DEADEND,
                        taskState: self.STATIC.TASKSTATE,
                        taskOpt: self.STATIC.TASKOPT,
                        sortBy: itemcfg.key,
                        desc: self.STATIC.SORT
                    };
                    self.STATIC.SORT = !self.STATIC.SORT;
                    FR.ajax({
                        url: FR.servletURL + '?op=report_process&cmd=get_all_taskImpl',
                        type: 'POST',
                        data: data,
                        complete: function (res, status) {
                            if (status == 'success') {
                                var items = FR.jsonDecode(res.responseText);
                                grid.refresh(items);
                            }
                        }
                    });
                }
            ).append($('<span/>').text(itemcfg.value));
            return $cell;
        },

        createViewBtn: function (item) {
            FR.ajax({
                url: FR.servletURL + "?op=report_process&cmd=get_taskImpl&" + new Date().getTime(),
                data: {
                    taskId: item.id
                },
                complete: function (res, status) {
                    if (status == 'success') {
                        var result = FR.jsonDecode(res.responseText);
                        doCreateByConfig(result, item.left);
                    }
                }
            });
            var createView = function (nodes, notes, curIdx, nodeRoute, left) {
                var h = FR.windowHeight;
                var left4View = left > 0 ? left : 0;
                var top = (h - 300) / 2
                    + $(document).scrollTop();
                var $view = $('<div class="fr-combo-list"/>').css({
                    width: 290,
                    height: 300,
                    position: 'absolute',
                    'z-index': FR.widget.opts.zIndex++,
                    left: left4View,
                    top: top
                });
                var $ul = $('<ul class="fr-rptool-viewprocess"/>').appendTo($view);
                var len = nodeRoute.length + (nodes.length - 1 - curIdx);
                for (var i = 0; i < len; i++) {
                    var idx = i < nodeRoute.length ? nodeRoute[i] : nodeRoute[nodeRoute.length - 1] + i - nodeRoute.length + 1;
                    var $li = $('<li/>').appendTo($ul);
                    var nodeCls = 'fr-rptool-viewprocess-node',
                        noteCls = 'fr-rptool-viewprocess-note';
                    if (i === 0) {
                        nodeCls += '-first';
                        noteCls += '-done';
                    } else if (i < nodeRoute.length) {
                        nodeCls += '-done';
                        noteCls += '-done';
                    }
                    var $node = $('<div/>').addClass(nodeCls).text(nodes[idx].name).appendTo($li);
                    if (notes[i]) {
                        for (var j = 0, size = notes[i].length; j < size; j++) {
                            $('<div/>').addClass(noteCls).text(notes[i][j].noter).attr('title', notes[i][j].noter).appendTo($li);
                            $('<div/>').addClass(noteCls)
                                .text(notes[i][j].message)
                                .attr('title', notes[i][j].message)
                                .appendTo($li);
                        }
                    }
                }
                var $last = $('<li/>').appendTo($ul);
                $('<div/>').addClass('fr-rptool-viewprocess-node-last').text(FR.i18nText('Dec-Workflow_End')).appendTo($last);
                return $view;
            };

            var doCreateByConfig = function (result, left) {
                var notes = {};
                if (result.note) {
                    for (var i = 0, len = result.note.length; i < len; i++) {
                        var note = result.note[i];
                        notes[note.nodeIdx] = notes[note.nodeIdx] || [];
                        notes[note.nodeIdx].push({
                            noter: note.user + ' ' + note.time,
                            message: FR.i18nText("Dec-Workflow_Note") + ':' + note.message
                        });
                    }
                }
                var $pview = createView(result.process.nodes, notes,
                    result.currentNodeIdx, result.nodeRoute, left);
                $pview.show().appendTo($('body'));
                setTimeout(function () {
                    $(document).bind('click.viewp', function (event) {
                        var target = event.target;
                        var result = $(target).closest('.fr-combo-list');
                        if (result.length === 0) {
                            $pview.remove();
                            $(document).unbind('click.viewp');

                        }
                    });
                }, 200);
            };
        },

        createNameCombo: function ($sel) {
            var self = this;
            var $combo = $('<div class="fr-combo-list rp-mytask-namecombo"/>');
            $('<div/>').text(FR.i18nText("Dec-Workflow_All_Tasks")).data('type', 0).appendTo($combo);
            $('<div/>').text(FR.i18nText('Dec-Workflow_Finished_Task')).data('type', 1).appendTo($combo);
            $('<div/>').text(FR.i18nText("Dec-Workflow_Unfinished_Task_Name")).data('type', 2).appendTo($combo);
            $combo.children('div').hover(
                function () {
                    $(this).addClass('rp-mytask-name-hover');
                },
                function () {
                    $(this).removeClass('rp-mytask-name-hover');
                }
            ).click(
                function () {
                    var type = $(this).data('type');
                    self.STATIC.TASKTYPE = type;
                    self.mytaskPane.getWidgetByName('TASKGRID').options.async.data.getType = type;
                    self.mytaskPane.getWidgetByName('TASKGRID').refresh();
                    $combo.remove();
                    $(document).unbind('mousedown.namecombo');
                }
            );
            $combo.css({
                position: 'absolute',
                left: $sel.offset().left,
                top: $sel.offset().top + $sel.height(),
                'z-Index': FR.widget.opts.zIndex++
            }).appendTo($('body'));
            $(document).bind('mousedown.namecombo', function (e) {
                var target = e.target;
                var res = $(target).closest('.fr-combo-list');
                if (res.length === 0) {
                    $combo.remove();
                    $(document).unbind('mousedown.namecombo');
                }
            });
        }
    };
    Mytask.init();
});