/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: Sean
 * Date: 14-3-3
 * Time: 下午4:31
 */
FR.AuthSelectBtn = FR.extend(FR.ToggleButton, {
    selected_class: 'rp-newp-auth-sel',
    unselected_class: 'rp-newp-auth-unsel',
    _init: function () {
        FR.AuthSelectBtn.superclass._init.apply(this, arguments);
        var self = this;
        this.element.css({
            'display': 'inline',
            width: 'auto',
            height: 20
        });
        this.$btn.hover(
            function () {
                if (self.isEnabled()) {
                    $(this).addClass('rp-newp-auth-hover');
                }
            },
            function () {
                if (self.isEnabled()) {
                    $(this).removeClass('rp-newp-auth-hover');
                }
            }
        )
    }
});
$(function () {
    var ProcessMgr = {
        STATIC: {
            NODESIZE: 0, //节点个数
            GETALL: 0,
            DETAILSEARCH: false,
            FILTER: null,
            PROCESSNAME: null,
            USERID: null,
            DEPARTMENTID: null,
            STARTTIME: null,
            ENDTIME: null,
            SORT: true,
            USEMULTI: false
        },
        PROCESS: {
            NAME: ''
        },
        NODE: {
            ISFIRSTNODE: true
        },
        CONSTS: {
            PROCESSCATE: {
                0: FR.i18nText("Dec-Workflow__Created_By_Me"),
                1: FR.i18nText("Dec-Workflow_AllProcesses")
            },
            AUTHS: {
                0: FR.i18nText("Dec-Workflow_Report"),
                1: FR.i18nText("Dec-Workflow_Review"),
                2: FR.i18nText("Dec-Workflow_Deliver"),
                3: FR.i18nText("Dec-Workflow_Close"),
                4: FR.i18nText("Dec-Workflow_Face_View"),
                5: FR.i18nText("Dec-Workflow_Note"),
                6: FR.i18nText("Dec-Workflow__View"),
                7: FR.i18nText("Dec-Workflow_Save"),
                8: FR.i18nText("Dec-Workflow_Pass"),
                9: FR.i18nText("Dec-Workflow_Rollback"),
                10: FR.i18nText("Dec-Workflow_Report")
            },
            UNIT: {
                0: FR.i18nText("Dec-Workflow_Minute"),
                1: FR.i18nText("Dec-Workflow_Hour"),
                2: FR.i18nText("Dec-Workflow_Day"),
                3: FR.i18nText("Dec-Workflow_Week"),
                4: FR.i18nText("Dec-Workflow_Month")
            },
            MODE: {
                0: FR.i18nText("Dec-Workflow_Email"),
                1: FR.i18nText("Dec-Workflow_System_Message"),
                3: FR.i18nText("Dec-Basic_SMS_Reminder"),
                "3,0,1": FR.i18nText("Dec-Basic_SMS_Reminder") + ',' + FR.i18nText("Dec-Workflow_Email") + ',' + FR.i18nText("Dec-Workflow_System_Message"),
                "3,0": FR.i18nText("Dec-Basic_SMS_Reminder") + ',' + FR.i18nText("Dec-Workflow_Email"),
                "3,1": FR.i18nText("Dec-Basic_SMS_Reminder") + ',' + FR.i18nText("Dec-Workflow_System_Message"),
                "0,1": FR.i18nText("Dec-Workflow_Email") + ',' + FR.i18nText("Dec-Workflow_System_Message")
            },
            IDEN: {
                1: FR.i18nText("Dec-Workflow_User"),
                2: FR.i18nText("Dec-Workflow_Role")
            },
            SOURCE: {
                1: FR.i18nText("Dec-Workflow_Select_FS_Users"),
                2: FR.i18nText("Dec-Workflow_Select_FS_Roles"),
                3: FR.i18nText("Dec-Workflow_Custom_FS_Users"),
                4: FR.i18nText("Dec-Workflow_Custom_FS_Roles"),
                5: FR.i18nText("Dec-Workflow_Custom_FS_Process")
            },
            WATERMARK: {
                1: FR.i18nText("Dec-Workflow_Current_Node_Staff"),
                2: FR.i18nText("Dec-Workflow_Previous_Node_Staff")
            }

        },
        init: function () {
            var self = this;
            this.preLoadData();
            this.processMgrPane = new FR.Panel({
                renderEl: $('#rp-processmgr'),
                doSize: true,
                fit: true,
                contentWidget: {
                    type: 'border',
                    scrollable: true,
                    widgetName: 'MAINLAYOUT',
                    items: [
                        {
                            el: {
                                type: 'tablelayout',
                                scrollable: false,
                                widgetName: 'TOPTOOL',
                                items: [
                                    [
                                        null,
                                        null,
                                        null,
                                        {el: {type: 'label'}},
                                        null
                                    ],
                                    [
                                        {el: {type: 'label'}},
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                text: FR.i18nText("Dec-Workflow_add"),
                                                height: 24,
                                                width: 70,
                                                baseClass: 'rp-processmgr-add',
                                                handler: function () {
                                                    self.optDialog = self.createOptDialog();
                                                    self.optDialog.setVisible(true);
                                                    self.$editor.select();
                                                }
                                            }
                                        },
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                height: 24,
                                                width: 70,
                                                baseClass: 'rp-processmgr-refresh',
                                                text: FR.i18nText("Dec-Workflow_Refresh"),
                                                handler: function () {
                                                    self.processMgrPane.getWidgetByName('PROCESSGRID').refresh({isRefresh: true});
                                                }
                                            }
                                        },
                                        {el: {type: 'label'}},
                                        {
                                            el: {
                                                type: 'search',
                                                advanced: true,
                                                width: 244,
                                                //简单搜索
                                                onSearch: function () {
                                                    var val = this.getValue();
                                                    var data = {getAll: false, filter: val};
                                                    if (self.STATIC.GETALL === 1) {
                                                        data.getAll = true;
                                                    }
                                                    FR.ajax({
                                                        url: FR.servletURL + "?op=report_process&cmd=get_all_process",
                                                        type: 'POST',
                                                        data: data,
                                                        complete: function (res, status) {
                                                            if (status == 'success') {
                                                                self.STATIC.FILTER = val;
                                                                self.STATIC.DETAILSEARCH = false;
                                                                var items = FR.jsonDecode(res.responseText);
                                                                self.processMgrPane.getWidgetByName('PROCESSGRID').refresh(items);
                                                            }
                                                        }
                                                    })
                                                },
                                                //下拉高级搜索
                                                onTrigger: function () {
                                                    var $advance = $('<div class="fr-processmgr-advance"/>');
                                                    $advance.css({
                                                        position: 'absolute',
                                                        left: this.element.offset().left,
                                                        width: 300,
                                                        height: 200,
                                                        top: this.element.offset().top + this.element.height(),
                                                        'z-Index': FR.widget.opts.zIndex++
                                                    }).appendTo('body');
                                                    var rh = 20, fill = 155, sizeLong = 135, sizeMedium = 115,
                                                        sizeShort = 95;
                                                    var conditionPane = new FR.ConfirmPane({
                                                        renderEl: $advance,
                                                        doSize: true,
                                                        width4OK: 60,
                                                        height4OK: 30,
                                                        width4Cancel: Math.max(FR.i18nTextWidth("Dec-Basic_Cancel") + 30, 60),
                                                        height4Cancel: 30,
                                                        text4OK: FR.i18nText("Dec-Workflow_Search"),
                                                        onOK: function () {
                                                            var processtype = this.getWidgetByName('PROCESSTYPE').getValue();
                                                            var processname = this.getWidgetByName('PROCESSNAME').getValue();
                                                            var creator = this.getWidgetByName('CREATOR').getValue();
                                                            var department = this.getWidgetByName('DEPARTMENT').getValue();
                                                            var starttime = this.getWidgetByName('STARTTIME').getValue();
                                                            var endtime = this.getWidgetByName('ENDTIME').getValue();
                                                            var getall = false;
                                                            if (processtype == '1') {
                                                                getall = true;
                                                            }
                                                            FR.ajax({
                                                                url: FR.servletURL + "?op=report_process&cmd=get_all_process",
                                                                type: 'POST',
                                                                data: {
                                                                    detailSearch: true,
                                                                    getAll: getall,
                                                                    processName: processname,
                                                                    userId: creator,
                                                                    departmentId: department,
                                                                    startTime: starttime,
                                                                    endTime: endtime
                                                                },
                                                                complete: function (res, status) {
                                                                    if (status == 'success') {
                                                                        self.STATIC.DETAILSEARCH = true;
                                                                        if (!FR.isEmpty(processtype)) {
                                                                            self.STATIC.GETALL = processtype;
                                                                        }
                                                                        self.STATIC.PROCESSNAME = processname;
                                                                        self.STATIC.USERID = creator;
                                                                        self.STATIC.DEPARTMENTID = department;
                                                                        self.STATIC.STARTTIME = starttime;
                                                                        self.STATIC.ENDTIME = endtime;
                                                                        var items = FR.jsonDecode(res.responseText);
                                                                        self.processMgrPane.getWidgetByName('PROCESSGRID').refresh(items);
                                                                    }
                                                                }
                                                            });
                                                        },
                                                        contentWidget: {
                                                            type: 'tablelayout',
                                                            columnSize: [10, 60, 5, 205],
                                                            rowSize: [5, rh, rh, rh, rh, rh],
                                                            vgap: 8,
                                                            items: [
                                                                [
                                                                    {el: $('<div/>')},
                                                                    null,
                                                                    null,
                                                                    null,
                                                                    null
                                                                ],
                                                                [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow__Type")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetName: 'PROCESSTYPE',
                                                                            items: [
                                                                                {
                                                                                    value: 0,
                                                                                    text: FR.i18nText('Dec-Workflow__Created_By_Me')
                                                                                },
                                                                                {
                                                                                    value: 1,
                                                                                    text: FR.i18nText('Dec-Workflow_AllProcesses')
                                                                                }
                                                                            ],
                                                                            width: fill,
                                                                            listeners: [{
                                                                                eventName: FR.Events.AFTEREDIT,
                                                                                action: function () {
                                                                                    var c = conditionPane.getWidgetByName('CREATOR');
                                                                                    if (this.getValue() === 0) {
                                                                                        var user = self.CONSTS.CURRENTUSER;
                                                                                        if (user) {
                                                                                            if (user.id < 0) {
                                                                                                c.setText(user.username || user.text);
                                                                                            } else {
                                                                                                c.setValue(user.username);
                                                                                            }
                                                                                            c.setEnable(false);
                                                                                        }
                                                                                    } else {
                                                                                        c.setValue("");
                                                                                        c.setEnable(true);
                                                                                    }
                                                                                }
                                                                            }]
                                                                        }
                                                                    }
                                                                ],
                                                                [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Name")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'text',
                                                                            widgetName: 'PROCESSNAME',
                                                                            width: sizeLong
                                                                        }
                                                                    }
                                                                ],
                                                                [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Creator")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user",
                                                                            widgetName: 'CREATOR',
                                                                            width: sizeMedium
                                                                        }
                                                                    }
                                                                ],
                                                                [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Institution")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_depart",
                                                                            widgetName: 'DEPARTMENT',
                                                                            width: sizeMedium
                                                                        }
                                                                    }
                                                                ],
                                                                [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Create_Time")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'border', items: [
                                                                                {
                                                                                    region: 'west',
                                                                                    el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'STARTTIME',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('ENDTIME');
                                                                                                c.setStartDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    },
                                                                                    width: sizeShort
                                                                                },
                                                                                {
                                                                                    region: 'center',
                                                                                    el: $('<div class="fr-processmgr-to"/>').html('&minus;')
                                                                                },
                                                                                {
                                                                                    region: 'east',
                                                                                    el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'ENDTIME',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('STARTTIME');
                                                                                                c.setEndDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    },
                                                                                    width: sizeShort
                                                                                }
                                                                            ]
                                                                        }
                                                                    }
                                                                ]
                                                            ]
                                                        }
                                                    });
                                                    $(document).bind('mousedown.advance', function (e) {
                                                        var target = e.target;
                                                        var res = $(target).isChildAndSelfOf('.fr-processmgr-advance')
                                                            || $(target).isChildAndSelfOf('.view-container');
                                                        if (!res) {
                                                            $advance.remove();
                                                            $(document).unbind('mousedown.advance');
                                                        }
                                                    });
                                                    conditionPane.getWidgetByName('PROCESSTYPE').setValue(self.STATIC.GETALL);
                                                    conditionPane.getWidgetByName('PROCESSNAME').setValue(self.STATIC.PROCESSNAME);
                                                    if (self.STATIC.USERID !== null) {
                                                        conditionPane.getWidgetByName('CREATOR').setValue(self.STATIC.USERID);
                                                    }
                                                    conditionPane.getWidgetByName('DEPARTMENT').setValue(self.STATIC.DEPARTMENTID);
                                                    conditionPane.getWidgetByName('STARTTIME').setValue(self.STATIC.STARTTIME);
                                                    conditionPane.getWidgetByName('ENDTIME').setValue(self.STATIC.ENDTIME);
                                                    conditionPane.getWidgetByName('STARTTIME').setEndDate(self.STATIC.ENDTIME);
                                                    conditionPane.getWidgetByName('ENDTIME').setStartDate(self.STATIC.STARTTIME);
                                                }
                                            }
                                        }
                                    ]
                                ],
                                columnSize: [0.01, 0.1, 0.1, 0.45, 0.3],
                                rowSize: [24, 28, 24]
                            },
                            region: 'north',
                            height: 76
                        },
                        {
                            el: {
                                type: "fitablequickgrid",
                                widgetName: 'PROCESSGRID',
                                intervalColor: true,
                                page: true,
                                pageCount: 15,
                                isHeadShow: true,
                                async: {
                                    url: FR.servletURL + "?op=report_process&cmd=get_all_process",
                                    type: 'POST',
                                    data: {getAll: false}
                                },
                                columnsConfig: [
                                    {
                                        key: 'name',
                                        value: self.CONSTS.PROCESSCATE[self.STATIC.GETALL],
                                        width: 0.3,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            var $cell = $('<div/>').hover(
                                                function () {
                                                    $(this).addClass('cell-hover');
                                                },
                                                function () {
                                                    $(this).removeClass('cell-hover');
                                                }
                                            ).click(
                                                function () {
                                                    self.createNameCombo($(this));
                                                }
                                            );
                                            $('<span/>').text(self.CONSTS.PROCESSCATE[self.STATIC.GETALL]).appendTo($cell);
                                            $('<span class="rp-processmgr-arrow">').appendTo($cell);
                                            return $cell;
                                        }
                                    },
                                    {
                                        key: 'creatorName',
                                        value: FR.i18nText("Dec-Workflow_Creator"),
                                        width: 0.2,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'department',
                                        value: FR.i18nText("Dec-Workflow_Institution"),
                                        width: 0.2,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'createTime',
                                        value: FR.i18nText("Dec-Workflow_Create_Time"),
                                        width: 0.2,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        width: 0.05,
                                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                                            var $cell = $('<div/>');
                                            if (item.isSelfCreate) {
                                                if (item.isLocked) {
                                                    //自己的流程正在被运行则只能查看
                                                    $cell.addClass('fr-process-lock').click(function () {
                                                        FR.ajax({
                                                            url: FR.servletURL + "?op=report_process&cmd=get_process",
                                                            type: 'POST',
                                                            data: {processId: item.id},
                                                            success: function (res, status) {
                                                                var result = FR.jsonDecode(res);
                                                                var viewDialog = self.createViewDialog(result);
                                                                viewDialog.setVisible(true);
                                                            }
                                                        });
                                                    }).hover(function () {
                                                        $(this).addClass('fr-process-lock-hover');
                                                    }, function () {
                                                        $(this).removeClass('fr-process-lock-hover');
                                                    });
                                                } else {
                                                    //编辑流程
                                                    $cell.addClass('fr-process-edit').click(function () {
                                                        FR.ajax({
                                                            url: FR.servletURL + "?op=report_process&cmd=get_process",
                                                            type: 'POST',
                                                            data: {processId: item.id},
                                                            success: function (res, status) {
                                                                var result = FR.jsonDecode(res);
                                                                self.optDialog = self.createOptDialog(result);
                                                                self.optDialog.setVisible(true);
                                                            }
                                                        });
                                                    }).hover(function () {
                                                        $(this).addClass('fr-process-edit-hover');
                                                    }, function () {
                                                        $(this).removeClass('fr-process-edit-hover');
                                                    });
                                                }
                                            }
                                            return $cell;
                                        }
                                    },
                                    {
                                        width: 0.05,
                                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                                            var $cell = $('<div/>');
                                            var grid = this;
                                            if (item.isSelfCreate) {
                                                //删除流程
                                                $cell.addClass('fr-process-delete').click(function () {
                                                    FR.Msg.confirm(FR.i18nText('Dec-Workflow_Delete_Data'), FR.i18nText('Dec-Workflow_Sure_to_delete_process') + "?", function (result) {
                                                        if (result) {
                                                            FR.ajax({
                                                                url: FR.servletURL + "?op=report_process&cmd=remove_process",
                                                                type: 'POST',
                                                                data: {processId: item.id},
                                                                success: function (res, status) {
                                                                    if (!res.error) {
                                                                        grid.refresh();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                }).hover(function () {
                                                    $(this).addClass('fr-process-delete-hover');
                                                }, function () {
                                                    $(this).removeClass('fr-process-delete-hover');
                                                });
                                            } else {
                                                //别人的流程只能查看
                                                $cell.addClass('fr-process-view').click(function () {
                                                    FR.ajax({
                                                        url: FR.servletURL + "?op=report_process&cmd=get_process",
                                                        type: 'POST',
                                                        data: {processId: item.id},
                                                        success: function (res, status) {
                                                            var result = FR.jsonDecode(res);
                                                            var viewDialog = self.createViewDialog(result);
                                                            viewDialog.setVisible(true);
                                                        }
                                                    });
                                                }).hover(function () {
                                                    $(this).addClass('fr-process-view-hover');
                                                }, function () {
                                                    $(this).removeClass('fr-process-view-hover');
                                                });
                                            }
                                            return $cell;
                                        }
                                    }
                                ],
                                onAfterRowCreate: function (row, rowIdx, item) {
                                    if (!item.isSelfCreate) {
                                        row.addClass('hilit');
                                    }
                                },
                                onAsyncSuccess: function (res, status, items) {
                                    this.options.items = FR.jsonDecode(res);
                                    if (items && items.isRefresh) {
                                        FR.Msg.toast(FR.i18nText("Dec-Workflow_Refresh_Successfully"));
                                    }
                                }
                            },
                            region: 'center',
                            height: 700
                        }
                    ]
                }
            });
            this.processMgrPane.getWidgetByName('MAINLAYOUT').doLayout();
        },

        /**
         * 查看流程面板
         * @param process 流程数据
         * @returns {FR.Dialog}
         */
        createViewDialog: function (process) {
            this.STATIC.NODESIZE = 0;
            var $main = $('<div id="rp-newp-main"/>');
            var viewDialog = new FR.Dialog({
                resizeable: false,
                title: FR.i18nText("Dec-Workflow__View"),
                closable: true,
                doSize: true,
                width: 670,
                height: 450,
                autoScroll: true,
                contentHtml: $main
            });
            $('<div class="rp-newp-title-view"/>').text(process.name).appendTo($main);
            this.$ptree = $('<ul/>').appendTo($main);
            for (var i = 0, len = process.nodes.length; i < len; i++) {
                this.NODE.ISFIRSTNODE = i === 0;
                var node = process.nodes[i];
                this.addProcessNode(node, true, true);

            }
            return viewDialog;
        },
        /**
         * 新建和编辑流程面板
         * @param process 流程数据
         * @returns {FR.Dialog}
         */
        createOptDialog: function (process) {
            var self = this;
            this.STATIC.NODESIZE = 0;
            this.STATIC.USEMULTI = true;
            this.PROCESS.NAME = '';
            var $main = $('<div id="rp-newp-main"/>');
            var $editTitle = this.createTitleEditor();
            $editTitle.appendTo($main);
            this.$ptree = $('<ul/>').appendTo($main);
            var title = FR.i18nText("Dec-Workflow_Add_Process");
            if (process) {
                title = FR.i18nText("Dec-Workflow_Edit_Process");
                $editTitle.data('editor').setValue(process.name);
                $editTitle.data('editor').setVisible(false);
                $editTitle.data('name').text(process.name);
                this.PROCESS.NAME = process.name;
                for (var i = 0, len = process.nodes.length; i < len; i++) {
                    self.NODE.ISFIRSTNODE = i === 0;
                    var node = process.nodes[i];
                    var isMulti = self.isMultiNode(node);
                    this.addProcessNode(node, false, true, i, len);
                    if (i === len - 1) {
                        this.NODE.ISFIRSTNODE = true;
                    }
                }
            } else {
                self.NODE.ISFIRSTNODE = true;
                this.addProcessNode(null, false, true);
            }
            var optDialog = new FR.Dialog({
                confirm: true,
                resizeable: false,
                title: title,
                doSize: true,
                width: 670,
                height: 460,
                needSeparate: 8,
                btnsAlignment: 'right',
                autoScroll: true,
                closeAfterAction: false,
                onCancel: function () {
                    this.doClose();
                },
                onOK: function () {
                    var url = FR.servletURL + "?op=report_process&cmd=add_process";
                    var data = self.getAllData();
                    if (data.errorMsg) {
                        if (data.errorMsg != 'error') {
                            FR.Msg.alert(FR.i18nText("Dec-Workflow_Alert"), data.errorMsg);
                        }
                        return false;
                    }
                    if (process) {
                        url = FR.servletURL + "?op=report_process&cmd=update_process";
                        data.processId = process.id;
                    }
                    optDialog.loading(true);
                    FR.ajax({
                        url: url,
                        type: 'POST',
                        data: data,
                        complete: function (res, status) {
                            optDialog.loading(false);
                            if (status === "success") {
                                optDialog.doClose();
                                self.processMgrPane.getWidgetByName('PROCESSGRID').refresh();
                            } else {
                                FR.Msg.toast(FR.i18nText("Dec-Workflow_Fail"));
                            }
                        }
                    });
                },
                contentHtml: $main
            });
//            this.$ptree.sortable({
//                handle: 'div.rp-newp-node-name',
//                delay: 200,
//                onDrag: function ($item, position, _super, event) {
//                    position.left = 0;
//                    $item.css(position)
//                },
//                onDrop: function ($item, container, _super, event) {
//                    $item.removeClass("dragged").removeAttr("style");
//                    $("body").removeClass("dragging");
//                    self.$ptree.find('span.rp-newp-node-index').each(function (index, item) {
//                        $(item).text(index + 1);
//                    });
//                }
//            });
            return optDialog;
        },

        /**
         * 判断是否是多人多模版操作节点
         * @param node 流程节点
         * @returns {boolean} 返回是否是多人多模版操作节点
         */
        isMultiNode: function (node) {
            var isMulti = false;
            if (node.reportControl) {
                if (node.reportControl.length > 1) {
                    isMulti = true;
                } else if (node.reportControl[0].operator.split('-').length > 2) {
                    isMulti = true;
                }
            }
            return isMulti;
        },

        /**
         * 流程路径编辑面板
         * @returns {*|jQuery|HTMLElement}
         */
        createTitleEditor: function () {
            var self = this;
            var $title = $('<div class="rp-newp-title"/>');
            var $context = $('<div class="rp-newp-context"/>').appendTo($title);
            var $editor = new FR.TextEditor({
                fontSize: 16,
                height: 24,
                width: 300,
                verticalAlign: true,
                allowBlank: false,
                value: FR.i18nText("Dec-Workflow_Add_Process"),
                listeners: [
                    {
                        eventName: FR.Events.STOPEDIT,
                        action: function () {
                            var text = this.getValue();
                            if (!FR.isEmpty(text)) {
                                self.PROCESS.NAME = text;
                                $name.text(text).show();
                                this.setVisible(false);
                            }
                        }
                    }
                ]
            });
            this.$editor = $editor;
            var $name = $('<span class="rp-newp-name"/>').click(
                function () {
                    $(this).hide();
                    $editor.setVisible(true);
                    $editor.select();
                }
            ).appendTo($context);
            $editor.element.appendTo($context);
//            new FR.IconButton({
//                renderEl: $('<div/>').appendTo($title),
//                imgsrc: 'rp-newp-addicon-one',
//                width: 24,
//                height : 24,
//                title: FR.i18nText("RP_Add_SimpleNode"),
//                handler: function(){
//                    self.addProcessNode();
//                }
//            });
            this.multibtn = new FR.IconButton({
                renderEl: $('<div/>').appendTo($title),
                imgsrc: 'rp-newp-addicon-some',
                title: FR.i18nText("Dec-Workflow_Add_MultiNode"),
                width: 24,
                height: 24,
                handler: function () {
//                    if(self.STATIC.USEMULTI){
//                        return;
//                    }
//                    this.element.addClass('rp-newp-addicon-disable');
                    self.NODE.ISFIRSTNODE = false;
                    self.addProcessNode(null, false, true);
                    self.STATIC.USEMULTI = true;
                }
            });
            $title.data('editor', $editor).data('name', $name);
            return $title;
        },
        /**
         * 从控件中获取全部数据
         */
        getAllData: function () {
            var data = {};
            data.name = this.PROCESS.NAME;
            if (FR.isEmpty(this.PROCESS.NAME)) {
                data.errorMsg = FR.i18nText('Dec-Workflow__Name_Not_Null') + '!';
                return data;
            }
            data.nodes = [];
            var widgetNodes = this.$ptree.children('li');
            var parentOperator = '';
            for (var i = 0, len = widgetNodes.length; i < len; i++) {
                var isValid = true;
                var currentOperator = '';
                var wnode = widgetNodes.eq(i).data('widgets');
                isValid = wnode.name.checkValid() && isValid;
                var processNeedOffCpt = FR.Core.Plugin.ProcessNeedOffCpt.action;
                var dnode = {
                    'name': wnode.name.getValue(), //节点名
                    'description': wnode.description.getValue(), //节点描述
                    'needAllComplete': wnode.needAllOpts.getValue(),
                    'alertControl': {
                        timeNumber: wnode.time.getValue(),
                        timeType: wnode.unit.getValue(),
                        alertType: wnode.alert.getValue()
                    },
                    'needOfflineReport': processNeedOffCpt ? wnode.needOffCpt.getValue() : false
                };
                var nodeid = wnode.name.element.data('id');
                if (!FR.isEmpty(nodeid)) {
                    dnode.id = nodeid;
                }
                //权限列表
                dnode.authority = '';
                for (var k = 0; k < 11; k++) {
                    dnode.authority += (wnode.authorities[k].getValue() + 0);
                }
                //报表参数
                var optCtrls = widgetNodes.eq(i).find('div.rp-newp-cptopt');
                dnode.reportControl = [];
                for (var j = 0, size = optCtrls.length; j < size; j++) {
                    var cpt = optCtrls.eq(j).data('optnode');
                    isValid = cpt.reportPath.checkValid() && isValid;
                    var control = {
                        'reportPath': cpt.reportPath.getValue().join('/'),
                        'parameters': cpt.cptparas.getValue()
                    };
                    var optors = cpt.operators.getValue();
                    var optDb = cpt.dataBase.getValue();
                    if (!$.isArray(optors)) {
                        optors = [optors];
                    }
                    var type = cpt.roleType.getValue();
                    if (type == "3") {
                        if (i === 0) {
                            isValid = cpt.dataBase.checkValid() && cpt.currentRole.checkValid() && isValid;
                            currentOperator = cpt.role.getValue() + '##' + type + '##' + optDb + '##' + cpt.currentRole.getValue();
                            control['operator'] = parentOperator + ":" + currentOperator;
                        } else {
                            isValid = cpt.dataBase.checkValid() && cpt.currentRole.checkValid() && cpt.nextRole.checkValid() && isValid;
                            currentOperator = cpt.role.getValue() + '##' + type + '##' + optDb + '##' + cpt.currentRole.getValue() + '##' + cpt.nextRole.getValue();
                            control['operator'] = parentOperator + ":" + currentOperator;
                        }
                    } else {
                        isValid = cpt.operators.checkValid() && isValid;
                        currentOperator = cpt.role.getValue() + '##' + type + '##' + optors.join('##');
                        control['operator'] = parentOperator + ":" + currentOperator;
                    }
                    dnode.reportControl.push(control);
                }
                parentOperator = currentOperator;
                data.nodes.push(dnode);
                if (!isValid) {
                    data.errorMsg = 'error';
                    widgetNodes.eq(i).find('.rp-newp-node-invalid').show();
                } else {
                    widgetNodes.eq(i).find('.rp-newp-node-invalid').hide();
                }
            }
            return data;
        },

        /**
         * 加载数据到控件
         */
        popAllData: function (processnode, rpnode, addBtn, isMulti) {
            rpnode.name.setValue(processnode.name);
            rpnode.description.setValue(processnode.description);
            rpnode.needAllOpts.setValue(processnode.needAllComplete);
            var alertCtrls = FR.jsonDecode(processnode.alertControl);
            rpnode.time.setValue(alertCtrls.timeNumber);
            rpnode.unit.setValue(alertCtrls.timeType);
            rpnode.alert.setValue(alertCtrls.alertType);
            var processNeedOffCpt = FR.Core.Plugin.ProcessNeedOffCpt.action;
            if (processNeedOffCpt) {
                rpnode.needOffCpt.setValue(processnode.needOfflineReport);
            }
            for (var k = 0; k < 11; k++) {
                if (processnode.authority.charAt(k) == '1') {
                    rpnode.authorities[k].setValue(true);
                } else {
                    rpnode.authorities[k].setValue(false);
                }
            }
//            if(processnode.authority.charAt(0) == '1'){
//                rpnode.authorities[8].setEnable(false);
//                rpnode.authorities[9].setEnable(false);
//                rpnode.authorities[10].setEnable(false);
//            }else{
            rpnode.authorities[8].setEnable(false);
            rpnode.authorities[9].setEnable(false);
            rpnode.authorities[10].setEnable(false);
//            }
            for (var i = 0, len = processnode.reportControl.length; i < len; i++) {
                var reportCtrl = processnode.reportControl[i];
                var operator = reportCtrl.operator.split(':');
                var opts = operator[operator.length - 1].split('##');
                var optnode = this.addCptOptPane(addBtn.element, isMulti, rpnode);
                var reportPath = reportCtrl.reportPath;
                optnode.reportPath.setValue(reportPath);
                optnode.cptparas.refresh(reportCtrl.parameters);
                optnode.role.setValue(opts[0]);
                opts.splice(0, 1);
                var type = opts[0];
                optnode.roleType.setValue(opts[0]);
                opts.splice(0, 1);
                if (type == "3") {
                    this.STATIC.USEMULTI = true;
                    optnode.dataBase.setValue(opts[0]);
                    optnode.currentRole.setValue(opts[1]);
                    if (!this.NODE.ISFIRSTNODE) {
                        optnode.nextRole.setValue(opts[2]);
                    }
                } else {
                    if (isMulti) {
                        this.STATIC.USEMULTI = true;
//                    this.multibtn.element.addClass('rp-newp-addicon-disable');
                        optnode.operators.setValue(opts);
                    } else {
                        optnode.operators.setValue(opts[0]);
                    }
                }

            }
        },

        /**
         * 添加流程节点
         * @param processNode 流程节点数据
         * @param isView 是否是查看操作
         * @param isMulti 是否是多人多模版操作节点
         * @param isSlient 是否需要展开,默认展开
         */
        addProcessNode: function (processNode, isView, isMulti, isSlient, nodeLength) {
            var self = this;
            var $node = $('<li class="rp-newp-node"/>');
            var $title = $('<div class="rp-newp-node-name" onselectstart="return false;"/>').appendTo($node);
            var $index = $('<span class="rp-newp-node-index"/>').text(++this.STATIC.NODESIZE).appendTo($title);
//            if(isMulti){
//                $index.addClass('rp-newp-node-multi');
//            }
            $node.data('index', $index);
            var $content = this.NODE.ISFIRSTNODE ? $('<div class="rp-newp-node-content rp-newp-node-first"/>') : $('<div class="rp-newp-node-content"/>');
            $content.appendTo($node);
            //删除按钮
            var delBtn = $('<div class="rp-newp-node-del"/>').click(
                function (e) {
                    FR.Msg.confirm(FR.i18nText('Dec-Workflow_Delete_Data'), FR.i18nText('Dec-Workflow_sure_to_delete') + "?", function (result) {
                        if (result) {
                            $node.remove();
                            self.STATIC.NODESIZE--;
                            var nodeSize = self.STATIC.NODESIZE;
                            self.NODE.ISFIRSTNODE = nodeSize === 1;
//                            if(isMulti){
//                                self.STATIC.USEMULTI = false;
//                                self.multibtn.element.removeClass('rp-newp-addicon-disable');
//                            }
                            self.resortNode(self.$ptree);
                        }
                    });
                    e.stopEvent();
                }
            ).hide();
            if (nodeLength > 1) {
                delBtn.appendTo($title);
            } else {
                if (!self.NODE.ISFIRSTNODE) {
                    delBtn.appendTo($title);
                }
            }
            //错误提醒
            $('<div class="rp-newp-node-invalid"/>').attr('title', FR.i18nText("Dec-Workflow_Exist_Null_Node")).hide().appendTo($title);
            var $context = $('<div class="rp-newp-node-context"/>').appendTo($title);
            $title.click(function () {
                self.NODE.ISFIRSTNODE = $content.hasClass("rp-newp-node-first");
                if ($content.hasClass('sel')) {
                    $content.removeClass('sel').hide();
                    return;
                }
                var selnode = $('.sel', self.$ptree);
                if (selnode.length) {
                    selnode.removeClass('sel').hide();
                }
                $content.addClass('sel').show();
            });
            if (isView) {
                this.createViewNode($content, $index, $context, processNode);
            } else {
                $title.hover(function () {
                    if (self.STATIC.NODESIZE > 1) {
                        $(this).addClass('hover');
                        delBtn.show();
                    }
                }, function () {
                    if (self.STATIC.NODESIZE > 1) {
                        delBtn.hide();
                        $(this).removeClass('hover');
                    }
                });
                var widgets = this.createOptNode($content, $index, $context, processNode, isMulti);
                $node.data('widgets', widgets);
            }
            if (isSlient) {
                $content.hide();
            } else {
                var selnode = $('.sel', self.$ptree);
                if (selnode.length) {
                    selnode.removeClass('sel').hide();
                }
                $content.addClass('sel');
            }
            $node.appendTo(this.$ptree);
        },

        /**
         * 生成查看流程的节点
         * @param content 内容dom
         * @param index 位置索引dom
         * @param context 节点名称dom
         * @param processnode 节点数据
         */
        createViewNode: function (content, index, context, processnode) {
            if (!processnode) {
                return;
            }
            context.text(processnode.name);
            var createRow = function (label, editorEl, text) {
                var $row = $('<tr/>');
                $('<td class="rp-newp-label"/>').html(label).appendTo($row);
                $('<td/>').width(10).appendTo($row);
                if (editorEl) {
                    $('<td class="rp-newp-text"/>').append(editorEl).appendTo($row);
                } else {
                    $('<td class="rp-newp-text"/>').text(text).appendTo($row);
                }
                return $row;
            };
            var $table = $('<table cellspacing = "5" cellpadding = "0" class="rp-newp-nodetable"/>').appendTo(content);
            createRow(FR.i18nText("Dec-Workflow_Node_Name"), null, processnode.name).appendTo($table);
            createRow(FR.i18nText("Dec-Workflow_Node_Description"), null, processnode.description).appendTo($table);
            var authorities = processnode.authority;
            var authTasklist = $('<div/>');
            $('<span/>').html(FR.i18nText("Dec-Workflow_Task_List") + '&nbsp;').appendTo(authTasklist);
            for (var i = 0; i < 5; i++) {
                if (authorities.charAt(i) == '1') {
                    $('<span class="rp-newp-auth-sel"/>').text(this.CONSTS.AUTHS[i]).appendTo(authTasklist);
                }
            }
            createRow(FR.i18nText("Dec-Workflow_Authority_Edit"), authTasklist).appendTo($table);
            var authPagewrite = $('<div/>');
            $('<span/>').html(FR.i18nText("Dec-Workflow_Authority_Edit") + '&nbsp;').appendTo(authPagewrite);
            for (var i = 5; i < 11; i++) {
                if (authorities.charAt(i) == '1') {
                    $('<span class="rp-newp-auth-sel"/>').text(this.CONSTS.AUTHS[i]).appendTo(authPagewrite);
                }
            }
            createRow('&nbsp;', authPagewrite).appendTo($table);
            var isMulti = false;
            for (var i = 0, len = processnode.reportControl.length; i < len; i++) {
                var cptCtrl = $('<div class="rp-newp-cptopt"/>');
                var cptopttable = $('<table cellspacing = "5" cellpadding = "0" class="rp-newp-cptopt-table"/>').appendTo(cptCtrl);
                createRow(FR.i18nText("Dec-Workflow_Cpt_Name"), null, processnode.reportControl[i].reportPath).appendTo(cptopttable);
                createRow(FR.i18nText("Dec-Workflow_Operator"), null, processnode.reportControl[i].operatorName).appendTo(cptopttable);
                if (i === 0) {
                    createRow(FR.i18nText("Dec-Workflow_Cpt_Operation"), cptCtrl).appendTo($table);
                } else {
                    createRow('&nbsp;', cptCtrl).appendTo($table);
                }
                isMulti = (processnode.reportControl[i].operatorName.indexOf(',') !== -1);
            }
            isMulti = isMulti && (processnode.reportControl.length > 1);
            if (processnode.needAllComplete && isMulti) {
                var needAllOpts = new FR.CheckBox({
                    fontSize: 13,
                    text: FR.i18nText("Dec-Workflow_Pass_After_All_Operations"),
                    height: 20,
                    disabled: true,
                    selected: true
                });
                createRow('&nbsp;', needAllOpts.element).appendTo($table);
            }
            //是否需要发送离线报表
            if (processnode.needOfflineReport) {
                var needOffCpt = new FR.CheckBox({
                    fontSize: 13,
                    text: FR.i18nText("Dec-Workflow_Send_Offline_Report"),
                    height: 20,
                    disabled: true,
                    selected: true
                });
                createRow('&nbsp;', needOffCpt.element).appendTo($table);
            }
            var alertCtrls = FR.jsonDecode(processnode.alertControl);
            if (alertCtrls.alertType) {
                var alarm = $('<div/>');
                $('<span/>').text(FR.i18nText("Dec-Workflow_Reach_Node")).appendTo(alarm);
                $('<span class="rp-newp-alarm"/>').text(alertCtrls.timeNumber).appendTo(alarm);
                $('<span/>').text(this.CONSTS.UNIT[alertCtrls.timeType] + FR.i18nText("Dec-Workflow_After_Use")).appendTo(alarm);
                $('<span class="rp-newp-alarm"/>').text(this.CONSTS.MODE[alertCtrls.alertType]).appendTo(alarm);
                createRow(FR.i18nText("Dec-Workflow_Alert_Setting"), alarm).appendTo($table);
            }
        },
        /**
         * 生成新建和编辑流程的节点
         * @param content 内容dom
         * @param index 位置索引dom
         * @param context 节点名称dom
         * @param processnode 节点数据
         * @param isMulti 是否是多人员多模版操作节点
         * @returns {{}} 返回控件集合
         */
        createOptNode: function (content, index, context, processnode, isMulti) {
            var rpnode = {};
            var self = this;
            var createRow = function (label, editorEl) {
                var $row = $('<tr/>');
                $('<td class="rp-newp-label"/>').html(label).appendTo($row);
                $('<td/>').width(10).appendTo($row);
                $('<td class="rp-newp-text"/>').append(editorEl).appendTo($row);
                return $row;
            };
            var $table = $('<table cellspacing = "5" cellpadding = "0" class="rp-newp-nodetable"/>').appendTo(content);
            //节点名称
            rpnode.name = new FR.TextEditor({
                height: 20,
                width: 200,
                allowBlank: false,
                listeners: [
                    {
                        eventName: FR.Events.STOPEDIT,
                        action: function () {
                            context.text(this.getValue());
                        }
                    }
                ]
            });
            createRow(FR.i18nText("Dec-Workflow_Node_Name"), rpnode.name.element).appendTo($table);
            //节点描述
            rpnode.description = new FR.TextEditor({
                height: 20,
                width: 200
            });
            createRow(FR.i18nText("Dec-Workflow_Node_Description"), rpnode.description.element).appendTo($table);
            //权限编辑
            //  任务列表: 0-上报 1-审核 2-分发 3-关闭
            //  页面填报: 4-备注 5-任务流程查看 6-保存 7-通过 8-回退 9-上报
            rpnode.authorities = [];
            //任务列表
            var authTasklist = $('<div/>');
            $('<span/>').html(FR.i18nText("Dec-Workflow_Task_List") + '&nbsp;').appendTo(authTasklist);
            var tasklist = [
                {
                    text: this.CONSTS.AUTHS[0],
                    selected: true,
                    listeners: [
                        {
                            eventName: FR.Events.STATECHANGE,
                            action: function () {
                                if (this.isSelected()) {
                                    rpnode.authorities[1].setValue(false);
                                    rpnode.authorities[1].setEnable(true);
                                    rpnode.authorities[10].setValue(true);
                                    rpnode.authorities[10].setEnable(false);
                                    rpnode.authorities[8].setValue(false);
                                    rpnode.authorities[8].setEnable(false);
                                    rpnode.authorities[9].setValue(false);
                                    rpnode.authorities[9].setEnable(false);
                                } else {
                                    this.setValue(true);
                                }
                            }
                        }
                    ]
                },
                {
                    text: this.CONSTS.AUTHS[1],
                    listeners: [
                        {
                            eventName: FR.Events.STATECHANGE,
                            action: function () {
                                if (this.isSelected()) {
                                    rpnode.authorities[0].setValue(false);
                                    rpnode.authorities[0].setEnable(true);
                                    rpnode.authorities[8].setValue(true);
                                    rpnode.authorities[8].setEnable(false);
                                    rpnode.authorities[9].setValue(true);
                                    rpnode.authorities[9].setEnable(false);
                                    rpnode.authorities[10].setValue(false);
                                    rpnode.authorities[10].setEnable(false);
                                } else {
                                    this.setValue(true);
                                }
                            }
                        }
                    ]
                },
                {
                    text: this.CONSTS.AUTHS[2]
                },
                {
                    text: this.CONSTS.AUTHS[3]
                },
                {
                    text: this.CONSTS.AUTHS[4],
                    selected: true
                }
            ];
            for (var i = 0, len = tasklist.length; i < len; i++) {
                var topt = new FR.AuthSelectBtn(tasklist[i]);
                rpnode.authorities.push(topt);
                topt.element.appendTo(authTasklist);
            }
            createRow(FR.i18nText("Dec-Workflow_Authority_Edit"), authTasklist).appendTo($table);
            //页面填报
            var authPagewrite = $('<div/>');
            $('<span/>').html(FR.i18nText("Dec-Workflow_Page_Write") + '&nbsp;').appendTo(authPagewrite);
            var writeopts = [
                {
                    text: this.CONSTS.AUTHS[5],
                    selected: true
                },
                {
                    text: this.CONSTS.AUTHS[6],
                    selected: true
                },
                {
                    text: this.CONSTS.AUTHS[7],
                    selected: true
                },
                {
                    text: this.CONSTS.AUTHS[8],
                    disabled: true
                },
                {
                    text: this.CONSTS.AUTHS[9],
                    disabled: true
                },
                {
                    selected: true,
                    disabled: true,
                    text: this.CONSTS.AUTHS[10]
                }
            ];
            for (var i = 0, len = writeopts.length; i < len; i++) {
                var wopt = new FR.AuthSelectBtn(writeopts[i]);
                rpnode.authorities.push(wopt);
                wopt.element.appendTo(authPagewrite);
            }
            createRow('&nbsp;', authPagewrite).appendTo($table);
            //添加模版操作按钮
            var addBtn = new FR.IconButton({
                text: '+',
                height: 25,
                width: 540,
                imgsrc: 'fr-process-addcpt',
                handler: function () {
                    self.addCptOptPane(this.element, isMulti, rpnode);
                }
            });
            createRow(FR.i18nText("Dec-Workflow_Cpt_Operation"), addBtn.element).appendTo($table);

            //是否所有人操作完后流转
            rpnode.needAllOpts = new FR.CheckBox({
                fontSize: 13,
                text: FR.i18nText("Dec-Workflow_Pass_After_All_Operations"),
                height: 20,
                disabled: false,
                selected: true
            });

            createRow('', rpnode.needAllOpts.element).appendTo($table);

            if (!isMulti) {
                rpnode.needAllOpts.element.hide();
                addBtn.element.hide();
            }
            addBtn.element.hide();
            var alarm = $('<div class="rp-newp-alarm"/>');
            $('<div/>').html(FR.i18nText("Dec-Workflow_Reach_Node") + '&nbsp;').appendTo(alarm);
            //时间计数
            rpnode.time = new FR.NumberEditor({
                height: 20,
                width: 40,
                allowDecimals: false,
                allowNegative: false,
                value: 0,
                allowBlank: false
            });
            rpnode.time.element.appendTo(alarm);
            $('<div/>').html('&nbsp;').appendTo(alarm);
            //时间计量单位
            rpnode.unit = new FR.ComboBoxEditor({
                height: 20, width: 60, allowBlank: false, value: 0, items: [
                    {value: 0, text: this.CONSTS.UNIT[0]},
                    {value: 1, text: this.CONSTS.UNIT[1]},
                    {value: 2, text: this.CONSTS.UNIT[2]},
                    {value: 3, text: this.CONSTS.UNIT[3]},
                    {value: 4, text: this.CONSTS.UNIT[4]}
                ]
            });
            rpnode.unit.element.appendTo(alarm);
            $('<div/>').html('&nbsp;' + FR.i18nText("Dec-Workflow_After_Use") + '&nbsp;').appendTo(alarm);
            //是否需要发送离线报表
            var processNeedOffCpt = FR.Core.Plugin.ProcessNeedOffCpt.action;
            if (processNeedOffCpt) {
                rpnode.needOffCpt = new FR.CheckBox({
                    fontSize: 13,
                    text: FR.i18nText("Dec-Workflow_Send_Offline_Report"),
                    height: 20
                });
                createRow('&nbsp;', rpnode.needOffCpt.element).appendTo($table);
            }
            //提醒方式
            var alertItems = [];
            var defaultValue = [0];
            if (FRProcess.smsAvailable === "true") {
                defaultValue = [3];
                alertItems.push({
                    value: 3,
                    text: this.CONSTS.MODE[3]
                });
            }
            alertItems = _.union(alertItems, [{
                value: 0,
                text: this.CONSTS.MODE[0]
            },
                {
                    value: 1,
                    text: this.CONSTS.MODE[1]
                }]);

            rpnode.alert = new FR.CheckBoxEditor({
                height: 20,
                width: 120,
                value: defaultValue,
                returnArray: true,
                items: alertItems
            });
            rpnode.alert.element.appendTo(alarm);
            if (FRProcess.smsAvailable !== "true") {
                $('<div class="fr-processmgr-to"/>').html('&nbsp;' + FR.i18nText("Dec-Workflow_Remind_SMS_Tip") + '&nbsp;').appendTo(alarm);
            }
            $('<div/>').html('&nbsp;' + FR.i18nText("Dec-Workflow_Inform_Appending") + '&nbsp;').appendTo(alarm);
            alarm.children('div').css('float', 'left');
            createRow(FR.i18nText("Dec-Workflow_Alert_Setting"), alarm).appendTo($table);
            //加载全部数据到控件
            if (processnode) {
                context.text(processnode.name);
                rpnode.name.element.data('id', processnode.id);
                this.popAllData(processnode, rpnode, addBtn, isMulti);
            } else {
                this.addCptOptPane(addBtn.element, isMulti, rpnode);
            }
            return rpnode;
        },

        /**
         * 添加模版操作面板
         * @param btndom 添加按钮所在dom
         * @param isMulti 是否是多人多模版操作
         */
        addCptOptPane: function (btndom, isMulti, rpnode) {
            var self = this, optnode = {};
            var $pane = $('<div class="rp-newp-cptopt"/>');
            var optDelBtn = new FR.IconButton({
                renderEl: $('<div/>').appendTo($pane),
                invisible: true,
                imgsrc: 'rp-newp-cptopt-del',
                handler: function () {
                    FR.Msg.confirm(FR.i18nText('Dec-Workflow_Delete_Data'), FR.i18nText('Dec-Workflow_sure_to_delete') + "?", function (result) {
                        if (result) {
                            $pane.remove();
                        }
                    });
                }
            });
            if (isMulti) {
                $pane.hover(
                    function () {
                        if ($(this).prev('.rp-newp-cptopt').length || $(this).next('.rp-newp-cptopt').length) {
                            optDelBtn.setVisible(true);
                        }
                    }, function () {
                        optDelBtn.setVisible(false);
                    });
            }
            var $table = $('<table cellspacing = "5" cellpadding = "0" class="rp-newp-cptopt-table"/>').appendTo($pane);
            var createRow = function (label, editorEl) {
                var $row = $('<tr/>');
                $('<td class="rp-newp-label"/>').html(label).appendTo($row);
                $('<td/>').width(10).appendTo($row);
                $('<td class="rp-newp-text"/>').append(editorEl).appendTo($row);
                return $row;
            };
            //模版名字选择
            optnode.reportPath = new FR.TreeComboBoxEditor({
                allowBlank: false,
                height: 20,
                width: 420,
                selectLeafOnly: true,
                returnArray: true,
                returnFullPath: true,
                widgetUrl: FR.servletURL + "?op=report_process&cmd=get_user_reports&form=true&file=cpt"
            });
            createRow(FR.i18nText("Dec-Workflow_Cpt_Name"), optnode.reportPath.element).appendTo($table);
            //模版参数
            optnode.cptparas = new FR.QuickGrid({
                intervalColor: true,
                isHeadShow: true,
                items: [],
                columnsConfig: [
                    {
                        key: 'name',
                        value: FR.i18nText('Dec-Workflow_WF-Name'),
                        width: 150,
                        onCellClick: function (rowIdx, colIdx, item, colCfg, $cell) {
                            self.text2widegt(150, item, 'name', $cell);
                        }
                    },
                    {
                        key: 'type',
                        value: FR.i18nText("Dec-Workflow_FS_Report_Type"),
                        width: 100,
                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                            var $combo = new FR.ComboBoxEditor({
                                width: 100,
                                height: 25,
                                directEdit: false,
                                allowBlank: false,
                                value: item.type,
                                items: [
                                    {value: "String", text: FR.i18nText('Dec-Workflow_Parameter-String')},
                                    {value: "Integer", text: FR.i18nText('Dec-Workflow_Parameter-Integer')},
                                    {value: "Double", text: FR.i18nText('Dec-Workflow_Parameter-Double')},
                                    {value: "Boolean", text: FR.i18nText('Dec-Workflow_Parameter-Boolean')},
                                    {value: "Formula", text: FR.i18nText('Dec-Workflow_Parameter-Formula')}
                                ],
                                listeners: [
                                    {
                                        eventName: FR.Events.STOPEDIT,
                                        action: function () {
                                            item.type = this.getValue()
                                        }
                                    }
                                ]
                            });
                            return $combo.element;
                        }
                    },
                    {
                        key: 'value',
                        value: FR.i18nText("Dec-Workflow_Value"),
                        width: 100,
                        onCellClick: function (rowIdx, colIdx, item, colCfg, $cell) {
                            self.text2widegt(100, item, 'value', $cell);
                        }
                    },
                    {
                        width: 24,
                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                        },
                        onHeadCellCreate: function (colIdx, colCfg) {
                            return $('<div class="rp-process-refresh"/>')
                                .hover(function () {
                                    $(this).addClass('rp-process-refresh-hover');
                                }, function () {
                                    $(this).removeClass('rp-process-refresh-hover').removeClass('rp-process-refresh-click');
                                })
                                .mousedown(function () {
                                    $(this).addClass('rp-process-refresh-click');
                                })
                                .mouseup(function () {
                                    $(this).removeClass('rp-process-refresh-click');
                                    FR.ajax({
                                        url: FR.servletURL + "?op=report_process&cmd=get_report_paras",
                                        type: 'POST',
                                        asyn: false,
                                        data: {reportPath: optnode.reportPath.getValue().join('/')},
                                        complete: function (res, status) {
                                            if (!res.responseText) {
                                                return;
                                            }
                                            var parameters;
                                            try {
                                                parameters = FR.jsonDecode(res.responseText);
                                            } catch (e) {
                                                FR.Msg.toast("Parameter parse error!");
                                                return;
                                            }
                                            optnode.cptparas.refresh(parameters);
                                        }
                                    });
                                });
                        }
                    },
                    {
                        width: 24,
                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                            var self = this;
                            var $cell = $('<div/>').addClass('fr-process-delete').click(
                                function () {
                                    FR.Msg.confirm(FR.i18nText('Dec-Workflow_Delete_Data'), FR.i18nText('Dec-Workflow_sure_to_delete') + "?",
                                        function (result) {
                                            if (result) {
                                                self.options.items.splice(rowIdx, 1);
                                                self.refresh();
                                            }
                                        });

                                }
                            ).hover(function () {
                                $(this).addClass('fr-process-delete-hover');
                            }, function () {
                                $(this).removeClass('fr-process-delete-hover');
                            });
                            return $cell;
                        },
                        onHeadCellCreate: function (colIdx, colCfg) {
                            var self = this;
                            return $('<div class="rp-process-blue-add"/>')
                                .hover(function () {
                                    $(this).addClass('rp-process-blue-add-hover');
                                }, function () {
                                    $(this).removeClass('rp-process-blue-add-hover').removeClass('rp-process-blue-add-click');
                                })
                                .mousedown(function () {
                                    $(this).addClass('rp-process-blue-add-click');
                                })
                                .mouseup(function () {
                                        $(this).removeClass('rp-process-blue-add-click');
                                        self.addRowData({
                                            name: '',
                                            type: 'String',
                                            value: ''
                                        });
                                    }
                                );
                        }
                    }
                ]
            });
            createRow(FR.i18nText("Dec-Workflow_Parameter_Setting"), optnode.cptparas.element).appendTo($table);
            var operatorType = $('<div/>'), operators = $('<div/>'), types = $('<div/>');
            var realOperator = $('<div/>'), dataBase = $('<div/>'), currentRole = $('<div/>'), nextRole = $('<div/>');
            //模版操作人员身份
            optnode.role = FR.createWidget({
                type: 'combo',
                height: 20,
                width: 80,
                items: [
                    {value: 1, text: this.CONSTS.IDEN[1]},
                    {value: 2, text: this.CONSTS.IDEN[2]}
                ],
                value: 1,
                allowBlank: false,
                directEdit: false,
                listeners: [
                    {
                        eventName: FR.Events.AFTEREDIT,
                        action: function () {
                            var item = [];
                            var initValue;
                            if (this.getValue() == '2') {
                                item = [
                                    {value: 2, text: self.CONSTS.SOURCE[2]},
                                    {
                                        value: 3,
                                        text: self.NODE.ISFIRSTNODE ? self.CONSTS.SOURCE[4] : self.CONSTS.SOURCE[5]
                                    }
                                ];
                                initValue = 2;
                                rpnode.needAllOpts.setSelected(false);
                                rpnode.needAllOpts.disable();
                            } else {
                                item = [
                                    {value: 1, text: self.CONSTS.SOURCE[1]},
                                    {
                                        value: 3,
                                        text: self.NODE.ISFIRSTNODE ? self.CONSTS.SOURCE[3] : self.CONSTS.SOURCE[5]
                                    }
                                ];
                                initValue = 1;
                                rpnode.needAllOpts.enable();
                            }
                            optnode.roleType.rebuild(item);
                            optnode.roleType.setValue(initValue);

                        }
                    }
                ]
            });
            optnode.role.element.appendTo(operatorType);
            $('<div/>').html('&nbsp').appendTo(operatorType).css("width", "10px");

            optnode.roleType = FR.createWidget({
                type: 'combo',
                renderEl: types,
                height: 20,
                width: 192,
                items: [
                    {value: 1, text: this.CONSTS.SOURCE[1]},
                    {value: 3, text: this.NODE.ISFIRSTNODE ? this.CONSTS.SOURCE[3] : this.CONSTS.SOURCE[5]}
                ],
                value: 1,
                allowBlank: false,
                directEdit: false,
                listeners: [
                    {
                        eventName: FR.Events.AFTEREDIT,
                        action: function () {
                            var url = FR.servletURL + "?op=report_process&cmd=";
                            if (this.getValue() != '3') {
                                if (this.getValue() == '1') {
                                    url += "get_all_user";
                                } else if (this.getValue() == '2') {
                                    url += "get_all_role";
                                }
                                url += "&isCheckBox=" + isMulti;
                                optnode.operators.reset();
                                optnode.operators.rebuild({widgetUrl: url});
                                optnode.operators.setVisible(true);
                                optnode.dataBase.setVisible(false);
                                optnode.currentRole.setVisible(false);
                                optnode.nextRole.setVisible(false);
                            } else {
                                optnode.operators.setVisible(false);
                                optnode.dataBase.setVisible(true);
                                if (self.NODE.ISFIRSTNODE) {
                                    optnode.currentRole.setWaterMark(self.CONSTS.WATERMARK[1]);
                                    optnode.nextRole.setVisible(false);
                                } else {
                                    optnode.currentRole.setWaterMark(self.CONSTS.WATERMARK[2]);
                                    optnode.nextRole.setVisible(true);
                                }
                                optnode.currentRole.setVisible(true);
                            }
                        }
                    }
                ]
            });

            optnode.operators = FR.createWidget({
                type: 'combocheckbox',
                renderEl: operators,
                allowBlank: false,
                height: 20,
                width: 280,
                widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user&isCheckBox=" + isMulti,
                returnArray: true
            });

            optnode.dataBase = FR.createWidget({
                type: 'combo',
                renderEl: dataBase,
                height: 20,
                width: 210,
                allowBlank: false,
                widgetUrl: FR.servletURL + "?op=report_process&cmd=get_servertabledata",
                directEdit: false,
                watermark: FR.i18nText("Dec-Workflow_DS-TableData"),
                listeners: [
                    {
                        eventName: FR.Events.AFTEREDIT,
                        action: function () {
                            var ds = this.getValue();
                            self.rebuildDSWidgets(ds, optnode);
                        }
                    }
                ]
            });
            optnode.currentRole = FR.createWidget({
                type: 'combo',
                renderEl: currentRole,
                allowBlank: false,
                height: 20,
                width: 86,
                watermark: this.NODE.ISFIRSTNODE ? this.CONSTS.WATERMARK[1] : this.CONSTS.WATERMARK[2],
                items: []
            });

            optnode.nextRole = FR.createWidget({
                type: 'combo',
                renderEl: nextRole,
                allowBlank: false,
                height: 20,
                width: 86,
                watermark: this.CONSTS.WATERMARK[1],
                items: []
            });

            types.appendTo(operatorType);
            operators.appendTo(realOperator);
            dataBase.appendTo(realOperator);
            $('<div/>').html('&nbsp').appendTo(realOperator).css("width", "10px");
            currentRole.appendTo(realOperator);
            $('<div/>').html('&nbsp').appendTo(realOperator).css("width", "10px");
            nextRole.appendTo(realOperator);
            optnode.dataBase.setVisible(false);
            optnode.currentRole.setVisible(false);
            optnode.nextRole.setVisible(false);
            operatorType.children('div').css({'float': 'left'});
            realOperator.children('div').css({'float': 'left'});
            createRow(FR.i18nText("Dec-Workflow_Operator"), operatorType).appendTo($table);
            createRow("", realOperator).appendTo($table);
            $pane.data('optOperator', realOperator).insertBefore(btndom);
            $pane.data('optnode', optnode).insertBefore(btndom);
            return optnode;
        },

        rebuildDSWidgets: function (ds, optnode) {
            var cols = [];
            var self = this;
            if (!FR.isEmpty(ds)) {
                cols = self.getColsByTableDataName(ds);
            }
            var widget = [];
            if (self.NODE.ISFIRSTNODE) {
                widget = [optnode.currentRole];
            } else {
                widget = [optnode.currentRole, optnode.nextRole];
            }
            for (var i = 0; i < widget.length; i++) {
                widget[i].rebuild(cols);
            }
        },
        getColsByTableDataName: function (tabledataname) {
            var cols = [];
            FR.ajax({
                url: FR.servletURL + '?op=report_process&cmd=get_tabledatacolname',
                type: 'POST',
                async: false,
                data: {
                    name: tabledataname
                },
                complete: function (res, status) {
                    if (status == 'success') {
                        cols = FR.jsonDecode(res.responseText);
                    }
                }
            });
            return cols;
        },
        /**
         * 参数转换成可编辑控件
         * @param width 控件宽度
         * @param item 数据
         * @param key 字段
         * @param $cell 单元格dom
         */
        text2widegt: function (width, item, key, $cell) {
            if (!$cell.data('editing')) {
                $cell.hide();
                var editor = new FR.TextEditor({
                    renderEl: $('<div/>').insertBefore($cell),
                    width: width,
                    height: 25,
                    value: item[key],
                    listeners: [
                        {
                            eventName: FR.Events.STOPEDIT,
                            action: function () {
                                var val = this.getValue();
                                item[key] = val;
                                FR.html($cell, val).show();
                                this.destroy();
                                $cell.data('editing', false);
                            }
                        }
                    ]
                });
                $cell.data('editing', true);
                editor.select();
            }
        },
        /**
         * 重新排序流程内的所有节点
         * @param root 父容器dom
         */
        resortNode: function (root) {
            var nodes = root.children('li');
            for (var i = 0, len = nodes.length; i < len; i++) {
                nodes.eq(i).data('index').text(i + 1);
            }
        },

        createSortCell: function (itemcfg) {
            var grid = this.processMgrPane.getWidgetByName('PROCESSGRID'), self = this;
            var $cell = $('<div/>').hover(
                function () {
                    $(this).addClass('cell-hover');
                },
                function () {
                    $(this).removeClass('cell-hover');
                }
            ).click(
                function () {
                    var data = {
                        detailSearch: self.STATIC.DETAILSEARCH,
                        getAll: self.STATIC.GETALL === 1,
                        processName: self.STATIC.PROCESSNAME,
                        userId: self.STATIC.USERID,
                        departmentId: self.STATIC.DEPARTMENTID,
                        startTime: self.STATIC.STARTTIME,
                        endTime: self.STATIC.ENDTIME,
                        sortBy: itemcfg.key,
                        desc: self.STATIC.SORT
                    };
                    self.STATIC.SORT = !self.STATIC.SORT;
                    if (self.STATIC.FILTER != null) {
                        data.filter = self.STATIC.FILTER;
                    }
                    FR.ajax({
                        url: FR.servletURL + '?op=report_process&cmd=get_all_process',
                        type: 'POST',
                        data: data,
                        complete: function (res, status) {
                            if (status == 'success') {
                                var items = FR.jsonDecode(res.responseText);
                                grid.refresh(items);
                            }
                        }
                    });
                }
            ).append($('<span/>').text(itemcfg.value));
            return $cell;
        },

        createNameCombo: function ($sel) {
            var self = this;
            var $combo = $('<div class="fr-combo-list rp-processmgr-namecombo"/>');
            $('<div/>').text(FR.i18nText("Dec-Workflow__Created_By_Me")).appendTo($combo);
            $('<div/>').text(FR.i18nText("Dec-Workflow_AllProcesses")).data('data', {getAll: true}).appendTo($combo);
            $combo.children('div').hover(
                function () {
                    $(this).addClass('rp-processmgr-name-hover');
                },
                function () {
                    $(this).removeClass('rp-processmgr-name-hover');
                }
            ).click(
                function () {
                    var data = $(this).data('data');
                    if (data) {
                        self.STATIC.GETALL = 1;
                    } else {
                        self.STATIC.GETALL = 0;
                    }
                    self.processMgrPane.getWidgetByName('PROCESSGRID').options.async.data = data;
                    self.processMgrPane.getWidgetByName('PROCESSGRID').refresh();
                    $combo.remove();
                    $(document).unbind('mousedown.namecombo');
                }
            );
            $combo.css({
                position: 'absolute',
                left: $sel.offset().left,
                top: $sel.offset().top + $sel.height(),
                'z-Index': FR.widget.opts.zIndex++
            }).appendTo($('body'));
            $(document).bind('mousedown.namecombo', function (e) {
                var target = e.target;
                var res = $(target).closest('.fr-combo-list');
                if (res.length === 0) {
                    $combo.remove();
                    $(document).unbind('mousedown.namecombo');
                }
            });
        },

        /**
         * 预加载数据
         */
        preLoadData: function () {
            var self = this;
            FR.ajax({
                url: FR.servletURL + "?op=fs_main&cmd=user_getinfo",
                async: false,
                type: 'POST',
                success: function (res, status) {
                    self.CONSTS.CURRENTUSER = FR.jsonDecode(res);
                }
            });

        }
    };
    FR.preloadImgs([FR.servletURL + '?op=resource&resource=/com/fr/decision/workflow/web/images/process_icons.png']);
    ProcessMgr.init();
});