/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: Sean
 * Date: 14-3-10
 * Time: 上午12:45
 */
$(function () {
    FR.Taskmgr = {
        STATIC: {
            GETALL: 0,
            DETAILSEARCH: false,
            TASKNAME: null,
            USERID: null,
            DEPARTMENTID: null,
            STARTTIME: null,
            ENDTIME: null,
            FILTER: null,
            SORT: true
        },
        CONSTS: {
            TASKCATE: {
                0: FR.i18nText("Dec-Workflow_Task_Created_By_Me"),
                1: FR.i18nText("Dec-Workflow_All_Tasks")
            }
        },
        init: function () {
            var self = this;
            this.preLoadData();
            this.taskMgrPane = new FR.Panel({
                renderEl: $('#rp-taskmgr'),
                doSize: true,
                fit: true,
                contentWidget: {
                    type: 'border',
                    scrollable: true,
                    widgetName: 'MAINLAYOUT',
                    items: [
                        {
                            el: {
                                type: 'tablelayout',
                                scrollable: false,
                                widgetName: 'TOPTOOL',
                                items: [
                                    [
                                        null,
                                        null,
                                        null,
                                        {el: {type: 'label'}},
                                        null
                                    ],
                                    [
                                        {el: {type: 'label'}},
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                text: FR.i18nText("Dec-Workflow_add"),
                                                height: 24,
                                                width: 70,
                                                baseClass: 'rp-taskmgr-add',
                                                handler: function () {
                                                    var optDialog = self.createOptDialog();
                                                    optDialog.setVisible(true);
                                                    optDialog.getWidgetByName('MAINTABLE').doLayout();
                                                }
                                            }
                                        },
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                text: FR.i18nText("Dec-Workflow_Refresh"),
                                                height: 24,
                                                width: 70,
                                                baseClass: 'rp-taskmgr-refresh',
                                                handler: function () {
                                                    self.taskMgrPane.getWidgetByName('TASKGRID').refresh({isRefresh: true});
                                                }
                                            }
                                        },
                                        {
                                            el: {type: 'label'}
                                        },
                                        {
                                            el: {
                                                type: 'search',
                                                width: 244,
                                                advanced: true,
                                                onSearch: function () {
                                                    var val = this.getValue();
                                                    var data = {getAll: false, filter: val};
                                                    if (self.STATIC.GETALL === 1) {
                                                        data.getAll = true;
                                                    }
                                                    FR.ajax({
                                                        url: FR.servletURL + "?op=report_process&cmd=get_all_task",
                                                        type: 'POST',
                                                        data: data,
                                                        complete: function (res, status) {
                                                            if (status == 'success') {
                                                                self.STATIC.FILTER = val;
                                                                self.STATIC.DETAILSEARCH = false;
                                                                var items = FR.jsonDecode(res.responseText);
                                                                self.taskMgrPane.getWidgetByName('TASKGRID').refresh(items);
                                                            }
                                                        }
                                                    });
                                                },
                                                onTrigger: function () {
                                                    var $advance = $('<div class="fr-taskmgr-advance"/>');
                                                    $advance.css({
                                                        position: 'absolute',
                                                        left: this.element.offset().left,
                                                        width: 300,
                                                        height: 200,
                                                        top: this.element.offset().top + this.element.height(),
                                                        'z-Index': FR.widget.opts.zIndex++
                                                    }).appendTo('body');
                                                    var rh = 20, fill = 155, sizeLong = 135, sizeMedium = 115,
                                                        sizeShort = 95;
                                                    var conditionPane = new FR.ConfirmPane({
                                                        renderEl: $advance,
                                                        doSize: true,
                                                        width4OK: 60,
                                                        height4OK: 30,
                                                        width4Cancel: Math.max(FR.i18nTextWidth("Dec-Basic_Cancel") + 30, 60),
                                                        height4Cancel: 30,
                                                        text4OK: FR.i18nText("Dec-Workflow_Search"),
                                                        onOK: function () {
                                                            var tasktype = this.getWidgetByName('TASKTYPE').getValue();
                                                            var taskname = this.getWidgetByName('TASKNAME').getValue();
                                                            var creator = this.getWidgetByName('CREATOR').getValue();
                                                            var department = this.getWidgetByName('DEPARTMENT').getValue();
                                                            var starttime = this.getWidgetByName('STARTTIME').getValue();
                                                            var endtime = this.getWidgetByName('ENDTIME').getValue();
                                                            var getall = false;
                                                            if (tasktype == '1') {
                                                                getall = true;
                                                            }
                                                            FR.ajax({
                                                                url: FR.servletURL + "?op=report_process&cmd=get_all_task",
                                                                type: 'POST',
                                                                data: {
                                                                    detailSearch: true,
                                                                    getAll: getall,
                                                                    taskName: taskname,
                                                                    userId: creator,
                                                                    departmentId: department,
                                                                    startTime: starttime,
                                                                    endTime: endtime
                                                                },
                                                                complete: function (res, status) {
                                                                    if (status == 'success') {
                                                                        self.STATIC.DETAILSEARCH = true;
                                                                        if (!FR.isEmpty(tasktype)) {
                                                                            self.STATIC.GETALL = tasktype;
                                                                        }
                                                                        self.STATIC.TASKNAME = taskname;
                                                                        self.STATIC.USERID = creator;
                                                                        self.STATIC.DEPARTMENTID = department;
                                                                        self.STATIC.STARTTIME = starttime;
                                                                        self.STATIC.ENDTIME = endtime;
                                                                        var items = FR.jsonDecode(res.responseText);
                                                                        self.taskMgrPane.getWidgetByName('TASKGRID').refresh(items);
                                                                    }
                                                                }
                                                            });
                                                        },
                                                        contentWidget: {
                                                            type: 'tablelayout',
                                                            columnSize: [10, 60, 5, 205],
                                                            rowSize: [5, rh, rh, rh, rh, rh],
                                                            vgap: 8,
                                                            items: [
                                                                [
                                                                    {el: $('<div/>')},
                                                                    null,
                                                                    null,
                                                                    null,
                                                                    null
                                                                ],
                                                                [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Task_Type")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetName: 'TASKTYPE',
                                                                            items: [
                                                                                {
                                                                                    value: 0,
                                                                                    text: FR.i18nText('Dec-Workflow_Task_Created_By_Me')
                                                                                },
                                                                                {
                                                                                    value: 1,
                                                                                    text: FR.i18nText('Dec-Workflow_All_Tasks')
                                                                                }
                                                                            ],
                                                                            width: fill,
                                                                            listeners: [{
                                                                                eventName: FR.Events.AFTEREDIT,
                                                                                action: function () {
                                                                                    var c = conditionPane.getWidgetByName('CREATOR');
                                                                                    if (this.getValue() === 0) {
                                                                                        var user = self.CONSTS.CURRENTUSER;
                                                                                        if (user) {
                                                                                            if (user.id < 0) {
                                                                                                c.setText(user.username || user.text);
                                                                                            } else {
                                                                                                c.setValue(user.username);
                                                                                            }
                                                                                            c.setEnable(false);
                                                                                        }
                                                                                    } else {
                                                                                        c.setValue("");
                                                                                        c.setEnable(true);
                                                                                    }
                                                                                }
                                                                            }]
                                                                        }
                                                                    }

                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_TaskName")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'text',
                                                                            widgetName: 'TASKNAME',
                                                                            width: sizeLong
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Creator")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetName: 'CREATOR',
                                                                            widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user",
                                                                            width: sizeMedium
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Institution")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'combo',
                                                                            widgetName: 'DEPARTMENT',
                                                                            widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_depart",
                                                                            width: sizeMedium
                                                                        }
                                                                    }
                                                                ], [
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'label',
                                                                            value: FR.i18nText("Dec-Workflow_Create_Time")
                                                                        }
                                                                    },
                                                                    null,
                                                                    {
                                                                        el: {
                                                                            type: 'border', items: [
                                                                                {
                                                                                    region: 'west',
                                                                                    el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'STARTTIME',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('ENDTIME');
                                                                                                c.setStartDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    },
                                                                                    width: sizeShort
                                                                                },
                                                                                {
                                                                                    region: 'center',
                                                                                    el: $('<div class="fr-taskmgr-to"/>').html('&minus;')
                                                                                },
                                                                                {
                                                                                    region: 'east',
                                                                                    el: {
                                                                                        type: 'datetime',
                                                                                        format: 'yyyy-MM-dd',
                                                                                        widgetName: 'ENDTIME',
                                                                                        listeners: [{
                                                                                            eventName: FR.Events.AFTEREDIT,
                                                                                            action: function () {
                                                                                                var c = conditionPane.getWidgetByName('STARTTIME');
                                                                                                c.setEndDate(this.getValue());
                                                                                            }
                                                                                        }]
                                                                                    },
                                                                                    width: sizeShort
                                                                                }
                                                                            ]
                                                                        }
                                                                    }
                                                                ]
                                                            ]
                                                        }
                                                    });
                                                    $(document).bind('mousedown.advance', function (e) {
                                                        var target = e.target;
                                                        var res = $(target).isChildAndSelfOf('.fr-taskmgr-advance')
                                                            || $(target).isChildAndSelfOf('.view-container');
                                                        if (!res) {
                                                            $advance.remove();
                                                            $(document).unbind('mousedown.advance');
                                                        }
                                                    });
                                                    conditionPane.getWidgetByName('TASKTYPE').setValue(self.STATIC.GETALL);
                                                    conditionPane.getWidgetByName('TASKNAME').setValue(self.STATIC.TASKNAME);
                                                    if (self.STATIC.USERID !== null) {
                                                        conditionPane.getWidgetByName('CREATOR').setValue(self.STATIC.USERID);
                                                    }
                                                    conditionPane.getWidgetByName('DEPARTMENT').setValue(self.STATIC.DEPARTMENTID);
                                                    conditionPane.getWidgetByName('STARTTIME').setValue(self.STATIC.STARTTIME);
                                                    conditionPane.getWidgetByName('ENDTIME').setValue(self.STATIC.ENDTIME);
                                                    conditionPane.getWidgetByName('STARTTIME').setEndDate(self.STATIC.ENDTIME);
                                                    conditionPane.getWidgetByName('ENDTIME').setStartDate(self.STATIC.STARTTIME);
                                                }
                                            }
                                        }
                                    ]
                                ],
                                columnSize: [0.01, 0.1, 0.1, 0.45, 0.3],
                                rowSize: [24, 28, 24]
                            },
                            region: 'north',
                            height: 76
                        },
                        {
                            el: {
                                type: "fitablequickgrid",
                                widgetName: 'TASKGRID',
                                page: true,
                                pageCount: 15,
                                intervalColor: true,
                                isHeadShow: true,
                                async: {
                                    url: FR.servletURL + '?op=report_process&cmd=get_all_task',
                                    type: 'POST',
                                    data: {getAll: false}
                                },
                                columnsConfig: [
                                    {
                                        key: 'name',
                                        value: self.CONSTS.TASKCATE[self.STATIC.GETALL],
                                        width: 0.3,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            var $cell = $('<div/>').hover(
                                                function () {
                                                    $(this).addClass('cell-hover');
                                                },
                                                function () {
                                                    $(this).removeClass('cell-hover');
                                                }
                                            ).click(
                                                function () {
                                                    self.createNameCombo($(this));
                                                }
                                            );
                                            $('<span/>').text(self.CONSTS.TASKCATE[self.STATIC.GETALL]).appendTo($cell);
                                            $('<span class="rp-taskmgr-arrow">').appendTo($cell);
                                            return $cell;
                                        }
                                    },
                                    {
                                        key: 'creatorName',
                                        value: FR.i18nText("Dec-Workflow_Creator"),
                                        width: 0.2,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'department',
                                        value: FR.i18nText("Dec-Workflow_Institution"),
                                        width: 0.2,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        key: 'createTime',
                                        value: FR.i18nText("Dec-Workflow_Create_Time"),
                                        width: 0.2,
                                        onHeadCellCreate: function (colIdx, itemcfg) {
                                            return self.createSortCell(itemcfg);
                                        }
                                    },
                                    {
                                        width: 0.05,
                                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                                            var $cell = $('<div/>');
                                            if (item.isSelfCreate) {
                                                if (item.isLocked) {
                                                    $cell.addClass('fr-process-lock').click(function () {
                                                        FR.ajax({
                                                            url: FR.servletURL + "?op=report_process&cmd=get_task",
                                                            type: 'POST',
                                                            data: {taskId: item.id},
                                                            success: function (res, status) {
                                                                var result = FR.jsonDecode(res);
                                                                var optDialog = self.createOptDialog(result, true);
                                                                optDialog.setVisible(true);
                                                                optDialog.getWidgetByName('MAINTABLE').doLayout();
                                                            }
                                                        });
                                                    }).hover(function () {
                                                        $(this).addClass('fr-process-lock-hover');
                                                    }, function () {
                                                        $(this).removeClass('fr-process-lock-hover');
                                                    });
                                                } else {
                                                    $cell.addClass('fr-process-edit').click(function () {
                                                        FR.ajax({
                                                            url: FR.servletURL + "?op=report_process&cmd=get_task",
                                                            type: 'POST',
                                                            data: {taskId: item.id},
                                                            success: function (res, status) {
                                                                var result = FR.jsonDecode(res);
                                                                var optDialog = self.createOptDialog(result);
                                                                optDialog.setVisible(true);
                                                                optDialog.getWidgetByName('MAINTABLE').doLayout();
                                                            }
                                                        });
                                                    }).hover(function () {
                                                        $(this).addClass('fr-process-edit-hover');
                                                    }, function () {
                                                        $(this).removeClass('fr-process-edit-hover');
                                                    });
                                                }
                                            }
                                            return $cell;
                                        }
                                    },
                                    {
                                        width: 0.05,
                                        onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                                            var $cell = $('<div/>');
                                            var grid = this;
                                            if (item.isSelfCreate) {
                                                $cell.addClass('fr-process-delete').click(function () {
                                                    FR.Msg.confirm(FR.i18nText('Dec-Workflow_Delete_Data'), FR.i18nText('Dec-Workflow_sure_to_delete') + "?", function (result) {
                                                        if (result) {
                                                            FR.ajax({
                                                                url: FR.servletURL + "?op=report_process&cmd=remove_task",
                                                                type: 'POST',
                                                                data: {taskId: item.id},
                                                                success: function (res, status) {
                                                                    if (!res.error) {
                                                                        grid.refresh();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    });
                                                }).hover(function () {
                                                    $(this).addClass('fr-process-delete-hover');
                                                }, function () {
                                                    $(this).removeClass('fr-process-delete-hover');
                                                });
                                            } else {
                                                $cell.addClass('fr-process-view').click(function () {
                                                    FR.ajax({
                                                        url: FR.servletURL + "?op=report_process&cmd=get_task",
                                                        type: 'POST',
                                                        data: {taskId: item.id},
                                                        success: function (res, status) {
                                                            var result = FR.jsonDecode(res);
                                                            var viewDialog = self.createOptDialog(result, true);
                                                            viewDialog.setVisible(true);
                                                            viewDialog.getWidgetByName('MAINTABLE').doLayout();
                                                        }
                                                    });
                                                }).hover(function () {
                                                    $(this).addClass('fr-process-view-hover');
                                                }, function () {
                                                    $(this).removeClass('fr-process-view-hover');
                                                });
                                            }
                                            return $cell;
                                        }
                                    }
                                ],
                                onAfterRowCreate: function (row, rowIdx, item) {
                                    if (!item.isSelfCreate) {
                                        row.addClass('hilit');
                                    }
                                },
                                onAsyncSuccess: function (res, status, items) {
                                    this.options.items = FR.jsonDecode(res);
                                    if (items && items.isRefresh) {
                                        FR.Msg.toast(FR.i18nText("Dec-Workflow_Refresh_Successfully"));
                                    }
                                }
                            },
                            region: 'center',
                            height: 700
                        }
                    ]
                }
            });
            this.taskMgrPane.getWidgetByName('MAINLAYOUT').doLayout();
        },

        /**
         * 创建任务操作面板
         * @param tasknode 初始数据
         * @param isView 是否是查看
         * @param pId 分发操作的父任务的id
         * @returns {FR.Dialog}
         */
        createOptDialog: function (tasknode, isView, pId) {
            var self = this;
            var monthItems = [];
            for (var i = 1; i < 32; i++) {
                var item = {
                    text: i + FR.i18nText('Dec-Workflow_SimgleNumber'),
                    value: i
                };
                monthItems.push(item);
            }
            // 选择每月最后一天执行
            var lastDayItem = {
                text: FR.i18nText("Dec-Generic-Last_Day"),
                value: 32
            };
            monthItems.push(lastDayItem);
            var dialogcfg = {
                doSize: true,
                width: 570,
                height: 400,
                resizeable: false,
                title: FR.i18nText("Dec-Workflow_View_Task"),
                contentWidget: {
                    type: 'tablelayout',
                    widgetName: 'MAINTABLE',
                    scrolly: true,
                    vgap: 5,
                    columnSize: [15, Math.max(60, FR.i18nTextWidth("Dec-Workflow__Select", 6.5) + 8), 25, 470],
                    rowSize: [5, 21, 21,
                        21, 21,
                        21, 21, 21, 155, 21, 125, 21,
                        21, 21, 21, 21,
                        21, 21, 100, 130, 50, 21, 21, 58,
                        21,
                        5],
                    items: [
                        [
                            {el: $('<div/>')},
                            null,
                            null,
                            null
                        ],
                        //任务名称
                        [
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow_TaskName"))},
                            null,
                            {
                                el: {
                                    type: 'horizontal',
                                    alignment: 'left',
                                    rowSize: [21],
                                    hgap: 0,
                                    vgap: 0,
                                    items: [
                                        {
                                            el: {
                                                type: 'text',
                                                allowBlank: false,
                                                widgetName: 'TASKNAME',
                                                disabled: isView,
                                                watermark: FR.i18nText("Dec-Workflow_Support_Formula")
                                            }, width: 300
                                        },
                                        {
                                            el: {
                                                type: 'checkbox',
                                                width: 170,
                                                widgetName: 'TASKNAMECALCULATEONCE',
                                                text: FR.i18nText("Dec-Workflow_TaskName_CalculateOneTime"),
                                                selected: false,
                                                disabled: false
                                            }
                                        }
                                    ]
                                }
                            }
                        ],
                        //流程选择
                        [
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow__Select"))},
                            null,
                            {
                                el: {
                                    type: 'combo',
                                    allowBlank: false,
                                    widgetName: 'PROCESSCOMBO',
                                    disabled: isView,
                                    widgetUrl: FR.servletURL + "?op=report_process&cmd=get_process_items",
                                    customData: false,
                                    width: 300,
                                    listeners: [
                                        {
                                            eventName: FR.Events.AFTEREDIT,
                                            action: function () {
                                                var val = this.getValue();
                                                var res = self.getRelatedUsers(val);
                                                optDialog.getWidgetByName("ERECEIVERCOMBO").setValue(res.emailUser);
                                                optDialog.getWidgetByName('SRECEIVERCOMBO').setValue(res.sysUser);
                                                optDialog.getWidgetByName('SMSRECEIVERCOMBO').setValue(res.smsUser);
                                                self.isStraightLine = self.isStraightLineProcess(val);
                                                optDialog.getWidgetByName('MAINTABLE').setRowVisible(24, self.isStraightLine);

                                            }
                                        }
                                    ]
                                }
                            }
                        ],
                        //提醒方式
                        [
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Alert_Mode"))},
                            null,
                            {
                                el: this.createEditLabel(
                                    function () {
                                        if (optDialog.getWidgetByName('SMSCHECK').getValue()) {
                                            optDialog.getWidgetByName("MAINTABLE").setRowVisible(6, true);
                                        } else {
                                            optDialog.getWidgetByName("MAINTABLE").setRowVisible(6, false);
                                        }
                                        if (optDialog.getWidgetByName('ECHECK').getValue()) {
                                            optDialog.getWidgetByName("MAINTABLE").setRowVisible(8, true);
                                        } else {
                                            optDialog.getWidgetByName("MAINTABLE").setRowVisible(8, false);
                                        }
                                        if (optDialog.getWidgetByName('SCHECK').getValue()) {
                                            optDialog.getWidgetByName("MAINTABLE").setRowVisible(10, true);
                                        } else {
                                            optDialog.getWidgetByName("MAINTABLE").setRowVisible(10, false);
                                        }
                                        optDialog.getWidgetByName("MAINTABLE").setRowVisible([3, 4], false);
                                        optDialog.getWidgetByName("MAINTABLE").setRowVisible([5, 7, 9, 11], true);
                                        optDialog.getWidgetByName('MAINTABLE').doLayout();
                                    }, isView)
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow_None"), "ALERTLABEL")}
                        ],
                        //短信提醒
                        [
                            null,
                            {el: this.createBoldLabel(FR.i18nText("Dec-Workflow_Alert_Mode"), undefined, true)},
                            null,
                            {
                                el: {
                                    type: 'checkbox',
                                    text: FR.i18nText("Dec-Basic_SMS_Reminder"),
                                    fontSize: 13,
                                    widgetName: 'SMSCHECK',
                                    disabled: FRProcess.smsAvailable === "false",
                                    listeners: [
                                        {
                                            eventName: FR.Events.STATECHANGE,
                                            action: function () {
                                                if (this.isSelected()) {
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(6, true);
                                                } else {
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(6, false);
                                                }
                                                optDialog.getWidgetByName('MAINTABLE').doLayout();
                                            }
                                        }
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'tablelayout',
                                    columnSize: [21, 50, 'fill'],
                                    rowSize: [21],
                                    vgap: 5,
                                    items: [
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Receiver"), 'SMSRECEIVERLABEL')},
                                            {
                                                el: {
                                                    type: 'combocheckbox',
                                                    widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user&isCheckBox=true",
                                                    widgetName: 'SMSRECEIVERCOMBO',
                                                    returnArray: true,
                                                    width: 210
                                                }
                                            }
                                        ]
                                    ]
                                }
                            }
                        ],
                        //邮件提醒
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'checkbox',
                                    text: FR.i18nText("Dec-Workflow_Email"),
                                    widgetName: 'ECHECK',
                                    fontSize: 13,
                                    listeners: [
                                        {
                                            eventName: FR.Events.STATECHANGE,
                                            action: function () {
                                                if (this.isSelected()) {
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(8, true);
                                                    optDialog.getWidgetByName('TITLETEXT').setValue('');
                                                    optDialog.getWidgetByName('ECONTENTTEXT').setValue('');
                                                } else {
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(8, false);
                                                    optDialog.getWidgetByName('SCONTENTTEXT').setValue('');
                                                }
                                                optDialog.getWidgetByName('MAINTABLE').doLayout();
                                            }
                                        }
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'tablelayout',
                                    columnSize: [20, 50, 'fill'],
                                    rowSize: [21, 21, 95],
                                    vgap: 5,
                                    items: [
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Receiver"), 'ERECEIVERLABEL')},
                                            {
                                                el: {
                                                    type: 'combocheckbox',
                                                    widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user&isCheckBox=true&withEmail=true",
                                                    widgetName: 'ERECEIVERCOMBO',
                                                    returnArray: true,
                                                    width: 210
                                                }
                                            }
                                        ],
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Title"), 'TITLELABEL')},
                                            {el: {type: 'text', widgetName: 'TITLETEXT', width: 195}}
                                        ],
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Content"), 'ECONTENTLABEL')},
                                            {
                                                el: {
                                                    type: 'text',
                                                    widgetName: 'ECONTENTTEXT',
                                                    multiline: true,
                                                    width: 355
                                                }
                                            }
                                        ]
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'checkbox',
                                    text: FR.i18nText("Dec-Workflow_System_Message"),
                                    fontSize: 13,
                                    widgetName: 'SCHECK',
                                    listeners: [
                                        {
                                            eventName: FR.Events.STATECHANGE,
                                            action: function () {
                                                if (this.isSelected()) {
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(10, true);
                                                } else {
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(10, false);
                                                }
                                                optDialog.getWidgetByName('MAINTABLE').doLayout();
                                            }
                                        }
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'tablelayout',
                                    columnSize: [21, 50, 'fill'],
                                    rowSize: [21, 95],
                                    vgap: 5,
                                    items: [
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Receiver"), 'SRECEIVERLABEL')},
                                            {
                                                el: {
                                                    type: 'combocheckbox',
                                                    widgetUrl: FR.servletURL + "?op=report_process&cmd=get_all_user&isCheckBox=true",
                                                    widgetName: 'SRECEIVERCOMBO',
                                                    returnArray: true,
                                                    width: 210
                                                }
                                            }
                                        ],
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Content"), 'SCONTENTLABEL')},
                                            {
                                                el: {
                                                    type: 'text',
                                                    widgetName: 'SCONTENTTEXT',
                                                    multiline: true,
                                                    width: 355
                                                }
                                            }
                                        ]
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'horizontal',
                                    vgap: 0,
                                    hgap: 10,
                                    alignment: 'left',
                                    items: [
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                imgsrc: 'rp-taskmgr-okbtn',
                                                text: FR.i18nText("Dec-Workflow_OK"),
                                                handler: function () {
                                                    var rc = self.getRemindCtrl(optDialog);
                                                    self.refreshRemindCtrl(optDialog, rc);
                                                    optDialog.rc = rc;
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([5, 6, 7, 8, 9, 10, 11], false);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([3, 4], true);
                                                    optDialog.getWidgetByName("MAINTABLE").doLayout();
                                                }
                                            }, width: FR.i18nTextWidth("Dec-Workflow_OK") + 30
                                        },
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                imgsrc: 'rp-taskmgr-cancelbtn',
                                                text: FR.i18nText("Dec-Workflow_Cancel"),
                                                handler: function () {
                                                    self.popRemindCtrl(optDialog, optDialog.rc);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([5, 6, 7, 8, 9, 10, 11], false);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([3, 4], true);
                                                    optDialog.getWidgetByName("MAINTABLE").doLayout();
                                                }
                                            }, width: FR.i18nTextWidth("Dec-Workflow_Cancel") + 30
                                        }
                                    ]
                                }
                            }
                        ],
                        //限时填报
                        [
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Timed_Write"))},
                            null,
                            {
                                el: this.createEditLabel(
                                    function () {
                                        optDialog.getWidgetByName('MAINTABLE').setRowVisible([12, 13], false);
                                        optDialog.getWidgetByName('MAINTABLE').setRowVisible([14, 15], true);
                                        optDialog.getWidgetByName('MAINTABLE').doLayout();
                                    }, isView)
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Unlimited"), "DEADLINELABEL")}
                        ],
                        [
                            null,
                            {el: this.createBoldLabel(FR.i18nText("Dec-Workflow_Timed_Write"))},
                            null,
                            {
                                el: {
                                    type: 'horizontal',
                                    vgap: 0,
                                    hgap: 5,
                                    alignment: 'left',
                                    items: [
                                        {
                                            el: this.createLabel(FR.i18nText('Dec-Workflow_FS_Task_Start'), null, true),
                                            width: FR.i18nTextWidth('Dec-Workflow_FS_Task_Start', 6.5) > 65 ?
                                                (FR.i18nTextWidth('Dec-Workflow_FS_Task_Start', 6.5) + 10) : 70
                                        },
                                        {
                                            el: {
                                                type: 'number',
                                                widgetName: 'DEADLINE',
                                                allowBlank: true,
                                                allowDecimals: false,
                                                allowNegative: false
                                            }, width: 50
                                        },
                                        {
                                            el: {
                                                type: 'combo',
                                                widgetName: 'DEADLINETYPE',
                                                allowBlank: false,
                                                directEdit: false,
                                                fontSize: 13,
                                                value: 'd',
                                                items: [
                                                    {text: FR.i18nText('Dec-Workflow_Day'), value: 'd'},
                                                    {text: FR.i18nText('Dec-Workflow_Week'), value: 'w'},
                                                    {text: FR.i18nText('Dec-Workflow_Month_Count'), value: 'm'}
                                                ]
                                            }, width: 40
                                        },
                                        {
                                            el: this.createLabel(FR.i18nText('Dec-Workflow_FS_Task_End'), null, true),
                                            width: 50
                                        }
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'horizontal',
                                    vgap: 0,
                                    hgap: 10,
                                    alignment: 'left',
                                    items: [
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                imgsrc: 'rp-taskmgr-okbtn',
                                                text: FR.i18nText("Dec-Workflow_OK"),
                                                handler: function () {
                                                    var dl = self.getDeadLineDate(optDialog);
                                                    var dt = self.getDeadLineType(optDialog);
                                                    self.refreshDeadline(optDialog, dl, dt);
                                                    optDialog.dld = dl;
                                                    optDialog.dt = dl === '' ? 'd' : dt;
                                                    self.popDeadLineDate(optDialog, optDialog.dld);
                                                    self.popDeadLineType(optDialog, optDialog.dt);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([12, 13], true);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([14, 15], false);
                                                    optDialog.getWidgetByName("MAINTABLE").doLayout();
                                                }
                                            }, width: FR.i18nTextWidth("Dec-Workflow_OK") + 30
                                        },
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                imgsrc: 'rp-taskmgr-cancelbtn',
                                                text: FR.i18nText("Dec-Workflow_Cancel"),
                                                handler: function () {
                                                    self.popDeadLineDate(optDialog, optDialog.dld);
                                                    self.popDeadLineType(optDialog, optDialog.dt ? optDialog.dt : 'd');
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([12, 13], true);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([14, 15], false);
                                                    optDialog.getWidgetByName("MAINTABLE").doLayout();
                                                }
                                            }, width: FR.i18nTextWidth("Dec-Workflow_Cancel") + 30
                                        }
                                    ]
                                }
                            }
                        ],
                        //定时下发
                        [
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Timing_Issue"))},
                            null,
                            {
                                el: this.createEditLabel(
                                    function () {
                                        if (optDialog.getWidgetByName('EOTRADIO').isSelected()) {
                                            optDialog.getWidgetByName('MAINTABLE').setRowVisible([19, 20], false);
                                            optDialog.getWidgetByName('MAINTABLE').setRowVisible(21, true);
                                        } else {
                                            optDialog.getWidgetByName('MAINTABLE').setRowVisible([19, 20], true);
                                            optDialog.getWidgetByName('MAINTABLE').setRowVisible(21, false);
                                        }
                                        optDialog.getWidgetByName('MAINTABLE').setRowVisible([16, 17, 23], false);
                                        optDialog.getWidgetByName('MAINTABLE').setRowVisible([18, 22], true);
                                        optDialog.getWidgetByName('MAINTABLE').doLayout();
                                    }, isView)
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {el: this.createLabel(FR.i18nText("Dec-Workflow_None"))}
                        ],
                        [
                            null,
                            {el: this.createBoldLabel(FR.i18nText("Dec-Workflow_Timing_Issue"))},
                            null,
                            {
                                el: {
                                    type: 'tablelayout',
                                    rowSize: [21, 21, 21, 21],
                                    vgap: 5,
                                    columnSize: [
                                        60,
                                        10,
                                        FR.i18nTextWidth('Dec-Workflow_RestartAfterSet', 6.5) > 100 ?
                                            (FR.i18nTextWidth('Dec-Workflow_RestartAfterSet', 6.5) + 30) : 130,
                                        170
                                    ],
                                    items: [
                                        [
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_FS_Start_Time"))},
                                            null,
                                            {
                                                el: {
                                                    type: 'radio',
                                                    widgetName: 'RASRADIO',
                                                    text: FR.i18nText('Dec-Workflow_RestartAfterSet'),
                                                    selected: true,
                                                    fontSize: 13,
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STATECHANGE,
                                                            action: function () {
                                                                if (!optDialog.getWidgetByName('SSTRADIO').isSelected()) {
                                                                    self.setRadioSelected(this);
                                                                }
                                                                if (this.isSelected()) {
                                                                    optDialog.getWidgetByName('STDATETIME').setEnable(false);
                                                                    optDialog.getWidgetByName('STDATETIME').setValue(null);
                                                                    optDialog.getWidgetByName('SSTRADIO').setSelected(false);
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                            null
                                        ],
                                        [
                                            null,
                                            null,
                                            {
                                                el: {
                                                    type: 'radio',
                                                    widgetName: 'SSTRADIO',
                                                    text: FR.i18nText('Dec-Workflow_SetStartTime'),
                                                    fontSize: 13,
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STATECHANGE,
                                                            action: function () {
                                                                if (!optDialog.getWidgetByName('RASRADIO').isSelected()) {
                                                                    self.setRadioSelected(this);
                                                                }
                                                                if (this.isSelected()) {
                                                                    optDialog.getWidgetByName('RASRADIO').setSelected(false);
                                                                    optDialog.getWidgetByName('STDATETIME').setEnable(true);
                                                                    optDialog.getWidgetByName('STDATETIME').setValue(FR.date2Str(new Date(new Date().setMinutes(new Date().getMinutes() + 2)), "yyyy-MM-dd HH:mm:ss"));
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                el: {
                                                    type: "datetime",
                                                    widgetName: 'STDATETIME',
                                                    width: 166,
                                                    disable: false,
                                                    directEdit: true,
                                                    format: "yyyy-MM-dd HH:mm:ss",
                                                    disabled: true,
                                                    startDate: FR.date2Str(new Date(), "yyyy-MM-dd HH:mm:ss"),
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STOPEDIT,
                                                            action: function () {
                                                                var startDate = new Date(optDialog.getWidgetByName('STDATETIME').getValue().replace(/-/g, '/')).getTime();
                                                                if (startDate < new Date().getTime()) {
                                                                    FR.Msg.alert(FR.i18nText("Dec-Workflow_Alert"), FR.i18nText("Dec-Error_Schedule_Start_Time_Now"));
                                                                    optDialog.getWidgetByName('STDATETIME').setValue(FR.date2Str(new Date(new Date().setMinutes(new Date().getMinutes() + 2)), "yyyy-MM-dd HH:mm:ss"));
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        ],
                                        [
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_ExecuteFrequency"))},
                                            null,
                                            {
                                                el: {
                                                    type: 'radio',
                                                    widgetName: 'EOTRADIO',
                                                    text: FR.i18nText('Dec-Workflow_ExecuteOneTime'),
                                                    selected: true,
                                                    fontSize: 13,
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STATECHANGE,
                                                            action: function () {
                                                                if (!optDialog.getWidgetByName('FSRADIO').isSelected()) {
                                                                    self.setRadioSelected(this);
                                                                }
                                                                if (this.isSelected()) {
                                                                    optDialog.getWidgetByName('FSRADIO').setSelected(false);
                                                                    optDialog.getWidgetByName('EDDATETIME').setValue(null);
                                                                    optDialog.getWidgetByName('MAINTABLE').setRowVisible(21, true);
                                                                    optDialog.getWidgetByName('MAINTABLE').setRowVisible([19, 20], false);
                                                                    optDialog.getWidgetByName('MAINTABLE').doLayout();
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                            null
                                        ],
                                        [
                                            null,
                                            null,
                                            {
                                                el: {
                                                    type: 'radio',
                                                    widgetName: 'FSRADIO',
                                                    text: FR.i18nText('Dec-Workflow_FrequencySet'),
                                                    fontSize: 13,
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STATECHANGE,
                                                            action: function () {
                                                                if (!optDialog.getWidgetByName('EOTRADIO').isSelected()) {
                                                                    self.setRadioSelected(this);
                                                                }
                                                                if (this.isSelected()) {
                                                                    optDialog.getWidgetByName('EOTRADIO').setSelected(false);
                                                                    optDialog.getWidgetByName('MAINTABLE').setRowVisible(21, false);
                                                                    optDialog.getWidgetByName('MAINTABLE').setRowVisible([19, 20], true);
                                                                    optDialog.getWidgetByName('MAINTABLE').doLayout();
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                            null
                                        ]
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'tablelayout',
                                    rowSize: [21, 21, 21, 21, 21],
                                    columnSize: [130, 60, 10, 170],
                                    vgap: 5,
                                    items: [
                                        //明细频率设置
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Execute_Time"))},
                                            null,
                                            {
                                                el: {
                                                    type: 'horizontal',
                                                    alignment: 'left',
                                                    hgap: 10,
                                                    vgap: 0,
                                                    items: [
                                                        {
                                                            el: {
                                                                type: "number",
                                                                widgetName: 'HOURNUMBER',
                                                                allowDecimals: false,
                                                                allowNegative: false,
                                                                value: 12
                                                            }, width: 50
                                                        },
                                                        {
                                                            el: this.createLabel(FR.i18nText("Dec-Workflow_Sche-Hour")),
                                                            width: 20
                                                        },
                                                        {
                                                            el: {
                                                                type: "number",
                                                                widgetName: 'MINUTENUMBER',
                                                                allowDecimals: false,
                                                                allowNegative: false,
                                                                value: 0
                                                            }, width: 50
                                                        },
                                                        {
                                                            el: this.createLabel(FR.i18nText("Dec-Workflow_Sche-Minute")),
                                                            width: 20
                                                        }
                                                    ]
                                                }
                                            }
                                        ],
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Execute_Day"))},
                                            null,
                                            {
                                                el: {
                                                    type: 'radio',
                                                    text: FR.i18nText("Dec-Workflow_Everyday"),
                                                    widgetName: 'DAYRADIO',
                                                    fontSize: 13,
                                                    selected: true,
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STATECHANGE,
                                                            action: function () {
                                                                if (!optDialog.getWidgetByName('WEEKRADIO').isSelected() && !optDialog.getWidgetByName('MONTHRADIO').isSelected()) {
                                                                    self.setRadioSelected(this);
                                                                }
                                                                if (this.isSelected()) {
                                                                    optDialog.getWidgetByName('WEEKRADIO').setSelected(false);
                                                                    optDialog.getWidgetByName('MONTHRADIO').setSelected(false);
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        ],
                                        [
                                            null,
                                            null,
                                            null,
                                            {
                                                el: {
                                                    type: 'horizontal',
                                                    alignment: 'left',
                                                    hgap: 10,
                                                    vgap: 0,
                                                    items: [
                                                        {
                                                            el: {
                                                                type: "radio",
                                                                text: FR.i18nText("Dec-Workflow_Schedule-Weekly"),
                                                                fontSize: 13,
                                                                widgetName: 'WEEKRADIO',
                                                                listeners: [
                                                                    {
                                                                        eventName: FR.Events.STATECHANGE,
                                                                        action: function () {
                                                                            if (!optDialog.getWidgetByName('DAYRADIO').isSelected() && !optDialog.getWidgetByName('MONTHRADIO').isSelected()) {
                                                                                self.setRadioSelected(this);
                                                                            }
                                                                            if (this.isSelected()) {
                                                                                optDialog.getWidgetByName('DAYRADIO').setSelected(false);
                                                                                optDialog.getWidgetByName('MONTHRADIO').setSelected(false);
                                                                                optDialog.getWidgetByName('WEEKCOMBO').setEnable(true);
                                                                            } else {
                                                                                optDialog.getWidgetByName('WEEKCOMBO').setEnable(false);
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }, width: 50
                                                        },
                                                        {
                                                            el: {
                                                                type: "combocheckbox",
                                                                widgetName: 'WEEKCOMBO',
                                                                disabled: true,
                                                                items: [
                                                                    {
                                                                        text: FR.i18nText('Dec-Workflow_Mon'),
                                                                        value: 2
                                                                    },
                                                                    {
                                                                        text: FR.i18nText('Dec-Workflow_Tue'),
                                                                        value: 3
                                                                    },
                                                                    {
                                                                        text: FR.i18nText('Dec-Workflow_Wed'),
                                                                        value: 4
                                                                    },
                                                                    {
                                                                        text: FR.i18nText('Dec-Workflow_Thu'),
                                                                        value: 5
                                                                    },
                                                                    {
                                                                        text: FR.i18nText('Dec-Workflow_Fri'),
                                                                        value: 6
                                                                    },
                                                                    {
                                                                        text: FR.i18nText('Dec-Workflow_Sat'),
                                                                        value: 7
                                                                    },
                                                                    {
                                                                        text: FR.i18nText('Dec-Workflow_Sun'),
                                                                        value: 1
                                                                    }
                                                                ]
                                                            }, width: 110
                                                        }
                                                    ]
                                                }
                                            }
                                        ],
                                        [
                                            null,
                                            null,
                                            null,
                                            {
                                                el: {
                                                    type: 'horizontal',
                                                    alignment: 'left',
                                                    hgap: 10,
                                                    vgap: 0,
                                                    items: [
                                                        {
                                                            el: {
                                                                type: "radio",
                                                                text: FR.i18nText("Dec-Workflow_Schedule-Monthly"),
                                                                fontSize: 13,
                                                                widgetName: 'MONTHRADIO',
                                                                listeners: [
                                                                    {
                                                                        eventName: FR.Events.STATECHANGE,
                                                                        action: function () {
                                                                            if (!optDialog.getWidgetByName('DAYRADIO').isSelected() && !optDialog.getWidgetByName('WEEKRADIO').isSelected()) {
                                                                                self.setRadioSelected(this);
                                                                            }
                                                                            if (this.isSelected()) {
                                                                                optDialog.getWidgetByName('DAYRADIO').setSelected(false);
                                                                                optDialog.getWidgetByName('WEEKRADIO').setSelected(false);
                                                                                optDialog.getWidgetByName('MONTHCOMBO').setEnable(true);
                                                                            } else {
                                                                                optDialog.getWidgetByName('MONTHCOMBO').setEnable(false);
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }, width: 50
                                                        },
                                                        {
                                                            el: {
                                                                type: "combocheckbox",
                                                                widgetName: 'MONTHCOMBO',
                                                                disabled: true,
                                                                items: monthItems
                                                            }, width: 110
                                                        }
                                                    ]
                                                }
                                            }
                                        ],
                                        [
                                            null,
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_Execute_Month"))},
                                            null,
                                            {
                                                el: {
                                                    type: 'combocheckbox',
                                                    widgetName: 'MONTHCOMBOCHECK',
                                                    returnArray: true,
                                                    value: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
                                                    items: [
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Jan') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 1
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Feb') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 2
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Mar') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 3
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Apr') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 4
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-May') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 5
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Jun') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 6
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Jul') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 7
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Aug') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 8
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Sep') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 9
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Oct') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 10
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Nov') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 11
                                                        },
                                                        {
                                                            text: FR.i18nText('Dec-Workflow_Short-Dec') + FR.i18nText('Dec-Workflow_Month'),
                                                            value: 12
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'tablelayout',
                                    rowSize: [21, 21],
                                    columnSize: [60, 10, 130, 170],
                                    vgap: 5,
                                    items: [
                                        [
                                            {el: this.createLabel(FR.i18nText("Dec-Workflow_FS_End_Time"))},
                                            null,
                                            {
                                                el: {
                                                    type: 'radio',
                                                    text: FR.i18nText("Dec-Workflow_NoLimit"),
                                                    fontSize: 13,
                                                    widgetName: 'NOLIMITRADIO',
                                                    selected: true,
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STATECHANGE,
                                                            action: function () {
                                                                if (!optDialog.getWidgetByName('EDRADIO').isSelected()) {
                                                                    self.setRadioSelected(this);
                                                                }
                                                                if (this.isSelected()) {
                                                                    optDialog.getWidgetByName('EDRADIO').setSelected(false);
                                                                    optDialog.getWidgetByName('EDDATETIME').setValue(null);
                                                                    optDialog.getWidgetByName('EDDATETIME').setEnable(false);
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                            null
                                        ],
                                        [
                                            null,
                                            null,
                                            {
                                                el: {
                                                    type: 'radio',
                                                    text: FR.i18nText("Dec-Workflow_FS_End_Date"),
                                                    fontSize: 13,
                                                    widgetName: 'EDRADIO',
                                                    listeners: [
                                                        {
                                                            eventName: FR.Events.STATECHANGE,
                                                            action: function () {
                                                                if (!optDialog.getWidgetByName('NOLIMITRADIO').isSelected()) {
                                                                    self.setRadioSelected(this);
                                                                }
                                                                if (this.isSelected()) {
                                                                    optDialog.getWidgetByName('NOLIMITRADIO').setSelected(false);
                                                                    optDialog.getWidgetByName('EDDATETIME').setEnable(true);
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                el: {
                                                    type: 'datetime',
                                                    format: 'yyyy-MM-dd HH:mm:ss',
                                                    widgetName: 'EDDATETIME',
                                                    disabled: true,
                                                    startDate: FR.date2Str(new Date(), "yyyy-MM-dd HH:mm:ss")
                                                }
                                            }
                                        ]
                                    ]
                                }
                            }
                        ],
                        [null, null, null, {
                            el: {
                                type: 'horizontal',
                                vgap: 0,
                                hgap: 10,
                                alignment: 'left',
                                items: [
                                    {el: this.createLabel(FR.i18nText("Dec-Workflow_FS_End_Time")), width: 55},
                                    {
                                        el: {
                                            type: 'checkbox',
                                            disabled: true,
                                            fontSize: 13,
                                            text: FR.i18nText("Dec-Workflow_TaskEndWhenOneTime"),
                                            selected: true
                                        }
                                    }
                                ]
                            }
                        }],
                        [
                            null,
                            null,
                            null,
                            {
                                el: {
                                    type: 'horizontal',
                                    vgap: 0,
                                    hgap: 10,
                                    alignment: 'left',
                                    items: [
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                imgsrc: 'rp-taskmgr-okbtn',
                                                text: FR.i18nText("Dec-Workflow_OK"),
                                                handler: function () {
                                                    var ic = self.getIssueCtrl(optDialog);
                                                    self.refreshIssueCtrl(optDialog, ic);
                                                    optDialog.ic = ic;
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([18, 19, 20, 21, 22], false);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(16, true);
                                                    optDialog.getWidgetByName("MAINTABLE").doLayout();
                                                }
                                            }, width: FR.i18nTextWidth("Dec-Workflow_OK") + 30
                                        },
                                        {
                                            el: {
                                                type: 'iconbutton',
                                                imgsrc: 'rp-taskmgr-cancelbtn',
                                                text: FR.i18nText("Dec-Workflow_Cancel"),
                                                handler: function () {
                                                    self.popIssueCtrl(optDialog, optDialog.ic);
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible([18, 19, 20, 21, 22], false);
                                                    if (!optDialog.getWidgetByName("ISSUELABEL").getValue()) {
                                                        optDialog.getWidgetByName("MAINTABLE").setRowVisible(17, true);
                                                    } else {
                                                        optDialog.getWidgetByName("MAINTABLE").setRowVisible(23, true);
                                                    }
                                                    optDialog.getWidgetByName("MAINTABLE").setRowVisible(16, true);
                                                    optDialog.getWidgetByName("MAINTABLE").doLayout();
                                                }
                                            }, width: FR.i18nTextWidth("Dec-Workflow_Cancel") + 30
                                        }
                                    ]
                                }
                            }
                        ],
                        [
                            null,
                            null,
                            null,
                            {el: this.createLabel("", "ISSUELABEL")}
                        ],
                        [null,
                            {
                                el: {
                                    type: 'label',
                                    value: FR.i18nText("Dec-Workflow_Leapfrog_Back"),
                                    textalign: 'left',
                                    color: '#1F1F1F',
                                    fontsize: 13,
                                    lineheight: 24,
                                    fontfamily: 'SimSun'
                                }
                            },
                            null,
                            {
                                el: {
                                    type: 'horizontal',
                                    alignment: 'left',
                                    rowSize: [21],
                                    hgap: 0,
                                    vgap: 0,
                                    items: [
                                        {
                                            el: {
                                                type: 'checkbox',
                                                widgetName: 'leapfrogBack',
                                                selected: false,
                                                text: FR.i18nText("Dec-Workflow_Back_To_Start"),
                                                disabled: isView
                                            }, width: Math.max(FR.i18nTextWidth("Dec-Workflow_Back_To_Start") + 60, 170)
                                        },
                                        {
                                            el: self.getDetailElement(FR.i18nText("Dec-Workflow_Leapfrog_Back_Tip")),
                                            width: 16
                                        }
                                    ]

                                }
                            }],
                        [
                            {el: $('<div/>')},
                            null,
                            null,
                            null
                        ]
                    ]
                }
            };
            if (!isView) {
                var title = FR.i18nText("Dec-Workflow_Add_Task");
                if (tasknode) {
                    title = FR.i18nText("Dec-Workflow_Edit_Task");
                }
                $.extend(dialogcfg, {
                    needSeparate: 8,
                    btnsAlignment: 'right',
                    title: title,
                    confirm: true,
                    onOK: function () {
                        var url = FR.servletURL + "?op=report_process&cmd=add_task";
                        var data = self.getAllData(optDialog);
                        if (data.errorMsg) {
                            FR.Msg.alert(FR.i18nText("Dec-Workflow_Alert"), data.errorMsg);
                            return false;
                        }
                        if (tasknode) {
                            url = FR.servletURL + "?op=report_process&cmd=update_task";
                            data.taskId = tasknode.id;
                        }
                        if (pId) {
                            data.parentId = pId;
                        }
                        FR.ajax({
                            url: url,
                            type: 'POST',
                            data: data,
                            success: function (res, status) {
                                if (res.error) {
                                    FR.Msg.toast(res.error);
                                } else {
                                    optDialog.doClose();
                                    if (FR.isEmpty(pId)) {
                                        self.taskMgrPane.getWidgetByName('TASKGRID').refresh();
                                    }
                                }
                            }
                        });
                    },
                    onCancel: function () {
                        this.doClose();
                    }
                });
            }
            var optDialog = new FR.Dialog(dialogcfg);
            this.popAllData(optDialog, tasknode);
            optDialog.getWidgetByName('MAINTABLE').setRowVisible([5, 6, 7, 8, 9, 10, 11, 14, 15, 18, 19, 20, 21, 22], false);
            if (!optDialog.getWidgetByName("ISSUELABEL").getValue()) {
                optDialog.getWidgetByName('MAINTABLE').setRowVisible(23, false);
            } else {
                optDialog.getWidgetByName('MAINTABLE').setRowVisible(17, false);
            }
            return optDialog;
        },

        getDetailElement: function (text) {
            return $('<div class="help-detail-up"/>').hover(
                function () {
                    $(this).addClass('help-detail-hover');
                },
                function () {
                    $(this).removeClass('help-detail-hover')
                }
            ).click(
                function () {
                    var $tipPre = $('<pre/>').append($('<span/>').text(text));
                    var $tipContext = $('<div class="help-detail-msg"/>')
                        .append($tipPre);
                    $tipContext.appendTo($('body')).css({
                        position: 'absolute',
                        left: $(this).offset().left + $(this).width(),
                        top: $(this).offset().top + $(this).height(),
                        'z-index': FR.widget.opts.zIndex++
                    });
                    $(document).bind('mousedown.tip', function (e) {
                        var target = e.target;
                        if (!$(target).isChildAndSelfOf('.help-detail-msg')) {
                            $tipContext.remove();
                            $(document).unbind('mousedown.tip');
                        }
                    });
                }
            );
        },

        /**
         * 获取全部控件数据
         * @param optDialog
         * @returns {*}
         */
        getAllData: function (optDialog) {
            var isValid = true,
                process = optDialog.getWidgetByName('PROCESSCOMBO'),
                task = optDialog.getWidgetByName('TASKNAME'),
                leapfrogBack = optDialog.getWidgetByName('leapfrogBack'),
                taskNameCalculateOnce = optDialog.getWidgetByName('TASKNAMECALCULATEONCE'),
                isStartTimeValid = optDialog.getWidgetByName('SSTRADIO').isSelected(),
                startTime = new Date(optDialog.getWidgetByName('STDATETIME').getValue().replace(/-/g, '/')).getTime();
            isValid = process.checkValid() && isValid;
            isValid = task.checkValid() && isValid;
            if (isValid) {
                if (!isStartTimeValid || isStartTimeValid && startTime > new Date().getTime()) {
                    return {
                        'name': task.getValue(),
                        'processId': process.getValue(),
                        'remindControl': this.getRemindCtrl(optDialog),
                        'deadLineDate': this.getDeadLineDate(optDialog),
//                    'deadLine': this.getDeadline(optDialog),
                        'deadLineType': this.getDeadLineType(optDialog),
                        'issueControl': this.getIssueCtrl(optDialog),
                        'leapfrogBack': leapfrogBack.isSelected(),
                        'taskNameCalculateOnce': taskNameCalculateOnce.isSelected()
                    }
                } else {
                    return {
                        errorMsg: FR.i18nText("Dec-Error_Schedule_Start_Time_Now")
                    }
                }
            } else {
                return {
                    errorMsg: FR.i18nText("Dec-Workflow_Invalid_Task_Or_Process") + '!'
                }
            }
        },

        /**
         * 赋值全部控件
         * @param optDialog
         * @param tasknode
         */
        popAllData: function (optDialog, tasknode) {
            if (!tasknode) {
                optDialog.rc = {};
                optDialog.dld = null;
                optDialog.dt = null;
                optDialog.ic = {};
                return;
            }
            //提醒方式label
            if (tasknode.remindControl && tasknode.remindControl != 'null') {
                var rc = FR.jsonDecode(tasknode.remindControl);
                optDialog.rc = rc;
                this.popRemindCtrl(optDialog, rc);
                this.refreshRemindCtrl(optDialog, rc);
            }
            //限时填报label
            if (tasknode.deadLineDate) {
                optDialog.dld = tasknode.deadLineDate;
                optDialog.dt = tasknode.deadLineType;
                this.popDeadLineDate(optDialog, tasknode.deadLineDate);
                this.popDeadLineType(optDialog, tasknode.deadLineType);
                this.refreshDeadline(optDialog, tasknode.deadLineDate, tasknode.deadLineType);
            }
            //定时下发
            if (tasknode.issueControl && tasknode.issueControl != 'null') {
                var ic = FR.jsonDecode(tasknode.issueControl);
                optDialog.ic = ic;
                this.popIssueCtrl(optDialog, ic);
                this.refreshIssueCtrl(optDialog, ic);
            }

            optDialog.getWidgetByName('TASKNAME').setValue(tasknode.name);
            optDialog.getWidgetByName('PROCESSCOMBO').setValue(tasknode.process.id);
            optDialog.getWidgetByName('leapfrogBack').setSelected(tasknode.leapfrogBack);
            optDialog.getWidgetByName('TASKNAMECALCULATEONCE').setSelected(tasknode.taskNameCalculateOnce);
        },

        /**
         * 赋值消息提醒部分的控件
         * @param optDialog
         * @param rc
         */
        popRemindCtrl: function (optDialog, rc) {
            if (rc.useEmail) {
                optDialog.getWidgetByName('ECHECK').setValue(true);
                optDialog.getWidgetByName('ERECEIVERCOMBO').setValue(rc.emailTo);
                optDialog.getWidgetByName('TITLETEXT').setValue(rc.emailTitle);
                optDialog.getWidgetByName('ECONTENTTEXT').setValue(rc.emailContext);
            } else {
                optDialog.getWidgetByName('ECHECK').setValue(false);
            }
            if (rc.useToast) {
                optDialog.getWidgetByName('SCHECK').setValue(true);
                optDialog.getWidgetByName('SRECEIVERCOMBO').setValue(rc.toastTo);
                optDialog.getWidgetByName('SCONTENTTEXT').setValue(rc.toastContext);
                optDialog.getWidgetByName("MAINTABLE").setRowVisible(12, true);
            } else {
                optDialog.getWidgetByName('SCHECK').setValue(false);
            }
            if (rc.useSMS) {
                optDialog.getWidgetByName('SMSCHECK').setValue(true);
                optDialog.getWidgetByName('SMSRECEIVERCOMBO').setValue(rc.smsTo);
            } else {
                optDialog.getWidgetByName('SMSCHECK').setValue(false);
            }
        },
        /**
         * 赋值限时填报部分的控件
         * @param optDialog
         * @param dl
         */
        popDeadLineDate: function (optDialog, dl) {
            optDialog.getWidgetByName("DEADLINE").setValue(dl);
        },

        popDeadLineType: function (optDialog, dt) {
            optDialog.getWidgetByName("DEADLINETYPE").setValue(dt);
        },

        /**
         * 赋值定时下发部分的控件
         * @param optDialog
         * @param ic
         */
        popIssueCtrl: function (optDialog, ic) {
            if (ic.startTime) {
                optDialog.getWidgetByName('SSTRADIO').setSelected(true);
                optDialog.getWidgetByName('STDATETIME').setValue(ic.startTime);
            } else {
                var rasradioWidget = optDialog.getWidgetByName('RASRADIO');
                var temp = rasradioWidget.getValue();
                if (!temp) {
                    rasradioWidget.setSelected(true);
                }
            }
            if (ic.onlyOnce !== false) {
                var eotradioWidget = optDialog.getWidgetByName('EOTRADIO');
                var temp = eotradioWidget.getValue();
                if (!temp) {
                    eotradioWidget.setSelected(true);
                }
                optDialog.getWidgetByName('MAINTABLE').setRowVisible([19, 20], false);
                optDialog.getWidgetByName('MAINTABLE').setRowVisible(21, true);
            } else {
                var fsradioWidget = optDialog.getWidgetByName('FSRADIO');
                var temp = fsradioWidget.getValue();
                if (!temp) {
                    fsradioWidget.setSelected(true);
                }
                optDialog.getWidgetByName('MAINTABLE').setRowVisible([19, 20], true);
                optDialog.getWidgetByName('MAINTABLE').setRowVisible(21, false);
                if (ic.endTime) {
                    var edradioWidget = optDialog.getWidgetByName('EDRADIO');
                    var temp = edradioWidget.getValue();
                    if (!temp) {
                        edradioWidget.setSelected(true);
                    }
                    var eddatetimeWidget = optDialog.getWidgetByName('EDDATETIME');
                    var tempValue = eddatetimeWidget.getValue();
                    if (!temp) {
                        eddatetimeWidget.setValue(ic.endTime);
                    }
                } else {
                    var nolimitradioWidget = optDialog.getWidgetByName('NOLIMITRADIO');
                    var temp = nolimitradioWidget.getValue();
                    if (!temp) {
                        nolimitradioWidget.setSelected(true);
                    }
                }
            }
            if (ic.frequency) {
                optDialog.getWidgetByName('MINUTENUMBER').setValue(ic.frequency.executeMinute);
                optDialog.getWidgetByName('HOURNUMBER').setValue(ic.frequency.executeHour);
                if (ic.frequency.executeDay.weekDay) {
                    var weekradioWidget = optDialog.getWidgetByName('WEEKRADIO')
                    var temp = weekradioWidget.getValue();
                    if (!temp) {
                        weekradioWidget.setSelected(true);
                    }
                    optDialog.getWidgetByName('WEEKCOMBO').setValue(ic.frequency.executeDay.weekDay);
                } else if (ic.frequency.executeDay.monthDay) {
                    var monthradioWidget = optDialog.getWidgetByName('MONTHRADIO');
                    var temp = monthradioWidget.getValue();
                    if (!temp) {
                        monthradioWidget.setSelected(true);
                    }
                    optDialog.getWidgetByName('MONTHCOMBO').setValue(ic.frequency.executeDay.monthDay)
                } else {
                    var dayradioWidget = optDialog.getWidgetByName('DAYRADIO');
                    var temp = dayradioWidget.getValue();
                    if (!temp) {
                        dayradioWidget.setSelected(true);
                    }
                }
                optDialog.getWidgetByName('MONTHCOMBOCHECK').setValue(ic.frequency.executeMonth);
            }
        },

        /**
         * 获取消息提示部分的数据
         * @param optDialog
         * @returns {*}
         */
        getRemindCtrl: function (optDialog) {
            var rc = {
                'useSMS': optDialog.getWidgetByName('SMSCHECK').getValue(),
                'smsTo': optDialog.getWidgetByName('SMSRECEIVERCOMBO').getValue(),
                'useEmail': optDialog.getWidgetByName('ECHECK').getValue(),
                'emailTo': optDialog.getWidgetByName('ERECEIVERCOMBO').getValue(),
                'emailTitle': optDialog.getWidgetByName('TITLETEXT').getValue(),
                'emailContext': optDialog.getWidgetByName('ECONTENTTEXT').getValue(),
                'useToast': optDialog.getWidgetByName('SCHECK').getValue(),
                'toastTo': optDialog.getWidgetByName('SRECEIVERCOMBO').getValue(),
                'toastContext': optDialog.getWidgetByName('SCONTENTTEXT').getValue()
            };
            return rc;
        },
        /**
         * 获取限时填报部分的数据
         * @param optDialog
         * @returns {Object}
         */
        getDeadLineDate: function (optDialog) {
            var deadline = optDialog.getWidgetByName('DEADLINE').getValue();
            return deadline;
        },
//        getDeadline: function (optDialog) {
//            var deadline = optDialog.getWidgetByName('DEADLINE').getValue();
//            if(deadline === ''){
//                return null;
//            }
//            var deadLineType = this.getdeadLineTypeValue(optDialog);
//            var deadDate = new Date();
//            switch (deadLineType){
//                case 'd' :deadDate = new Date(Date.parse(deadDate) + (86400000 * deadline));
//                case 'w' :deadDate = new Date(Date.parse(deadDate) + ((86400000 * 7) * deadline));
//                case 'm' :deadDate = new Date(deadDate.getFullYear(), (deadDate.getMonth()) + deadline, deadDate.getDate(),deadDate.getHours(),deadDate.getMinutes());
//            }
//            return FR.date2Str(deadDate,'yyyy-MM-dd HH:mm');
//        },
        getDeadLineType: function (optDialog) {
            var deadLineType = optDialog.getWidgetByName('DEADLINETYPE').getValue();
            return deadLineType;
        },
        /**
         * 获取定时下发部分的数据
         * @param optDialog
         * @returns {*}
         */
        getIssueCtrl: function (optDialog) {
            var execDaySel = {};
            if (optDialog.getWidgetByName('DAYRADIO').getValue()) {
                execDaySel.everyDay = optDialog.getWidgetByName('DAYRADIO').getValue();
            } else if (optDialog.getWidgetByName('WEEKRADIO').getValue()) {
                execDaySel.weekDay = optDialog.getWidgetByName('WEEKCOMBO').getValue();
            } else {
                execDaySel.monthDay = optDialog.getWidgetByName('MONTHCOMBO').getValue();
            }
            var ic = {
                'startTime': optDialog.getWidgetByName('STDATETIME').getValue(),
                'onlyOnce': optDialog.getWidgetByName('EOTRADIO').getValue(),
                'frequency': {
                    'executeMinute': optDialog.getWidgetByName('MINUTENUMBER').getValue(),
                    'executeHour': optDialog.getWidgetByName('HOURNUMBER').getValue(),
                    'executeDay': execDaySel,
                    'executeMonth': optDialog.getWidgetByName('MONTHCOMBOCHECK').getValue()
                },
                'endTime': optDialog.getWidgetByName('EDDATETIME').getValue()
            };
            return ic;
        },
        /**
         * 刷新消息提示标签
         * @param optDialog
         * @param rc
         */
        refreshRemindCtrl: function (optDialog, rc) {
            var alertInfo = '';
            if (rc.useSMS) {
                alertInfo += FR.i18nText("Dec-Basic_SMS_Reminder") + ' ';
            }
            if (rc.useEmail) {
                alertInfo += FR.i18nText("Dec-Workflow_Email") + ' ';
            }
            if (rc.useToast) {
                alertInfo += FR.i18nText("Dec-Workflow_System_Message");
            }
            if (FR.isEmpty(alertInfo)) {
                alertInfo = FR.i18nText("Dec-Workflow_None");
            }
            optDialog.getWidgetByName("ALERTLABEL").setValue(alertInfo);
        },
        /**
         * 刷新限时填报标签
         * @param optDialog
         * @param dl
         * @param dt
         */
        refreshDeadline: function (optDialog, dl, dt) {
            var deadInfo = FR.i18nText("Dec-Workflow_Unlimited");
            var dtStr = FR.i18nText('Dec-Workflow_Day');
            switch (dt) {
                case 'd':
                    dtStr = FR.i18nText('Dec-Workflow_Day');
                    break;
                case 'w':
                    dtStr = FR.i18nText('Dec-Workflow_Week');
                    break;
                case 'm':
                    dtStr = FR.i18nText('Dec-Workflow_Month');
                    break;
            }
            if (dl || dl === 0) {
                deadInfo = FR.i18nText("Dec-Workflow_Report_Deadline") + ': ' + FR.i18nText('Dec-Workflow_FS_Task_Start') + dl + dtStr + FR.i18nText('Dec-Workflow_FS_Task_End');
            }
            optDialog.getWidgetByName("DEADLINELABEL").setValue(deadInfo);
        },
        /**
         * 刷新定时下发标签
         * @param optDialog
         * @param ic
         */
        refreshIssueCtrl: function (optDialog, ic) {
            var ff = '';
            if (ic.frequency.executeDay.everyDay) {
                ff = FR.i18nText('Dec-Workflow_Everyday');
            } else if (ic.frequency.executeDay.weekDay) {
                ff = optDialog.getWidgetByName('WEEKCOMBO').getText();
            } else {
                ff = optDialog.getWidgetByName('MONTHCOMBO').getText();
            }
            var stinfo = FR.i18nText("Dec-Workflow_FS_Start_Time") + ': ',
                edinfo = FR.i18nText("Dec-Workflow_FS_End_Date") + ': ',
                freq = FR.i18nText("Dec-Workflow_ExecuteFrequency") + ': ';
            if (ic.startTime) {
                stinfo += ic.startTime + '\n';
            } else {
                stinfo += FR.i18nText("Dec-Workflow_RestartAfterSet") + '\n';
            }
            if (ic.onlyOnce) {
                freq += FR.i18nText("Dec-Workflow_ExecuteOneTime") + '\n';
                edinfo += FR.i18nText("Dec-Workflow_TaskEndWhenOneTime");
            } else {
                freq += FR.i18nText("Dec-Workflow_Every") + optDialog.getWidgetByName('MONTHCOMBOCHECK').getText() + FR.i18nText("Dec-Workflow_De");
                freq += ff + FR.i18nText("Dec-Workflow_De") +
                    ic.frequency.executeHour + FR.i18nText("Dec-Workflow_Sche-Hour") +
                    ic.frequency.executeMinute + FR.i18nText("Dec-Workflow_Sche-Minute") + FR.i18nText("Dec-Workflow_Execute") + '\n'
                if (ic.endTime) {
                    edinfo += ic.endTime;
                } else {
                    edinfo += FR.i18nText("Dec-Workflow_Unlimited");
                }
            }
            var issueinfo = stinfo + freq + edinfo;
            optDialog.getWidgetByName("ISSUELABEL").setValue(issueinfo);
            optDialog.getWidgetByName('MAINTABLE').setRowVisible(23, true);
            optDialog.getWidgetByName('MAINTABLE').setRowVisible(17, false);
        },

        isStraightLineProcess: function (id) {
            var isStraightLine = false;
            FR.ajax({
                url: FR.servletURL + "?op=report_process&cmd=get_process",
                async: false,
                type: 'POST',
                data: {processId: id},
                success: function (res, status) {
                    var result = FR.jsonDecode(res);
                    isStraightLine = result.isStraightLine;
                }
            });
            return isStraightLine;
        },

        getRelatedUsers: function (id, condition) {
            var users = [];
            FR.ajax({
                url: FR.servletURL + "?op=report_process&cmd=get_related_user",
                async: false,
                data: {
                    processId: id
                },
                complete: function (res, status) {
                    if (status == 'success') {
                        users = FR.jsonDecode(res.responseText);
                    }
                }
            });

            return users;
        },

        createLabel: function (text, widgetname, iscenter) {
            var config = {
                type: 'label',
                value: text,
                textalign: 'left',
                color: '#1F1F1F',
                fontsize: 13,
                fontfamily: 'SimSun',
                verticalcenter: iscenter
            };
            if (widgetname) {
                config.widgetName = widgetname;
            }
            return config;
        },

        createBoldLabel: function (text, widgetname, verticalcenter) {
            var config = {
                type: 'label',
                value: text,
                textalign: 'left',
                color: '#1F1F1F',
                fontsize: 13,
                fontweight: 'bold',
                fontfamily: 'SimSun',
                verticalcenter: verticalcenter
            };
            if (widgetname) {
                config.widgetName = widgetname;
            }
            return config;
        },

        createEditLabel: function (clickFn, isView) {
            var cfg = {
                type: 'label',
                value: '[' + FR.i18nText("Dec-Workflow_Edit") + ']',
                fontsize: 13,
                fontfamily: 'Simsun',
                color: '#179fff',
                width: 50,
                listeners: [
                    {
                        eventName: FR.Events.CLICK,
                        action: clickFn
                    }
                ]
            };
            if (isView) {
                cfg.disabled = true;
            }
            return cfg;
        },

        createNameCombo: function ($sel) {
            var self = this;
            var $combo = $('<div class="fr-combo-list rp-taskmgr-namecombo"/>');
            $('<div/>').text(FR.i18nText("Dec-Workflow_Task_Created_By_Me")).appendTo($combo);
            $('<div/>').text(FR.i18nText("Dec-Workflow_All_Tasks")).data('data', {getAll: true}).appendTo($combo);
            $combo.children('div').hover(
                function () {
                    $(this).addClass('rp-taskmgr-name-hover');
                },
                function () {
                    $(this).removeClass('rp-taskmgr-name-hover');
                }
            ).click(
                function () {
                    var data = $(this).data('data');
                    if (data) {
                        self.STATIC.GETALL = 1;
                    } else {
                        self.STATIC.GETALL = 0;
                    }
                    self.taskMgrPane.getWidgetByName('TASKGRID').options.async.data = data;
                    self.taskMgrPane.getWidgetByName('TASKGRID').refresh();
                    $combo.remove();
                    $(document).unbind('mousedown.namecombo');
                }
            );
            $combo.css({
                position: 'absolute',
                left: $sel.offset().left,
                top: $sel.offset().top + $sel.height(),
                'z-Index': FR.widget.opts.zIndex++
            }).appendTo($('body'));
            $(document).bind('mousedown.namecombo', function (e) {
                var target = e.target;
                var res = $(target).closest('.fr-combo-list');
                if (res.length === 0) {
                    $combo.remove();
                    $(document).unbind('mousedown.namecombo');
                }
            });
        },

        createSortCell: function (itemcfg) {
            var grid = this.taskMgrPane.getWidgetByName('TASKGRID'), self = this;
            var $cell = $('<div/>').hover(
                function () {
                    $(this).addClass('cell-hover');
                },
                function () {
                    $(this).removeClass('cell-hover');
                }
            ).click(
                function () {
                    var data = {
                        detailSearch: self.STATIC.DETAILSEARCH,
                        getAll: self.STATIC.GETALL === 1,
                        taskName: self.STATIC.TASKNAME,
                        userId: self.STATIC.USERID,
                        departmentId: self.STATIC.DEPARTMENTID,
                        startTime: self.STATIC.STARTTIME,
                        endTime: self.STATIC.ENDTIME,
                        sortBy: itemcfg.key,
                        desc: self.STATIC.SORT
                    };
                    if (self.STATIC.FILTER != null) {
                        data.filter = self.STATIC.FILTER;
                    }
                    self.STATIC.SORT = !self.STATIC.SORT;
                    FR.ajax({
                        url: FR.servletURL + '?op=report_process&cmd=get_all_task',
                        type: 'POST',
                        data: data,
                        complete: function (res, status) {
                            if (status == 'success') {
                                var items = FR.jsonDecode(res.responseText);
                                grid.refresh(items);
                            }
                        }
                    });
                }
            ).append($('<span/>').text(itemcfg.value));
            return $cell;
        },

        preLoadData: function () {
            var self = this;
            FR.ajax({
                url: FR.servletURL + "?op=fs_main&cmd=user_getinfo",
                async: false,
                type: 'POST',
                success: function (res, status) {
                    self.CONSTS.CURRENTUSER = FR.jsonDecode(res);
                }
            });

        },

        setRadioSelected: function (radio) {
            if (!radio.selected()) {
                radio.setSelected();
            }
        }
    };
});