/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: Sean
 * Date: 14-3-20
 * Time: 下午2:47
 */
;
(function ($) {

    var P = {

        /**
         * 审核不通过 回退
         * @param taskId
         */
        back: function (taskId) {
            // {0.cpt:[{text:'A', value:0}, {text:'B', value:1}], 1.cpt:[{text:'c', value:0}, {text:'D', value:1}]}
            var allBackTargets, startAndBackTargets, items = [], backNodeItem = "backTarget";
            var self = this;
            this.doProcessOperate({
                params: {
                    cmd: "get_back_target"
                },
                fn: function (res) {
                    var result = FR.jsonDecode(res.responseText);
                    if (result.error) {
                        FR.Msg.toast(result.error);
                    } else {
                        if (result.startTarget) {
                            startAndBackTargets = result;
                            allBackTargets = startAndBackTargets["backTarget"];
                            createBackDialog();
                        } else {
                            allBackTargets = result.backTarget;
                            createItemsAndDialog();
                        }

                    }
                }
            }, {
                params: {
                    type: "getBackTarget"
                },
                fn: function (res) {
                    var result = FR.jsonDecode(res);
                    if (result.error) {
                        FR.Msg.toast(result.error);
                    } else {
                        allBackTargets = result.backTarget;
                        createItemsAndDialog();
                    }
                }
            }, taskId);

            function createBackDialog() {
                var self = this;
                var interfaceSetting = {
                    "startTarget": {
                        nodeIndex: 0,
                        nodeName: FR.i18nText("Dec-Workflow_Start_Node")
                    },
                    "backTarget": {
                        nodeIndex: 1,
                        nodeName: FR.i18nText("Dec-Workflow_Last_Node")
                    }
                };
                var backNodes = ["startTarget", "backTarget"];
                var bItem = [];

                $.each(backNodes, function (index, backNode) {
                    $.each(startAndBackTargets[backNode], function (index, item) {
                        bItem.push({
                            value: interfaceSetting[backNode].nodeIndex,
                            text: interfaceSetting[backNode].nodeName + item[0].text
                        });
                    })
                });

                items.push({
                    type: 'radiogroup',
                    assureSelect: true,
                    columnsInRow: 1,
                    items: bItem,
                    height: 70,
                    width: 240,
                    value: '1',
                    widgetName: 'backRadioGroup',
                    x: 70,
                    y: 50,
                    listeners: [
                        {
                            eventName: FR.Events.AFTEREDIT,
                            action: function () {
                                var value = this.getValue();
                                for (var key in interfaceSetting) {
                                    if (interfaceSetting[key].nodeIndex === value) {
                                        allBackTargets = startAndBackTargets[key];
                                        backNodeItem = key;
                                        return;
                                    }
                                }
                            }
                        }
                    ]
                });
                var backDialog = self.backDialog = new FR.Dialog({
                    height: 245,
                    width: 315,
                    confirm: true,
                    title: FR.i18nText("Dec-Workflow_Rollback_To"),
                    resizeable: false,
                    contentWidget: {
                        type: 'absolute',
                        widgetName: 'BACKWIDGET',
                        items: items
                    },
                    onOK: function () {
                        doSendBack();
                        this.doClose();
                    },
                    onCancel: function () {
                        this.doClose();
                    }
                });
                backDialog.setVisible(true);
            }


            function createItemsAndDialog() {
                for (var report in allBackTargets) {
                    for (var i = 0; i < allBackTargets[report].length; i++) {
                        var op = allBackTargets[report][i];
                        var check = new FR.CheckBox({
                            invisible: true,
                            renderEl: $('<div/>').appendTo('body'),
                            text: op.text
                        });
                        $.extend(check.options, {
                            width: check.element.width() + 25,
                            height: check.element.height(),
                            renderEl: null,
                            invisible: false,
                            selected: true,
                            fontSize: 13,
                            type: 'checkbox',
                            value: op.value,
                            report: report,
                            listeners: [{
                                eventName: FR.Events.STATECHANGE,
                                action: function () {
                                    var o = this.options;
                                    var arr = allBackTargets[o.report];
                                    var obj = {text: o.text, value: o.value};
                                    if (this.selected()) {
                                        arr.push(obj);
                                    } else {
                                        arr.splice(arr.weakIndexOf(obj), 1);
                                    }
                                }
                            }]
                        });
                        items.push({el: check.options});
                    }
                }

                if (items.length > 1) {
                    var backDialog = new FR.Dialog({
                        height: 245,
                        width: 315,
                        confirm: true,
                        title: FR.i18nText("Dec-Workflow_Rollback_To"),
                        closable: true,
                        autoScroll: true,
                        needSeparate: 5,
                        btnsAlignment: 'right',
                        closeAfterAction: false,
                        contentWidget: {
                            type: 'flow',
                            scrollable: true,
                            widgetName: 'FLOW',
                            hgap: 10,
                            vgap: 10,
                            items: items
                        },
                        onOK: function () {
                            var cnt = 0;
                            for (var report in allBackTargets) {
                                cnt += allBackTargets[report].length;
                            }
                            if (cnt === 0) {
                                FR.Msg.toast("select one at least");
                            } else {
                                doSendBack();
                                this.doClose();
                            }
                        },
                        onCancel: function () {
                            this.doClose();
                        }
                    });
                    backDialog.getWidgetByName('FLOW').doLayout();
                    backDialog.setVisible(true);
                } else if (items.length === 1) {
                    doSendBack();
                } else {
                    // FR.Msg.toast("no back target");
                    FR.Msg.toast(FR.i18nText("Dec-Workflow_No_Back_Target"));
                }
            }

            function doSendBack() {
                var successFn = function () {
                    self.onSuccessOp();
                };

                self.doProcessOperate({
                    params: {
                        cmd: "task_back",
                        backTarget: allBackTargets,
                        backNodeItem: backNodeItem
                    },
                    fn: successFn
                }, {
                    params: {
                        type: "back",
                        backTarget: allBackTargets,
                        backNodeItem: backNodeItem
                    },
                    fn: successFn
                }, taskId);
            }
        },

        /**
         * 审核通过
         * @param taskId
         * @param nodeIdx
         */
        pass: function (taskId, nodeIdx) {
            var self = this;

            var successFn = function () {
                self.onSuccessOp();
            };

            var checkSuccess = function () {
                self.verifyAndWriteReport(true, null, function () {
                    self.doProcessOperate({
                        params: {
                            cmd: "task_pass",
                            nodeIdx: nodeIdx
                        },
                        fn: successFn
                    }, {
                        params: {
                            type: "pass",
                            nodeIdx: nodeIdx
                        },
                        fn: successFn
                    }, taskId);
                });
            };

            this.preventNoWriter = true;
            var doPass = function () {
                self.doProcessOperate({
                    params: {
                        cmd: "move_check"
                    },
                    fn: checkSuccess
                }, {
                    params: {
                        type: "check"
                    },
                    fn: checkSuccess
                }, taskId)
            };

            this.checkValidAndOperate(doPass);

        },

        /**
         * 上报
         * @param taskId
         * @param nodeIdx
         */
        report: function (taskId, nodeIdx) {
            var self = this;

            var successFn = function () {
                self.onSuccessOp();
            };

            var checkSuccess = function () {
                var toolbar = contentPane.toolbar;
                if (toolbar instanceof Array) {
                    toolbar = toolbar[1];
                }
                var submitButton = toolbar.getWidgetByName('Report');
                self.verifyAndWriteReport(true, submitButton, function () {
                    self.doProcessOperate({
                        params: {
                            cmd: "task_report",
                            nodeIdx: nodeIdx
                        },
                        fn: successFn
                    }, {
                        params: {
                            type: "report",
                            nodeIdx: nodeIdx
                        },
                        fn: successFn
                    }, taskId);
                });
            };

            var doReport = function () {
                self.doProcessOperate({
                    params: {
                        cmd: "move_check"
                    },
                    fn: checkSuccess
                }, {
                    params: {
                        type: "check"
                    },
                    fn: checkSuccess
                }, taskId)
            };

            this.checkValidAndOperate(doReport);

        },

        addNote: function (taskId) {
            var self = this;
            var noteDialog = new FR.Dialog({
                height: 245,
                width: 315,
                confirm: true,
                title: FR.i18nText("Dec-Workflow_Note"),
                closable: true,
                btnsAlignment: 'right',
                contentWidget: {
                    type: 'absolute',
                    items: [
                        {
                            el: {
                                type: 'text',
                                widgetName: 'MESSAGE',
                                multiline: true,
                                height: 145,
                                width: 270
                            },
                            y: 12,
                            x: 22
                        }
                    ]
                },
                onOK: function () {
                    var message = noteDialog.getWidgetByName("MESSAGE").getValue();
                    // 离线备注存储在本地 提交的时候再传入服务器
                    if (self.isWriteOfflinePage) {
                        if (!self.processNote) {
                            self.processNote = [];
                        }
                        self.processNote.push({
                            nodeIdx: self.parameters.ROUTEIDX,
                            message: message,
                            user: self.parameters.USERNAME,
                            time: FR.date2Str(new Date(), "yyyy-MM-dd HH:mm:ss")
                        });
                        FR.WE.storeProcessNote(self.processNote);
                    } else {
                        FR.ajax({
                            url: FR.servletURL + "?op=report_process&cmd=add_note",
                            async: false,
                            data: {
                                taskId: taskId,
                                message: message
                            },
                            complete: function (res, success) {
                                if (success == 'success') {
                                    var result = FR.jsonDecode(res.responseText);
                                    if (result.error) {
                                        FR.Msg.toast(result.error);
                                    } else {
                                        FR.Msg.toast(FR.i18nText("Dec-Basic_Success"));
                                    }
                                } else {
                                    FR.Msg.toast(FR.i18nText("Dec-Workflow_Failed"));
                                }
                            }
                        });
                    }

                }
            });
            noteDialog.setVisible(true);
        },

        viewProcess: function (taskId) {
            var notes = {};
            var $btn = $('#rp-tool-viewprocess');
            var createView = function (nodes, notes, curIdx, nodeRoute) {
                var $view = $('<div class="fr-combo-list"/>').css({
                    width: 290,
                    height: 300,
                    position: 'absolute',
                    'z-index': FR.widget.opts.zIndex++,
                    left: $btn.offset().left,
                    top: $btn.offset().top - 300
                });
                var $ul = $('<ul class="fr-rptool-viewprocess"/>').appendTo($view);
                var len = nodeRoute.length + (nodes.length - 1 - curIdx);
                for (var i = 0; i < len; i++) {
                    var idx = i < nodeRoute.length ? nodeRoute[i] : nodeRoute[nodeRoute.length - 1] + i - nodeRoute.length + 1;
                    var $li = $('<li/>').appendTo($ul);
                    var nodeCls = 'fr-rptool-viewprocess-node',
                        noteCls = 'fr-rptool-viewprocess-note';
                    if (i === 0) {
                        nodeCls += '-first';
                        noteCls += '-done';
                    } else if (i < nodeRoute.length) {
                        nodeCls += '-done';
                        noteCls += '-done';
                    }
                    var $node = $('<div/>').addClass(nodeCls).text(nodes[idx].name).appendTo($li);
                    if (notes[i]) {
                        for (var j = 0, size = notes[i].length; j < size; j++) {
                            $('<div/>').addClass(noteCls).text(notes[i][j].noter).appendTo($li);
                            $('<div/>').addClass(noteCls)
                                .text(notes[i][j].message)
                                .attr('title', notes[i][j].message)
                                .appendTo($li);
                        }
                    }
                }
                var $last = $('<li/>').appendTo($ul);
                $('<div/>').addClass('fr-rptool-viewprocess-node-last').text(FR.i18nText('Dec-Workflow_End')).appendTo($last);
                return $view;
            };

            var doCreateByConfig = function (result) {
                if (result.note) {
                    for (var i = 0, len = result.note.length; i < len; i++) {
                        var note = result.note[i];
                        notes[note.nodeIdx] = notes[note.nodeIdx] || [];
                        notes[note.nodeIdx].push({
                            noter: note.user + ' ' + note.time,
                            message: FR.i18nText("Dec-Workflow_Note") + ':' + note.message
                        });
                    }
                }
                var $pview = createView(result.process.nodes, notes,
                    result.currentNodeIdx, result.nodeRoute);
                $pview.show().appendTo($('body'));
                setTimeout(function () {
                    $(document).bind('click.viewp', function (event) {
                        var target = event.target;
                        var result = $(target).closest('.fr-combo-list');
                        if (result.length === 0) {
                            $pview.remove();
                            $(document).unbind('click.viewp');

                        }
                    });
                }, 200);
            };

            if (this.isWriteOfflinePage) {
                // 生成离线时候写死的配置信息 包括备注
                var conf = FR.jsonDecode(this.processConfig);
                // 添加本地的备注
                if (this.processNote) {
                    if (!conf.note) {
                        conf.note = [];
                    }
                    for (var i = 0; i < this.processNote.length; i++) {
                        conf.note.push(this.processNote[i]);
                    }
                }
                doCreateByConfig(conf);
            } else {
                FR.ajax({
                    url: FR.servletURL + "?op=report_process&cmd=get_taskImpl&" + new Date().getTime(),
                    data: {
                        taskId: taskId
                    },
                    complete: function (res, status) {
                        if (status == 'success') {
                            var result = FR.jsonDecode(res.responseText);
                            doCreateByConfig(result);
                        }
                    }
                });
            }
        },

        stashData: function (taskId) {
            this.saveReport();
            if (this.isWriteOfflinePage) {
                //离线填报数据保存在浏览器中，保存按钮的存在没什么意义
                FR.Msg.toast(FR.i18nText("Dec-Basic_Success"));
            } else {
                FR.ajax({
                    url: FR.servletURL + "?op=report_process&cmd=task_stash",
                    data: {
                        taskId: taskId,
                        sessionID: this.currentSessionID,
                        reportXML: this.generateReportXML(true)
                    },
                    complete: function (res, success) {
                        if (success == 'success') {
                            var result = FR.jsonDecode(res.responseText);
                            if (result.error) {
                                FR.Msg.toast(result.error);
                            } else {
                                FR.Msg.toast(FR.i18nText("Dec-Basic_Success"));
                            }
                        } else {
                            FR.Msg.toast(FR.i18nText("Dec-Workflow_Failed"));
                        }
                    }
                })
            }
        },

        checkValidAndOperate: function (fn) {
            var self = this;
            if (!$.isFunction(fn)) {
                return;
            }

            if (this.isWriteOfflinePage) {
                this.offlineSave({
                    params: {
                        op: "report_process_offline",
                        cmd: "offline_for_process",
                        type: "validOffline",
                        taskId: self.parameters.TASKID,
                        userId: self.parameters.USERID,
                        nodeIdx: self.parameters.NODEIDX
                    },
                    fn: function (res) {
                        var result = res;
                        if (result && result.valid) {
                            fn();
                        } else {
                            FR.Msg.toast("operated already");
                        }
                    }
                });
            } else {
                fn();
            }
        },

        doProcessOperate: function (options, offlineOps, taskId) {
            var self = this;

            function doOffline(params) {
                self.offlineSave({
                    params: params,
                    fn: function (res) {
                        if (res.error) {
                            FR.Msg.toast(res.error);
                        } else {
                            if (offlineOps.fn) {
                                offlineOps.fn(res);
                            }
                        }
                    },
                    errorFn: function () {
                        FR.Msg.toast("fail to connect");
                        FR.hideLoadingDialog();
                    }
                });
            }

            if (this.isWriteOfflinePage) { // 离线
                // 离线的时候使用离线填报的请求方式op=fr_off_write
                var notes = [];
                for (var i = 0; i < self.processNote.length; i++) {
                    if (!self.processNote[i].submited) {
                        notes.push(self.processNote[i]);
                    }
                }
                var params = $.extend({
                    op: "report_process_offline",
                    cmd: "offline_for_process",
                    taskId: self.parameters.TASKID,
                    userId: self.parameters.USERID,
                    notes: notes
                }, offlineOps.params);
                if (this.currentSessionID) {
                    doOffline(params);
                } else {
                    this.registerReportSession({
                        fn: function () {
                            doOffline(params);
                        }
                    });
                }
            } else {   // 非离线
                var params = $.extend({
                    op: "report_process",
                    sessionID: self.currentSessionID,
                    taskId: taskId
                }, options.params);
                FR.ajax({
                    url: FR.servletURL,
                    data: params,
                    complete: function (res, status) {
                        if (status == 'success') {
                            var result = FR.jsonDecode(res.responseText);
                            if (result.error) {
                                FR.Msg.toast(result.error);
                            } else {
                                if (options.fn) {
                                    options.fn(res);
                                }
                            }
                        } else {
                            FR.Msg.toast("failed");
                        }
                    }
                });
            }

        },

        onSuccessOp: function () {
            if (this.isWriteOfflinePage) {
//                this.setOperated();
                // 离线操作完成后 备注已经上传过了 标注一下 下次不再上传
                if (this.processNote) {
                    for (var i = 0; i < this.processNote.length; i++) {
                        var note = this.processNote[i];
                        note.submited = true;
                    }
                    FR.WE.storeProcessNote(this.processNote);
                }
            } else {
                window.FR.Msg.toast(FR.i18nText("Dec-Basic_Success"));
                if (window.parent) {
                    if (window.parent.FS) {
                        window.parent.FS.tabPane.closeActiveTab();
                    } else {// 无平台时直接关闭tab页
                        if (FR.Report.Plugin.OpenOnNewTabpane.action) {
                            window.close();
                        } else {
                            window.history.back();
                        }
                    }
                } else { // 嵌入在自定义的iframe中的情况
                    window.history.back();
                }
            }
        },

        isOperated: function () {
            return !!FR.WE.getParameter("processOperated");
        },

        setOperated: function () {
            FR.WE.setParameter("processOperated", true);
        }
    };

    if (window.contentPane) {
        $.extend(contentPane, P);
    } else {
        $.extend(FR.WritePane.prototype, P);
    }
})(jQuery);