/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class ASN1 {
    public static final int OPTIONAL = 65536;
    public static final int DEFAULT = 131072;
    protected static final int CHOICE_ELEMENT = 262144;
    static final int APPLICATION = 0x400000;
    static final int CONTEXT_SPECIFIC = 0x800000;
    static final int PRIVATE = 0xC00000;
    static final int EXPLICIT = 0x200000;
    public static final int CONTEXT_IMPLICIT = 0x800000;
    public static final int CONTEXT_EXPLICIT = 0xA00000;
    public static final int APP_IMPLICIT = 0x400000;
    public static final int APP_EXPLICIT = 0x600000;
    public static final int PRIVATE_IMPLICIT = 0xC00000;
    public static final int PRIVATE_EXPLICIT = 0xE00000;
    public static final int ANY = 65280;
    public static final int UNLISTED_OID = 0x1000000;
    public static final int CONSTRUCTED = 8192;
    protected static final int PRIMITIVE = 0;
    public static final int SEQUENCE = 12288;
    public static final int SET = 12544;
    public static final int BOOLEAN = 256;
    public static final int INTEGER = 512;
    public static final int ENUMERATED = 2560;
    public static final int BIT_STRING = 768;
    public static final int OCTET_STRING = 1024;
    public static final int NULL_STRING = 1280;
    public static final int UTF8_STRING = 3072;
    public static final int NUMERIC_STRING = 4608;
    public static final int PRINT_STRING = 4864;
    public static final int TELETEX_STRING = 5120;
    public static final int IA5_STRING = 5632;
    public static final int UNIVERSAL_STRING = 7168;
    public static final int BMP_STRING = 7680;
    public static final int OBJECT_ID = 1536;
    public static final int UTC_TIME = 5888;
    public static final int GEN_TIME = 6144;
    public static final int SEQUENCE_TAG = 48;
    protected static final int OBJECT_ID_TAG = 6;
    public static final int NULL_TAG = 5;
    public static final int NO_TAG = 0;
    static final int INDEFINITE_LENGTH = 0x4000000;
    static final int TAG_MASK = 255;
    static final int TYPE_MASK = 65280;
    static final int OPT_MASK = 983040;
    static final int PLICIT_MASK = 0xE00000;
    static final int OID_MASK = 0x3000000;
    static final int TYPE_SHIFT = 8;
    static final int PLICIT_SHIFT = 16;
    static final int END = 0;
    static final int CHOICE = 16128;
    static final int ENCODE_TAG = 127;
    static final int CON_OCTET_TAG = 36;
    static final int CON_BIT_TAG = 35;
    static final int CON_UTF8_TAG = 44;
    static final int CON_PRINT_TAG = 51;
    static final int CON_TELETEX_TAG = 52;
    static final int CON_IA5_TAG = 54;
    static final int CON_UNIVERSAL_TAG = 60;
    static final int CON_BMP_TAG = 62;
    public static final int NO_SPECIAL = 0;

    public static byte[] derEncode(ASN1Container[] aSN1ContainerArray) throws ASN_Exception {
        ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
        int n = aSN1Template.derEncodeInit();
        byte[] byArray = new byte[n];
        if ((n = aSN1Template.derEncode(byArray, 0)) == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static int berDecode(byte[] byArray, int n, ASN1Container[] aSN1ContainerArray) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1.berDecode: encoding should not be null.");
        }
        ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
        aSN1Template.berDecodeInit();
        int n2 = aSN1Template.berDecodeUpdate(byArray, n, byArray.length - n);
        aSN1Template.berDecodeFinal();
        return n2;
    }
}

