/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public abstract class ASN1Container {
    public boolean dataPresent;
    public byte[] data;
    public int dataOffset;
    public int dataLen;
    protected int explicitTag = -1;
    protected int explicitLength;
    protected int theTag;
    protected int bracketTag = -1;
    protected int subTag;
    protected int theLength;
    protected int special = 0;
    protected int optionTag;
    boolean aConstructed;
    boolean encoded;
    protected boolean createBuffer = false;
    protected int state;
    static final int ZEROES_MASK = 65535;
    static final int WRITE_TAG = 65536;
    static final int NEW_DATA = 131072;
    static final int NO_MORE_DATA = 262144;
    protected static final int CHECK_TAG = 0x100000;
    protected static final int CHECK_EXPLICIT_TAG = 0x200000;
    static final int NOT_OPTIONAL = 0x400000;
    protected static final int CANNOT_CONTINUE = 0x1000000;
    protected static final int COMPLETE = 0x2000000;
    static final int OF_BER_ENCODE_INIT = 0x10000000;
    static final int OF_NO_MORE_CONTAINERS = 0x20000000;
    protected int bytesAvailable = 0;
    protected boolean appendData = false;
    protected int maxBufferSize = 0;

    protected ASN1Container() {
    }

    protected ASN1Container(int n, int n2) {
        this(n, true, 0, n2);
    }

    protected ASN1Container(int n, int n2, int n3) {
        this(n, true, 0, n2, n3);
    }

    protected ASN1Container(int n, boolean bl, int n2, int n3) {
        this(n, bl, n2, n3, 0);
    }

    protected ASN1Container(int n, boolean bl, int n2, int n3, int n4) {
        if (n >= 0) {
            this.special = n;
        }
        this.dataPresent = bl;
        this.optionTag = n2;
        this.subTag = n3;
        this.maxBufferSize = n4;
        if ((n3 & 0x2000) != 0) {
            this.aConstructed = true;
        }
    }

    public void setExtendedTag(int n) throws ASN_Exception {
        if (this.bracketTag != -1) {
            throw new ASN_Exception("Extended tag already set.");
        }
        if (n < 0 || n > 0x1FFFFFF) {
            throw new ASN_Exception("Invalid extended tag value.");
        }
        if (n < 31) {
            this.special |= n;
            return;
        }
        this.bracketTag = n;
    }

    protected void setTag() {
        if ((this.state & 0x2000000) != 0) {
            this.state &= 0xFDFFFFFF;
            this.state |= 0x20000;
        }
        if ((this.special & 0x20000) != 0) {
            this.optionTag = 0;
        }
        this.theTag = this.subTag >>> 8;
        int n = this.special & 0xE00000;
        if (n == 0) {
            return;
        }
        n >>>= 16;
        if (this.aConstructed) {
            n |= 0x20;
        }
        if (this.bracketTag == -1) {
            n |= this.special & 0xFF;
        } else {
            n |= 0x1F;
            int n2 = this.bracketTag;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                int n5 = (n2 & 0x7F) << n4;
                if (n4 != 0) {
                    n5 |= 128 << n4;
                }
                n3 |= n5;
                if ((n2 >>>= 7) == 0) break;
                n4 += 8;
            }
            n <<= n4 + 8;
            n |= n3;
        }
        if ((this.special & 0x200000) != 0) {
            this.explicitTag = n;
        } else {
            this.theTag = n;
        }
    }

    public boolean isComplete() {
        return (this.state & 0x2000000) != 0;
    }

    public boolean checkTag() {
        return (this.state & 0x100000) != 0;
    }

    public void addData(byte[] byArray, int n, int n2, boolean bl, boolean bl2) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Container.addData: encoding should not be null.");
        }
        if (n < 0 || n >= byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: offset is out of range.");
        }
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: len is out of range.");
        }
        if (bl) {
            if ((this.state & 0x2000000) != 0) {
                this.state ^= 0x2000000;
            }
        } else {
            if ((this.special & 0x4000000) == 0) {
                throw new ASN_Exception("This type is not allowed to accept new data.");
            }
            if ((this.state & 0x2000000) != 0) {
                throw new ASN_Exception("The container cannot accept new data, already encoded.");
            }
        }
        if ((this.state & 0x40000) != 0 && byArray != null) {
            throw new ASN_Exception("The container cannot accept new data any more.");
        }
        this.data = byArray;
        this.state |= 0x20000;
        if (byArray == null) {
            if (!bl2) {
                throw new ASN_Exception("Cannot add null newData unless dataComplete is true.");
            }
            this.dataOffset = 0;
            this.dataLen = 0;
            this.state ^= 0x20000;
            this.state |= 0x40000;
            return;
        }
        this.dataOffset = n;
        this.dataLen = n2;
        this.dataPresent = true;
        if (bl2) {
            this.state |= 0x40000;
        }
    }

    public void noMoreData() throws ASN_Exception {
        this.state |= 0x40000;
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.setTag();
        this.state |= 0x40000;
        if (!this.dataPresent) {
            return this.dataNotPresent(false, null, 0);
        }
        if (this.encoded) {
            return this.dataLen;
        }
        this.theLength = this.dataLen;
        int n2 = ASN1Lengths.getTagLen(this.theTag) + this.theLength + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.explicitTag == -1) {
            return n2;
        }
        this.explicitLength = n2;
        return ASN1Lengths.getTagLen(this.explicitTag) + this.explicitLength + ASN1Lengths.getLengthLen(n2);
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        this.state = 0x2000000;
        if (!this.dataPresent) {
            return this.dataNotPresent(true, byArray, n2);
        }
        int n3 = n2;
        if (this.explicitTag != -1) {
            n2 += ASN1Lengths.writeTag(byArray, n2, this.explicitTag);
            n2 += ASN1Lengths.writeLength(byArray, n2, this.explicitLength);
        }
        n2 += ASN1Lengths.writeTag(byArray, n2, this.theTag);
        n2 += ASN1Lengths.writeLength(byArray, n2, this.theLength);
        if (this.data != null) {
            if (n2 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.derEncode: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n2, this.dataLen);
            n2 += this.dataLen;
        }
        return n2 - n3;
    }

    protected int dataNotPresent(boolean bl, byte[] byArray, int n) throws ASN_Exception {
        if ((this.special & 0x10000) != 0 && this.optionTag == 5) {
            if (bl) {
                byArray[n] = 5;
                byArray[n + 1] = 0;
            }
            return 2;
        }
        if ((this.special & 0xF0000) != 0) {
            return 0;
        }
        int n2 = 2;
        if (this.explicitTag != -1) {
            if (bl) {
                byArray[n] = (byte)this.explicitTag;
                byArray[n + 1] = 2;
            }
            n2 += 2;
            n += 2;
        }
        if (bl) {
            byArray[n] = (byte)this.theTag;
            byArray[n + 1] = 0;
        }
        return n2;
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.setTag();
        this.theLength = this.dataLen;
        if ((this.special & 0x4000000) != 0 && (this.state & 0x40000) == 0) {
            this.theTag |= 0x20;
            this.theLength = -1;
        } else {
            this.state |= 0x40000;
        }
        this.state |= 0x10000;
    }

    int berEncodeUpdate(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (this.state == 0) {
            throw new ASN_Exception("Cannot continue BER encoding without new data.");
        }
        if ((this.state & 0x2000000) != 0) {
            return 0;
        }
        if (!this.dataPresent) {
            this.state = 0x2000000;
            return this.dataNotPresent(true, byArray, n2);
        }
        int n3 = n2;
        if ((this.state & 0x10000) != 0) {
            n2 += this.writeTagBER(byArray, n2);
        }
        if ((this.state & 0x20000) != 0) {
            n2 += this.writeDataBER(aSN1ContainerArray, n, byArray, n2);
        }
        if ((this.state & 0x40000) != 0) {
            n2 += this.finishData(byArray, n2);
        }
        return n2 - n3;
    }

    protected int writeTagBER(byte[] byArray, int n) throws ASN_Exception {
        int n2 = n;
        if (this.explicitTag != -1) {
            n += ASN1Lengths.writeTag(byArray, n, this.explicitTag);
            byArray[n++] = -128;
        }
        n += ASN1Lengths.writeTag(byArray, n, this.theTag);
        if (this.theLength == -1) {
            byArray[n++] = -128;
        } else {
            n += ASN1Lengths.writeLength(byArray, n, this.theLength);
        }
        this.state ^= 0x10000;
        return n - n2;
    }

    protected int writeDataBER(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        if (this.data != null && this.dataLen != 0) {
            if (this.theLength == -1) {
                byArray[n2++] = (byte)(this.subTag >>> 8);
                n2 += ASN1Lengths.writeLength(byArray, n2, this.dataLen);
            }
            if (n2 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.writeDataBER: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n2, this.dataLen);
            n2 += this.dataLen;
        }
        this.state ^= 0x20000;
        return n2 - n3;
    }

    protected int finishData(byte[] byArray, int n) {
        this.state = 0x2000000;
        int n2 = n;
        if (this.theLength == -1) {
            byArray[n] = 0;
            byArray[n + 1] = 0;
            n += 2;
        }
        if (this.explicitTag != -1) {
            byArray[n] = 0;
            byArray[n + 1] = 0;
            n += 2;
        }
        return n - n2;
    }

    void initializeForDecode() {
        this.setEntryEmpty();
        this.setTag();
        this.state = 0x100000;
        if (this.explicitTag != -1) {
            this.state |= 0x200000;
        }
        this.dataPresent = true;
    }

    void setEntryEmpty() {
        this.explicitLength = 0;
        this.theLength = 0;
        this.clearSensitiveData();
    }

    int berDecodeUpdate(ASN1Template aSN1Template, int n, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4;
        block3: {
            this.clearSensitiveData();
            n4 = n2;
            this.bytesAvailable = n3 - n2;
            if ((this.state & 0x100000) != 0) {
                int n5 = this.checkTagAndLen(aSN1Template, n, byArray, n2, this.bytesAvailable);
                if ((this.state & 0x1000000) != 0 || (this.state & 0x2000000) != 0) {
                    return n5;
                }
                this.state |= 0x400000;
                n2 += n5;
                this.bytesAvailable -= n5;
            }
            if (this.bytesAvailable < 1 && this.theLength != 0) break block3;
            do {
                n2 += this.berDecodeData(aSN1Template, n, byArray, n2);
            } while ((this.state & 0x1000000) == 0 && (this.state & 0x2000000) == 0 && this.bytesAvailable >= 1);
        }
        return n2 - n4;
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3;
        int n4 = n2;
        if (this.theLength > 0) {
            n3 = this.theLength;
            if (this.bytesAvailable < this.theLength) {
                n3 = this.bytesAvailable;
            }
            if (this.appendData) {
                this.appendNewData(byArray, n2, n3);
            } else {
                if (this.maxBufferSize != 0 && this.maxBufferSize >= n3) {
                    this.data = new byte[this.maxBufferSize];
                    System.arraycopy(byArray, n2, this.data, 0, n3);
                    this.dataOffset = 0;
                } else {
                    this.data = byArray;
                    this.dataOffset = n2;
                }
                this.dataLen = n3;
            }
            this.theLength -= n3;
            n2 += n3;
            if (this.theLength > 0) {
                this.state |= 0x1000000;
                return n2 - n4;
            }
            this.bytesAvailable -= n3;
        }
        n3 = this.checkNextBytes(aSN1Template, byArray, n2, this.bytesAvailable);
        n2 += n3;
        this.bytesAvailable -= n3;
        if ((this.state & 0x1000000) != 0 || (this.state & 0x2000000) != 0) {
            return n2 - n4;
        }
        this.state |= 0x100000;
        n3 = this.checkTagAndLen(aSN1Template, n, byArray, n2, this.bytesAvailable);
        n2 += n3;
        if ((this.state & 0x1000000) != 0) {
            return n2 - n4;
        }
        this.bytesAvailable -= n3;
        if (this.bytesAvailable < 1) {
            this.state |= 0x1000000;
        }
        this.appendData = true;
        return n2 - n4;
    }

    protected int checkNextBytes(ASN1Template aSN1Template, byte[] byArray, int n, int n2) throws ASN_Exception {
        int n3 = this.state & 0xFFFF;
        if (n3 == 0) {
            this.state = 0x2000000;
            return 0;
        }
        if (n2 < 1) {
            return 0;
        }
        int n4 = n;
        int n5 = this.placeTagAndLen(aSN1Template, byArray, n, n2);
        n += n5;
        if ((this.state & 0x1000000) != 0) {
            return n - n4;
        }
        n2 -= n5;
        if (aSN1Template.tagAndLen[0] == 0) {
            if (aSN1Template.tagAndLen[1] != 0) {
                throw new ASN_Exception("Improper ending to indefinite length.");
            }
            this.state -= 2;
            aSN1Template.tagAndLenLen = 0;
            if ((n3 -= 2) == 0) {
                this.state = 0x2000000;
                return n - n4;
            }
            n += this.checkNextBytes(aSN1Template, byArray, n, n2);
            return n - n4;
        }
        if (this.explicitLength == -1 && n3 == 2) {
            throw new ASN_Exception("Improper ending to indefinite length.");
        }
        return n - n4;
    }

    protected void appendNewData(byte[] byArray, int n, int n2) {
        if (n2 < 1) {
            return;
        }
        if (this.data == null && this.maxBufferSize != 0) {
            this.data = new byte[this.maxBufferSize];
        }
        if (this.data != null && this.data.length > this.dataLen + n2) {
            System.arraycopy(byArray, n, this.data, this.dataLen, n2);
            this.dataLen += n2;
            return;
        }
        byte[] byArray2 = new byte[this.dataLen + n2];
        if (this.data != null) {
            System.arraycopy(this.data, this.dataOffset, byArray2, 0, this.dataLen);
        }
        System.arraycopy(byArray, n, byArray2, this.dataLen, n2);
        if (this.createBuffer) {
            this.clearSensitiveData();
        }
        this.data = byArray2;
        this.dataOffset = 0;
        this.dataLen = byArray2.length;
        this.createBuffer = true;
    }

    protected int checkTagAndLen(ASN1Template aSN1Template, int n, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = n2;
        int n5 = this.placeTagAndLen(aSN1Template, byArray, n2, n3);
        if ((this.state & 0x1000000) != 0) {
            return n5;
        }
        n2 += n5;
        n3 -= n5;
        if ((this.state & 0x200000) != 0) {
            if (!this.sameTag(aSN1Template, this.explicitTag)) {
                this.checkOptional(aSN1Template, n);
                return n2 - n4;
            }
            this.state ^= 0x200000;
            this.explicitLength = ASN1Lengths.determineLength(aSN1Template.tagAndLen, aSN1Template.tagLen);
            if (this.explicitLength == -1) {
                this.state += 2;
            }
            aSN1Template.tagAndLenLen = 0;
            n5 = this.placeTagAndLen(aSN1Template, byArray, n2, n3);
            n2 += n5;
            n3 -= n5;
            if ((this.state & 0x1000000) != 0) {
                return n2 - n4;
            }
        }
        if (this.sameTag(aSN1Template, this.theTag)) {
            this.theLength = ASN1Lengths.determineLength(aSN1Template.tagAndLen, aSN1Template.tagLen);
            if (this.theLength == -1) {
                if ((aSN1Template.tagAndLen[0] & 0x20) == 0) {
                    throw new ASN_Exception("Invalid indefinite length octet.");
                }
                this.state += 2;
            }
            this.state ^= 0x100000;
            aSN1Template.tagAndLenLen = 0;
            return n2 - n4;
        }
        int n6 = 32;
        n6 <<= (aSN1Template.tagLen - 1) * 8;
        if ((this.special & 0x4000000) != 0 && this.sameTag(aSN1Template, n6 |= this.theTag)) {
            this.theLength = ASN1Lengths.determineLength(aSN1Template.tagAndLen, aSN1Template.tagLen);
            if (this.theLength != -1) {
                throw new ASN_Exception("Primitive promoted to constructed must be indefinite length.");
            }
            this.state ^= 0x100000;
            this.state += 2;
            this.theTag = this.subTag >>> 8;
            aSN1Template.tagAndLenLen = 0;
            return n2 - n4;
        }
        if (this.explicitTag != -1) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        this.checkOptional(aSN1Template, n);
        return n2 - n4;
    }

    protected int placeTagAndLen(ASN1Template aSN1Template, byte[] byArray, int n, int n2) throws ASN_Exception {
        this.state |= 0x1000000;
        int n3 = n;
        int n4 = this.tagAndLenBytesNeeded(aSN1Template);
        while (n4 > 0) {
            if (n2 < 1) break;
            aSN1Template.tagAndLen[aSN1Template.tagAndLenLen] = byArray[n];
            --n2;
            ++aSN1Template.tagAndLenLen;
            ++n;
            if (--n4 >= 1) continue;
            n4 = this.tagAndLenBytesNeeded(aSN1Template);
        }
        if (n4 < 1) {
            this.state ^= 0x1000000;
        }
        return n - n3;
    }

    protected int tagAndLenBytesNeeded(ASN1Template aSN1Template) throws ASN_Exception {
        if (aSN1Template.tagAndLenLen == 0) {
            return 1;
        }
        int n = 1;
        aSN1Template.tagLen = 1;
        if ((aSN1Template.tagAndLen[0] & 0x1F) == 31) {
            while (n < aSN1Template.tagAndLenLen) {
                if ((aSN1Template.tagAndLen[n] & 0x80) == 0) break;
                ++n;
            }
            if (n >= aSN1Template.tagAndLenLen) {
                return 1;
            }
            aSN1Template.tagLen = ++n;
        }
        if (n >= aSN1Template.tagAndLenLen) {
            return 1;
        }
        int n2 = n;
        return (n2 += ASN1Lengths.determineLengthLen(aSN1Template.tagAndLen, n)) - aSN1Template.tagAndLenLen;
    }

    protected boolean sameTag(ASN1Template aSN1Template, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < aSN1Template.tagLen) {
            n2 = n2 << 8 | aSN1Template.tagAndLen[n3] & 0xFF;
            ++n3;
        }
        return n2 == n;
    }

    protected void checkOptional(ASN1Template aSN1Template, int n) throws ASN_Exception {
        if ((this.state & 0x400000) != 0) {
            throw new ASN_Exception("Invalid encoding: expected tag or data not there.");
        }
        if ((this.special & 0x10000) != 0 && aSN1Template.tagAndLenLen > 0 && aSN1Template.tagAndLen[0] == 5) {
            this.dataPresent = false;
            this.optionTag = 5;
            if (aSN1Template.tagAndLen[1] != 0) {
                throw new ASN_Exception("Length after NULL not zero.");
            }
            this.state |= 0x2000000;
            aSN1Template.tagAndLenLen = 0;
            return;
        }
        if ((this.special & 0xF0000) == 0) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        this.dataPresent = false;
        this.state |= 0x2000000;
    }

    boolean compareTag(int n, ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        if ((this.state & 0x2000000) != 0) {
            return false;
        }
        if (n == 5 && (this.special & 0x10000) != 0) {
            return true;
        }
        if (this.explicitTag != -1) {
            return n == this.explicitTag;
        }
        if (n == this.theTag) {
            return true;
        }
        return (this.special & 0x4000000) != 0 && n == (this.theTag | 0x20);
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return false;
    }

    protected ASN1Container getBlankCopy() {
        return null;
    }

    public void clearSensitiveData() {
        if (this.data != null && this.createBuffer) {
            int n = 0;
            while (n < this.data.length) {
                this.data[n] = 0;
                ++n;
            }
        }
        this.data = null;
        this.dataOffset = 0;
        this.dataLen = 0;
        this.createBuffer = false;
    }
}

