/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN_Exception;

public class ASN1Lengths {
    public static int getTagLen(int n) {
        int n2 = 1;
        while ((n >>>= 8) != 0) {
            ++n2;
        }
        return n2;
    }

    public static int getLengthLen(int n) throws ASN_Exception {
        if (n < 0) {
            throw new ASN_Exception("ASN1Lengths.getLengthLen: dataLen should not be negative.");
        }
        int n2 = 1;
        if (n > 127) {
            ++n2;
            if (n > 255) {
                ++n2;
                if (n > 65535) {
                    ++n2;
                    if (n > 0xFFFFFF) {
                        ++n2;
                    }
                }
            }
        }
        return n2;
    }

    public static int writeTag(byte[] byArray, int n, int n2) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Lengths.writeTag: encoding should not be null.");
        }
        if (n < 0 || n >= byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeTag: offset is out of range.");
        }
        int n3 = ASN1Lengths.getTagLen(n2);
        if (n + n3 > byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeTag: tag falls off of encoding array.");
        }
        int n4 = n + n3 - 1;
        while (n4 >= n) {
            byArray[n4] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
            --n4;
        }
        return n3;
    }

    public static int writeLength(byte[] byArray, int n, int n2) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Lengths.writeLength: encoding should not be null.");
        }
        if (n < 0 || n >= byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeLength: offset is out of range.");
        }
        int n3 = ASN1Lengths.getLengthLen(n2);
        if (n + n3 > byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeLength: length falls off of encoding array.");
        }
        int n4 = n3;
        if (n3 > 1) {
            byArray[n] = (byte)(0x80 | n3 - 1);
            ++n;
            --n3;
        }
        int n5 = n + n3 - 1;
        while (n5 >= n) {
            byArray[n5] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
            --n5;
        }
        return n4;
    }

    public static int determineLengthLen(byte[] byArray, int n) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Lengths.determineLengthLen: encoding should not be null.");
        }
        if (n < 0 || n >= byArray.length) {
            throw new ASN_Exception("ASN1Lengths.determineLengthLen: offset is out of range.");
        }
        int n2 = byArray[n] & 0xFF;
        switch (n2) {
            case 129: {
                return 2;
            }
            case 130: {
                return 3;
            }
            case 131: {
                return 4;
            }
            case 132: {
                return 5;
            }
        }
        return 1;
    }

    public static int determineLength(byte[] byArray, int n) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Lengths.determineLength: encoding should not be null.");
        }
        if (n < 0 || n >= byArray.length) {
            throw new ASN_Exception("ASN1Lengths.determineLength: offset is out of range.");
        }
        int n2 = byArray[n] & 0xFF;
        switch (n2) {
            case 129: {
                if (n + 1 >= byArray.length) {
                    throw new ASN_Exception("ASN1Lengths.determineLength: not enough room in encoding for 0x81.");
                }
                return byArray[n + 1] & 0xFF;
            }
            case 130: {
                if (n + 2 >= byArray.length) {
                    throw new ASN_Exception("ASN1Lengths.determineLength: not enough room in encoding for 0x82.");
                }
                int n3 = (byArray[n + 1] & 0xFF) << 8;
                return n3 |= byArray[n + 2] & 0xFF;
            }
            case 131: {
                if (n + 3 >= byArray.length) {
                    throw new ASN_Exception("ASN1Lengths.determineLength: not enough room in encoding for 0x83.");
                }
                int n4 = (byArray[n + 1] & 0xFF) << 16;
                n4 |= (byArray[n + 2] & 0xFF) << 8;
                return n4 |= byArray[n + 3] & 0xFF;
            }
            case 132: {
                if (n + 4 >= byArray.length) {
                    throw new ASN_Exception("ASN1Lengths.determineLength: not enough room in encoding for 0x84.");
                }
                int n5 = (byArray[n + 1] & 0xFF) << 24;
                n5 |= (byArray[n + 2] & 0xFF) << 16;
                n5 |= (byArray[n + 3] & 0xFF) << 8;
                return n5 |= byArray[n + 4] & 0xFF;
            }
            case 128: {
                return -1;
            }
        }
        return n2;
    }
}

