/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;

public class ASN1Template {
    ASN1Container[] asn1Def;
    int numberOfEntries;
    byte[] tagAndLen;
    int tagLen;
    int tagAndLenLen;
    private boolean completed;

    public ASN1Template(ASN1Container[] aSN1ContainerArray) {
        if (aSN1ContainerArray == null) {
            aSN1ContainerArray = new ASN1Container[]{};
        }
        this.numberOfEntries = aSN1ContainerArray.length;
        this.asn1Def = aSN1ContainerArray;
    }

    public int derEncodeInit() throws ASN_Exception {
        this.completed = false;
        int n = 0;
        int n2 = 0;
        while (n < this.numberOfEntries) {
            n2 += this.asn1Def[n].derEncodeInit(this.asn1Def, n);
            if (this.asn1Def[n].aConstructed && (n = ASN1Template.findLastIndex(this.asn1Def, n)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n;
        }
        return n2;
    }

    public int derEncode(byte[] byArray, int n) throws ASN_Exception {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n2 = 0;
        int n3 = n;
        while (n2 < this.numberOfEntries) {
            n += this.asn1Def[n2].derEncode(this.asn1Def, n2, byArray, n);
            if (this.asn1Def[n2].aConstructed && (n2 = ASN1Template.findLastIndex(this.asn1Def, n2)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n2;
        }
        this.completed = true;
        return n - n3;
    }

    public void berEncodeInit() throws ASN_Exception {
        this.completed = false;
        int n = 0;
        while (n < this.numberOfEntries) {
            this.asn1Def[n].berEncodeInit(this.asn1Def, n);
            if (this.asn1Def[n].aConstructed && (n = ASN1Template.findLastIndex(this.asn1Def, n)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n;
        }
    }

    public int berEncodeUpdate(byte[] byArray, int n) throws ASN_Exception {
        int n2 = 0;
        int n3 = n;
        while (n2 < this.numberOfEntries) {
            if ((this.asn1Def[n2].state & 0x2000000) == 0) {
                n += this.asn1Def[n2].berEncodeUpdate(this.asn1Def, n2, byArray, n);
                if ((this.asn1Def[n2].state & 0x2000000) == 0) break;
                if (this.asn1Def[n2].aConstructed && (n2 = ASN1Template.findLastIndex(this.asn1Def, n2)) == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
            }
            ++n2;
        }
        if (n2 >= this.numberOfEntries) {
            this.completed = true;
        }
        return n - n3;
    }

    public int berEncodeFinal(byte[] byArray, int n) throws ASN_Exception {
        int n2 = 0;
        int n3 = n;
        while (n2 < this.numberOfEntries) {
            if ((this.asn1Def[n2].state & 0x2000000) == 0) {
                this.asn1Def[n2].state |= 0x40000;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numberOfEntries) {
            if ((this.asn1Def[n2].state & 0x2000000) == 0) {
                n += this.asn1Def[n2].berEncodeUpdate(this.asn1Def, n2, byArray, n);
                if (this.asn1Def[n2].aConstructed && (n2 = ASN1Template.findLastIndex(this.asn1Def, n2)) == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
            }
            ++n2;
        }
        if (n2 >= this.numberOfEntries) {
            this.completed = true;
        }
        return n - n3;
    }

    public void berDecodeInit() {
        this.completed = false;
        int n = 0;
        while (n < this.numberOfEntries) {
            this.asn1Def[n].initializeForDecode();
            ++n;
        }
        this.tagAndLen = new byte[10];
        this.tagAndLenLen = 0;
    }

    public int berDecodeUpdate(byte[] byArray, int n, int n2) throws ASN_Exception {
        if (byArray == null || n < 0 || byArray.length < n + n2) {
            throw new ASN_Exception("The encoding is null.");
        }
        int n3 = 0;
        int n4 = n;
        while (n3 < this.numberOfEntries) {
            if ((this.asn1Def[n3].state & 0x2000000) != 0) {
                n3 = this.setEntryDecodeEmpty(n3);
                --n3;
            } else {
                int n5 = this.asn1Def[n3].berDecodeUpdate(this, n3, byArray, n, n2 + n);
                n += n5;
                n2 -= n5;
                if ((this.asn1Def[n3].state & 0x2000000) == 0) break;
                if (this.asn1Def[n3].aConstructed && (n3 = ASN1Template.findLastIndex(this.asn1Def, n3)) == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
            }
            ++n3;
        }
        if (n3 >= this.numberOfEntries) {
            this.completed = true;
        }
        return n - n4;
    }

    public void berDecodeFinal() throws ASN_Exception {
        if (this.completed) {
            return;
        }
        int n = 0;
        this.tagAndLenLen = 0;
        while (n < this.numberOfEntries) {
            n = this.checkComplete(n);
            if (this.asn1Def[n].aConstructed && (n = ASN1Template.findLastIndex(this.asn1Def, n)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n;
        }
        this.completed = true;
    }

    int checkComplete(int n) throws ASN_Exception {
        int n2 = n;
        if (this.asn1Def[n].aConstructed) {
            n2 = ASN1Template.findLastIndex(this.asn1Def, n);
            if (n2 == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
        } else if (this.asn1Def[n].isComplete()) {
            return n2;
        }
        if (n == n2) {
            this.asn1Def[n].checkOptional(this, n);
            return n2;
        }
        int n3 = n + 1;
        while (n3 < n2) {
            n3 = this.checkComplete(n3);
            ++n3;
        }
        this.asn1Def[n].state = 0x2000000;
        return n2;
    }

    public boolean isComplete() {
        return this.completed;
    }

    static int findLastIndex(ASN1Container[] aSN1ContainerArray, int n) {
        int n2 = 1;
        int n3 = n;
        while (n2 > 0) {
            if (n3 >= aSN1ContainerArray.length) break;
            if (aSN1ContainerArray[++n3].aConstructed) {
                ++n2;
            }
            if (aSN1ContainerArray[n3].theTag != -1) continue;
            --n2;
        }
        if (n2 > 0) {
            return -1;
        }
        return n3;
    }

    int setEntryDecodeEmpty(int n) {
        this.asn1Def[n].setEntryEmpty();
        this.asn1Def[n].dataPresent = false;
        this.asn1Def[n].state = 0x2000000;
        if (this.asn1Def[n].aConstructed) {
            ++n;
            while (this.asn1Def[n].theTag != -1) {
                n = this.setEntryDecodeEmpty(n);
            }
        }
        return ++n;
    }
}

