/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class BitStringContainer
extends ASN1Container {
    public static final boolean NAMED = true;
    public static final boolean UNNAMED = false;
    private static final int USE_ALL_BITS = -1;
    private int numberOfBits;
    private int unusedBits;

    public BitStringContainer(int n) {
        this(n, true, 0, 0, 0, false);
    }

    public BitStringContainer(int n, int n2) {
        this(n, true, 0, 0, n2, true);
    }

    public BitStringContainer(int n, boolean bl, int n2, int n3, byte[] byArray, int n4, int n5) throws ASN_Exception {
        this(n, bl, n2, byArray, n4, n5, -1, false);
        this.maxBufferSize = n3;
    }

    public BitStringContainer(int n, boolean bl, int n2, int n3, int n4, boolean bl2) {
        super(n, bl, n2, 768);
        this.special |= 0x4000000;
        this.numberOfBits = n4;
        if (this.numberOfBits > 32) {
            this.numberOfBits %= 32;
        }
        if (this.numberOfBits < 0) {
            this.numberOfBits = 0;
        }
        int n5 = -1 << 32 - this.numberOfBits;
        this.data = new byte[4];
        this.data[0] = (byte)((n3 &= n5) >>> 24 & 0xFF);
        this.data[1] = (byte)(n3 >>> 16 & 0xFF);
        this.data[2] = (byte)(n3 >>> 8 & 0xFF);
        this.data[3] = (byte)(n3 & 0xFF);
        this.createBuffer = true;
        this.dataLen = (n4 + 7) / 8;
        this.dataLen = BitStringContainer.setLength(this.data, this.dataOffset, this.dataLen, bl2);
        this.unusedBits = BitStringContainer.setUnusedBits(this.data, this.dataOffset, this.dataLen, this.numberOfBits, bl2);
        this.state |= 0x60000;
    }

    public BitStringContainer(int n, boolean bl, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        this(n, bl, n2, byArray, n3, n4, -1, false);
    }

    public BitStringContainer(int n, boolean bl, int n2, int n3, byte[] byArray, int n4, int n5, int n6, boolean bl2) throws ASN_Exception {
        this(n, bl, n2, byArray, n4, n5, n6, bl2);
        this.maxBufferSize = n3;
    }

    public BitStringContainer(int n, boolean bl, int n2, byte[] byArray, int n3, int n4, int n5, boolean bl2) throws ASN_Exception {
        super(n, bl, n2, 768);
        this.special |= 0x4000000;
        this.numberOfBits = n5;
        this.dataLen = n4;
        if (byArray == null) {
            return;
        }
        this.data = byArray;
        if (n3 < 0 || n3 >= byArray.length) {
            throw new ASN_Exception("BitStringContainer.BitStringContainer: dataOffset is out of range.");
        }
        this.dataOffset = n3;
        if (n4 < 0 || n3 + n4 > byArray.length) {
            throw new ASN_Exception("BitStringContainer.BitStringContainer: dataLen is out of range.");
        }
        if (n5 < 0) {
            n5 = n4 * 8;
        }
        if (n5 < n4 * 8) {
            this.dataLen = (n5 + 7) / 8;
            int n6 = n5 % 8;
            if (n6 != 0) {
                n6 = 255 >>> n6;
            }
            if ((n6 = this.data[this.dataOffset + this.dataLen - 1] & n6) != 0) {
                byte[] byArray2 = new byte[this.dataLen];
                System.arraycopy(this.data, this.dataOffset, byArray2, 0, this.dataLen);
                int n7 = byArray2.length - 1;
                byArray2[n7] = (byte)(byArray2[n7] ^ n6);
                this.data = byArray2;
                this.dataOffset = 0;
                this.createBuffer = true;
            }
        }
        this.dataLen = BitStringContainer.setLength(this.data, this.dataOffset, this.dataLen, bl2);
        this.unusedBits = BitStringContainer.setUnusedBits(this.data, this.dataOffset, this.dataLen, n5, bl2);
        this.state |= 0x20000;
        if (bl2) {
            this.state |= 0x40000;
        }
    }

    public int getValueAsInt() throws ASN_Exception {
        if (this.dataLen > 4) {
            throw new ASN_Exception("Cannot represent bit string in 32 bits.");
        }
        int n = -1 << this.unusedBits;
        int n2 = 0;
        int n3 = 24;
        int n4 = this.dataOffset;
        while (n3 >= 32 - this.dataLen * 8) {
            n2 |= (this.data[n4] & 0xFF) << n3;
            n3 -= 8;
            ++n4;
        }
        return n2 & n;
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.setTag();
        this.state |= 0x40000;
        if (!this.dataPresent) {
            return this.dataNotPresent(false, null, 0);
        }
        this.theLength = this.dataLen;
        if (this.theLength != 0) {
            ++this.theLength;
        }
        int n2 = ASN1Lengths.getTagLen(this.theTag) + this.theLength + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.explicitTag == -1) {
            return n2;
        }
        this.explicitLength = n2;
        return ASN1Lengths.getTagLen(this.explicitTag) + this.explicitLength + ASN1Lengths.getLengthLen(n2);
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        this.state = 0x2000000;
        if (!this.dataPresent) {
            return this.dataNotPresent(true, byArray, n2);
        }
        int n3 = n2;
        if (this.explicitTag != -1) {
            n2 += ASN1Lengths.writeTag(byArray, n2, this.explicitTag);
            n2 += ASN1Lengths.writeLength(byArray, n2, this.explicitLength);
        }
        n2 += ASN1Lengths.writeTag(byArray, n2, this.theTag);
        n2 += ASN1Lengths.writeLength(byArray, n2, this.theLength);
        if (this.theLength != 0) {
            if (n2 >= byArray.length) {
                throw new ASN_Exception("BitStringContainer.derEncode: not enough room in encoding to put unusedBits");
            }
            byArray[n2++] = (byte)this.unusedBits;
        }
        if (this.data != null) {
            if (n2 + this.dataLen > byArray.length) {
                throw new ASN_Exception("BitStringContainer.derEncode: not enough room in encoding to put data");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n2, this.dataLen);
            n2 += this.dataLen;
        }
        return n2 - n3;
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) {
        this.setTag();
        if ((this.state & 0x40000) == 0) {
            this.theTag |= 0x20;
            this.theLength = -1;
        } else {
            this.theLength = this.dataLen;
            if (this.theLength != 0) {
                ++this.theLength;
            }
        }
        this.state |= 0x10000;
    }

    protected int writeTagBER(byte[] byArray, int n) throws ASN_Exception {
        int n2 = n;
        n += super.writeTagBER(byArray, n);
        if (this.theLength != 0) {
            if (byArray == null) {
                throw new ASN_Exception("BitStringContainer.writeTagBER: encoding should not be null.");
            }
            if (n < 0 || n >= byArray.length) {
                throw new ASN_Exception("BitStringContainer.writeTagBER: offset is out of range.");
            }
            byArray[n++] = (byte)this.unusedBits;
        }
        return n - n2;
    }

    void setEntryEmpty() {
        super.setEntryEmpty();
        this.unusedBits = -1;
        this.numberOfBits = 0;
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        if (this.unusedBits == -1 && this.theLength != 0) {
            this.unusedBits = (byte)(byArray[n2++] & 0xFF);
            --this.bytesAvailable;
            if (this.theLength != -1) {
                --this.theLength;
            }
        }
        if (this.bytesAvailable >= 1) {
            n2 += super.berDecodeData(aSN1Template, n, byArray, n2);
        }
        return n2 - n3;
    }

    private static int setLength(byte[] byArray, int n, int n2, boolean bl) {
        if (!bl) {
            return n2;
        }
        int n3 = n2;
        int n4 = n + (n2 - 1);
        while (n4 >= n) {
            if (byArray[n4] != 0) break;
            --n4;
            --n3;
        }
        return n3;
    }

    private static int setUnusedBits(byte[] byArray, int n, int n2, int n3, boolean bl) {
        if (n2 == 0) {
            return 0;
        }
        if (!bl) {
            int n4 = 8 - n3 % 8;
            if (n4 == 8) {
                n4 = 0;
            }
            return n4;
        }
        int n5 = byArray[n + n2 - 1] & 0xFF;
        int n6 = 0;
        while (n6 < 7) {
            int n7 = n5 >>> n6 & 1;
            if (n7 != 0) {
                return n6;
            }
            ++n6;
        }
        return 7;
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof BitStringContainer;
    }

    protected ASN1Container getBlankCopy() {
        try {
            return new BitStringContainer(this.special, true, this.optionTag, null, 0, 0, this.numberOfBits, false);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

