/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class BooleanContainer
extends ASN1Container {
    public boolean value;

    public BooleanContainer(int n) {
        this(n, true, 0, false);
    }

    public BooleanContainer(int n, boolean bl, int n2, boolean bl2) {
        super(n, bl, n2, 256);
        this.data = new byte[1];
        this.createBuffer = true;
        this.value = bl2;
        if (bl2) {
            this.data[0] = -1;
        }
        this.dataLen = 1;
        this.dataOffset = 0;
        this.state |= 0x20000;
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (this.createBuffer) {
            this.clearSensitiveData();
        }
        int n3 = super.berDecodeData(aSN1Template, n, byArray, n2);
        if ((this.state & 0x1000000) != 0) {
            return n3;
        }
        if (this.dataLen != 1) {
            throw new ASN_Exception("Invalid length for BOOLEAN.");
        }
        if (!this.dataPresent) {
            return n3;
        }
        this.value = this.data[this.dataOffset] != 0;
        return n3;
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof BooleanContainer;
    }

    protected ASN1Container getBlankCopy() {
        return new BooleanContainer(this.special, true, this.optionTag, true);
    }
}

