/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public abstract class CharacterStringContainer
extends ASN1Container {
    public static final int UNLIMITED_LENGTH = -1;
    protected int octetsPerChar;
    protected boolean charactersChecked;
    protected int minLen;
    protected int maxLen;

    protected CharacterStringContainer(int n, int n2, int n3) throws ASN_Exception {
        this(n, n2, n3, -1, -1);
    }

    protected CharacterStringContainer(int n, int n2, int n3, int n4, int n5) throws ASN_Exception {
        this(n, true, 0, n2, n3, n4, n5);
    }

    private CharacterStringContainer(int n, boolean bl, int n2, int n3, int n4, int n5, int n6) throws ASN_Exception {
        super(n, bl, n2, n3);
        n |= 0x4000000;
        this.setOctetsPerChar(n4);
        if (n5 < 0) {
            n5 = -1;
        }
        if (n6 < 0) {
            n6 = -1;
        }
        if (n5 != -1 && n6 != -1 && n5 > n6) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: maxLen should be larger than minLen.");
        }
        this.minLen = n5;
        this.maxLen = n6;
    }

    protected CharacterStringContainer(int n, boolean bl, int n2, int n3, String string, int n4, int n5, int n6) throws ASN_Exception {
        this(n, bl, n2, n3, n4, n5, n6);
        if (string == null) {
            return;
        }
        this.data = CharacterStringContainer.convertStringToByteArray(string, n4);
        this.createBuffer = true;
        this.dataLen = this.data.length;
        this.dataOffset = 0;
        this.checkCharacters(true);
        this.state |= 0x20000;
    }

    protected CharacterStringContainer(int n, boolean bl, int n2, int n3, byte[] byArray, int n4, int n5, int n6, int n7, int n8, int n9) throws ASN_Exception {
        this(n, bl, n2, n3, n6, n8, n9);
        this.dataLen = n5;
        if (byArray == null) {
            return;
        }
        this.data = byArray;
        if (n4 < 0 || n4 >= byArray.length) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: dataOffset is out of range.");
        }
        this.dataOffset = n4;
        if (n5 < 0 || n4 + n5 > byArray.length) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: dataLen is out of range.");
        }
        if (n7 < 1) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: bytesPerCharacter should be a positive integer.");
        }
        this.convertToByteArray(n6, n7);
        this.checkCharacters(true);
        this.state |= 0x20000;
    }

    protected CharacterStringContainer(int n, boolean bl, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7, int n8, int n9, int n10) throws ASN_Exception {
        this(n, bl, n2, n3, byArray, n5, n6, n7, n8, n9, n10);
        this.maxBufferSize = n4;
    }

    protected void checkCharacters(boolean bl) throws ASN_Exception {
        if (!this.dataPresent) {
            return;
        }
        if (bl) {
            if (((this.state & 0x2000000) != 0 || (this.state & 0x40000) != 0) && this.minLen != -1 && this.dataLen < this.minLen * this.octetsPerChar) {
                throw new ASN_Exception("Invalid String length (too short).");
            }
            if (this.maxLen != -1 && this.dataLen > this.maxLen * this.octetsPerChar) {
                throw new ASN_Exception("Invalid String length (too long).");
            }
        }
    }

    public void addData(byte[] byArray, int n, int n2, boolean bl, boolean bl2) throws ASN_Exception {
        super.addData(byArray, n, n2, bl, bl2);
        this.convertToByteArray(this.octetsPerChar, 1);
        this.charactersChecked = false;
        this.checkCharacters(true);
    }

    public void addData(String string, boolean bl, boolean bl2) throws ASN_Exception {
        if (string == null) {
            throw new ASN_Exception("CharacterStringContainer.addData: newStringData should not be null.");
        }
        byte[] byArray = CharacterStringContainer.convertStringToByteArray(string, this.octetsPerChar);
        super.addData(byArray, 0, byArray.length, bl, bl2);
        this.createBuffer = true;
        this.charactersChecked = false;
        this.checkCharacters(true);
    }

    public void noMoreData() throws ASN_Exception {
        this.state |= 0x40000;
        this.checkCharacters(true);
    }

    public String getValueAsString() {
        if (this.data == null || this.dataLen == 0) {
            return new String();
        }
        if (this.octetsPerChar == 1) {
            return new String(this.data, this.dataOffset, this.dataLen);
        }
        char[] cArray = new char[(this.dataLen + this.octetsPerChar - 1) / this.octetsPerChar];
        int n = 0;
        int n2 = this.dataOffset + (this.octetsPerChar - 2);
        while (n < cArray.length) {
            cArray[n] = (char)((char)(this.data[n2] << 8) | (char)(this.data[n2 + 1] & 0xFF));
            ++n;
            n2 += this.octetsPerChar;
        }
        return new String(cArray);
    }

    private static byte[] convertStringToByteArray(String string, int n) {
        char[] cArray = string.toCharArray();
        byte[] byArray = null;
        switch (n) {
            case 1: {
                return string.getBytes();
            }
            case 2: {
                byArray = new byte[cArray.length * 2];
                int n2 = 0;
                while (n2 < cArray.length) {
                    byArray[2 * n2] = (byte)((cArray[n2] & 0xFF00) >>> 8);
                    byArray[2 * n2 + 1] = (byte)(cArray[n2] & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 4: {
                byArray = new byte[cArray.length * 4];
                int n3 = 0;
                while (n3 < cArray.length) {
                    byArray[4 * n3 + 2] = (byte)((cArray[n3] & 0xFF00) >>> 8);
                    byArray[4 * n3 + 3] = (byte)(cArray[n3] & 0xFF);
                    ++n3;
                }
                return byArray;
            }
        }
        return byArray;
    }

    private void convertToByteArray(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.dataLen / n2 * n;
        byte[] byArray = new byte[n3];
        if (n < n2) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.dataLen) {
                int n6 = n5 + (n2 - n);
                int n7 = 0;
                while (n7 < n) {
                    byArray[n4] = this.data[n5 + this.dataOffset];
                    ++n7;
                    ++n4;
                }
                n5 += n2;
            }
        } else {
            int n8 = this.dataOffset;
            int n9 = 0;
            while (n9 < n3) {
                int n10 = n9 + (n - n2);
                int n11 = 0;
                while (n11 < n2) {
                    byArray[n10] = this.data[n8 + this.dataOffset];
                    ++n11;
                    ++n10;
                    ++n8;
                }
                n9 += n;
            }
        }
        this.data = byArray;
        this.dataOffset = 0;
        this.dataLen = n3;
        this.createBuffer = true;
    }

    void setEntryEmpty() {
        super.setEntryEmpty();
    }

    int berDecodeUpdate(ASN1Template aSN1Template, int n, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = super.berDecodeUpdate(aSN1Template, n, byArray, n2, n3);
        this.charactersChecked = false;
        this.checkCharacters(false);
        return n4;
    }

    private void setOctetsPerChar(int n) throws ASN_Exception {
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new ASN_Exception("CharacterStringContainer.setOctetsPerChar: octetsPerCharacter should be 1, 2, or 4");
            }
        }
        this.octetsPerChar = n;
    }
}

