/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class ChoiceContainer
extends ASN1Container {
    private int chosenIndex;

    public ChoiceContainer(int n) {
        this(n, 0);
    }

    public ChoiceContainer(int n, int n2) {
        super(n, true, n2, 16128);
        this.aConstructed = true;
        this.state |= 0x20000;
        this.special = n;
        int n3 = this.special & 0xE00000;
        if (n3 == 0) {
            return;
        }
        this.special |= 0x200000;
        n3 |= 0x200000;
        this.explicitTag = (n3 >>>= 16) | this.special & 0xFF;
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.dataPresent = true;
        this.dataLen = 0;
        int n2 = ASN1Template.findLastIndex(aSN1ContainerArray, n);
        if (n2 == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        this.chosenIndex = -1;
        int n3 = n + 1;
        while (n3 < n2) {
            aSN1ContainerArray[n3].special |= 0x40000;
            if (this.chosenIndex == -1) {
                this.dataLen = aSN1ContainerArray[n3].derEncodeInit(aSN1ContainerArray, n3);
                if (aSN1ContainerArray[n3].dataPresent) {
                    this.chosenIndex = n3;
                }
            } else {
                aSN1ContainerArray[n3].dataPresent = false;
            }
            if (aSN1ContainerArray[n3].aConstructed && (n3 = ASN1Template.findLastIndex(aSN1ContainerArray, n3)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n3;
        }
        if (this.chosenIndex != -1) {
            if (this.explicitTag != -1) {
                return ASN1Lengths.getTagLen(this.explicitTag) + this.dataLen + ASN1Lengths.getLengthLen(this.dataLen);
            }
            return this.dataLen;
        }
        this.dataPresent = false;
        return this.dataNotPresent(false, null, 0);
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (!this.dataPresent) {
            return this.dataNotPresent(true, byArray, n2);
        }
        int n3 = 0;
        if (this.explicitTag != -1) {
            n3 = ASN1Lengths.writeTag(byArray, n2, this.explicitTag);
            n3 += ASN1Lengths.writeLength(byArray, n2 + n3, this.dataLen);
            n2 += n3;
        }
        this.state = 0x2000000;
        return n3 + aSN1ContainerArray[this.chosenIndex].derEncode(aSN1ContainerArray, this.chosenIndex, byArray, n2);
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.dataPresent = true;
        int n2 = ASN1Template.findLastIndex(aSN1ContainerArray, n);
        if (n2 == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        this.state = 196608;
        this.chosenIndex = -1;
        int n3 = n + 1;
        while (n3 < n2) {
            aSN1ContainerArray[n3].special |= 0x40000;
            if (this.chosenIndex == -1) {
                if (aSN1ContainerArray[n3].dataPresent) {
                    aSN1ContainerArray[n3].berEncodeInit(aSN1ContainerArray, n3);
                    this.chosenIndex = n3;
                }
            } else {
                aSN1ContainerArray[n3].dataPresent = false;
                aSN1ContainerArray[n3].state = 0x2000000;
            }
            if (aSN1ContainerArray[n3].aConstructed && (n3 = ASN1Template.findLastIndex(aSN1ContainerArray, n3)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n3;
        }
        this.state |= 0x10000;
        if (this.chosenIndex != -1) {
            return;
        }
        this.dataPresent = false;
    }

    int berEncodeUpdate(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if ((this.state & 0x2000000) != 0) {
            return 0;
        }
        if (!this.dataPresent) {
            this.state = 0x2000000;
            return this.dataNotPresent(true, byArray, n2);
        }
        int n3 = n2;
        if (this.explicitTag != -1 && (this.state & 0x10000) != 0) {
            byArray[n2] = (byte)this.explicitTag;
            byArray[n2 + 1] = -128;
            n2 += 2;
        }
        if ((this.state & 0x10000) != 0) {
            this.state ^= 0x10000;
        }
        n2 += aSN1ContainerArray[this.chosenIndex].berEncodeUpdate(aSN1ContainerArray, this.chosenIndex, byArray, n2);
        if (aSN1ContainerArray[this.chosenIndex].isComplete()) {
            this.state = 0x2000000;
            if (this.explicitTag != -1) {
                byArray[n2] = 0;
                byArray[n2 + 1] = 0;
                n2 += 2;
            }
        }
        return n2 - n3;
    }

    void initializeForDecode() {
        this.setEntryEmpty();
        this.state = 0;
        this.state = 0x100000;
        if (this.explicitTag != -1) {
            this.state |= 0x200000;
        }
        this.dataPresent = false;
    }

    /*
     * Unable to fully structure code
     */
    protected int checkTagAndLen(ASN1Template var1_1, int var2_2, byte[] var3_3, int var4_4, int var5_5) throws ASN_Exception {
        var6_6 = var4_4;
        var7_7 = this.placeTagAndLen(var1_1, var3_3, var4_4, var5_5);
        if ((this.state & 0x1000000) != 0) {
            return var7_7;
        }
        var4_4 += var7_7;
        var5_5 -= var7_7;
        if ((this.state & 0x200000) != 0) {
            if ((var1_1.tagAndLen[0] & 255) != this.explicitTag) {
                this.checkOptional(var1_1, var2_2);
                return var4_4 - var6_6;
            }
            this.state ^= 0x200000;
            this.explicitLength = ASN1Lengths.determineLength(var1_1.tagAndLen, 1);
            if (this.explicitLength == -1) {
                this.state += 2;
            }
            var1_1.tagAndLenLen = 0;
            var7_7 = this.placeTagAndLen(var1_1, var3_3, var4_4, var5_5);
            var4_4 += var7_7;
            var5_5 -= var7_7;
            if ((this.state & 0x1000000) != 0) {
                return var4_4 - var6_6;
            }
        }
        if ((var8_8 = ASN1Template.findLastIndex(var1_1.asn1Def, var2_2)) == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        this.chosenIndex = var2_2 + 1;
        var9_9 = var1_1.tagAndLen[0] & 255;
        while (this.chosenIndex < var8_8) {
            block11: {
                if (!var1_1.asn1Def[this.chosenIndex].compareTag(var9_9, var1_1.asn1Def, this.chosenIndex)) break block11;
                var10_10 = this.chosenIndex + 1;
                this.dataPresent = true;
                if (!var1_1.asn1Def[this.chosenIndex].aConstructed || (var10_10 = ASN1Template.findLastIndex(var1_1.asn1Def, this.chosenIndex) + 1) != 0) ** GOTO lbl36
                throw new ASN_Exception("EndContainer is missing.");
lbl-1000:
                // 1 sources

                {
                    var1_1.setEntryDecodeEmpty(var10_10);
                    if (var1_1.asn1Def[var10_10].aConstructed && (var10_10 = ASN1Template.findLastIndex(var1_1.asn1Def, var10_10)) == -1) {
                        throw new ASN_Exception("EndContainer is missing.");
                    }
                    ++var10_10;
lbl36:
                    // 2 sources

                    ** while (var10_10 < var8_8)
                }
lbl37:
                // 1 sources

                this.state ^= 0x100000;
                return var4_4 - var6_6;
            }
            var1_1.setEntryDecodeEmpty(this.chosenIndex);
            if (var1_1.asn1Def[this.chosenIndex].aConstructed) {
                this.chosenIndex = ASN1Template.findLastIndex(var1_1.asn1Def, this.chosenIndex);
                if (this.chosenIndex == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
            }
            ++this.chosenIndex;
        }
        this.checkOptional(var1_1, var2_2);
        return var4_4 - var6_6;
    }

    protected void checkOptional(ASN1Template aSN1Template, int n) throws ASN_Exception {
        super.checkOptional(aSN1Template, n);
        int n2 = ASN1Template.findLastIndex(aSN1Template.asn1Def, n);
        if (n2 == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        int n3 = n + 1;
        while (n3 < n2) {
            aSN1Template.setEntryDecodeEmpty(n3);
            if (aSN1Template.asn1Def[n3].aConstructed) {
                this.chosenIndex = ASN1Template.findLastIndex(aSN1Template.asn1Def, n3);
                if (this.chosenIndex == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
            }
            ++n3;
        }
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = aSN1Template.asn1Def[this.chosenIndex].berDecodeUpdate(aSN1Template, this.chosenIndex, byArray, n2, n2 + this.bytesAvailable);
        if (aSN1Template.asn1Def[this.chosenIndex].isComplete()) {
            this.state = 0x2000000;
        }
        return n3;
    }

    boolean compareTag(int n, ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        if ((this.state & 0x2000000) != 0) {
            return false;
        }
        int n3 = ASN1Template.findLastIndex(aSN1ContainerArray, n2);
        if (n3 == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        int n4 = n2 + 1;
        while (n4 < n3) {
            if (aSN1ContainerArray[n4].compareTag(n, aSN1ContainerArray, n4)) {
                return true;
            }
            if (aSN1ContainerArray[n4].aConstructed && (n4 = ASN1Template.findLastIndex(aSN1ContainerArray, n4)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n4;
        }
        return false;
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof ChoiceContainer;
    }

    protected ASN1Container getBlankCopy() {
        return new ChoiceContainer(this.special, this.optionTag);
    }
}

