/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class CompositeContainer
extends ASN1Container {
    private ASN1Container[] asn1Def;
    private ASN1Template asn1Template;

    public CompositeContainer(ASN1Container[] aSN1ContainerArray) {
        if (aSN1ContainerArray != null) {
            this.asn1Def = new ASN1Container[aSN1ContainerArray.length];
            System.arraycopy(aSN1ContainerArray, 0, this.asn1Def, 0, aSN1ContainerArray.length);
            this.asn1Template = new ASN1Template(this.asn1Def);
        }
    }

    public ASN1Container[] getContainers() {
        if (this.asn1Def == null) {
            return null;
        }
        ASN1Container[] aSN1ContainerArray = new ASN1Container[this.asn1Def.length];
        System.arraycopy(this.asn1Def, 0, aSN1ContainerArray, 0, this.asn1Def.length);
        return aSN1ContainerArray;
    }

    public void setContainers(ASN1Container[] aSN1ContainerArray) {
        if (aSN1ContainerArray != null) {
            this.asn1Def = new ASN1Container[aSN1ContainerArray.length];
            System.arraycopy(aSN1ContainerArray, 0, this.asn1Def, 0, aSN1ContainerArray.length);
            this.asn1Template = new ASN1Template(this.asn1Def);
        }
    }

    protected void setTag() {
        if ((this.state & 0x2000000) != 0) {
            this.state &= 0xFDFFFFFF;
            this.state |= 0x20000;
        }
        if (this.asn1Def != null) {
            this.explicitTag = this.asn1Def[0].explicitTag;
            this.theTag = this.asn1Def[0].theTag;
        }
    }

    public boolean isComplete() {
        if (this.asn1Template == null) {
            return false;
        }
        return this.asn1Template.isComplete();
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        if (this.asn1Template == null) {
            throw new ASN_Exception("The ASN1 containers are not set.");
        }
        this.dataLen = this.asn1Template.derEncodeInit();
        this.setTag();
        return this.dataLen;
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (this.asn1Template == null) {
            throw new ASN_Exception("The ASN1 containers are not set.");
        }
        return this.asn1Template.derEncode(byArray, n2);
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.state = 131072;
        this.asn1Template.berEncodeInit();
        this.setTag();
    }

    int berEncodeUpdate(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (this.asn1Template == null) {
            throw new ASN_Exception("The ASN1 containers are not set.");
        }
        this.state = 0x1000000;
        int n3 = this.asn1Template.berEncodeUpdate(byArray, n2);
        if (this.asn1Template.isComplete()) {
            this.state = 0x2000000;
        }
        return n3;
    }

    void initializeForDecode() {
        this.setEntryEmpty();
        this.setTag();
        this.state = 0x100000;
        if (this.explicitTag != -1) {
            this.state |= 0x200000;
        }
        this.dataPresent = true;
        this.asn1Template.berDecodeInit();
    }

    int berDecodeUpdate(ASN1Template aSN1Template, int n, byte[] byArray, int n2, int n3) throws ASN_Exception {
        if (this.asn1Template == null) {
            throw new ASN_Exception("The ASN1 containers are not set.");
        }
        if (aSN1Template.tagAndLenLen != 0) {
            System.arraycopy(aSN1Template.tagAndLen, 0, this.asn1Template.tagAndLen, 0, aSN1Template.tagAndLenLen);
            this.asn1Template.tagAndLenLen = aSN1Template.tagAndLenLen;
            aSN1Template.tagAndLenLen = 0;
        }
        int n4 = this.asn1Template.berDecodeUpdate(byArray, n2, n3 - n2);
        if (this.asn1Template.isComplete()) {
            this.state |= 0x2000000;
        }
        return n4;
    }

    boolean compareTag(int n, ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        if (this.asn1Def == null) {
            return false;
        }
        return this.asn1Def[0].compareTag(n, this.asn1Def, 0);
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        if (!(aSN1Container instanceof CompositeContainer)) {
            return false;
        }
        CompositeContainer compositeContainer = (CompositeContainer)aSN1Container;
        if (this.asn1Def == null) {
            return compositeContainer.asn1Def == null;
        }
        if (this.asn1Def.length != compositeContainer.asn1Def.length) {
            return false;
        }
        return this.asn1Def[0].sameType(compositeContainer.asn1Def[0]);
    }

    protected ASN1Container getBlankCopy() {
        if (this.asn1Def == null) {
            return new CompositeContainer(null);
        }
        int n = this.asn1Def.length;
        ASN1Container[] aSN1ContainerArray = new ASN1Container[n];
        int n2 = 0;
        while (n2 < n) {
            aSN1ContainerArray[n2] = this.asn1Def[n2].getBlankCopy();
            ++n2;
        }
        return new CompositeContainer(aSN1ContainerArray);
    }

    public void clearSensitiveData() {
        if (this.asn1Def != null) {
            int n = 0;
            while (n < this.asn1Def.length) {
                this.asn1Def[n].clearSensitiveData();
                ++n;
            }
        }
    }
}

