/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class EncodedContainer
extends ASN1Container {
    private int totalLength;
    private int previousBytes;
    private byte[] saveData;

    private EncodedContainer(int n, boolean bl, int n2) {
        super(n, bl, n2, n & 0xFF00);
        this.special |= 0x4000000;
        this.encoded = true;
        this.aConstructed = false;
    }

    private EncodedContainer(int n, boolean bl, int n2, int n3) {
        super(n, bl, n2, n & 0xFF00, n3);
        this.special |= 0x4000000;
        this.encoded = true;
        this.aConstructed = false;
    }

    public EncodedContainer(int n) {
        this(n, true, 0);
    }

    public EncodedContainer(int n, boolean bl, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        this(n, bl, n2, 0, byArray, n3, n4);
    }

    public EncodedContainer(int n, boolean bl, int n2, int n3, byte[] byArray, int n4, int n5) throws ASN_Exception {
        this(n, bl, n2, n3);
        this.dataLen = n5;
        if (byArray == null) {
            return;
        }
        this.data = byArray;
        if (n4 < 0 || n4 >= byArray.length) {
            throw new ASN_Exception("EncodedContainer.EncodedContainer: dataOffset is out of range.");
        }
        this.dataOffset = n4;
        if (n5 < 0 || n4 + n5 > byArray.length) {
            throw new ASN_Exception("EncodedContainer.EncodedContainer: dataLen is out of range.");
        }
        this.state |= 0x20000;
    }

    protected void setTag() {
        if ((this.subTag & 0x2000) != 0) {
            this.aConstructed = true;
        }
        super.setTag();
        this.aConstructed = false;
        this.previousBytes = 0;
        this.saveData = null;
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (!this.dataPresent) {
            return this.dataNotPresent(true, byArray, n2);
        }
        if (this.data == null) {
            return 0;
        }
        System.arraycopy(this.data, this.dataOffset, byArray, n2, this.dataLen);
        return this.dataLen;
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) {
        this.setTag();
        this.state ^= 0x10000;
    }

    protected int writeTagBER(byte[] byArray, int n) {
        this.state ^= 0x10000;
        return 0;
    }

    protected int finishData(byte[] byArray, int n) {
        this.state = 0x2000000;
        return 0;
    }

    protected int checkTagAndLen(ASN1Template aSN1Template, int n, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = n2;
        int n5 = this.placeTagAndLen(aSN1Template, byArray, n2, n3);
        this.previousBytes += n5;
        if (n5 == 0) {
            this.previousBytes = aSN1Template.tagAndLenLen;
        }
        if ((this.state & 0x1000000) != 0) {
            return n5;
        }
        n2 += n5;
        n3 -= n5;
        this.totalLength = ASN1Lengths.determineLength(aSN1Template.tagAndLen, 1);
        if (this.totalLength == -1) {
            this.state += 2;
            this.totalLength = 2;
        } else {
            this.totalLength += aSN1Template.tagAndLenLen;
        }
        if ((this.special & 0xFF00) == 65280) {
            if (aSN1Template.tagAndLen[0] == 0 && aSN1Template.tagAndLen[1] == 0 && aSN1Template.tagAndLenLen == 2) {
                this.checkOptional(aSN1Template, n);
                this.state = 0x2000000;
                return 0;
            }
            this.state |= 0x300000;
            this.state ^= 0x300000;
            aSN1Template.tagAndLenLen = 0;
            if (this.previousBytes == n2 - n4) {
                this.previousBytes = 0;
                return 0;
            }
            return n2 - n4;
        }
        if ((this.state & 0x200000) != 0) {
            if ((aSN1Template.tagAndLen[0] & 0xFF) != this.explicitTag) {
                this.checkOptional(aSN1Template, n);
                return n2 - n4;
            }
            this.state ^= 0x200000;
            this.saveData = new byte[aSN1Template.tagAndLenLen];
            System.arraycopy(aSN1Template.tagAndLen, 0, this.saveData, 0, aSN1Template.tagAndLenLen);
            aSN1Template.tagAndLenLen = 0;
            this.previousBytes = n5 = this.placeTagAndLen(aSN1Template, byArray, n2, n3);
            n2 += n5;
            n3 -= n5;
            if ((this.state & 0x1000000) != 0) {
                return n2 - n4;
            }
        }
        if ((aSN1Template.tagAndLen[0] & 0xFF) == this.theTag) {
            this.state ^= 0x100000;
            aSN1Template.tagAndLenLen = 0;
            if (this.previousBytes == n2 - n4) {
                this.previousBytes = 0;
                return 0;
            }
            return n2 - n4;
        }
        if ((aSN1Template.tagAndLen[0] & 0xFF) == (this.theTag | 0x20)) {
            this.state ^= 0x100000;
            aSN1Template.tagAndLenLen = 0;
            if (this.previousBytes == n2 - n4) {
                this.previousBytes = 0;
                return 0;
            }
            return n2 - n4;
        }
        if (this.explicitTag != -1) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        this.checkOptional(aSN1Template, n);
        return n2 - n4;
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3;
        int n4 = n2;
        if (this.saveData != null) {
            this.appendNewData(this.saveData, 0, this.saveData.length);
            this.appendData = true;
            this.totalLength -= this.saveData.length;
        }
        if (this.previousBytes != 0) {
            this.totalLength -= this.previousBytes;
            this.appendNewData(aSN1Template.tagAndLen, 0, this.previousBytes);
            this.appendData = true;
            this.previousBytes = 0;
            this.saveData = null;
        }
        if (this.totalLength > 0) {
            n3 = this.totalLength;
            if (this.bytesAvailable < this.totalLength) {
                n3 = this.bytesAvailable;
            }
            if (this.appendData) {
                this.appendNewData(byArray, n2, n3);
            } else {
                if (this.data == null) {
                    this.data = byArray;
                    this.dataOffset = n2;
                }
                this.dataLen += n3;
            }
            this.totalLength -= n3;
            n2 += n3;
            this.bytesAvailable -= n3;
            if (this.totalLength > 0) {
                return n2 - n4;
            }
        }
        if ((n3 = this.state & 0xFFFF) == 0) {
            this.state = 0x2000000;
            return n2 - n4;
        }
        if (this.bytesAvailable < 1) {
            return n2 - n4;
        }
        int n5 = this.placeTagAndLen(aSN1Template, byArray, n2, this.bytesAvailable);
        if ((this.state & 0x1000000) != 0) {
            this.previousBytes = n5;
            return n2 - n4;
        }
        if (aSN1Template.tagAndLen[0] == 0) {
            if (aSN1Template.tagAndLen[1] != 0) {
                throw new ASN_Exception("Improper ending to indefinite length.");
            }
            this.state -= 2;
            n3 -= 2;
            this.totalLength = 2;
            aSN1Template.tagAndLenLen = 0;
        } else if ((aSN1Template.tagAndLen[1] & 0xFF) == 128) {
            this.state += 2;
            this.totalLength = 2;
            aSN1Template.tagAndLenLen = 0;
        } else {
            this.totalLength = ASN1Lengths.determineLength(aSN1Template.tagAndLen, 1);
            this.totalLength += aSN1Template.tagAndLenLen;
            aSN1Template.tagAndLenLen = 0;
        }
        if (this.previousBytes != 0) {
            this.appendData = true;
        }
        return n2 - n4;
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof EncodedContainer;
    }

    protected ASN1Container getBlankCopy() {
        try {
            return new EncodedContainer(this.special, true, this.optionTag, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

