/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;

public class IntegerContainer
extends ASN1Container {
    public IntegerContainer(int n) {
        this(n, true, 0, 0);
    }

    public IntegerContainer(int n, boolean bl, int n2, int n3) {
        super(n, bl, n2, 512);
        this.convertInt(n3);
    }

    public IntegerContainer(int n, boolean bl, int n2, byte[] byArray, int n3, int n4, boolean bl2) throws ASN_Exception {
        super(n, bl, n2, 512);
        this.dataLen = n4;
        if (byArray == null) {
            return;
        }
        this.data = byArray;
        if (n3 < 0 || n3 >= byArray.length) {
            throw new ASN_Exception("IntegerContainer.IntegerContainer: dataOffset is out of range.");
        }
        this.dataOffset = n3;
        if (n4 < 0 || n3 + n4 > byArray.length) {
            throw new ASN_Exception("IntegerContainer.IntegerContainer: dataLen is out of range.");
        }
        this.setData(bl2);
        this.state |= 0x20000;
    }

    protected IntegerContainer(int n, boolean bl, int n2, int n3, int n4) {
        super(n, bl, n2, n4);
        this.convertInt(n3);
    }

    public int getValueAsInt() throws ASN_Exception {
        if (this.dataLen > 4) {
            throw new ASN_Exception("Cannot represent integer in 32 bits.");
        }
        int n = this.data[this.dataOffset] >= 0 ? 0 : -1;
        int n2 = 0;
        int n3 = this.dataOffset;
        while (n2 < this.dataLen) {
            n <<= 8;
            n |= this.data[n3] & 0xFF;
            ++n2;
            ++n3;
        }
        return n;
    }

    public void addData(byte[] byArray, int n, int n2, boolean bl, boolean bl2) throws ASN_Exception {
        super.addData(byArray, n, n2, bl, bl2);
        if (bl) {
            this.setData(true);
        }
    }

    public void addData(byte[] byArray, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ASN_Exception {
        super.addData(byArray, n, n2, bl2, bl3);
        if (bl2) {
            this.setData(bl);
        }
    }

    protected void convertInt(int n) {
        this.data = new byte[4];
        this.data[0] = (byte)(n >>> 24 & 0xFF);
        this.data[1] = (byte)(n >>> 16 & 0xFF);
        this.data[2] = (byte)(n >>> 8 & 0xFF);
        this.data[3] = (byte)(n & 0xFF);
        this.dataOffset = 0;
        this.dataLen = 4;
        this.createBuffer = true;
        boolean bl = n >= 0;
        this.setData(bl);
        this.state |= 0x20000;
    }

    protected int dataNotPresent(boolean bl, byte[] byArray, int n) throws ASN_Exception {
        int n2 = n;
        if ((this.special & 0x10000) != 0 && this.optionTag == 5) {
            if (bl) {
                byArray[n] = 5;
                byArray[n + 1] = 0;
            }
            return 2;
        }
        if ((this.special & 0xF0000) != 0) {
            return 0;
        }
        throw new ASN_Exception("INTEGER not allowed to have length 0.");
    }

    void setData(boolean bl) {
        int n;
        if (bl) {
            int n2 = this.dataOffset + this.dataLen;
            int n3 = this.dataOffset;
            while (n3 < n2 - 1) {
                if (this.data[n3] != 0 || this.data[n3 + 1] < 0) break;
                ++n3;
                ++this.dataOffset;
                --this.dataLen;
            }
            if (this.data[this.dataOffset] >= 0) {
                return;
            }
            byte[] byArray = new byte[this.dataLen + 1];
            System.arraycopy(this.data, this.dataOffset, byArray, 1, this.dataLen);
            if (this.createBuffer) {
                this.clearSensitiveData();
            }
            this.data = byArray;
            this.dataOffset = 0;
            ++this.dataLen;
            this.createBuffer = true;
            return;
        }
        if (this.data[this.dataOffset] >= 0) {
            byte[] byArray = new byte[this.dataLen];
            n = 1;
            int n4 = this.dataLen - 1;
            this.dataOffset += this.dataLen - 1;
            while (n4 >= 0) {
                byArray[n4] = (byte)(~this.data[this.dataOffset] + n);
                if (byArray[n4] != 0) {
                    n = 0;
                }
                --n4;
                --this.dataOffset;
            }
            if (n == 1) {
                this.dataLen = 1;
                int n5 = 0;
                while (n5 < byArray.length) {
                    byArray[n5] = 0;
                    ++n5;
                }
                return;
            }
            if (this.createBuffer) {
                this.clearSensitiveData();
            }
            this.data = byArray;
            this.dataOffset = 0;
            this.createBuffer = true;
        }
        int n6 = this.dataLen - 1;
        n = 0;
        while (n < n6) {
            if (this.data[n] != -1 || this.data[n + 1] >= 0) break;
            ++n;
            ++this.dataOffset;
            --this.dataLen;
        }
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof IntegerContainer;
    }

    protected ASN1Container getBlankCopy() {
        try {
            return new IntegerContainer(this.special, true, this.optionTag, null, 0, 0, true);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

