/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDList;

public class OIDContainer
extends ASN1Container {
    public String transformation;
    private int type = -1;

    public OIDContainer(int n) {
        this(n, -1);
    }

    public OIDContainer(int n, int n2) {
        this(n, true, 0, null);
    }

    public OIDContainer(int n, boolean bl, int n2, String string) {
        this(n, bl, n2, string, -1);
    }

    public OIDContainer(int n, boolean bl, int n2, String string, int n3) {
        super(n, bl, n2, 1536);
        if (string == null) {
            return;
        }
        if ((n & 0x1000000) == 0) {
            this.data = OIDList.getOID(string, n3);
            this.dataOffset = 0;
            this.dataLen = this.data.length;
            this.type = n3;
            this.transformation = OIDList.getTrans(this.data, this.dataOffset, this.dataLen, n3);
            this.state |= 0x20000;
        }
    }

    public OIDContainer(int n, boolean bl, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        this(n, bl, n2, byArray, n3, n4, -1);
    }

    public OIDContainer(int n, boolean bl, int n2, byte[] byArray, int n3, int n4, int n5) throws ASN_Exception {
        super(n, bl, n2, 1536);
        if (byArray != null) {
            if (n3 < 0 || n3 >= byArray.length) {
                throw new ASN_Exception("OIDContainer.OIDContainer: dataOffset is out of range.");
            }
            if (n4 < 0 || n3 + n4 > byArray.length) {
                throw new ASN_Exception("OIDContainer.OIDContainer: dataLen is out of range.");
            }
        }
        this.data = byArray;
        this.dataOffset = n3;
        this.dataLen = n4;
        if (byArray != null && (n & 0x1000000) == 0) {
            this.transformation = OIDList.getTrans(byArray, n3, n4, n5);
        }
        this.state |= 0x20000;
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (this.dataPresent && (this.special & 0x1000000) == 0 && this.transformation == null) {
            throw new ASN_Exception("No OID for this transformation.");
        }
        return super.derEncode(aSN1ContainerArray, n, byArray, n2);
    }

    int berEncodeUpdate(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        if (this.dataPresent && (this.special & 0x1000000) == 0 && this.transformation == null) {
            throw new ASN_Exception("No OID for this transformation.");
        }
        return super.berEncodeUpdate(aSN1ContainerArray, n, byArray, n2);
    }

    void setEntryEmpty() {
        super.setEntryEmpty();
        this.transformation = null;
    }

    int berDecodeUpdate(ASN1Template aSN1Template, int n, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = super.berDecodeUpdate(aSN1Template, n, byArray, n2, n3);
        if ((this.state & 0x2000000) != 0 && (this.special & 0x1000000) == 0) {
            this.transformation = OIDList.getTrans(this.data, this.dataOffset, this.dataLen, this.type);
        }
        return n4;
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof OIDContainer;
    }

    protected ASN1Container getBlankCopy() {
        return new OIDContainer(this.special, true, this.optionTag, null, -1);
    }
}

