/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

public class OIDList {
    public static final int UNKNOWN_OID = -1;
    public static final int SIGNATURE_ALGORITHM_OID = 1;
    public static final int ASYMMETRIC_CIPHER_OID = 2;
    public static final int ASYMMETRIC_KEY_OID = 3;
    public static final int PARAMETERS_OID = 4;
    public static final int KEY_AGREEMENT_OID = 5;
    public static final int SYMMETRIC_CIPHER_OID = 6;
    public static final int STREAM_CIPHER_OID = 7;
    public static final int BLOCK_CIPHER_OID = 8;
    public static final int PASSWORD_CIPHER_OID = 9;
    public static final int DIGEST_OID = 10;
    public static final int MGF_UNDERLYING_ALGORITHM_OID = 11;
    public static final int MASK_GENERATING_FUNCTION_OID = 12;
    public static final int OAEP_PARAM_OID = 13;
    public static final int DIGEST_MAC_OID = 14;
    public static final String[] transformationList = new String[]{"MD5/RSA/PKCS1Block01Pad", "SHA1/RSA/PKCS1Block01Pad", "SHA1/RSA/PKCS1Block01Pad", "MD2/RSA/PKCS1Block01Pad", "RSA/PKCS1V2PSS", "SHA1/DSA/NoPad", "SHA1/DSA/NoPad", "RSAWithSHA1ISO_OIW", "RSAWithSHA1PKCS", "DSAWithSHA1X957", "DSAWithSHA1X930", "RIPEMD160/RSA/PKCS1Block01Pad", "SHA256/RSA/PKCS1Block01Pad", "SHA384/RSA/PKCS1Block01Pad", "SHA512/RSA/PKCS1Block01Pad", "RSA/PKCS1V2OAEPPad", "RSA", "DSA", "DSA", "DSAX957", "DH", "RC4", "RC2/CBC/PKCS5Padding", "RC5/CBC/PKCS5Padding", "DES/CBC/PKCS5Padding", "DES/ECB/NoPad", "DES/CFB/NoPad", "DESX/CBC/PKCS5Padding", "3DES_EDE/CBC/PKCS5Padding", "AES128/ECB/NoPad", "AES192/ECB/NoPad", "AES256/ECB/NoPad", "AES128/CBC/NoPad", "AES192/CBC/NoPad", "AES256/CBC/NoPad", "AES128/CFB/NoPad", "AES192/CFB/NoPad", "AES256/CFB/NoPad", "PBE/MD2/DES/CBC/PKCS5PBE", "PBE/MD5/DES/CBC/PKCS5PBE", "PBE/SHA1/DES/CBC/PKCS5PBE", "PBE/MD2/RC2/CBC/PKCS5PBE", "PBE/MD5/RC2/CBC/PKCS5PBE", "PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-1-3", "PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-1-2", "PBE/SHA1/RC2/CBC/PKCS12V1PBE-1-128", "PBE/SHA1/RC2/CBC/PKCS12V1PBE-1-40", "PBE/SHA1/RC4/PKCS12V1PBE-1-128", "PBE/SHA1/RC4/PKCS12V1PBE-1-40", "PBE/HMAC/SHA1/PKIXPBE", "MD5", "MD2", "SHA256", "SHA384", "SHA512", "RIPEMD160", "SHA1", "MGF1", "SpecifiedParams", "HMAC/SHA1"};
    public static final byte[][] oidList = new byte[][]{{42, -122, 72, -122, -9, 13, 1, 1, 4}, {42, -122, 72, -122, -9, 13, 1, 1, 5}, {43, 14, 3, 2, 29}, {42, -122, 72, -122, -9, 13, 1, 1, 2}, {42, -122, 72, -122, -9, 13, 1, 1, 10}, {43, 14, 3, 2, 27}, {42, -122, 72, -50, 56, 4, 3}, {43, 14, 3, 2, 29}, {42, -122, 72, -122, -9, 13, 1, 1, 5}, {42, -122, 72, -50, 56, 4, 3}, {43, 14, 3, 2, 27}, {43, 36, 3, 3, 1, 2}, {42, -122, 72, -122, -9, 13, 1, 1, 11}, {42, -122, 72, -122, -9, 13, 1, 1, 12}, {42, -122, 72, -122, -9, 13, 1, 1, 13}, {42, -122, 72, -122, -9, 13, 1, 1, 7}, {42, -122, 72, -122, -9, 13, 1, 1, 1}, {43, 14, 3, 2, 12}, {42, -122, 72, -50, 56, 4, 1}, {42, -122, 72, -50, 56, 4, 1}, {42, -122, 72, -122, -9, 13, 1, 3, 1}, {42, -122, 72, -122, -9, 13, 3, 4}, {42, -122, 72, -122, -9, 13, 3, 2}, {42, -122, 72, -122, -9, 13, 3, 9}, {43, 14, 3, 2, 7}, {43, 14, 3, 2, 6}, {43, 14, 3, 2, 9}, {42, -122, 72, -122, -9, 13, 3, 6}, {42, -122, 72, -122, -9, 13, 3, 7}, {96, -122, 72, 1, 101, 3, 4, 1, 1}, {96, -122, 72, 1, 101, 3, 4, 1, 21}, {96, -122, 72, 1, 101, 3, 4, 1, 41}, {96, -122, 72, 1, 101, 3, 4, 1, 2}, {96, -122, 72, 1, 101, 3, 4, 1, 22}, {96, -122, 72, 1, 101, 3, 4, 1, 42}, {96, -122, 72, 1, 101, 3, 4, 1, 4}, {96, -122, 72, 1, 101, 3, 4, 1, 24}, {96, -122, 72, 1, 101, 3, 4, 1, 44}, {42, -122, 72, -122, -9, 13, 1, 5, 1}, {42, -122, 72, -122, -9, 13, 1, 5, 3}, {42, -122, 72, -122, -9, 13, 1, 5, 10}, {42, -122, 72, -122, -9, 13, 1, 5, 4}, {42, -122, 72, -122, -9, 13, 1, 5, 6}, {42, -122, 72, -122, -9, 13, 1, 12, 1, 3}, {42, -122, 72, -122, -9, 13, 1, 12, 1, 4}, {42, -122, 72, -122, -9, 13, 1, 12, 1, 5}, {42, -122, 72, -122, -9, 13, 1, 12, 1, 6}, {42, -122, 72, -122, -9, 13, 1, 12, 1, 1}, {42, -122, 72, -122, -9, 13, 1, 12, 1, 2}, {42, -122, 72, -122, -10, 125, 7, 66, 13}, {42, -122, 72, -122, -9, 13, 2, 5}, {42, -122, 72, -122, -9, 13, 2, 2}, {96, -122, 72, 1, 101, 3, 4, 2, 1}, {96, -122, 72, 1, 101, 3, 4, 2, 2}, {96, -122, 72, 1, 101, 3, 4, 2, 3}, {43, 36, 3, 2, 1}, {43, 14, 3, 2, 26}, {42, -122, 72, -122, -9, 13, 1, 1, 8}, {42, -122, 72, -122, -9, 13, 1, 1, 9}, {43, 6, 1, 5, 5, 8, 1, 2}};
    private static final int SIGNATURE_START = 0;
    private static final int SIGNATURE_END = 14;
    private static final int ASYMMETRIC_START = 15;
    private static final int ASYMMETRIC_END = 16;
    private static final int ASYM_KEY_START = 16;
    private static final int ASYM_KEY_END = 20;
    private static final int PARAMETERS_START = 17;
    private static final int PARAMETERS_END = 20;
    private static final int KEY_AGREE_START = 20;
    private static final int KEY_AGREE_END = 20;
    private static final int SYMMETRIC_START = 21;
    private static final int SYMMETRIC_END = 48;
    private static final int STREAM_START = 21;
    private static final int STREAM_END = 21;
    private static final int BLOCK_START = 22;
    private static final int BLOCK_END = 37;
    private static final int PASSWORD_START = 38;
    private static final int PASSWORD_END = 49;
    private static final int DIGEST_START = 50;
    private static final int DIGEST_END = 56;
    private static final int MGF_UNDER_START = 56;
    private static final int MGF_UNDER_END = 56;
    private static final int MGF_START = 57;
    private static final int MGF_END = 57;
    private static final int OAEP_PARAM_START = 58;
    private static final int OAEP_PARAM_END = 58;
    private static final int DIGEST_MAC_START = 59;
    private static final int DIGEST_MAC_END = 59;

    public static byte[] getOID(String string, int n) {
        int n2 = OIDList.getStartIndex(n);
        int n3 = OIDList.getEndIndex(n);
        while (n2 <= n3) {
            if (string.compareTo(transformationList[n2]) == 0) break;
            ++n2;
        }
        if (n2 > n3) {
            return new byte[0];
        }
        return (byte[])oidList[n2].clone();
    }

    public static String getTrans(byte[] byArray, int n, int n2, int n3) {
        int n4 = OIDList.getStartIndex(n3);
        int n5 = OIDList.getEndIndex(n3);
        while (n4 <= n5) {
            if (OIDList.oidCompare(byArray, n, n2, n4)) break;
            ++n4;
        }
        if (n4 > n5) {
            return null;
        }
        return transformationList[n4];
    }

    private static boolean oidCompare(byte[] byArray, int n, int n2, int n3) {
        if (n2 != oidList[n3].length) {
            return false;
        }
        if (n2 > byArray.length - n) {
            return false;
        }
        int n4 = 0;
        while (n4 < oidList[n3].length) {
            if (byArray[n] != oidList[n3][n4]) {
                return false;
            }
            ++n4;
            ++n;
        }
        return true;
    }

    private static int getStartIndex(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 15;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 17;
            }
            case 5: {
                return 20;
            }
            case 6: {
                return 21;
            }
            case 7: {
                return 21;
            }
            case 8: {
                return 22;
            }
            case 9: {
                return 38;
            }
            case 10: {
                return 50;
            }
            case 11: {
                return 56;
            }
            case 12: {
                return 57;
            }
            case 13: {
                return 58;
            }
            case 14: {
                return 59;
            }
        }
        return 0;
    }

    private static int getEndIndex(int n) {
        switch (n) {
            case 1: {
                return 14;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 20;
            }
            case 4: {
                return 20;
            }
            case 5: {
                return 20;
            }
            case 6: {
                return 48;
            }
            case 7: {
                return 21;
            }
            case 8: {
                return 37;
            }
            case 9: {
                return 49;
            }
            case 10: {
                return 56;
            }
            case 11: {
                return 56;
            }
            case 12: {
                return 57;
            }
            case 13: {
                return 58;
            }
            case 14: {
                return 59;
            }
        }
        return transformationList.length - 1;
    }
}

