/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import java.util.Vector;

public class OfContainer
extends ASN1Container {
    private int ofType;
    private ASN1Container internalContainer;
    private Vector contents;
    private int currentContainerIndex;

    public OfContainer(int n, int n2, ASN1Container aSN1Container) throws ASN_Exception {
        this(n, true, 0, n2, aSN1Container);
    }

    public OfContainer(int n, boolean bl, int n2, int n3, ASN1Container aSN1Container) throws ASN_Exception {
        super(n, bl, n2, n3);
        if (bl && aSN1Container == null) {
            throw new ASN_Exception("OfContainer.OfContainer: internalContainer should not be null if data is present.");
        }
        this.aConstructed = false;
        this.special |= 0x4000000;
        this.internalContainer = aSN1Container;
        this.ofType = n3;
    }

    public void addContainer(ASN1Container aSN1Container) throws ASN_Exception {
        if (this.state == 0 || (this.state & 0x2000000) != 0) {
            this.contents = new Vector();
            this.state = 131072;
        }
        if ((this.state & 0x20000000) != 0) {
            throw new ASN_Exception("Method noMoreData for OfContainer has been called.");
        }
        if (this.internalContainer == null) {
            throw new ASN_Exception("OfContainer.addContainer: internalContainer is null.");
        }
        if (this.internalContainer.sameType(aSN1Container)) {
            this.contents.addElement(aSN1Container);
            return;
        }
        throw new ASN_Exception("Improper internal container for OF.");
    }

    public void noMoreData() {
        this.state |= 0x20000000;
    }

    public int getContainerCount() {
        return this.contents.size();
    }

    public ASN1Container containerAt(int n) throws ASN_Exception {
        if (n < 0 || n >= this.contents.size()) {
            throw new ASN_Exception("No container at requested index.");
        }
        return (ASN1Container)this.contents.elementAt(n);
    }

    protected void setTag() {
        this.aConstructed = true;
        super.setTag();
        this.aConstructed = false;
        this.currentContainerIndex = 0;
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        int n2;
        this.dataLen = 0;
        this.setTag();
        if (this.dataPresent) {
            if (this.contents == null) {
                this.dataLen = 0;
            } else {
                n2 = 0;
                while (n2 < this.contents.size()) {
                    this.dataLen += ((ASN1Container)this.contents.elementAt(n2)).derEncodeInit(null, 0);
                    ++n2;
                }
            }
        } else {
            return this.dataNotPresent(false, null, 0);
        }
        this.theLength = this.dataLen;
        n2 = ASN1Lengths.getTagLen(this.theTag) + this.theLength + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.explicitTag == -1) {
            return n2;
        }
        this.explicitLength = n2;
        return ASN1Lengths.getTagLen(this.explicitTag) + this.explicitLength + ASN1Lengths.getLengthLen(n2);
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3;
        int n4 = n2;
        n2 += super.derEncode(aSN1ContainerArray, n, byArray, n2);
        if (!this.dataPresent || this.contents == null) {
            return n2 - n4;
        }
        int n5 = this.contents.size();
        int[] nArray = new int[n5];
        if (this.ofType == 12544) {
            n3 = 1;
            while (n3 < n5) {
                int n6 = 0;
                while (n6 < n3) {
                    if (this.compareContainerData(n3, nArray, n6)) break;
                    ++n6;
                }
                if (n6 >= n3) {
                    nArray[n3] = n3;
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n5) {
                nArray[n3] = n3;
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < n5) {
            n2 += ((ASN1Container)this.contents.elementAt(nArray[n3])).derEncode(aSN1ContainerArray, n, byArray, n2);
            ++n3;
        }
        return n2 - n4;
    }

    private boolean compareContainerData(int n, int[] nArray, int n2) {
        ASN1Container aSN1Container = (ASN1Container)this.contents.elementAt(n);
        ASN1Container aSN1Container2 = (ASN1Container)this.contents.elementAt(nArray[n2]);
        if (aSN1Container.dataLen > aSN1Container2.dataLen) {
            return false;
        }
        if (aSN1Container.dataLen < aSN1Container2.dataLen) {
            return this.insertIndex(n, nArray, n2);
        }
        int n3 = aSN1Container.dataOffset;
        int n4 = aSN1Container2.dataOffset;
        int n5 = 0;
        while (n5 < aSN1Container.dataLen) {
            if (aSN1Container.data[n3] > aSN1Container2.data[n4]) {
                return false;
            }
            if (aSN1Container.data[n3] < aSN1Container2.data[n4]) break;
            ++n5;
            ++n3;
            ++n4;
        }
        if (n5 >= aSN1Container.dataLen) {
            return false;
        }
        return this.insertIndex(n, nArray, n2);
    }

    private boolean insertIndex(int n, int[] nArray, int n2) {
        int n3 = nArray.length - 1;
        while (n3 > n2) {
            nArray[n3] = nArray[n3 - 1];
            --n3;
        }
        nArray[n2] = n;
        return true;
    }

    protected int writeDataBER(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        while (this.currentContainerIndex < this.contents.size()) {
            ASN1Container aSN1Container = (ASN1Container)this.contents.elementAt(this.currentContainerIndex);
            if ((this.state & 0x10000000) == 0) {
                aSN1Container.berEncodeInit(null, 0);
                this.state |= 0x10000000;
            }
            n2 += aSN1Container.berEncodeUpdate(null, 0, byArray, n2);
            if (!aSN1Container.isComplete()) {
                return n2 - n3;
            }
            this.state ^= 0x10000000;
            ++this.currentContainerIndex;
        }
        if ((this.state & 0x20000000) != 0) {
            this.state |= 0x40000;
        }
        return n2 - n3;
    }

    void initializeForDecode() {
        super.initializeForDecode();
        this.currentContainerIndex = 0;
        this.contents = new Vector();
    }

    /*
     * Unable to fully structure code
     */
    protected int berDecodeData(ASN1Template var1_1, int var2_2, byte[] var3_3, int var4_4) throws ASN_Exception {
        var5_5 = var4_4;
        var6_6 = this.contents.size();
        var7_7 = this.checkDecodeOfComplete(var1_1, var3_3, var4_4, this.bytesAvailable);
        if ((this.state & 0x2000000) != 0 || (this.state & 0x1000000) != 0) {
            return var7_7;
        }
        if (this.currentContainerIndex >= var6_6) ** GOTO lbl35
        var8_8 = (ASN1Container)this.contents.elementAt(this.currentContainerIndex);
        var7_7 = var8_8.berDecodeUpdate(var1_1, var2_2, var3_3, var4_4, var4_4 + this.bytesAvailable);
        if (this.theLength > 0) {
            this.theLength -= var7_7;
        }
        if ((var8_8.state & 0x2000000) == 0) {
            this.state |= 0x1000000;
            return var7_7;
        }
        var4_4 += var7_7;
        this.bytesAvailable -= var7_7;
        ++this.currentContainerIndex;
        var4_4 += this.checkDecodeOfComplete(var1_1, var3_3, var4_4, this.bytesAvailable);
        if ((this.state & 0x2000000) == 0 && (this.state & 0x1000000) == 0) ** GOTO lbl35
        return var4_4 - var5_5;
lbl-1000:
        // 1 sources

        {
            var8_8 = this.buildNewContainer();
            var8_8.initializeForDecode();
            var7_7 = var8_8.berDecodeUpdate(var1_1, var2_2, var3_3, var4_4, var4_4 + this.bytesAvailable);
            if (this.theLength > 0) {
                this.theLength -= var7_7;
            }
            var4_4 += var7_7;
            this.bytesAvailable -= var7_7;
            this.addContainer(var8_8);
            if ((var8_8.state & 0x2000000) == 0) {
                this.state |= 0x1000000;
                return var4_4 - var5_5;
            }
            ++this.currentContainerIndex;
            var4_4 += this.checkDecodeOfComplete(var1_1, var3_3, var4_4, this.bytesAvailable);
            if ((this.state & 0x2000000) == 0 && (this.state & 0x1000000) == 0) continue;
            return var4_4 - var5_5;
lbl35:
            // 3 sources

            ** while (this.bytesAvailable > 0)
        }
lbl36:
        // 1 sources

        this.state |= 0x1000000;
        return var4_4 - var5_5;
    }

    private int checkDecodeOfComplete(ASN1Template aSN1Template, byte[] byArray, int n, int n2) throws ASN_Exception {
        if (this.theLength > 0) {
            return 0;
        }
        if (this.theLength == 0) {
            this.state = 0x2000000;
            return 0;
        }
        int n3 = this.state & 0xFFFF;
        if (n3 == 0) {
            this.state = 0x2000000;
            return 0;
        }
        if (n2 < 1) {
            this.state |= 0x1000000;
            return 0;
        }
        if (this.currentContainerIndex != -1 && aSN1Template.tagAndLenLen == 0 && byArray[n] != 0) {
            return 0;
        }
        int n4 = n;
        int n5 = this.placeTagAndLen(aSN1Template, byArray, n, n2);
        n += n5;
        if ((this.state & 0x1000000) != 0) {
            return n - n4;
        }
        n2 -= n5;
        if (aSN1Template.tagAndLen[0] != 0 || aSN1Template.tagAndLen[1] != 0) {
            throw new ASN_Exception("Improper ending to indefinite length.");
        }
        this.state -= 2;
        aSN1Template.tagAndLenLen = 0;
        if ((n3 -= 2) == 0) {
            this.state = 0x2000000;
            return n - n4;
        }
        this.currentContainerIndex = -1;
        n += this.checkDecodeOfComplete(aSN1Template, byArray, n, n2);
        if ((this.state & 0x2000000) != 0 || (this.state & 0x1000000) != 0) {
            return n - n4;
        }
        throw new ASN_Exception("Improper ending to indefinite length.");
    }

    private ASN1Container buildNewContainer() {
        return this.internalContainer.getBlankCopy();
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof OfContainer;
    }

    protected ASN1Container getBlankCopy() {
        try {
            return new OfContainer(this.special, true, this.optionTag, this.ofType, this.internalContainer);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

