/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class SequenceContainer
extends ASN1Container {
    public SequenceContainer(int n) {
        this(n, true, 0);
    }

    public SequenceContainer(int n, boolean bl, int n2) {
        super(n, bl, n2, 12288);
        this.special |= 0x4000000;
        this.state |= 0x20000;
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.dataLen = 0;
        if (this.dataPresent) {
            int n2 = n + 1;
            while (aSN1ContainerArray[n2].theTag != -1) {
                this.dataLen += aSN1ContainerArray[n2].derEncodeInit(aSN1ContainerArray, n2);
                if (aSN1ContainerArray[n2].aConstructed && (n2 = ASN1Template.findLastIndex(aSN1ContainerArray, n2)) == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
                if (aSN1ContainerArray.length != ++n2) continue;
                throw new ASN_Exception("EndContainer is missing.");
            }
        }
        return super.derEncodeInit(aSN1ContainerArray, n);
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.setTag();
        this.theLength = -1;
        ++n;
        while (aSN1ContainerArray[n].theTag != -1) {
            aSN1ContainerArray[n].berEncodeInit(aSN1ContainerArray, n);
            if (aSN1ContainerArray[n].aConstructed && (n = ASN1Template.findLastIndex(aSN1ContainerArray, n)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            if (aSN1ContainerArray.length != ++n) continue;
            throw new ASN_Exception("EndContainer is missing.");
        }
        this.state |= 0x10000;
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        n2 += super.derEncode(aSN1ContainerArray, n, byArray, n2);
        if (!this.dataPresent) {
            return n2 - n3;
        }
        ++n;
        while (aSN1ContainerArray[n].theTag != -1) {
            n2 += aSN1ContainerArray[n].derEncode(aSN1ContainerArray, n, byArray, n2);
            if (aSN1ContainerArray[n].aConstructed && (n = ASN1Template.findLastIndex(aSN1ContainerArray, n)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            if (aSN1ContainerArray.length != ++n) continue;
            throw new ASN_Exception("EndContainer is missing.");
        }
        return n2 - n3;
    }

    protected int writeDataBER(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        ++n;
        while (aSN1ContainerArray[n].theTag != -1) {
            if ((aSN1ContainerArray[n].state & 0x2000000) == 0) {
                n2 += aSN1ContainerArray[n].berEncodeUpdate(aSN1ContainerArray, n, byArray, n2);
                if ((aSN1ContainerArray[n].state & 0x2000000) == 0) break;
                if (aSN1ContainerArray[n].aConstructed && (n = ASN1Template.findLastIndex(aSN1ContainerArray, n)) == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
                if (aSN1ContainerArray.length == n + 1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
            }
            ++n;
        }
        if (aSN1ContainerArray[n].theTag == -1) {
            this.state = 262144;
        }
        return n2 - n3;
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3;
        int n4;
        int n5 = n++;
        int n6 = n2;
        while (aSN1Template.asn1Def[n].theTag != -1) {
            if ((this.bytesAvailable <= 0 || this.theLength == 0) && aSN1Template.tagAndLenLen == 0) break;
            n4 = n;
            if (aSN1Template.asn1Def[n4].aConstructed && (n4 = ASN1Template.findLastIndex(aSN1Template.asn1Def, n4)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n4;
            if ((aSN1Template.asn1Def[n].state & 0x2000000) != 0) {
                n = n4;
                continue;
            }
            n3 = aSN1Template.asn1Def[n].berDecodeUpdate(aSN1Template, n, byArray, n2, n2 + this.bytesAvailable);
            n2 += n3;
            this.bytesAvailable -= n3;
            if (this.theLength >= 0) {
                this.theLength -= n3;
                if (this.theLength < 0) {
                    throw new ASN_Exception("Invalid encoding: SEQUENCE and data length do not match.");
                }
            }
            if ((aSN1Template.asn1Def[n].state & 0x2000000) == 0) {
                this.state |= 0x1000000;
                return n2 - n6;
            }
            n = n4;
            if (aSN1Template.asn1Def.length != n) continue;
            throw new ASN_Exception("EndContainer is missing.");
        }
        if (aSN1Template.asn1Def[n].theTag == -1) {
            if (this.theLength == 0) {
                this.state = 0x2000000;
                return n2 - n6;
            }
            if (this.theLength > 0) {
                throw new ASN_Exception("Invalid encoding: not enough data or containers.");
            }
            n4 = this.checkNextBytes(aSN1Template, byArray, n2, this.bytesAvailable);
            n2 += n4;
            if ((this.state & 0x1000000) != 0) {
                return n2 - n6;
            }
            if ((this.state & 0x2000000) != 0) {
                return n2 - n6;
            }
            throw new ASN_Exception("Invalid encoding: not enough data or containers.");
        }
        if (this.theLength == 0) {
            n4 = ASN1Template.findLastIndex(aSN1Template.asn1Def, n5);
            if (n4 == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            n3 = n5 + 1;
            while (n3 <= n4) {
                if (!aSN1Template.asn1Def[n3].isComplete() && aSN1Template.asn1Def[n3].theTag != -1) {
                    aSN1Template.asn1Def[n3].checkOptional(aSN1Template, n3);
                }
                ++n3;
            }
            this.state = 0x2000000;
            return n2 - n6;
        }
        this.state |= 0x1000000;
        return n2 - n6;
    }

    protected void checkOptional(ASN1Template aSN1Template, int n) throws ASN_Exception {
        super.checkOptional(aSN1Template, n);
        int n2 = ASN1Template.findLastIndex(aSN1Template.asn1Def, n);
        if (n2 == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        ++n;
        while (n < n2) {
            aSN1Template.setEntryDecodeEmpty(n);
            ++n;
        }
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof SequenceContainer;
    }

    protected ASN1Container getBlankCopy() {
        return new SequenceContainer(this.special, true, this.optionTag);
    }
}

