/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class SetContainer
extends ASN1Container {
    private int[] encodeOrder;
    private int currentDecode;
    private int decodeCount;

    public SetContainer(int n) {
        this(n, true, 0);
    }

    public SetContainer(int n, boolean bl, int n2) {
        super(n, bl, n2, 12544);
        this.special |= 0x4000000;
        this.state |= 0x20000;
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.dataLen = 0;
        if (this.dataPresent) {
            int n2 = n;
            int n3 = ASN1Template.findLastIndex(aSN1ContainerArray, n2);
            if (n3 == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            int n4 = n + 1;
            while (aSN1ContainerArray[n4].theTag != -1) {
                this.dataLen += aSN1ContainerArray[n4].derEncodeInit(aSN1ContainerArray, n4);
                if (aSN1ContainerArray[n4].aConstructed && (n4 = ASN1Template.findLastIndex(aSN1ContainerArray, n4)) == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
                if (aSN1ContainerArray.length != ++n4) continue;
                throw new ASN_Exception("EndContainer is missing.");
            }
            this.derOrderSet(aSN1ContainerArray, n2, n3);
        }
        return super.derEncodeInit(aSN1ContainerArray, n);
    }

    int derOrderSet(ASN1Container[] aSN1ContainerArray, int n, int n2) throws ASN_Exception {
        int n3 = n2 - n;
        this.encodeOrder = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.encodeOrder[n4] = -1;
            ++n4;
        }
        int n5 = n + 1;
        while (aSN1ContainerArray[n5].theTag != -1) {
            this.placeElement(aSN1ContainerArray, n5);
            if (aSN1ContainerArray[n5].aConstructed && (n5 = ASN1Template.findLastIndex(aSN1ContainerArray, n5)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            if (aSN1ContainerArray.length != ++n5) continue;
            throw new ASN_Exception("EndContainer is missing.");
        }
        return n2;
    }

    private void placeElement(ASN1Container[] aSN1ContainerArray, int n) {
        int n2 = aSN1ContainerArray[n].theTag;
        if (aSN1ContainerArray[n].explicitTag != -1) {
            n2 = aSN1ContainerArray[n].explicitTag;
        }
        int n3 = 0;
        while (n3 < this.encodeOrder.length) {
            if (this.encodeOrder[n3] == -1) {
                this.encodeOrder[n3] = n;
                break;
            }
            int n4 = aSN1ContainerArray[this.encodeOrder[n3]].theTag;
            if (aSN1ContainerArray[this.encodeOrder[n3]].explicitTag != -1) {
                n4 = aSN1ContainerArray[this.encodeOrder[n3]].explicitTag;
            }
            if (n2 < n4) {
                this.insertElement(n, n3);
                break;
            }
            ++n3;
        }
    }

    private void insertElement(int n, int n2) {
        int n3 = this.encodeOrder[n2];
        this.encodeOrder[n2] = n;
        ++n2;
        while (this.encodeOrder[n2] != -1) {
            int n4 = this.encodeOrder[n2];
            this.encodeOrder[n2] = n3;
            n3 = n4;
            ++n2;
        }
        this.encodeOrder[n2] = n3;
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.setTag();
        this.theLength = -1;
        ++n;
        while (aSN1ContainerArray[n].theTag != -1) {
            aSN1ContainerArray[n].berEncodeInit(aSN1ContainerArray, n);
            if (aSN1ContainerArray[n].aConstructed && (n = ASN1Template.findLastIndex(aSN1ContainerArray, n)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            if (aSN1ContainerArray.length != ++n) continue;
            throw new ASN_Exception("EndContainer is missing.");
        }
        this.state |= 0x10000;
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        n2 += super.derEncode(aSN1ContainerArray, n, byArray, n2);
        if (!this.dataPresent) {
            return n2 - n3;
        }
        int n4 = 0;
        while (n4 < this.encodeOrder.length && this.encodeOrder[n4] != -1) {
            n = this.encodeOrder[n4];
            if (n != -1) {
                n2 += aSN1ContainerArray[n].derEncode(aSN1ContainerArray, n, byArray, n2);
            }
            if (aSN1ContainerArray.length != ++n4) continue;
            throw new ASN_Exception("EndContainer is missing.");
        }
        return n2 - n3;
    }

    protected int writeDataBER(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        ++n;
        while (aSN1ContainerArray[n].theTag != -1) {
            if ((aSN1ContainerArray[n].state & 0x2000000) == 0) {
                n2 += aSN1ContainerArray[n].berEncodeUpdate(aSN1ContainerArray, n, byArray, n2);
                if ((aSN1ContainerArray[n].state & 0x2000000) == 0) break;
                if (aSN1ContainerArray[n].aConstructed && (n = ASN1Template.findLastIndex(aSN1ContainerArray, n)) == -1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
                if (aSN1ContainerArray.length == n + 1) {
                    throw new ASN_Exception("EndContainer is missing.");
                }
            }
            ++n;
        }
        if (aSN1ContainerArray[n].theTag == -1) {
            this.state = 262144;
        }
        return n2 - n3;
    }

    void initializeForDecode() {
        super.initializeForDecode();
        this.encodeOrder = null;
        this.currentDecode = -1;
        this.decodeCount = 0;
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        if (this.encodeOrder == null) {
            this.setDecodeFlags(aSN1Template.asn1Def, n);
        }
        int n4 = 1;
        int n5 = this.encodeOrder[n4];
        while (n5 > 0) {
            aSN1Template.asn1Def[n5].data = null;
            aSN1Template.asn1Def[n5].dataOffset = 0;
            aSN1Template.asn1Def[n5].dataLen = 0;
            if (++n4 > this.encodeOrder.length - 2) break;
            n5 = this.encodeOrder[n4];
        }
        while (this.decodeCount > 0) {
            if (this.theLength == 0) {
                return this.checkComplete(aSN1Template, n, byArray, n2, n3, this.bytesAvailable);
            }
            if (this.bytesAvailable < 1) {
                this.state |= 0x1000000;
                return n2 - n3;
            }
            if (this.theLength == -1 && byArray[n2] == 0) {
                this.checkComplete(aSN1Template, n, byArray, n2, n3, this.bytesAvailable);
                this.decodeCount = 0;
                break;
            }
            if (this.currentDecode == -1) {
                this.currentDecode = this.findContainer(byArray[n2] & 0xFF, aSN1Template.asn1Def);
                if (this.encodeOrder[this.currentDecode - this.encodeOrder[0]] != 0) {
                    throw new ASN_Exception("Unexpected tag in SET.");
                }
                this.encodeOrder[this.currentDecode - this.encodeOrder[0]] = this.currentDecode;
            }
            int n6 = aSN1Template.asn1Def[this.currentDecode].berDecodeUpdate(aSN1Template, this.currentDecode, byArray, n2, n2 + this.bytesAvailable);
            n2 += n6;
            this.bytesAvailable -= n6;
            if (this.theLength > 0) {
                this.theLength -= n6;
            }
            if ((aSN1Template.asn1Def[this.currentDecode].state & 0x2000000) == 0) {
                this.state |= 0x1000000;
                return n2 - n3;
            }
            --this.decodeCount;
            this.currentDecode = -1;
        }
        n2 += this.checkNextBytes(aSN1Template, byArray, n2, this.bytesAvailable);
        if ((this.state & 0x1000000) != 0 || (this.state & 0x2000000) != 0) {
            return n2 - n3;
        }
        throw new ASN_Exception("Improper ending to indefinite length.");
    }

    private int checkComplete(ASN1Template aSN1Template, int n, byte[] byArray, int n2, int n3, int n4) throws ASN_Exception {
        int n5 = aSN1Template.checkComplete(n);
        if (n5 != this.encodeOrder[this.encodeOrder.length - 1]) {
            throw new ASN_Exception("Invalid encoding: expected tag or data not there.");
        }
        if (this.theLength == -1) {
            this.state = 2;
        }
        return n2 - n3;
    }

    private void setDecodeFlags(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        int n2 = ASN1Template.findLastIndex(aSN1ContainerArray, n);
        if (n2 == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        this.encodeOrder = new int[n2 - n + 1];
        this.encodeOrder[0] = n++;
        this.encodeOrder[this.encodeOrder.length - 1] = n2;
        while (n < n2) {
            if (aSN1ContainerArray[n].aConstructed && (n = ASN1Template.findLastIndex(aSN1ContainerArray, n)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n;
            ++this.decodeCount;
        }
    }

    private int findContainer(int n, ASN1Container[] aSN1ContainerArray) throws ASN_Exception {
        int n2 = this.encodeOrder[0] + 1;
        int n3 = this.encodeOrder[this.encodeOrder.length - 1];
        while (n2 < n3) {
            if (aSN1ContainerArray[n2].compareTag(n, aSN1ContainerArray, n2)) {
                return n2;
            }
            if (aSN1ContainerArray[n2].aConstructed && (n2 = ASN1Template.findLastIndex(aSN1ContainerArray, n2)) == -1) {
                throw new ASN_Exception("EndContainer is missing.");
            }
            ++n2;
        }
        throw new ASN_Exception("Unexpected tag in SET.");
    }

    protected void checkOptional(ASN1Template aSN1Template, int n) throws ASN_Exception {
        super.checkOptional(aSN1Template, n);
        int n2 = ASN1Template.findLastIndex(aSN1Template.asn1Def, n);
        if (n2 == -1) {
            throw new ASN_Exception("EndContainer is missing.");
        }
        ++n;
        while (n < n2) {
            aSN1Template.setEntryDecodeEmpty(n);
            ++n;
        }
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof SetContainer;
    }

    protected ASN1Container getBlankCopy() {
        return new SetContainer(this.special, true, this.optionTag);
    }
}

