/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public class WrapContainer
extends ASN1Container {
    private int wrapType;
    private int unusedBits;
    private ASN1Container internalContainer;

    public WrapContainer(int n, int n2, ASN1Container aSN1Container) throws ASN_Exception {
        this(n, true, 0, n2, aSN1Container);
    }

    public WrapContainer(int n, boolean bl, int n2, int n3, ASN1Container aSN1Container) throws ASN_Exception {
        super(n, bl, n2, n3);
        this.setInternalContainer(aSN1Container);
        this.state |= 0x20000;
        this.wrapType = n3;
        if ((aSN1Container.special & 0x4000000) != 0) {
            this.special |= 0x4000000;
        }
    }

    public void setContainer(ASN1Container aSN1Container) throws ASN_Exception {
        if ((this.state & 0x20000000) != 0) {
            throw new ASN_Exception("Method noMoreData for WrapContainer has been called.");
        }
        this.setInternalContainer(aSN1Container);
    }

    public void noMoreData() {
        this.state |= 0x20000000;
    }

    public ASN1Container getContainer() {
        return this.internalContainer;
    }

    int derEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        this.dataLen = 0;
        this.setTag();
        if (this.dataPresent) {
            this.dataLen += this.internalContainer.derEncodeInit(null, 0);
        } else {
            return this.dataNotPresent(false, null, 0);
        }
        this.theLength = this.dataLen;
        if (this.wrapType == 768) {
            ++this.theLength;
        }
        int n2 = ASN1Lengths.getTagLen(this.theTag) + this.theLength + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.explicitTag == -1) {
            return n2;
        }
        this.explicitLength = n2;
        return ASN1Lengths.getTagLen(this.explicitTag) + this.explicitLength + ASN1Lengths.getLengthLen(n2);
    }

    int derEncode(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        n2 += super.derEncode(aSN1ContainerArray, n, byArray, n2);
        if (!this.dataPresent) {
            return n2 - n3;
        }
        if (this.wrapType == 768) {
            byArray[n2] = 0;
            ++n2;
        }
        n2 += this.internalContainer.derEncode(aSN1ContainerArray, n, byArray, n2);
        return n2 - n3;
    }

    void berEncodeInit(ASN1Container[] aSN1ContainerArray, int n) throws ASN_Exception {
        super.berEncodeInit(aSN1ContainerArray, n);
        this.internalContainer.berEncodeInit(null, 0);
    }

    protected int writeTagBER(byte[] byArray, int n) throws ASN_Exception {
        int n2 = n;
        n += super.writeTagBER(byArray, n);
        if (this.wrapType == 768 && this.theLength != 0) {
            byArray[n++] = 0;
        }
        return n - n2;
    }

    protected int writeDataBER(ASN1Container[] aSN1ContainerArray, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        n2 += this.internalContainer.berEncodeUpdate(null, 0, byArray, n2);
        if (!this.internalContainer.isComplete()) {
            return n2 - n3;
        }
        this.state |= 0x40000;
        return n2 - n3;
    }

    void initializeForDecode() {
        super.initializeForDecode();
        this.internalContainer.initializeForDecode();
        this.unusedBits = this.wrapType == 768 ? -1 : 0;
    }

    protected int berDecodeData(ASN1Template aSN1Template, int n, byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        if (this.unusedBits == -1) {
            this.unusedBits = byArray[n2];
            ++n2;
            --this.bytesAvailable;
        }
        int n4 = this.checkDecodeWrapComplete(aSN1Template, byArray, n2, this.bytesAvailable);
        if ((this.state & 0x2000000) != 0 || (this.state & 0x1000000) != 0) {
            return n4;
        }
        n4 = this.internalContainer.berDecodeUpdate(aSN1Template, n, byArray, n2, n2 + this.bytesAvailable);
        if (this.theLength > 0) {
            this.theLength -= n4;
        }
        if ((this.internalContainer.state & 0x2000000) == 0) {
            this.state |= 0x1000000;
            return n4;
        }
        n2 += n4;
        this.bytesAvailable -= n4;
        n2 += this.checkDecodeWrapComplete(aSN1Template, byArray, n2, this.bytesAvailable);
        if ((this.state & 0x2000000) != 0 || (this.state & 0x1000000) != 0) {
            return n2 - n3;
        }
        this.state |= 0x1000000;
        return n2 - n3;
    }

    private int checkDecodeWrapComplete(ASN1Template aSN1Template, byte[] byArray, int n, int n2) throws ASN_Exception {
        if (this.theLength > 0) {
            return 0;
        }
        if (this.theLength == 0) {
            this.state = 0x2000000;
            return 0;
        }
        int n3 = this.state & 0xFFFF;
        if (n3 == 0) {
            this.state = 0x2000000;
            return 0;
        }
        if (n2 < 1) {
            this.state |= 0x1000000;
            return 0;
        }
        if (aSN1Template.tagAndLenLen == 0 && byArray[n] != 0) {
            return 0;
        }
        int n4 = n;
        int n5 = this.placeTagAndLen(aSN1Template, byArray, n, n2);
        n += n5;
        if ((this.state & 0x1000000) != 0) {
            return n - n4;
        }
        n2 -= n5;
        if (aSN1Template.tagAndLen[0] != 0 || aSN1Template.tagAndLen[1] != 0) {
            throw new ASN_Exception("Improper ending to indefinite length.");
        }
        this.state -= 2;
        aSN1Template.tagAndLenLen = 0;
        if ((n3 -= 2) == 0) {
            this.state = 0x2000000;
            return n - n4;
        }
        n += this.checkDecodeWrapComplete(aSN1Template, byArray, n, n2);
        if ((this.state & 0x2000000) != 0 || (this.state & 0x1000000) != 0) {
            return n - n4;
        }
        throw new ASN_Exception("Improper ending to indefinite length.");
    }

    protected boolean sameType(ASN1Container aSN1Container) {
        return aSN1Container instanceof WrapContainer;
    }

    protected ASN1Container getBlankCopy() {
        try {
            return new WrapContainer(this.special, true, this.optionTag, this.wrapType, this.internalContainer);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }

    private void setInternalContainer(ASN1Container aSN1Container) throws ASN_Exception {
        if (aSN1Container == null) {
            throw new ASN_Exception("WrapContainer.setInternalContainer: container should not be null.");
        }
        this.internalContainer = aSN1Container;
    }
}

