/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_3DES_EDEKey;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_DES;
import com.rsa.jsafe.JA_DESKey;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

class JA_3DES_EDE
extends JSAFE_Object
implements JA_AlgaeBlockCipher,
Cloneable,
Serializable {
    private static final int TRIPDES_EDE_BLOCK_SIZE = 8;
    private JA_DES firstDES;
    private JA_DES secondDES;
    private JA_DES thirdDES;
    private JA_DESKey firstKey;
    private JA_DESKey secondKey;
    private JA_DESKey thirdKey;
    private byte[] temp1 = new byte[8];
    private byte[] temp2 = new byte[8];

    JA_3DES_EDE() {
    }

    JA_3DES_EDE(int[] nArray) throws JSAFE_InvalidParameterException {
        this();
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Expected no Algorithm Parameters");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        jA_FeedbackMode.setAlgorithmBER(byArray, n, n2);
    }

    public byte[] getParamsDER(byte[] byArray) {
        return byArray;
    }

    public String getAlgorithm() {
        return "3DES_EDE";
    }

    public int getBlockSize() {
        return 8;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_3DES_EDE jA_3DES_EDE = new JA_3DES_EDE();
        if (this.firstDES != null) {
            jA_3DES_EDE.firstDES = (JA_DES)this.firstDES.clone();
        }
        if (this.secondDES != null) {
            jA_3DES_EDE.secondDES = (JA_DES)this.secondDES.clone();
        }
        if (this.thirdDES != null) {
            jA_3DES_EDE.thirdDES = (JA_DES)this.thirdDES.clone();
        }
        if (this.firstKey != null) {
            jA_3DES_EDE.firstKey = (JA_DESKey)this.firstKey.clone();
        }
        if (this.secondKey != null) {
            jA_3DES_EDE.secondKey = (JA_DESKey)this.secondKey.clone();
        }
        if (this.thirdKey != null) {
            jA_3DES_EDE.thirdKey = (JA_DESKey)this.thirdKey.clone();
        }
        return jA_3DES_EDE;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public void pbeKeySize(int n) {
    }

    public byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    private void init(JA_3DES_EDEKey jA_3DES_EDEKey, SecureRandom secureRandom, boolean bl) throws JSAFE_InvalidKeyException {
        if (this.firstDES == null) {
            this.firstDES = new JA_DES();
        }
        if (this.secondDES == null) {
            this.secondDES = new JA_DES();
        }
        if (this.thirdDES == null) {
            this.thirdDES = new JA_DES();
        }
        this.firstKey = jA_3DES_EDEKey.getFirstDESKey();
        this.secondKey = jA_3DES_EDEKey.getSecondDESKey();
        this.thirdKey = jA_3DES_EDEKey.getThirdDESKey();
        if (bl) {
            this.firstDES.encryptInit(this.firstKey, secureRandom);
            this.secondDES.decryptInit(this.secondKey, secureRandom);
            this.thirdDES.encryptInit(this.thirdKey, secureRandom);
        } else {
            this.firstDES.decryptInit(this.firstKey, secureRandom);
            this.secondDES.encryptInit(this.secondKey, secureRandom);
            this.thirdDES.decryptInit(this.thirdKey, secureRandom);
        }
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        JA_3DES_EDEKey jA_3DES_EDEKey = null;
        try {
            jA_3DES_EDEKey = (JA_3DES_EDEKey)jSAFE_SecretKey;
        }
        catch (ClassCastException classCastException) {
            throw new JSAFE_InvalidKeyException("Incorrect key type");
        }
        this.init(jA_3DES_EDEKey, secureRandom, true);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        JA_3DES_EDEKey jA_3DES_EDEKey = null;
        try {
            jA_3DES_EDEKey = (JA_3DES_EDEKey)jSAFE_SecretKey;
        }
        catch (ClassCastException classCastException) {
            throw new JSAFE_InvalidKeyException("Incorrect key type");
        }
        this.init(jA_3DES_EDEKey, secureRandom, false);
    }

    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.firstDES.encryptBlock(byArray, n, this.temp1, 0);
        this.secondDES.decryptBlock(this.temp1, 0, this.temp2, 0);
        this.thirdDES.encryptBlock(this.temp2, 0, byArray2, n2);
        return 8;
    }

    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.thirdDES.decryptBlock(byArray, n, this.temp1, 0);
        this.secondDES.encryptBlock(this.temp1, 0, this.temp2, 0);
        this.firstDES.decryptBlock(this.temp2, 0, byArray2, n2);
        return 8;
    }

    public void obfuscate() {
        this.firstDES.obfuscate();
        this.secondDES.obfuscate();
        this.thirdDES.obfuscate();
    }

    public void deobfuscate() {
        this.firstDES.deobfuscate();
        this.secondDES.deobfuscate();
        this.thirdDES.deobfuscate();
    }

    public void clearSensitiveData() {
        if (this.firstDES != null) {
            this.firstDES.clearSensitiveData();
        }
        if (this.secondDES != null) {
            this.secondDES.clearSensitiveData();
        }
        if (this.thirdDES != null) {
            this.thirdDES.clearSensitiveData();
        }
        if (this.firstKey != null) {
            this.firstKey.clearSensitiveData();
        }
        if (this.secondKey != null) {
            this.secondKey.clearSensitiveData();
        }
        if (this.thirdKey != null) {
            this.thirdKey.clearSensitiveData();
        }
        this.thirdDES = null;
        this.secondDES = null;
        this.firstDES = null;
        this.thirdKey = null;
        this.secondKey = null;
        this.firstKey = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

