/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public final class JA_3DES_EDEBER
extends JSAFE_Object {
    public static byte[] setAlgorithmBER(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        OIDContainer oIDContainer = new OIDContainer(0);
        OctetStringContainer octetStringContainer = new OctetStringContainer(65536);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, octetStringContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid RC2 BER encoding. (" + aSN_Exception.getMessage() + ")");
        }
        if (!octetStringContainer.dataPresent) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[octetStringContainer.dataLen];
        System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, byArray2, 0, octetStringContainer.dataLen);
        return byArray2;
    }

    public static byte[] getDERAlgorithmID(JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException {
        String string = jA_FeedbackMode.getFeedbackMode();
        String string2 = jA_SymmetricPaddingScheme.getPaddingScheme();
        String string3 = "3DES_EDE/" + string + "/" + string2;
        byte[] byArray = jA_FeedbackMode.getIV();
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0, true, 0, string3, 8);
            boolean bl = byArray != null;
            OctetStringContainer octetStringContainer = new OctetStringContainer(65536, bl, 5, byArray, 0, 8);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, octetStringContainer, endContainer};
            return ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("DER for " + string3 + " unknown: " + aSN_Exception.getMessage());
        }
    }
}

