/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_DESKey;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_3DES_EDEKey
extends JSAFE_SecretKey
implements Cloneable,
Serializable {
    private JA_DESKey firstKey;
    private JA_DESKey secondKey;
    private JA_DESKey thirdKey;
    private static final int MIN_KEY_BITS = 64;
    private static final int MAX_KEY_BITS = 192;
    private static final int oneKey = 8;
    private static final int twoKeys = 16;
    private static final int threeKeys = 24;

    public JA_3DES_EDEKey() {
        super("3DES_EDE", 64, 192);
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        int[] nArray2 = new int[]{192};
        if (nArray != null) {
            if (nArray.length > 1) {
                throw new JSAFE_InvalidParameterException("Wrong number of parameters: Expected 1 for 3DES key generation");
            }
            switch (nArray[0]) {
                case 56: 
                case 64: {
                    nArray2[0] = 64;
                    break;
                }
                case 112: 
                case 128: {
                    nArray2[0] = 128;
                    break;
                }
                case 168: 
                case 192: {
                    break;
                }
                default: {
                    throw new JSAFE_InvalidParameterException("Incorrect 3DES key length.");
                }
            }
        }
        super.generateInit(nArray2, secureRandom);
    }

    boolean isWeakKeyData(byte[] byArray) {
        if (byArray.length != 24) {
            return true;
        }
        int n = 0;
        while (n < JA_DESKey.weakKeys.length) {
            int n2 = 0;
            while (n2 < 8) {
                if (byArray[n2] != JA_DESKey.weakKeys[n][n2]) break;
                ++n2;
            }
            if (n2 == 8) {
                return true;
            }
            n2 = 0;
            while (n2 < 8) {
                if (byArray[n2 + 8] != JA_DESKey.weakKeys[n][n2]) break;
                ++n2;
            }
            if (n2 == 8) {
                return true;
            }
            n2 = 0;
            while (n2 < 8) {
                if (byArray[n2 + 16] != JA_DESKey.weakKeys[n][n2]) break;
                ++n2;
            }
            if (n2 == 8) {
                return true;
            }
            ++n;
        }
        return false;
    }

    int getKeyBitLength(int n) {
        switch (n) {
            case -1: {
                return 192;
            }
            case 1: {
                return 64;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 192;
            }
        }
        return -1;
    }

    public void setSecretKeyData(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        if (this.keyData != null) {
            JSAFE_Obfuscator.deregisterOrOverwrite(this.keyData, this.keyOI);
            this.keyOI = null;
            this.keyData = null;
        }
        this.keyData = new byte[24];
        switch (n2) {
            case 8: {
                System.arraycopy(byArray, n, this.keyData, 0, n2);
                System.arraycopy(byArray, n, this.keyData, n2, n2);
                System.arraycopy(byArray, n, this.keyData, n2 * 2, n2);
                break;
            }
            case 16: {
                System.arraycopy(byArray, n, this.keyData, 0, n2 / 2);
                System.arraycopy(byArray, n, this.keyData, n2 / 2, n2 / 2);
                System.arraycopy(byArray, n2 / 2 + n, this.keyData, n2, n2 / 2);
                break;
            }
            case 24: {
                System.arraycopy(byArray, n, this.keyData, 0, n2);
                break;
            }
            default: {
                throw new JSAFE_InvalidKeyException("Invalid key length");
            }
        }
        if (this.firstKey == null) {
            this.firstKey = new JA_DESKey();
        }
        if (this.secondKey == null) {
            this.secondKey = new JA_DESKey();
        }
        if (this.thirdKey == null) {
            this.thirdKey = new JA_DESKey();
        }
        this.firstKey.setSecretKeyData(this.keyData, 0, 8);
        this.secondKey.setSecretKeyData(this.keyData, 8, 8);
        this.thirdKey.setSecretKeyData(this.keyData, 16, 8);
        this.keyOI = JSAFE_Obfuscator.register(this.keyData);
        this.keyOI.obfuscate();
    }

    public byte[] getSecretKeyData() {
        byte[] byArray = this.firstKey.getSecretKeyData();
        byte[] byArray2 = this.secondKey.getSecretKeyData();
        byte[] byArray3 = this.thirdKey.getSecretKeyData();
        int n = byArray.length + byArray2.length + byArray3.length;
        byte[] byArray4 = new byte[n];
        int n2 = 0;
        System.arraycopy(byArray, 0, byArray4, n2, byArray.length);
        JSAFE_Obfuscator.overwrite(byArray);
        System.arraycopy(byArray2, 0, byArray4, n2 += byArray.length, byArray2.length);
        JSAFE_Obfuscator.overwrite(byArray2);
        System.arraycopy(byArray3, 0, byArray4, n2 += byArray2.length, byArray3.length);
        JSAFE_Obfuscator.overwrite(byArray2);
        n2 += byArray3.length;
        return byArray4;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_3DES_EDEKey jA_3DES_EDEKey = (JA_3DES_EDEKey)super.clone();
        if (this.firstKey != null) {
            jA_3DES_EDEKey.firstKey = (JA_DESKey)this.firstKey.clone();
        }
        if (this.secondKey != null) {
            jA_3DES_EDEKey.secondKey = (JA_DESKey)this.secondKey.clone();
        }
        if (this.thirdKey != null) {
            jA_3DES_EDEKey.thirdKey = (JA_DESKey)this.thirdKey.clone();
        }
        return jA_3DES_EDEKey;
    }

    protected JA_DESKey getFirstDESKey() {
        try {
            return (JA_DESKey)this.firstKey.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected JA_DESKey getSecondDESKey() {
        try {
            return (JA_DESKey)this.secondKey.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected JA_DESKey getThirdDESKey() {
        try {
            return (JA_DESKey)this.thirdKey.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        JSAFE_Obfuscator.deregister(this.keyData, this.keyOI);
        this.keyData = null;
        this.keyOI = null;
        if (this.firstKey != null) {
            this.firstKey.clearSensitiveData();
        }
        if (this.secondKey != null) {
            this.secondKey.clearSensitiveData();
        }
        if (this.thirdKey != null) {
            this.thirdKey.clearSensitiveData();
        }
        this.thirdKey = null;
        this.secondKey = null;
        this.firstKey = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

